/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.web.content;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import oracle.dbtools.common.service.ServiceProperties;
import oracle.dbtools.common.service.model.Service;
import oracle.dbtools.common.util.Closeables;
import oracle.dbtools.common.util.Pair;
import oracle.dbtools.common.util.StreamCopy;
import oracle.dbtools.common.util.Text;
import oracle.dbtools.common.util.URIs;
import oracle.dbtools.rt.authentication.LogonRealm;
import oracle.dbtools.rt.authentication.SecurityConfig;
import oracle.dbtools.rt.authentication.SecurityConfigs;
import oracle.dbtools.rt.locale.LocalePreference;
import oracle.dbtools.rt.uri.URITemplate;
import oracle.dbtools.rt.uri.URITemplates;
import oracle.dbtools.rt.web.ContentType;
import oracle.dbtools.rt.web.ContentTypes;
import oracle.dbtools.rt.web.RedirectException;
import oracle.dbtools.rt.web.WebException;
import oracle.dbtools.rt.web.content.ContentInfo;
import oracle.dbtools.rt.web.content.ContentRule;
import oracle.dbtools.rt.web.content.MimeTypes;
import oracle.dbtools.rt.web.content.StaticContent;

@Service
public class ContentRules {
    private final Set<ContentRule> rules = new LinkedHashSet<ContentRule>();
    private static final String COMMENT_DELIMITER = "#";
    private static final String HTML_SUFFIX = ".html";
    private static final URITemplate HTML_TEMPLATE = URITemplates.uriTemplate("{path}.html");
    private static final String IGNORE = "ignore";
    private static final String INDEX = "index";
    private static final String INDEX_HTML = "index.html";
    private static final URITemplate INDEX_TEMPLATE = URITemplates.uriTemplate("{path}/index.html");
    private static final String PATH = "path";
    private static final String PATH_SEP = "/";
    private static final String ROOT_FOLDER = "";
    private static final String RULES_FILE = ".rules";
    private static final String SECURE = "secure";
    private static final URITemplate SESSION = URITemplates.uriTemplate("session:{id}");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void activate(ServiceProperties properties) throws IOException {
        InputStream in;
        block3: {
            URI rulesFile = StaticContent.uri(LocalePreference.DEFAULT, RULES_FILE);
            in = null;
            try {
                if (rulesFile == null) {
                    this.ignore(INDEX_HTML, "error.html", "reason.html", "not-yet-configured.html", "sign-on.html", "ui/oauth2/clients/client.html", ".htaccess");
                    this.session(LogonRealm.OAUTH_CLIENTS, "ui/oauth2/clients/*");
                    this.session(LogonRealm.OAUTH_APPROVALS, "ui/oauth2/approvals/*");
                    break block3;
                }
                in = URIs.inputStream((URI)rulesFile);
                this.rules.addAll(this.parse(in));
            }
            catch (Throwable throwable) {
                Closeables.close(in);
                throw throwable;
            }
        }
        Closeables.close((Object)in);
    }

    private void session(LogonRealm realm, String ... toProtect) {
        for (String session : toProtect) {
            this.rule(new ContentRule(session, false, realm.securityConfig()));
        }
    }

    private void ignore(String ... toIgnore) {
        for (String ignore : toIgnore) {
            this.rule(new ContentRule(ignore, true, SecurityConfigs.NONE));
        }
    }

    protected void rule(ContentRule rule) {
        if (rule != null) {
            this.rules.add(rule);
        }
    }

    ContentInfo match(LocalePreference localePreference, String path) {
        Pair<URI, String> uriAndTranslatedPath = this.checkResourceExists(localePreference, path);
        if (uriAndTranslatedPath == null) {
            return null;
        }
        URI uri = (URI)uriAndTranslatedPath.first();
        String translatedPath = (String)uriAndTranslatedPath.second();
        SecurityConfig security = SecurityConfigs.NONE;
        for (ContentRule rule : this.rules) {
            if (!rule.matches(translatedPath)) continue;
            if (rule.ignore()) {
                security = null;
                break;
            }
            security = rule.security();
            break;
        }
        if (security == null) {
            return null;
        }
        ContentType contentType = MimeTypes.get(translatedPath);
        if (contentType == null) {
            contentType = ContentTypes.HTML;
        }
        return new ContentInfo(uri, security, contentType);
    }

    private Pair<URI, String> checkResourceExists(LocalePreference localePreference, String path) {
        boolean hasTrailingSlash = path.endsWith(PATH_SEP);
        boolean hasHtmlSuffix = path.endsWith(HTML_SUFFIX);
        boolean hasIndexSuffix = path.endsWith("/index") || path.equals(INDEX) || path.endsWith("/index.html") || path.equals(INDEX_HTML);
        String translatedPath = path;
        URI resource = StaticContent.uri(localePreference, path);
        if (resource == null) {
            if (hasTrailingSlash) {
                String indexPath = this.indexPath(path);
                resource = StaticContent.uri(localePreference, indexPath);
                if (resource != null) {
                    translatedPath = indexPath;
                }
            } else {
                String htmlPath = HTML_TEMPLATE.encode(PATH, path);
                resource = StaticContent.uri(localePreference, htmlPath);
                if (resource == null) {
                    resource = StaticContent.uri(localePreference, path + PATH_SEP);
                    if (resource != null) {
                        throw RedirectException.permanentRedirect(path + '/');
                    }
                } else {
                    if (hasIndexSuffix) {
                        throw RedirectException.permanentRedirect(this.folder(path));
                    }
                    translatedPath = htmlPath;
                }
            }
        } else {
            URIs.Status status = URIs.status((URI)resource);
            if (URIs.Status.FOLDER == status) {
                if (!hasTrailingSlash && !ROOT_FOLDER.equals(path)) {
                    throw RedirectException.permanentRedirect(path + '/');
                }
                String indexPath = this.indexPath(path);
                resource = StaticContent.uri(localePreference, indexPath);
                if (resource == null) {
                    throw WebException.forbidden();
                }
                translatedPath = indexPath;
            } else if (URIs.Status.FILE == status) {
                if (hasIndexSuffix) {
                    throw RedirectException.permanentRedirect(this.folder(path));
                }
                if (hasHtmlSuffix) {
                    throw RedirectException.permanentRedirect(Text.stripSuffix((String)path, (String)HTML_SUFFIX));
                }
            }
        }
        if (resource == null) {
            return null;
        }
        return Pair.pair((Object)resource, (Object)translatedPath);
    }

    private String folder(String path) {
        int lastSlash = path.lastIndexOf(47);
        if (lastSlash == -1) {
            return ROOT_FOLDER;
        }
        return path.substring(0, lastSlash + 1);
    }

    private String indexPath(String path) {
        if (path.equals(ROOT_FOLDER)) {
            return INDEX_HTML;
        }
        return INDEX_TEMPLATE.encode(PATH, Text.stripSuffix((String)path, (String)PATH_SEP));
    }

    private List<ContentRule> parse(InputStream in) throws IOException {
        String[] lines;
        ArrayList<ContentRule> rules = new ArrayList<ContentRule>();
        String text = StreamCopy.string((InputStream)in);
        for (String line : lines = text.split("\\n")) {
            if ((line = line.trim()).isEmpty() || line.startsWith(COMMENT_DELIMITER)) continue;
            ContentRule rule = ContentRules.parse(line);
            this.rule(rule);
        }
        return rules;
    }

    static ContentRule parse(String text) {
        ContentRule rule = null;
        String[] patternAndParams = text.split("\\s+", 2);
        if (patternAndParams.length == 2) {
            String pattern = patternAndParams[0];
            List<Object> params = Collections.emptyList();
            params = Arrays.asList(patternAndParams[1].split(",\\s*"));
            if (params.size() > 0) {
                boolean ignore = false;
                SecurityConfig security = SecurityConfigs.NONE;
                if (params.contains(IGNORE)) {
                    ignore = true;
                }
                for (String string : params) {
                    if (string.equals(SECURE)) {
                        security = SecurityConfigs.SECURE;
                        continue;
                    }
                    if (!SESSION.matches(string)) continue;
                    String id = SESSION.decode(string).get("id");
                    security = LogonRealm.realm(id).securityConfig();
                }
                rule = new ContentRule(pattern, ignore, security);
            }
        }
        return rule;
    }
}

