/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import oracle.javatools.db.AbstractDBObjectProvider;
import oracle.javatools.db.Column;
import oracle.javatools.db.Constraint;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Database;
import oracle.javatools.db.Index;
import oracle.javatools.db.PKConstraint;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.Table;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.UniqueConstraint;
import oracle.javatools.db.ddl.DDLGenerator;
import oracle.javatools.db.diff.DefaultResultSetFilter;
import oracle.javatools.db.diff.Difference;
import oracle.javatools.db.diff.DifferenceFilter;
import oracle.javatools.db.diff.GenericDiffEngine;
import oracle.javatools.db.property.Property;
import oracle.javatools.db.property.PropertyHelper;
import oracle.javatools.db.property.PropertyManager;
import oracle.javatools.db.refactoring.DBObjectTransaction;
import oracle.javatools.db.refactoring.UpdateProcessor;
import oracle.javatools.db.resource.APIBundle;
import oracle.javatools.db.sql.ColumnUsage;
import oracle.javatools.db.sql.IndexObject;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.db.validators.ValidationContext;
import oracle.javatools.db.validators.ValidationException;
import oracle.javatools.db.validators.ValidationLevel;
import oracle.javatools.util.ModelUtil;

public class ConstraintIndexHelper {
    private final DBObjectProvider m_pro;
    private final Table m_table;
    private final Collection<Index> m_deletedIndexes;
    private final boolean m_supported;

    public ConstraintIndexHelper(DBObjectProvider dBObjectProvider, Table table) {
        this.m_pro = dBObjectProvider;
        this.m_table = table;
        this.m_deletedIndexes = new ArrayList<Index>();
        this.m_supported = this.m_pro.getPropertyManager().canCreateProperty((SystemObject)this.m_table, Property.createPath((String[])new String[]{"constraints", "indexID"}));
    }

    public boolean isSupported() {
        return this.m_supported;
    }

    private String getOriginalTableName() {
        DBObject dBObject;
        String string = this.m_table.getName();
        DBObjectID dBObjectID = this.m_table.getID();
        if (dBObjectID instanceof TemporaryObjectID && (dBObject = TemporaryObjectID.findOriginalObject((TemporaryObjectID)((TemporaryObjectID)dBObjectID))) != null) {
            string = dBObject.getName();
        }
        return string;
    }

    public void ensureAndValidateIndexes(UniqueConstraint uniqueConstraint, ValidationLevel validationLevel) throws ValidationException {
        if (this.isSupported()) {
            ConstraintIndexHelper.clearIndexIDIfInvalid(uniqueConstraint, this.m_pro);
            DBObjectID dBObjectID = uniqueConstraint.getIndexID();
            this.ensureIndexes(uniqueConstraint);
            String string = this.m_table.getName();
            String string2 = this.getOriginalTableName();
            try {
                this.m_table.setName(string2);
                ((AbstractDBObjectProvider)this.m_pro).validate(new ValidationContext(null, (DBObject)this.m_table, validationLevel, new String[]{"indexes"}));
            }
            catch (ValidationException validationException) {
                DBObjectID dBObjectID2 = uniqueConstraint.getIndexID();
                if (dBObjectID == null && dBObjectID2 != null) {
                    Index index = (Index)this.m_table.findOwnedObject(dBObjectID2);
                    if (index != null) {
                        this.m_table.removeIndex(index);
                    }
                    uniqueConstraint.setIndexID(null);
                }
                throw validationException;
            }
            finally {
                this.m_table.setName(string);
            }
        }
    }

    public void ensureIndexes(UniqueConstraint uniqueConstraint) {
        ConstraintIndexHelper.ensureIndexes(this.m_pro, this.m_table, uniqueConstraint, this.m_deletedIndexes);
    }

    public void clearNewUnusedIndexes(Table table) {
        ConstraintIndexHelper.clearNewUnusedIndexes(table, this.m_deletedIndexes);
    }

    private static void clearNewUnusedIndexes(Table table, Collection<Index> collection) {
        ArrayList<Index> arrayList = new ArrayList<Index>();
        for (Index index : table.getIndexes()) {
            if (!ConstraintIndexHelper.isSystemGenerated(index) || !ConstraintIndexHelper.isNew((DBObject)index) || ConstraintIndexHelper.isForAConstraint(index)) continue;
            arrayList.add(index);
        }
        for (Index index : arrayList) {
            collection.add(index);
            table.removeIndex(index);
        }
    }

    public static UniqueConstraint forConstraint(Index index) {
        UniqueConstraint uniqueConstraint = null;
        if (index != null && index.getTable() != null) {
            for (Constraint constraint : index.getTable().getConstraints()) {
                if (!(constraint instanceof UniqueConstraint) || index.getID() == null || !index.getID().equals(((UniqueConstraint)constraint).getIndexID())) continue;
                uniqueConstraint = (UniqueConstraint)constraint;
                break;
            }
        }
        return uniqueConstraint;
    }

    public static boolean isForAConstraint(Index index) {
        return ConstraintIndexHelper.forConstraint(index) != null;
    }

    public static boolean isSystemGenerated(Index index) {
        Boolean bl = index.getSystemGenerated();
        if (bl == null) {
            bl = false;
            UniqueConstraint uniqueConstraint = ConstraintIndexHelper.forConstraint(index);
            if (uniqueConstraint != null && ConstraintIndexHelper.indexDefaultForConstraint(index, uniqueConstraint)) {
                bl = true;
            }
        }
        return bl;
    }

    public static boolean ensureIndexes(DBObjectProvider dBObjectProvider, Table table, UniqueConstraint uniqueConstraint) {
        ArrayList<Index> arrayList = new ArrayList<Index>();
        return ConstraintIndexHelper.ensureIndexes(dBObjectProvider, table, uniqueConstraint, arrayList);
    }

    public static boolean ensureIndexes(DBObjectProvider dBObjectProvider, Table table, UniqueConstraint uniqueConstraint, Collection<Index> collection) {
        UniqueConstraint uniqueConstraint2 = (UniqueConstraint)TemporaryObjectID.getOriginalObject((DBObject)uniqueConstraint);
        return ConstraintIndexHelper.ensureIndexes(dBObjectProvider, table, uniqueConstraint, uniqueConstraint2, collection);
    }

    public static boolean ensureIndexes(DBObjectProvider dBObjectProvider, Table table, UniqueConstraint uniqueConstraint, UniqueConstraint uniqueConstraint2, Collection<Index> collection) {
        return ConstraintIndexHelper.ensureIndexes(dBObjectProvider, table, uniqueConstraint, uniqueConstraint2, collection, null);
    }

    public static boolean ensureIndexes(DBObjectProvider dBObjectProvider, Table table, UniqueConstraint uniqueConstraint, UniqueConstraint uniqueConstraint2, Collection<Index> collection, Set<String> set) {
        int n;
        Index index;
        Index index2;
        DBObjectID dBObjectID;
        Table table2;
        boolean bl = false;
        ArrayList<Index> arrayList = new ArrayList<Index>();
        arrayList.addAll(collection);
        if (dBObjectProvider == null) {
            throw new IllegalArgumentException("pro should not be null");
        }
        Boolean bl2 = ModelUtil.areEqual((Object)"Oracle Database", (Object)dBObjectProvider.getDescriptor().getDatabaseType());
        if (!bl2.booleanValue()) {
            return bl;
        }
        if (uniqueConstraint == null && uniqueConstraint2 == null) {
            throw new IllegalArgumentException("updUK or origUK should not be null");
        }
        if (uniqueConstraint2 == null) {
            table2 = null;
        } else {
            table2 = (Table)uniqueConstraint2.getParent();
            dBObjectID = uniqueConstraint2.getIndexID();
            if (dBObjectID != null) {
                Index index3;
                Index index4;
                int n2;
                index2 = (Index)table2.findOwnedObject(dBObjectID);
                index = null;
                if (index2 != null) {
                    Index index5 = table.getIndexes();
                    n2 = ((Index[])index5).length;
                    for (n = 0; n < n2; ++n) {
                        index4 = index5[n];
                        index3 = (Index)TemporaryObjectID.getOriginalObject((DBObject)index4);
                        if (index3 != index2) continue;
                        index = index4;
                        break;
                    }
                }
                if (index != null && ConstraintIndexHelper.isSystemGenerated(index)) {
                    boolean bl3 = false;
                    n2 = 0;
                    if (uniqueConstraint == null || uniqueConstraint.getColumnIDs().length == 0 || !uniqueConstraint.isEnabled()) {
                        bl3 = index.getIndexType() == Index.IndexType.UNIQUE;
                        n2 = uniqueConstraint != null ? 1 : 0;
                    } else if (dBObjectProvider != null && uniqueConstraint != null && uniqueConstraint.getColumnIDs().length > 0) {
                        Difference difference = dBObjectProvider.getDiffEngine().difference((Object)uniqueConstraint2, (Object)uniqueConstraint);
                        index4 = new DefaultResultSetFilter();
                        index4.addFilteredProps("name");
                        index4.addFilteredProps("enabled");
                        index3 = uniqueConstraint2.getIndexID();
                        DBObjectID dBObjectID2 = uniqueConstraint.getIndexID();
                        if (index3 != null) {
                            DBObject dBObject;
                            if (dBObjectID2 == null) {
                                index4.addFilteredProps("indexID");
                            } else if (dBObjectID2 instanceof TemporaryObjectID && (dBObject = TemporaryObjectID.findOriginalObject((TemporaryObjectID)((TemporaryObjectID)dBObjectID2))) != null && dBObject.getID().equals(index3)) {
                                index4.addFilteredProps("indexID");
                            }
                        }
                        if (!(difference = difference.getFilteredDifference(new DifferenceFilter[]{index4})).isSame()) {
                            bl3 = true;
                            n2 = 1;
                        }
                    }
                    if (bl3) {
                        collection.add(index);
                        table.removeIndex(index);
                        bl = true;
                    }
                    if (n2 != 0) {
                        uniqueConstraint.setIndexID(null);
                        bl = true;
                    }
                }
            }
        }
        if (uniqueConstraint != null) {
            Object object;
            ConstraintIndexHelper.clearNewUnusedIndexes(table, collection);
            dBObjectID = uniqueConstraint.getIndexID();
            if (dBObjectID != null) {
                if (uniqueConstraint.isEnabled()) {
                    return bl;
                }
                uniqueConstraint.setIndexID(null);
                return true;
            }
            if (uniqueConstraint.getColumnIDs().length == 0 || !uniqueConstraint.isEnabled()) {
                return bl;
            }
            index2 = null;
            for (Index index5 : arrayList) {
                table.addIndex(index5);
                if (ConstraintIndexHelper.indexValidForConstraint(index5, uniqueConstraint, dBObjectProvider)) {
                    index2 = index5;
                    break;
                }
                table.removeIndex(index5);
            }
            if (index2 != null) {
                collection.remove(index2);
                uniqueConstraint.setIndexID(index2.getID());
                return true;
            }
            for (Index index6 : table.getIndexes()) {
                if (!ConstraintIndexHelper.indexValidForConstraint(index6, uniqueConstraint, dBObjectProvider)) continue;
                uniqueConstraint.setIndexID(index6.getID());
                return true;
            }
            index = ConstraintIndexHelper.getDefaultIndex(dBObjectProvider, table, uniqueConstraint);
            int n3 = 1;
            for (Index index7 : collection) {
                if (!index.getName().equals(index7.getName())) continue;
                n3 = 0;
                break;
            }
            if (n3 != 0) {
                if (set != null) {
                    object = index.getName();
                    n = 2;
                    while (set.contains(object)) {
                        object = index.getName() + n;
                        ++n;
                    }
                    set.add((String)object);
                    index.setName((String)object);
                } else if (dBObjectProvider != null) {
                    object = dBObjectProvider.getUniqueName("INDEX", (DBObject)table.getSchema(), index.getName());
                    index.setName((String)object);
                }
            }
            table.addIndex(index);
            object = null;
            if (table2 != null) {
                object = table2.getIndex(index.getName());
            }
            dBObjectID = TemporaryObjectID.createID((DBObject)index, (DBObject)object);
            index.setID(dBObjectID);
            uniqueConstraint.setIndexID(dBObjectID);
            return true;
        }
        return bl;
    }

    public static void validateIndexForConstraint(Index index, UniqueConstraint uniqueConstraint, DBObjectProvider dBObjectProvider, boolean bl) throws ValidationException {
        Column column;
        IndexObject[] indexObjectArray = index.getColumnExpressions();
        if (index == null || indexObjectArray.length == 0) {
            throw new ValidationException((DBObject)uniqueConstraint, APIBundle.get((String)"CONIDX_NULL_INDEX_ERR"));
        }
        DBObjectID[] dBObjectIDArray = uniqueConstraint.getColumnIDs();
        if (uniqueConstraint == null || dBObjectIDArray.length == 0) {
            throw new ValidationException((DBObject)uniqueConstraint, APIBundle.get((String)"CONIDX_NULL_CONSTAINT_ERR"));
        }
        Table table = index.getTable();
        if (uniqueConstraint.getParent() != table) {
            throw new ValidationException((DBObject)uniqueConstraint, APIBundle.get((String)"CONIDX_DIFFERENT_TABLE_ERR"));
        }
        Index.IndexType indexType = index.getIndexType();
        if (indexType != Index.IndexType.NORMAL && indexType != Index.IndexType.UNIQUE) {
            throw new ValidationException((DBObject)uniqueConstraint, APIBundle.get((String)"CONIDX_INDEX_TYPE_ERR"));
        }
        if (uniqueConstraint.getDeferrableState() != null && indexType == Index.IndexType.UNIQUE) {
            throw new ValidationException((DBObject)uniqueConstraint, APIBundle.get((String)"CONIDX_DEFERRABLE_UNIQUE_ERR"));
        }
        boolean bl2 = true;
        if (indexType == Index.IndexType.UNIQUE && indexObjectArray.length != dBObjectIDArray.length) {
            bl2 = false;
        } else if (indexType == Index.IndexType.NORMAL && indexObjectArray.length < dBObjectIDArray.length) {
            bl2 = false;
        } else {
            Constraint[] constraintArray = new ArrayList();
            for (int i = 0; i < dBObjectIDArray.length; ++i) {
                IndexObject indexObject = indexObjectArray[i];
                String string = indexObject.getExpressionSource();
                if (dBObjectProvider != null) {
                    string = dBObjectProvider.getInternalName(string);
                }
                if ((column = table.getColumn(string)) == null || IndexObject.OrderType.DESC.equals((Object)indexObject.getOrderType())) {
                    bl2 = false;
                    break;
                }
                constraintArray.add(column.getID());
            }
            DBObjectID[] dBObjectIDArray2 = dBObjectIDArray;
            int n = dBObjectIDArray2.length;
            for (int i = 0; i < n; ++i) {
                column = dBObjectIDArray2[i];
                if (constraintArray.contains(column)) continue;
                bl2 = false;
                break;
            }
        }
        if (!bl2) {
            throw new ValidationException((DBObject)uniqueConstraint, APIBundle.format((String)"CONIDX_MISMATCH_ERR", (Object[])new Object[]{index.getName(), uniqueConstraint.getName()}));
        }
        if (!bl) {
            for (Constraint constraint : ((Table)uniqueConstraint.getParent()).getConstraints()) {
                if (!(constraint instanceof UniqueConstraint) || constraint == uniqueConstraint || (column = (UniqueConstraint)constraint).getIndexID() == null || !column.getIndexID().equals(index.getID())) continue;
                throw new ValidationException((DBObject)uniqueConstraint, APIBundle.format((String)"CONIDX_INDEX_USED_ERR", (Object[])new Object[]{index.getName(), uniqueConstraint.getName()}));
            }
        }
    }

    public static boolean indexValidForConstraint(Index index, UniqueConstraint uniqueConstraint, DBObjectProvider dBObjectProvider) {
        try {
            ConstraintIndexHelper.validateIndexForConstraint(index, uniqueConstraint, dBObjectProvider, false);
            return true;
        }
        catch (ValidationException validationException) {
            return false;
        }
    }

    public static boolean clearIndexIDIfInvalid(UniqueConstraint uniqueConstraint, DBObjectProvider dBObjectProvider) {
        Index index;
        Table table;
        boolean bl = false;
        DBObjectID dBObjectID = uniqueConstraint.getIndexID();
        if (dBObjectID != null && (table = (Table)uniqueConstraint.getParent()) != null && (index = (Index)table.findOwnedObject(dBObjectID)) != null && !ConstraintIndexHelper.indexValidForConstraint(index, uniqueConstraint, dBObjectProvider)) {
            uniqueConstraint.setIndexID(null);
            bl = true;
        }
        return bl;
    }

    public static boolean indexDefaultForConstraint(Index index, UniqueConstraint uniqueConstraint) {
        return ConstraintIndexHelper.indexDefaultForConstraint(index, uniqueConstraint, null);
    }

    public static boolean indexDefaultForConstraint(Index index, UniqueConstraint uniqueConstraint, DBObjectProvider dBObjectProvider) {
        MyDifferenceFilter myDifferenceFilter;
        if (index == null || uniqueConstraint == null) {
            return false;
        }
        if (index.getSystemGenerated() == Boolean.FALSE) {
            return false;
        }
        if (!index.getName().equals(uniqueConstraint.getName())) {
            return false;
        }
        if (index.getColumnExpressions().length == 0 || index.getColumnExpressions().length != uniqueConstraint.getColumnIDs().length) {
            return false;
        }
        if (!ConstraintIndexHelper.indexValidForConstraint(index, uniqueConstraint, dBObjectProvider)) {
            return false;
        }
        Index index2 = ConstraintIndexHelper.getDefaultIndex(null, index.getTable(), uniqueConstraint);
        Difference difference = GenericDiffEngine.getDiffEngine((boolean)false).difference((Object)index, (Object)index2);
        Difference difference2 = difference.getFilteredDifference(new DifferenceFilter[]{myDifferenceFilter = new MyDifferenceFilter(dBObjectProvider, index2)});
        if (!difference2.isSame()) {
            DefaultResultSetFilter defaultResultSetFilter = new DefaultResultSetFilter();
            defaultResultSetFilter.addFilteredProps("columnExpressions");
            difference2 = difference2.getFilteredDifference(new DifferenceFilter[]{defaultResultSetFilter});
            if (difference2.isSame()) {
                IndexObject[] indexObjectArray = index.getColumnExpressions();
                IndexObject[] indexObjectArray2 = index2.getColumnExpressions();
                for (int i = 0; i < indexObjectArray.length; ++i) {
                    if (IndexObject.OrderType.DESC.equals((Object)indexObjectArray[i].getOrderType())) {
                        return false;
                    }
                    if (!ModelUtil.areDifferent((Object)indexObjectArray[i].getExpressionSource(), (Object)indexObjectArray2[i].getExpressionSource())) continue;
                    return false;
                }
            } else {
                return false;
            }
        }
        return true;
    }

    private static Index getDefaultIndex(DBObjectProvider dBObjectProvider, Table table, UniqueConstraint uniqueConstraint) {
        Index index = new Index();
        index.setName(uniqueConstraint.getName());
        Index.IndexType indexType = Table.TableType.INDEX_ORGANIZED == table.getProperty("TableType") && uniqueConstraint instanceof PKConstraint ? Index.IndexType.UNIQUE : (uniqueConstraint.getDeferrableState() == null ? Index.IndexType.UNIQUE : Index.IndexType.NORMAL);
        index.setIndexType(indexType);
        index.setSystemGenerated(Boolean.valueOf(true));
        DBObjectID[] dBObjectIDArray = uniqueConstraint.getColumnIDs();
        IndexObject[] indexObjectArray = new IndexObject[dBObjectIDArray.length];
        int n = 0;
        for (DBObjectID dBObjectID : dBObjectIDArray) {
            ColumnUsage columnUsage = new ColumnUsage(dBObjectID);
            columnUsage.setProvider(dBObjectProvider);
            columnUsage.setQualified(false);
            IndexObject indexObject = new IndexObject();
            indexObject.setExpression((SQLFragment)columnUsage);
            indexObject.setOrderType(IndexObject.OrderType.ASC);
            indexObjectArray[n++] = indexObject;
        }
        index.setColumnExpressions(indexObjectArray);
        if (dBObjectProvider instanceof Database) {
            index.setReverse(Boolean.valueOf(false));
        }
        return index;
    }

    private static boolean isNew(DBObject dBObject) {
        DBObject dBObject2;
        return dBObject.getID() instanceof TemporaryObjectID && (dBObject2 = ((TemporaryObjectID)dBObject.getID()).getOriginalObject()) == null;
    }

    private static class MyDifferenceFilter
    implements DifferenceFilter {
        private final DBObjectProvider m_pro;
        private final Index m_index;
        private final DDLGenerator m_ddlGen;
        private final PropertyManager m_propMgr;

        public MyDifferenceFilter(DBObjectProvider dBObjectProvider, Index index) {
            this.m_pro = dBObjectProvider;
            this.m_index = index;
            this.m_ddlGen = dBObjectProvider == null ? null : dBObjectProvider.getDDLGenerator();
            this.m_propMgr = dBObjectProvider == null ? null : dBObjectProvider.getPropertyManager();
        }

        public boolean isFilteredProperty(Difference difference, String string) {
            String string2 = difference.getPropertyPath();
            if (difference.isLeaf()) {
                Object object;
                Object object2;
                Object object3;
                if ("schema".equals(string)) {
                    return true;
                }
                if (this.m_ddlGen != null && !this.m_ddlGen.canCreateProperty((SystemObject)this.m_index, string2)) {
                    return true;
                }
                if (this.m_pro instanceof Database && "reverse".equals(string) && difference.getUpdatedObject() == null && Boolean.FALSE.equals(difference.getOriginalObject())) {
                    return true;
                }
                if (this.m_propMgr != null && (object3 = difference.getUpdatedObject()) == null && ModelUtil.areEqual((Object)(object2 = this.m_propMgr.getImplicitDefaultValue((DBObject)this.m_index, string2)), (Object)(object = difference.getOriginalObject()))) {
                    return true;
                }
            }
            return false;
        }
    }

    public static class Processor
    extends UpdateProcessor {
        public void processUpdate(DBObjectTransaction dBObjectTransaction, Difference difference) {
            DBObjectProvider dBObjectProvider = dBObjectTransaction.getProvider();
            boolean bl = ModelUtil.areEqual((Object)"Oracle Database", (Object)dBObjectProvider.getDescriptor().getDatabaseType()) && difference.getUpdatedObject() instanceof Table;
            boolean bl2 = false;
            if (bl) {
                PropertyHelper propertyHelper = new PropertyHelper();
                Table table = (Table)difference.getOriginalObject();
                boolean bl3 = true;
                if (table != null && TemporaryObjectID.findOriginalObject((DBObject)((Table)difference.getUpdatedObject())) == table) {
                    boolean bl4 = bl3 = difference.getChildDifference("constraints", true) != null || difference.getChildDifference("indexes", true) != null;
                }
                if (bl3) {
                    Serializable serializable;
                    boolean bl5 = false;
                    Table table2 = (Table)dBObjectTransaction.getDiffUpdatedObject(difference);
                    if (table == null) {
                        for (Index index : table2.getConstraints()) {
                            boolean bl6;
                            if (!(index instanceof UniqueConstraint) || !(bl6 = ConstraintIndexHelper.ensureIndexes(dBObjectProvider, table2, (UniqueConstraint)index, null, serializable = new ArrayList()))) continue;
                            bl5 = true;
                        }
                    } else {
                        Index[] indexArray = difference.getChildDifference("constraints", true);
                        if (indexArray != null) {
                            for (Difference difference2 : indexArray.getChildren()) {
                                ArrayList<Index> arrayList;
                                boolean bl7;
                                Index index;
                                if (difference2.isSame()) continue;
                                index = (DBObject)difference2.getUpdatedObject();
                                serializable = (DBObject)difference2.getOriginalObject();
                                if (!(serializable instanceof UniqueConstraint) && !(index instanceof UniqueConstraint) || !(bl7 = ConstraintIndexHelper.ensureIndexes(dBObjectProvider, table2, (UniqueConstraint)index, (UniqueConstraint)serializable, arrayList = new ArrayList<Index>()))) continue;
                                bl5 = true;
                            }
                        }
                    }
                    for (Index index : table2.getIndexes()) {
                        serializable = index.getSystemGenerated();
                        if (serializable == null) {
                            bl2 = true;
                            continue;
                        }
                        if (!((Boolean)serializable).booleanValue() || ConstraintIndexHelper.isForAConstraint(index)) continue;
                        index.setSystemGenerated(Boolean.valueOf(false));
                        bl5 = true;
                    }
                    if (bl2 && (!difference.isSame() || bl5)) {
                        for (Index index : table2.getIndexes()) {
                            if (index.getSystemGenerated() != null) continue;
                            index.setSystemGenerated(Boolean.valueOf(ConstraintIndexHelper.isSystemGenerated(index)));
                            bl5 = true;
                        }
                    }
                    if (bl5) {
                        dBObjectTransaction.includeUpdate((SystemObject)table2);
                    }
                }
            }
        }
    }
}

