/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.derby;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import oracle.javatools.db.BaseDatabaseCreator;
import oracle.javatools.db.Database;
import oracle.javatools.db.DatabaseDescriptor;
import oracle.javatools.db.derby.DerbyDatabase;
import oracle.javatools.db.derby.DerbyDatabaseDescriptor;
import oracle.javatools.db.derby.DerbyDatabaseImpl;

public class DerbyDatabaseFactory
extends BaseDatabaseCreator {
    protected Database createDatabaseImpl(String string, String string2, Connection connection) {
        int n = this.getType(connection);
        switch (n) {
            case 1: {
                return new DerbyDatabaseImpl(string, string2, connection);
            }
        }
        return null;
    }

    protected int getType(Connection connection) {
        if (connection != null) {
            try {
                DatabaseMetaData databaseMetaData = connection.getMetaData();
                String string = databaseMetaData.getDatabaseProductName();
                if (string.startsWith("Apache Derby")) {
                    return 1;
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return -1;
    }

    protected DatabaseDescriptor getDatabaseDescriptorImpl(Class clazz) {
        if (DerbyDatabase.class.isAssignableFrom(clazz)) {
            return new DerbyDatabaseDescriptor(clazz);
        }
        return null;
    }
}

