/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.hive;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Relation;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.Table;
import oracle.javatools.db.ddl.BundleDDLGenerator;
import oracle.javatools.db.ddl.TokenContext;
import oracle.javatools.db.ddl.TokenGenerator;
import oracle.javatools.db.hive.HiveDDLType;
import oracle.javatools.db.hive.HiveDatabaseImpl;
import oracle.javatools.db.hive.HivePartitionProperties;
import oracle.javatools.db.hive.HivePropertyMetadata;
import oracle.javatools.db.hive.HiveStorageProperties;
import oracle.javatools.db.property.Property;

public class HiveDDLGenerator
extends BundleDDLGenerator<HiveDDLType> {
    private static final String BUNDLE_NAME = "HiveDDL.properties";

    public HiveDDLGenerator(DBObjectProvider dBObjectProvider) {
        super(HiveDatabaseImpl.class, dBObjectProvider, new String[]{BUNDLE_NAME});
        this.registerTokenGenerator("nonPartitionColumns", new ColumnsGen());
    }

    private int getDatabaseVersion() {
        DBObjectProvider dBObjectProvider = this.getProvider();
        return dBObjectProvider == null ? 14 : dBObjectProvider.getDescriptor().getDatabaseVersion();
    }

    protected boolean canChangeWithAlter(SystemObject systemObject, SystemObject systemObject2, String string) {
        boolean bl;
        HiveStorageProperties hiveStorageProperties;
        HiveStorageProperties hiveStorageProperties2 = hiveStorageProperties = systemObject instanceof Table ? (HiveStorageProperties)systemObject.getProperty("HiveStorageProperties") : null;
        if (hiveStorageProperties != null && hiveStorageProperties.getStorageHandlerClass() != null) {
            bl = false;
        } else {
            bl = super.canChangeWithAlter(systemObject, systemObject2, string);
            if (!bl) {
                String string2 = Property.getLastProperty((String)string);
                bl = HivePropertyMetadata.getDelimitedProperties().contains(string2);
            }
        }
        return bl;
    }

    protected HiveDDLType getDDLType(String string) {
        return new HiveDDLType(HiveDDLType.StatementType.valueOf(string));
    }

    public Collection getAllowedPropertyValues(DBObject dBObject, DBObject dBObject2, String string) {
        List<Table.TableType> list = "TableType".equals(string) ? Arrays.asList(Table.TableType.NORMAL, Table.TableType.EXTERNAL) : super.getAllowedPropertyValues(dBObject, dBObject2, string);
        if ("predefinedFileFormat".equals(string) && this.getDatabaseVersion() < 14) {
            list.remove(HiveStorageProperties.PredefinedFileFormat.AVRO);
        }
        return list;
    }

    public boolean supportsProperty(Class<? extends DBObject> clazz, String string) {
        boolean bl = super.supportsProperty(clazz, string);
        if (bl && HiveStorageProperties.class.equals(clazz) && "nullFormat".equals(string)) {
            int n = this.getDatabaseVersion();
            bl = n >= 13;
        }
        return bl;
    }

    private static class ColumnsGen
    extends TokenGenerator {
        static final String TOKEN = "nonPartitionColumns";

        private ColumnsGen() {
        }

        public Collection<String> getPropertiesProcessed(String string, DBObjectProvider dBObjectProvider) {
            return Collections.singleton("columns");
        }

        public Object evaluateToken(TokenContext tokenContext) {
            Object object = null;
            Object object2 = tokenContext.getObject();
            if (object2 instanceof Relation) {
                DBObjectID[] dBObjectIDArray;
                Column[] columnArray;
                Relation relation = (Relation)object2;
                object = columnArray = relation.getColumns();
                HivePartitionProperties hivePartitionProperties = (HivePartitionProperties)relation.getProperty("HivePartitionProperties");
                if (hivePartitionProperties != null && (dBObjectIDArray = hivePartitionProperties.getPartitionColumns()) != null && dBObjectIDArray.length > 0) {
                    ArrayList<Column> arrayList = new ArrayList<Column>();
                    for (Column column : columnArray) {
                        if (this.contains(column.getID(), dBObjectIDArray)) continue;
                        arrayList.add(column);
                    }
                    object = arrayList;
                }
            }
            return object;
        }

        private boolean contains(DBObjectID dBObjectID, DBObjectID[] dBObjectIDArray) {
            boolean bl = false;
            if (dBObjectID != null) {
                for (DBObjectID dBObjectID2 : dBObjectIDArray) {
                    if (!dBObjectID.equals(dBObjectID2, true)) continue;
                    bl = true;
                    break;
                }
            }
            return bl;
        }

        public void generateToken(TokenContext tokenContext) {
            throw new UnsupportedOperationException("generate not supported for nonPartitionColumns");
        }
    }
}

