/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.hive;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import oracle.javatools.db.AbstractDBObjectBuilder;
import oracle.javatools.db.AbstractDBObjectProvider;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Database;
import oracle.javatools.db.Schema;
import oracle.javatools.db.Table;
import oracle.javatools.db.execute.QueryWrapper;
import oracle.javatools.db.execute.StatementWrapper;
import oracle.javatools.db.hive.HiveDatabaseImpl;
import oracle.javatools.db.hive.HivePartition;
import oracle.javatools.db.hive.HivePartitionBuilder;
import oracle.javatools.db.hive.HivePartitionProperties;

public class HivePartitionsBuilder
extends AbstractDBObjectBuilder<HivePartitionProperties> {
    public HivePartitionsBuilder(HiveDatabaseImpl hiveDatabaseImpl) {
        super((AbstractDBObjectProvider)hiveDatabaseImpl, "HivePartitionProperties");
    }

    protected boolean canBuildComponents() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @AbstractDBObjectBuilder.PropertyBuilder(value={"partitions"})
    public void buildUsingDescribe(HivePartitionProperties hivePartitionProperties) throws DBException {
        Object object;
        Object object2;
        ArrayList arrayList;
        HiveDatabaseImpl hiveDatabaseImpl;
        block15: {
            Table table = (Table)hivePartitionProperties.getParent();
            if (table == null) return;
            hiveDatabaseImpl = (HiveDatabaseImpl)this.getProvider();
            boolean bl = hiveDatabaseImpl.getDatabaseVersion() >= 13;
            Schema schema = hiveDatabaseImpl.getDefaultSchema();
            arrayList = new ArrayList();
            Schema schema2 = table.getSchema();
            boolean bl2 = false;
            try {
                if (bl) {
                    object2 = DBUtil.getFullyQualifiedName((DBObject)table, (boolean)true);
                } else {
                    object2 = table.getName();
                    if (schema != null && schema2 != null && !hiveDatabaseImpl.getDescriptor().areNamesEqual((DBObject)schema2, (DBObject)schema)) {
                        bl2 = true;
                        new StatementWrapper((Database)hiveDatabaseImpl, new String[]{"use " + schema2.getName()}).execute();
                    }
                }
                object = new QueryWrapper((Database)hiveDatabaseImpl, "show partitions " + (String)object2);
                object.executeQuery(new QueryWrapper.QueryRunnable(){

                    public void processResultSet(ResultSet resultSet) throws DBException, SQLException {
                        while (resultSet.next()) {
                            arrayList.add(resultSet.getString(1));
                        }
                    }
                });
                if (!bl2) break block15;
            }
            catch (Throwable throwable) {
                if (!bl2) throw throwable;
                try {
                    new StatementWrapper((Database)hiveDatabaseImpl, new String[]{"use " + schema.getName()}).execute();
                    throw throwable;
                }
                catch (DBException dBException) {
                    this.getLogger().severe("Could not reset Connection database: " + dBException.getMessage());
                }
                throw throwable;
            }
            try {
                new StatementWrapper((Database)hiveDatabaseImpl, new String[]{"use " + schema.getName()}).execute();
            }
            catch (DBException dBException) {
                this.getLogger().severe("Could not reset Connection database: " + dBException.getMessage());
            }
        }
        object2 = new ArrayList();
        object = arrayList.iterator();
        while (true) {
            HivePartition hivePartition;
            if (!object.hasNext()) {
                hivePartitionProperties.setPartitions(object2.toArray(new HivePartition[object2.size()]));
                return;
            }
            String string = (String)object.next();
            LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
            StringBuilder stringBuilder = new StringBuilder();
            for (String string2 : hivePartition = string.split("/")) {
                String[] stringArray = string2.split("=");
                if (stringArray.length != 2) {
                    this.getLogger().warning("Invalid partition mapping: " + string2);
                    continue;
                }
                if (linkedHashMap.containsKey(stringArray[0])) {
                    this.getLogger().warning("Duplicate column " + stringArray[0] + " in partition: " + string);
                    continue;
                }
                String string3 = this.decode(stringArray[0]);
                String string4 = this.decode(stringArray[1]);
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(',');
                }
                stringBuilder.append(string3).append("='").append(string4).append('\'');
                linkedHashMap.put(string3, string4);
            }
            HivePartition hivePartition2 = new HivePartition();
            hivePartition2.setName(stringBuilder.toString());
            Collection collection = linkedHashMap.values();
            hivePartition2.setValues(collection.toArray(new String[collection.size()]));
            hiveDatabaseImpl.setHiveBuilder(hivePartition2, new HivePartitionBuilder(hiveDatabaseImpl));
            object2.add(hivePartition2);
        }
    }

    private String decode(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '%' && i < string.length() - 2) {
                int n;
                try {
                    n = Integer.valueOf(string.substring(i + 1, i + 3), 16);
                }
                catch (Exception exception) {
                    n = -1;
                }
                if (n >= 0) {
                    stringBuilder.append((char)n);
                    i += 2;
                    continue;
                }
            }
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }
}

