/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.informix;

import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeHelper;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.db.resource.APIBundle;
import oracle.javatools.db.validators.DataTypeUsageValidator;
import oracle.javatools.db.validators.ValidationException;

public class InformixDataTypeUsageValidator
extends DataTypeUsageValidator {
    private static final String FRACTION = "FRACTION";
    private static final String YEAR = "YEAR";
    private static final String MONTH = "MONTH";
    static final String[] TIME_UNITS = new String[]{"YEAR", "MONTH", "DAY", "HOUR", "MINUTE", "SECOND", "FRACTION"};

    public InformixDataTypeUsageValidator(DBObjectProvider dBObjectProvider) {
        super(dBObjectProvider);
    }

    @Override
    protected void validateAttributes(DataTypeUsage dataTypeUsage, DataType dataType) throws ValidationException {
        super.validateAttributes(dataTypeUsage, dataType);
        String string = dataType.getName();
        if (this.isVarchar(string)) {
            Long l = DataTypeHelper.getLongAttributeValue((DataTypeUsage)dataTypeUsage, (String)"reserve");
            Long l2 = DataTypeHelper.getLongAttributeValue((DataTypeUsage)dataTypeUsage, (String)"size");
            if (l2 != null && l != null && l.compareTo(l2) > 0) {
                this.throwAttributeValueInvalid(dataTypeUsage, "reserve", APIBundle.format((String)"DATATYPE_ERROR_INVALID_NUMERIC_VALUE2", (Object[])new Object[]{APIBundle.get((String)"DATATYPE_ATTRIBUTE_LABEL_RESERVE"), l2}));
            }
        } else if (this.isTime(string)) {
            String string2 = DataTypeHelper.getStringAttributeValue((DataTypeUsage)dataTypeUsage, (String)"to");
            String string3 = DataTypeHelper.getStringAttributeValue((DataTypeUsage)dataTypeUsage, (String)"from");
            Long l = DataTypeHelper.getLongAttributeValue((DataTypeUsage)dataTypeUsage, (String)"scale");
            if (string3 != null && string2 == null || string3 == null && string2 != null) {
                this.throwAttributeValueInvalid(dataTypeUsage, string3 == null ? "to" : "from", APIBundle.get((String)"DATATYPE_ERROR_INVALID_INFORMIX_DATETIME_OR_INTERVAL"));
            }
            if (l != null && string2 != null && !string2.equalsIgnoreCase(FRACTION)) {
                this.throwAttributeValueInvalid(dataTypeUsage, "scale", APIBundle.get((String)"DATATYPE_ERROR_INVALID_INFORMIX_INVALID_FRACTION"));
            }
            if (string3 != null) {
                if (InformixDataTypeUsageValidator.getTimeSize(string2) < InformixDataTypeUsageValidator.getTimeSize(string3)) {
                    this.throwAttributeValueInvalid(dataTypeUsage, "to", APIBundle.get((String)"DATATYPE_ERROR_INVALID_INFORMIX_INVALID_QUALIFIERS"));
                }
                if ("INTERVAL".equals(string)) {
                    Long l3;
                    if ((string3.equals(YEAR) || string3.equals(MONTH)) && !string2.equals(YEAR) && !string2.equals(MONTH)) {
                        this.throwAttributeValueInvalid(dataTypeUsage, "to", APIBundle.get((String)"DATATYPE_ERROR_INVALID_INFORMIX_INVALID_INTERVAL_QUALIFIERS"));
                    }
                    if (string3.equals(FRACTION) && (l3 = DataTypeHelper.getLongAttributeValue((DataTypeUsage)dataTypeUsage, (String)"precision")) != null && l3.compareTo(5L) > 0) {
                        this.throwAttributeValueInvalid(dataTypeUsage, "precision", APIBundle.format((String)"DATATYPE_ERROR_INVALID_NUMERIC_VALUE2", (Object[])new Object[]{APIBundle.get((String)"DATATYPE_ATTRIBUTE_LABEL_PRECISION"), 5L}));
                    }
                }
            }
        }
    }

    private boolean isVarchar(String string) {
        return "VARCHAR".equals(string) || "NVARCHAR".equals(string);
    }

    private boolean isTime(String string) {
        return "DATETIME".equals(string) || "INTERVAL".equals(string);
    }

    private static int getTimeSize(String string) {
        int n = 0;
        while (!TIME_UNITS[n].equalsIgnoreCase(string)) {
            ++n;
        }
        return n;
    }
}

