/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.jdbc;

import java.sql.ResultSet;
import java.sql.SQLException;
import oracle.javatools.db.AbstractDBObjectBuilder;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Database;
import oracle.javatools.db.JdbcDatabase;
import oracle.javatools.db.ReferenceID;
import oracle.javatools.db.Synonym;
import oracle.javatools.db.execute.QueryWrapper;
import oracle.javatools.db.jdbc.DMDBuilder;
import oracle.javatools.db.resource.APIBundle;
import oracle.javatools.util.ModelUtil;

public class JdbcSynonymBuilder
extends DMDBuilder<Synonym> {
    private boolean m_synonymNotAlias;

    public JdbcSynonymBuilder(JdbcDatabase jdbcDatabase, String string, boolean bl) {
        super(jdbcDatabase, string, bl ? "SYNONYM" : "ALIAS");
        this.m_synonymNotAlias = bl;
    }

    protected final boolean isSynonymNotAlias() {
        return this.m_synonymNotAlias;
    }

    @AbstractDBObjectBuilder.PropertyBuilder(value={"reference"})
    public void buildReference(final Synonym synonym) throws DBException {
        String string = this.getDictionaryQuery();
        if (string == null) {
            this.getLogger().warning(APIBundle.format((String)"SYNONYM_BUILD_REF_ERR", (Object[])new Object[]{synonym.getName()}));
        } else {
            final QueryWrapper queryWrapper = new QueryWrapper((Database)this.getDatabase(), string, this.getDictionaryQueryParams(synonym));
            queryWrapper.executeQuery(new QueryWrapper.QueryRunnable(){

                public void processResultSet(ResultSet resultSet) throws DBException {
                    try {
                        if (resultSet.next()) {
                            DBObjectID dBObjectID = JdbcSynonymBuilder.this.decodeReferenceID(resultSet, synonym);
                            synonym.setReference(dBObjectID);
                        }
                    }
                    catch (SQLException sQLException) {
                        queryWrapper.throwDBException(sQLException);
                    }
                }
            });
        }
    }

    protected String getDictionaryQuery() {
        return null;
    }

    protected Object[] getDictionaryQueryParams(Synonym synonym) {
        return new Object[]{synonym.getSchema(), synonym};
    }

    protected DBObjectID decodeReferenceID(ResultSet resultSet, Synonym synonym) throws SQLException {
        String string = resultSet.getString(1);
        String string2 = null;
        int n = resultSet.getMetaData().getColumnCount();
        if (n > 1) {
            string2 = resultSet.getString(2).trim();
        } else if (string.contains(".")) {
            int n2 = string.lastIndexOf(".");
            string2 = string.substring(0, n2);
            string = string.substring(n2 + 1);
        }
        ReferenceID referenceID = null;
        if (ModelUtil.hasLength((String)string)) {
            if (this.needsNamesConverting()) {
                string = this.getProvider().getInternalName(string);
            }
            if (!ModelUtil.hasLength((String)string2)) {
                string2 = synonym.getSchema().getName();
            } else if (this.needsNamesConverting()) {
                string2 = this.getProvider().getInternalName(string2);
            }
            referenceID = new ReferenceID("UNSPECIFIED_TYPE", string2, string);
            referenceID.setProvider((DBObjectProvider)this.getProvider());
        }
        return referenceID;
    }

    protected boolean needsNamesConverting() {
        return false;
    }

    public boolean canBuildEditableObject() {
        return this.getDictionaryQuery() != null;
    }

    protected boolean canBuildComponents() {
        return true;
    }
}

