/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.ResultSet;
import java.sql.SQLException;
import oracle.javatools.db.AbstractDBObjectBuilder;
import oracle.javatools.db.AbstractIncrementer;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.execute.QueryWrapper;
import oracle.javatools.db.ora.BaseOracleDatabase;
import oracle.javatools.db.ora.OracleDBObjectBuilder;

public abstract class OracleIncrementerBuilder<T extends AbstractIncrementer>
extends OracleDBObjectBuilder<T> {
    OracleIncrementerBuilder(BaseOracleDatabase baseOracleDatabase, String string) {
        super(baseOracleDatabase, string);
    }

    protected boolean canBuildComponents() {
        return true;
    }

    @AbstractDBObjectBuilder.PropertyBuilder(value={"minValue", "maxValue", "incrementBy", "cacheFlag", "cacheSize", "cycleFlag", "orderFlag", "lastNumber"})
    public void fillInIncrementProperties(final AbstractIncrementer abstractIncrementer) throws DBException {
        DBObject dBObject = DBUtil.getUppermostParent((DBObject)abstractIncrementer);
        if (dBObject instanceof SchemaObject) {
            final SchemaObject schemaObject = (SchemaObject)dBObject;
            final QueryWrapper queryWrapper = this.getDatabase().newQueryWrapper((SystemObject)schemaObject, this.getSequenceQuery(), schemaObject.getSchema(), abstractIncrementer.getName());
            QueryWrapper.QueryRunnable queryRunnable = new QueryWrapper.QueryRunnable(){

                public void processResultSet(ResultSet resultSet) throws DBException {
                    try {
                        if (resultSet.next()) {
                            BigDecimal bigDecimal = resultSet.getBigDecimal(1);
                            BigDecimal bigDecimal2 = resultSet.getBigDecimal(2);
                            BigDecimal bigDecimal3 = resultSet.getBigDecimal(3);
                            String string = resultSet.getString(4);
                            String string2 = resultSet.getString(5);
                            BigDecimal bigDecimal4 = resultSet.getBigDecimal(6);
                            BigDecimal bigDecimal5 = resultSet.getBigDecimal(7);
                            BigInteger bigInteger = bigDecimal == null ? null : bigDecimal.toBigInteger();
                            BigInteger bigInteger2 = bigDecimal2 == null ? null : bigDecimal2.toBigInteger();
                            BigInteger bigInteger3 = bigDecimal3 == null ? null : bigDecimal3.toBigInteger();
                            BigInteger bigInteger4 = bigDecimal5 == null ? null : bigDecimal5.toBigInteger();
                            BigInteger bigInteger5 = null;
                            if (bigDecimal4 == null || bigDecimal4.intValue() == 0) {
                                abstractIncrementer.setCacheFlag(Boolean.valueOf(false));
                            } else {
                                abstractIncrementer.setCacheFlag(Boolean.valueOf(true));
                                bigInteger5 = bigDecimal4.toBigInteger();
                            }
                            abstractIncrementer.setMinValue(bigInteger);
                            abstractIncrementer.setMaxValue(bigInteger2);
                            abstractIncrementer.setIncrementBy(bigInteger3);
                            abstractIncrementer.setCycleFlag(Boolean.valueOf("Y".equalsIgnoreCase(string)));
                            abstractIncrementer.setOrderFlag(Boolean.valueOf("Y".equalsIgnoreCase(string2)));
                            abstractIncrementer.setCacheSize(bigInteger5);
                            abstractIncrementer.setLastNumber(bigInteger4);
                        }
                    }
                    catch (SQLException sQLException) {
                        queryWrapper.throwDBException((DBObject)schemaObject, sQLException);
                    }
                }
            };
            queryWrapper.executeQuery(queryRunnable);
        }
    }

    private String getSequenceQuery() {
        return "Oracle Lite".equals(this.getDatabase().getDatabaseType()) ? "SELECT /*OracleDictionaryQueries.ALL_OLITE_SEQUENCE_QUERY*/\n       MIN_VALUE, MAX_VALUE, INCREMENT_BY, NULL, NULL, NULL, NULL FROM SYS.ALL_SEQUENCES S WHERE SEQUENCE_OWNER = ? AND SEQUENCE_NAME = ?" : "SELECT /*OracleDictionaryQueries.ALL_ORACLE_SEQUENCE_QUERY*/\n       MIN_VALUE, MAX_VALUE, INCREMENT_BY, CYCLE_FLAG, ORDER_FLAG, CACHE_SIZE, LAST_NUMBER FROM SYS.ALL_SEQUENCES S WHERE SEQUENCE_OWNER = ? AND SEQUENCE_NAME = ? ";
    }
}

