/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.lite;

import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.datatypes.DataTypeCache;
import oracle.javatools.db.ddl.DDLGenerator;
import oracle.javatools.db.ora.OracleDatabaseDescriptor;
import oracle.javatools.db.ora.OracleLite;
import oracle.javatools.db.ora.OracleLite10gR3;
import oracle.javatools.db.ora.ddl.OracleLiteDDLGenerator;
import oracle.javatools.db.ora.lite.OracleDatabaseLite;

public class OracleDatabaseLiteDescriptor
extends OracleDatabaseDescriptor {
    public OracleDatabaseLiteDescriptor(int n) {
        super(n == 103 ? OracleLite10gR3.class : OracleLite.class, n);
    }

    public OracleDatabaseLiteDescriptor(Class<? extends OracleDatabaseLite> clazz) {
        super(clazz, OracleLite10gR3.class.isAssignableFrom(clazz) ? 103 : 101);
    }

    @Override
    public String getDatabaseType() {
        return "Oracle Lite";
    }

    @Override
    public DDLGenerator getDDLGenerator(DBObjectProvider dBObjectProvider) {
        return new OracleLiteDDLGenerator(this.getDatabaseClass(), dBObjectProvider);
    }

    @Override
    protected void registerDataTypes(DataTypeCache dataTypeCache) {
        int n;
        String string = this.getDatabaseType();
        if ("Oracle Lite".equals(string) && (n = this.getDatabaseVersion()) == 101) {
            dataTypeCache.registerDataType("BIGINT");
            dataTypeCache.registerDataType("BINARY");
            dataTypeCache.registerDataType("BIT");
            dataTypeCache.registerDataType("BLOB");
            dataTypeCache.registerDataType("CHAR");
            dataTypeCache.registerDataType("CLOB");
            dataTypeCache.registerDataType("DATE");
            dataTypeCache.registerDataType("DECIMAL");
            dataTypeCache.registerDataType("DOUBLE PRECISION");
            dataTypeCache.registerDataType("FLOAT");
            dataTypeCache.registerDataType("INTEGER");
            dataTypeCache.registerDataType("LONG RAW");
            dataTypeCache.registerDataType("LONG VARBINARY");
            dataTypeCache.registerDataType("LONG VARCHAR");
            dataTypeCache.registerDataType("LONG");
            dataTypeCache.registerDataType("NUMBER");
            dataTypeCache.registerDataType("NUMERIC");
            dataTypeCache.registerDataType("RAW");
            dataTypeCache.registerDataType("REAL");
            dataTypeCache.registerDataType("ROWID");
            dataTypeCache.registerDataType("SMALLINT");
            dataTypeCache.registerDataType("TIME");
            dataTypeCache.registerDataType("TIMESTAMP");
            dataTypeCache.registerDataType("TINYINT");
            dataTypeCache.registerDataType("VARBINARY");
            dataTypeCache.registerDataType("VARCHAR");
            dataTypeCache.registerDataType("VARCHAR2");
        }
    }
}

