/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.owb;

import java.util.HashMap;
import oracle.javatools.db.Index;
import oracle.javatools.db.ora.MaterializedView;
import oracle.javatools.db.ora.OracleIndexPartitions;
import oracle.javatools.db.ora.owb.OMBSinglePropertyResolver;
import oracle.javatools.db.ora.owb.OMBStoragePropsBuilder;
import oracle.javatools.db.property.Property;
import oracle.javatools.db.property.PropertyHelper;
import oracle.javatools.db.sql.IndexObject;

class OMBIndexPropsBuilder
extends OMBStoragePropsBuilder<Index> {
    public OMBIndexPropsBuilder(Object object) {
        super((Index)object, Property.createPath((String[])new String[]{"properties", "OracleStorageProperties"}));
        this.registerPropertyMappings();
        this.buildSetProperties();
    }

    @Override
    public void registerPropertyMappings() {
        HashMap<String, String> hashMap;
        super.registerPropertyMappings();
        Index index = (Index)this.getContextObject();
        if (!(index.getParent() instanceof MaterializedView)) {
            this.registerPropertyMapping("parallelDegree", new String[]{"PARALLEL_ACCESS_MODE", "PARALLEL_DEGREE"});
            hashMap = new HashMap<String, String>();
            hashMap.put("$DEFAULT$", "PARALLEL");
            this.registerSubstitutionValues("PARALLEL_ACCESS_MODE", (HashMap)hashMap);
        }
        this.registerPropertyMapping("keyCompression", new String[]{"KEYCOMPRESS", "KEYCOMPRESSPREFIXLENGTH"});
        hashMap = new HashMap();
        hashMap.put("$DEFAULT$", "COMPRESS");
        this.registerSubstitutionValues("KEYCOMPRESS", (HashMap)hashMap);
        if (index.getIndexType() != Index.IndexType.BITMAP && index.getIndexType() != Index.IndexType.UNIQUE) {
            this.registerPropertyMapping("columnExpressions", new OMBColExpressionPropResolver());
        }
        this.registerPropertyMapping("indexType", 1, "INDEX_TYPE");
        HashMap<String, String> hashMap2 = new HashMap<String, String>();
        hashMap2.put("NORMAL", "FUNCTION-BASED");
        this.registerSubstitutionValues("INDEX_TYPE", (HashMap)hashMap2);
        String string = Property.createPath((String[])new String[]{"properties", "OracleIndexPartitions"});
        this.registerPropertyMapping(string, new OMBIsLocalIndxPropResolver(string));
    }

    public final class OMBIsLocalIndxPropResolver
    implements OMBSinglePropertyResolver {
        final String m_prop;

        OMBIsLocalIndxPropResolver(String string) {
            this.m_prop = string;
        }

        @Override
        public String resolvePropertyValue() {
            OracleIndexPartitions oracleIndexPartitions;
            PropertyHelper propertyHelper = new PropertyHelper();
            Object object = propertyHelper.getPropertyValue((Object)OMBIndexPropsBuilder.this.getContextObject(), this.m_prop);
            if (object != null && object instanceof OracleIndexPartitions && ((oracleIndexPartitions = (OracleIndexPartitions)object).getPartitionType().equals((Object)OracleIndexPartitions.PartitionType.LOCAL_HASH) || oracleIndexPartitions.getPartitionType().equals((Object)OracleIndexPartitions.PartitionType.LOCAL_COMP) || oracleIndexPartitions.getPartitionType().equals((Object)OracleIndexPartitions.PartitionType.LOCAL_OTHER))) {
                return "true";
            }
            return "false";
        }

        @Override
        public String resolvePropertyName() {
            return "LOCAL_INDEX";
        }
    }

    public final class OMBColExpressionPropResolver
    implements OMBSinglePropertyResolver {
        final String COMMA = ",";

        @Override
        public String resolvePropertyValue() {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = true;
            for (IndexObject indexObject : ((Index)OMBIndexPropsBuilder.this.getContextObject()).getColumnExpressions()) {
                if (!bl) {
                    stringBuffer.append(",");
                }
                String string = indexObject.getExpressionSource();
                stringBuffer.append(string);
                if (IndexObject.OrderType.DESC.equals((Object)indexObject.getOrderType())) {
                    stringBuffer.append(" DESC");
                }
                bl = false;
            }
            return stringBuffer.toString();
        }

        @Override
        public String resolvePropertyName() {
            return "COLUMN_EXPRESSION";
        }
    }
}

