/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.owb;

import java.util.Comparator;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.TreeMap;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.Relation;
import oracle.javatools.db.View;
import oracle.javatools.db.ora.MaterializedView;
import oracle.javatools.db.ora.owb.OMBPropertyKey;
import oracle.javatools.db.ora.owb.OMBPropertyResolver;
import oracle.javatools.db.ora.owb.OMBPropertyValidator;
import oracle.javatools.db.ora.owb.OMBSinglePropertyResolver;
import oracle.javatools.db.property.PropertyHelper;

abstract class OMBPropsStatementBuilder<T extends DBObject> {
    private final T m_ctxtObject;
    private TreeMap<OMBPropertyKey, Object> m_mappings;
    private HashMap<String, HashMap<String, String>> m_substitutes;
    private HashMap<String, OMBPropertyValidator> m_propValidators;
    private StringBuffer m_propertyNames = new StringBuffer();
    private StringBuffer m_propertyValues = new StringBuffer();
    public final String SET_PROPERTIES = "SET PROPERTIES \\\n(";
    public final String SEPARATOR = ", ";
    public final String VALUES = ") \\\nVALUES \\\n(";
    public final String END_BRACKET = ") \\";
    public final String DEFAULT = "$DEFAULT$";
    public final String IGNORE = "$IGNORE$";

    OMBPropsStatementBuilder(T t) {
        this.m_ctxtObject = t;
    }

    public abstract void registerPropertyMappings();

    public void buildSetProperties() {
        boolean bl = true;
        String string = null;
        String string2 = null;
        PropertyHelper propertyHelper = new PropertyHelper();
        for (OMBPropertyKey oMBPropertyKey : this.m_mappings.keySet()) {
            Object object = this.m_mappings.get(oMBPropertyKey);
            Object object2 = propertyHelper.getPropertyValue(this.m_ctxtObject, oMBPropertyKey.getKey());
            if (object2 == null) continue;
            if (object instanceof String[]) {
                for (int i = 0; i < ((String[])object).length; ++i) {
                    string = ((String[])object)[i];
                    string2 = object2.toString();
                    bl = this.appendProperty(string, string2, bl);
                    this.validateProperty(string, string2);
                }
                continue;
            }
            if (object instanceof OMBPropertyResolver) {
                int n;
                OMBPropertyResolver oMBPropertyResolver = (OMBPropertyResolver)object;
                String[] stringArray = oMBPropertyResolver.resolvePropertyNames();
                String[] stringArray2 = oMBPropertyResolver.resolvePropertyValues();
                if (stringArray == null || stringArray2 == null || (n = stringArray.length) <= 0 || stringArray2.length != n) continue;
                for (int i = 0; i < n; ++i) {
                    bl = this.appendProperty(stringArray[i], stringArray2[i], bl);
                    this.validateProperty(string, string2);
                }
                continue;
            }
            string = (String)this.m_mappings.get(oMBPropertyKey);
            string2 = object2.toString();
            bl = this.appendProperty(string, string2, bl);
            this.validateProperty(string, string2);
        }
    }

    private boolean appendProperty(String string, String string2, boolean bl) {
        if (!(string2 = this.applySubstitutions(string, string2)).equals("$IGNORE$")) {
            if (!bl) {
                this.m_propertyNames.append(", ");
                this.m_propertyValues.append(", ");
            } else {
                bl = false;
            }
            this.m_propertyNames.append(string);
            this.m_propertyValues.append("'");
            this.m_propertyValues.append(string2);
            this.m_propertyValues.append("'");
        }
        return bl;
    }

    public String getPropertiesStatement() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.m_propertyNames.length() > 0) {
            stringBuffer.append("SET PROPERTIES \\\n(");
            stringBuffer.append(this.m_propertyNames.toString());
            stringBuffer.append(") \\\nVALUES \\\n(");
            stringBuffer.append(this.m_propertyValues.toString());
            stringBuffer.append(") \\");
            return stringBuffer.toString();
        }
        return null;
    }

    public void registerPropertyMapping(String string, Object object) {
        this.registerPropertyMapping(string, 99, object);
    }

    public void registerPropertyMapping(String string, int n, Object object) {
        if (this.m_mappings == null) {
            this.m_mappings = new TreeMap(new PropertyComparator());
        }
        OMBPropertyKey oMBPropertyKey = new OMBPropertyKey(string, n);
        this.m_mappings.put(oMBPropertyKey, object);
    }

    public void registerSubstitutionValues(String string, HashMap<String, String> hashMap) {
        if (this.m_substitutes == null) {
            this.m_substitutes = new HashMap();
        }
        this.m_substitutes.put(string, hashMap);
    }

    public void registerPropertyValidator(String string, OMBPropertyValidator oMBPropertyValidator) {
        if (this.m_propValidators == null) {
            this.m_propValidators = new HashMap();
        }
        this.m_propValidators.put(string, oMBPropertyValidator);
    }

    protected String applySubstitutions(String string, String string2) {
        if (this.m_substitutes != null && this.m_substitutes.keySet().contains(string)) {
            HashMap<String, String> hashMap = this.m_substitutes.get(string);
            String string3 = hashMap.get(string2);
            if (string3 == null && (string3 = hashMap.get("$DEFAULT$")) == null) {
                return string2;
            }
            return string3;
        }
        return string2;
    }

    private void validateProperty(String string, String string2) {
        OMBPropertyValidator oMBPropertyValidator;
        if (this.m_propValidators != null && this.m_propValidators.keySet().contains(string) && (oMBPropertyValidator = this.m_propValidators.get(string)) != null) {
            oMBPropertyValidator.validateProperty(string, string2);
        }
    }

    public T getContextObject() {
        return this.m_ctxtObject;
    }

    private class PropertyComparator
    implements Comparator {
        private PropertyComparator() {
        }

        public int compare(Object object, Object object2) {
            if (object instanceof OMBPropertyKey && object2 instanceof OMBPropertyKey) {
                OMBPropertyKey oMBPropertyKey = (OMBPropertyKey)object;
                OMBPropertyKey oMBPropertyKey2 = (OMBPropertyKey)object2;
                String string = oMBPropertyKey.getPosition() + oMBPropertyKey.getKey();
                String string2 = oMBPropertyKey2.getPosition() + oMBPropertyKey2.getKey();
                return string.compareTo(string2);
            }
            return 0;
        }
    }

    public final class OMBViewQueryPropResolver
    implements OMBSinglePropertyResolver {
        final Relation m_view;

        public OMBViewQueryPropResolver(Relation relation) {
            this.m_view = relation;
        }

        @Override
        public String resolvePropertyValue() {
            String string = null;
            string = this.m_view instanceof View ? ((View)this.m_view).getViewText() : ((MaterializedView)this.m_view).getSQLQuery().getSQLText();
            StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
            StringBuffer stringBuffer = new StringBuffer();
            while (stringTokenizer.hasMoreTokens()) {
                stringBuffer.append(stringTokenizer.nextToken());
                stringBuffer.append("\\n\\\n");
            }
            return stringBuffer.toString().trim().replaceAll("'", "''");
        }

        @Override
        public String resolvePropertyName() {
            return "VIEW_QUERY";
        }
    }
}

