/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.sql;

import java.util.Iterator;
import java.util.List;
import oracle.dbtools.parser.ParseNode;
import oracle.javatools.db.DatabaseDescriptor;
import oracle.javatools.db.ora.sql.ExpressionContext;
import oracle.javatools.db.ora.sql.ExpressionFactory;
import oracle.javatools.db.ora.sql.OracleSQLQueryBuilderHelper;
import oracle.javatools.db.resource.APIBundle;
import oracle.javatools.db.sql.ArithmeticOperation;
import oracle.javatools.db.sql.BuiltInFunction;
import oracle.javatools.db.sql.Comparison;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.db.sql.SQLQueryException;

public class ArithmeticOperationBuilder
extends ExpressionFactory {
    @Override
    public SQLFragment createFragment(ExpressionContext expressionContext, ParseNode parseNode) throws SQLQueryException {
        SQLFragment sQLFragment = null;
        OracleSQLQueryBuilderHelper oracleSQLQueryBuilderHelper = expressionContext.getHelper();
        List<ParseNode> list = oracleSQLQueryBuilderHelper.getOrderedChildren(parseNode);
        if (oracleSQLQueryBuilderHelper.isRule(parseNode, "expr", "compound_expression") || list.size() == 2 && oracleSQLQueryBuilderHelper.isOperation(list.get(0))) {
            SQLFragment sQLFragment2 = expressionContext.getCreating();
            Object object = expressionContext.getQueryContext();
            if (list.size() == 4 && oracleSQLQueryBuilderHelper.isKeyword(list.get(1), "|") && oracleSQLQueryBuilderHelper.isKeyword(list.get(2), "|")) {
                SQLFragment sQLFragment3 = expressionContext.createFragment(list.get(0), sQLFragment2, object);
                SQLFragment sQLFragment4 = expressionContext.createFragment(list.get(3), sQLFragment2, object);
                SQLFragment[] sQLFragmentArray = new SQLFragment[]{sQLFragment3, sQLFragment4};
                String string = "||";
                BuiltInFunction builtInFunction = null;
                DatabaseDescriptor databaseDescriptor = expressionContext.getProvider().getDescriptor();
                Iterator iterator = databaseDescriptor.listBuiltInFunctions("CONCAT").iterator();
                if (iterator.hasNext()) {
                    BuiltInFunction builtInFunction2;
                    builtInFunction = builtInFunction2 = (BuiltInFunction)iterator.next();
                }
                sQLFragment = expressionContext.createFunction(string, builtInFunction, null, false, sQLFragmentArray);
            } else if (list.size() == 3) {
                if (oracleSQLQueryBuilderHelper.isKeyword(list.get(0), "(")) {
                    sQLFragment = expressionContext.createFragment(list.get(1), sQLFragment2, object);
                } else if (oracleSQLQueryBuilderHelper.isLeaf(list.get(1))) {
                    ParseNode parseNode2 = list.get(1);
                    if (!oracleSQLQueryBuilderHelper.isLeaf(parseNode2)) {
                        throw new SQLQueryException(expressionContext.getQueryBuilder().buildErrorMessage(parseNode2, APIBundle.get((String)"SQL_RQB_OPERATOR_EXPECTED")));
                    }
                    SQLFragment sQLFragment5 = expressionContext.createFragment(list.get(0), sQLFragment2, object);
                    SQLFragment sQLFragment6 = expressionContext.createFragment(list.get(2), sQLFragment2, object);
                    String string = oracleSQLQueryBuilderHelper.getContent(parseNode2).toUpperCase();
                    ArithmeticOperation.ArithmeticOperator arithmeticOperator = ArithmeticOperation.getArithmeticOperator((String)string, (int)2);
                    if (arithmeticOperator != null) {
                        sQLFragment = new ArithmeticOperation(arithmeticOperator, new SQLFragment[]{sQLFragment5, sQLFragment6});
                    }
                }
            } else if (list.size() == 2 && oracleSQLQueryBuilderHelper.isLeaf(list.get(0))) {
                ParseNode parseNode3 = list.get(0);
                if (!oracleSQLQueryBuilderHelper.isLeaf(parseNode3)) {
                    throw new SQLQueryException("Operator expected");
                }
                SQLFragment sQLFragment7 = expressionContext.createFragment(list.get(1), sQLFragment2, object);
                String string = oracleSQLQueryBuilderHelper.getContent(parseNode3);
                Comparison.Comparator comparator = Comparison.getComparator((String)string);
                if (comparator != null) {
                    sQLFragment = new Comparison(sQLFragment7, comparator, null);
                } else {
                    ArithmeticOperation.ArithmeticOperator arithmeticOperator = ArithmeticOperation.getArithmeticOperator((String)string, (int)1);
                    if (arithmeticOperator != null) {
                        sQLFragment = new ArithmeticOperation(arithmeticOperator, new SQLFragment[]{sQLFragment7});
                    } else {
                        throw new SQLQueryException(APIBundle.format((String)"SQL_UNRECOGNISED_OPERATOR", (Object[])new Object[]{string}));
                    }
                }
            }
        }
        return sQLFragment;
    }
}

