/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.sql;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.dbtools.parser.ParseNode;
import oracle.javatools.db.ora.sql.ExpressionContext;
import oracle.javatools.db.ora.sql.ExpressionFactory;
import oracle.javatools.db.ora.sql.OracleSQLQueryBuilderHelper;
import oracle.javatools.db.sql.Comparison;
import oracle.javatools.db.sql.ExpressionList;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.db.sql.SQLQueryException;
import oracle.javatools.db.sql.SetOperation;
import oracle.javatools.db.sql.SimpleSQLFragment;

public class ConditionBuilder
extends ExpressionFactory {
    private static Map<String, Comparison.Comparator> s_op_map = new HashMap<String, Comparison.Comparator>();

    @Override
    public SQLFragment createFragment(ExpressionContext expressionContext, ParseNode parseNode) throws SQLQueryException {
        OracleSQLQueryBuilderHelper oracleSQLQueryBuilderHelper = expressionContext.getHelper();
        if (!oracleSQLQueryBuilderHelper.isRule(parseNode, "condition")) {
            return null;
        }
        Comparison comparison = null;
        List<ParseNode> list = oracleSQLQueryBuilderHelper.getOrderedChildren(parseNode);
        SQLFragment sQLFragment = expressionContext.getCreating();
        Object object = expressionContext.getQueryContext();
        if (oracleSQLQueryBuilderHelper.isRule(parseNode, "null_condition")) {
            int n = oracleSQLQueryBuilderHelper.getKeywordIndex(list, "not");
            Comparison.Comparator comparator = n == -1 ? Comparison.Comparator.NULL : Comparison.Comparator.NOT_NULL;
            SQLFragment sQLFragment2 = expressionContext.createFragment(list.get(0), sQLFragment, object);
            comparison = new Comparison(sQLFragment2, comparator, null);
        } else if (oracleSQLQueryBuilderHelper.isRule(parseNode, "is_JSON_condition")) {
            int n;
            Comparison.Comparator comparator;
            int n2 = oracleSQLQueryBuilderHelper.getKeywordIndex(list, "not");
            if (n2 == -1) {
                comparator = Comparison.Comparator.JSON;
                n = 2;
            } else {
                comparator = Comparison.Comparator.NOT_JSON;
                n = 3;
            }
            SQLFragment sQLFragment3 = expressionContext.createFragment(list.get(0), sQLFragment, object);
            SimpleSQLFragment simpleSQLFragment = null;
            if (list.size() > n + 1) {
                StringBuilder stringBuilder = new StringBuilder();
                for (int i = n + 1; i < list.size(); ++i) {
                    ParseNode parseNode2 = list.get(i);
                    if (parseNode2 == null) continue;
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append(' ');
                    }
                    stringBuilder.append(oracleSQLQueryBuilderHelper.getContent(parseNode2));
                }
                if (stringBuilder.length() > 0) {
                    simpleSQLFragment = new SimpleSQLFragment(stringBuilder.toString());
                }
            }
            comparison = new Comparison(sQLFragment3, comparator, simpleSQLFragment);
        } else if (oracleSQLQueryBuilderHelper.isRule(parseNode, "regexp_like_condition")) {
            SQLFragment[] sQLFragmentArray = expressionContext.getArgList(comparison, parseNode);
            comparison = new Comparison(Comparison.Comparator.REGEXP_LIKE, sQLFragmentArray);
        } else if (oracleSQLQueryBuilderHelper.isRule(parseNode, "like_condition")) {
            SQLFragment sQLFragment4 = expressionContext.createFragment(list.get(0), sQLFragment, object);
            SQLFragment sQLFragment5 = expressionContext.createFragment(list.get(list.size() - 1), sQLFragment, object);
            int n = oracleSQLQueryBuilderHelper.getKeywordIndex(list, "not");
            Comparison.Comparator comparator = n == -1 ? Comparison.Comparator.LIKE : Comparison.Comparator.NOT_LIKE;
            comparison = new Comparison(sQLFragment4, comparator, sQLFragment5);
        } else if (oracleSQLQueryBuilderHelper.isRule(parseNode, "comparison_condition", "simple_comparison_condition")) {
            if (oracleSQLQueryBuilderHelper.isRule(parseNode, "group_comparison_condition") && (list.size() == 6 || list.size() == 7)) {
                Comparison.Comparator comparator;
                String string = oracleSQLQueryBuilderHelper.getContent(list.get(1)) + oracleSQLQueryBuilderHelper.getContent(list.get(2));
                int n = 4;
                if (list.size() == 7) {
                    string = string + oracleSQLQueryBuilderHelper.getContent(list.get(3));
                    n = 5;
                }
                if ((comparator = this.getOperation(string)) != null) {
                    SQLFragment sQLFragment6 = expressionContext.createFragment(list.get(0), sQLFragment);
                    List<SQLFragment> list2 = this.getExpressionList(list.get(n), expressionContext);
                    ExpressionList expressionList = new ExpressionList(list2.toArray(new SQLFragment[list2.size()]));
                    comparison = new Comparison(sQLFragment6, comparator, (SQLFragment)expressionList);
                }
            } else if (oracleSQLQueryBuilderHelper.isRule(parseNode, "comparison_condition", "simple_comparison_condition") && (list.size() == 4 || list.size() == 3)) {
                SQLFragment sQLFragment7 = expressionContext.createFragment(list.get(0), sQLFragment);
                boolean bl = this.hasPrior(list.get(0), expressionContext);
                int n = 2;
                String string = oracleSQLQueryBuilderHelper.getContent(list.get(1));
                if (list.size() == 4) {
                    string = string + oracleSQLQueryBuilderHelper.getContent(list.get(2));
                    n = 3;
                }
                SQLFragment sQLFragment8 = expressionContext.createFragment(list.get(n), sQLFragment);
                boolean bl2 = this.hasPrior(list.get(n), expressionContext);
                Comparison.Comparator comparator = this.getOperation(string);
                if (comparator != null) {
                    comparison = new Comparison(sQLFragment7, comparator, sQLFragment8);
                    comparison.setPriorOnLeft(bl);
                    comparison.setPriorOnRight(bl2);
                }
            }
        } else if (oracleSQLQueryBuilderHelper.isRule(parseNode, "condition")) {
            if (oracleSQLQueryBuilderHelper.isRule(parseNode, "in_condition")) {
                SQLFragment sQLFragment9;
                SQLFragment[] sQLFragmentArray = null;
                if (oracleSQLQueryBuilderHelper.isKeyword(list.get(0), "(")) {
                    SQLFragment[] sQLFragmentArray2 = this.getExpressionList(list, 0, oracleSQLQueryBuilderHelper.getKeywordIndex(list, ")"), expressionContext);
                    sQLFragment9 = new ExpressionList(sQLFragmentArray2);
                } else {
                    sQLFragment9 = expressionContext.createFragment(list.get(0), sQLFragment);
                }
                boolean bl = oracleSQLQueryBuilderHelper.getKeywordIndex(list, "not") != -1;
                int n = oracleSQLQueryBuilderHelper.getKeywordIndex(list, "IN");
                int n3 = n + 1;
                int n4 = list.size() - 1;
                SQLFragment[] sQLFragmentArray3 = this.getExpressionList(list, n3, n4, expressionContext);
                if (sQLFragmentArray3.length == 1 && sQLFragmentArray3[0] instanceof ExpressionList) {
                    sQLFragmentArray3 = ((ExpressionList)sQLFragmentArray3[0]).getArguments();
                }
                sQLFragmentArray = new SQLFragment[1 + sQLFragmentArray3.length];
                sQLFragmentArray[0] = sQLFragment9;
                for (int i = 0; i < sQLFragmentArray3.length; ++i) {
                    sQLFragmentArray[i + 1] = sQLFragmentArray3[i];
                }
                SetOperation.Operator operator = bl ? SetOperation.Operator.NOT_IN : SetOperation.Operator.IN;
                comparison = new SetOperation(operator, sQLFragmentArray);
            } else if (oracleSQLQueryBuilderHelper.isRule(parseNode, "exists_condition")) {
                boolean bl = "not".equals(expressionContext.getQueryContext());
                int n = oracleSQLQueryBuilderHelper.getKeywordIndex(list, "EXISTS");
                SQLFragment sQLFragment10 = expressionContext.createFragment(list.get(n + 2), sQLFragment);
                Comparison.Comparator comparator = bl ? Comparison.Comparator.NOT_EXISTS : Comparison.Comparator.EXISTS;
                comparison = new Comparison(sQLFragment10, comparator);
            } else if (list.size() == 2 && oracleSQLQueryBuilderHelper.isKeyword(list.get(0), "not")) {
                comparison = expressionContext.createFragment(list.get(1), sQLFragment, "not");
            }
        }
        return comparison;
    }

    private boolean hasPrior(ParseNode parseNode, ExpressionContext expressionContext) {
        boolean bl = false;
        OracleSQLQueryBuilderHelper oracleSQLQueryBuilderHelper = expressionContext.getHelper();
        List<ParseNode> list = oracleSQLQueryBuilderHelper.getOrderedChildren(parseNode);
        if (oracleSQLQueryBuilderHelper.isRule(parseNode, "compound_expression") && list.size() == 2 && oracleSQLQueryBuilderHelper.isKeyword(list.get(0), "PRIOR")) {
            bl = true;
        }
        return bl;
    }

    private Comparison.Comparator getOperation(String string) {
        Comparison.Comparator comparator = Comparison.getComparator((String)(string = string.toUpperCase()));
        if (comparator == null) {
            comparator = s_op_map.get(string);
        }
        return comparator;
    }

    private SQLFragment[] getExpressionList(List<ParseNode> list, int n, int n2, ExpressionContext expressionContext) throws SQLQueryException {
        OracleSQLQueryBuilderHelper oracleSQLQueryBuilderHelper = expressionContext.getHelper();
        List<Object> list2 = new ArrayList();
        SQLFragment[] sQLFragmentArray = null;
        if (n2 == n + 2 && oracleSQLQueryBuilderHelper.isRule(list.get(n + 1), "\"expr_list\"")) {
            list2 = this.getExpressionList(list.get(n + 1), expressionContext);
        } else {
            for (int i = n + 1; i < n2; ++i) {
                if (oracleSQLQueryBuilderHelper.isKeyword(list.get(i), ",")) continue;
                List<SQLFragment> list3 = this.getExpressionList(list.get(i), expressionContext);
                ExpressionList expressionList = new ExpressionList(list3.toArray(new SQLFragment[list3.size()]));
                list2.add(expressionList);
            }
        }
        sQLFragmentArray = list2.toArray(new SQLFragment[list2.size()]);
        return sQLFragmentArray;
    }

    private List<SQLFragment> getExpressionList(ParseNode parseNode, ExpressionContext expressionContext) throws SQLQueryException {
        ArrayList<SQLFragment> arrayList = new ArrayList<SQLFragment>();
        OracleSQLQueryBuilderHelper oracleSQLQueryBuilderHelper = expressionContext.getHelper();
        if (oracleSQLQueryBuilderHelper.isRule(parseNode, "expr", "query_block")) {
            SQLFragment sQLFragment = expressionContext.createFragment(parseNode, expressionContext.getCreating());
            arrayList.add(sQLFragment);
        } else if (oracleSQLQueryBuilderHelper.isRule(parseNode, "expression_list", "\"expr_list\"")) {
            List<ParseNode> list = oracleSQLQueryBuilderHelper.getOrderedChildren(parseNode);
            for (ParseNode parseNode2 : list) {
                arrayList.addAll(this.getExpressionList(parseNode2, expressionContext));
            }
        }
        return arrayList;
    }

    static {
        s_op_map.put("!=", Comparison.Comparator.NOT_EQUAL);
        s_op_map.put("^=", Comparison.Comparator.NOT_EQUAL);
        s_op_map.put("<>", Comparison.Comparator.NOT_EQUAL);
        s_op_map.put("!=ANY", Comparison.Comparator.NOT_EQUAL_ANY);
        s_op_map.put("^=ANY", Comparison.Comparator.NOT_EQUAL_ANY);
        s_op_map.put("<>ANY", Comparison.Comparator.NOT_EQUAL_ANY);
        s_op_map.put("!=ALL", Comparison.Comparator.NOT_EQUAL_ALL);
        s_op_map.put("^=ALL", Comparison.Comparator.NOT_EQUAL_ALL);
        s_op_map.put("<>ALL", Comparison.Comparator.NOT_EQUAL_ALL);
        s_op_map.put("!=SOME", Comparison.Comparator.NOT_EQUAL_SOME);
        s_op_map.put("^=SOME", Comparison.Comparator.NOT_EQUAL_SOME);
        s_op_map.put("<>SOME", Comparison.Comparator.NOT_EQUAL_SOME);
    }
}

