/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.sxml;

import java.util.ArrayList;
import oracle.javatools.db.BaseObjectID;
import oracle.javatools.db.CheckConstraint;
import oracle.javatools.db.Column;
import oracle.javatools.db.Constraint;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.FKConstraint;
import oracle.javatools.db.Index;
import oracle.javatools.db.NameBasedID;
import oracle.javatools.db.PKConstraint;
import oracle.javatools.db.ReferenceID;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.Table;
import oracle.javatools.db.UniqueConstraint;
import oracle.javatools.db.ora.sxml.SXMLFragmentGenerator;
import oracle.javatools.db.ora.sxml.SXMLReader;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

class ConstraintSXMLGenerator
extends SXMLFragmentGenerator {
    private static final String CKS = "CHECK_CONSTRAINT_LIST";
    private static final String PKS = "PRIMARY_KEY_CONSTRAINT_LIST";
    private static final String UKS = "UNIQUE_KEY_CONSTRAINT_LIST";
    private static final String FKS = "FOREIGN_KEY_CONSTRAINT_LIST";

    ConstraintSXMLGenerator() {
    }

    @Override
    protected void populateNode(Node node, Document document, Object object) {
        Node node2 = this.findOrCreateNode(document, node, "RELATIONAL_TABLE");
        Node node3 = this.findOrCreateNodeAfter(document, node2, CKS, "COL_LIST");
        Node node4 = this.findOrCreateNodeAfter(document, node2, PKS, CKS);
        Node node5 = this.findOrCreateNodeAfter(document, node2, UKS, PKS);
        Node node6 = this.findOrCreateNodeAfter(document, node2, FKS, UKS);
        Table table = (Table)object;
        Constraint[] constraintArray = table.getConstraints();
        for (int i = 0; i < constraintArray.length; ++i) {
            if (constraintArray[i] instanceof PKConstraint) {
                this.processConstraint(document, node, constraintArray[i], PKS, node4);
                continue;
            }
            if (constraintArray[i] instanceof FKConstraint) {
                Object object2;
                Object object3;
                Object object4;
                Object object5;
                Node node7 = this.processConstraint(document, node, constraintArray[i], FKS, node6);
                FKConstraint fKConstraint = (FKConstraint)constraintArray[i];
                DBObjectID dBObjectID = fKConstraint.getReferenceID();
                String string = null;
                String string2 = null;
                String[] stringArray = new String[]{};
                if (dBObjectID instanceof ReferenceID) {
                    object5 = (ReferenceID)dBObjectID;
                    object4 = object5.getParent();
                    if (object4 instanceof BaseObjectID) {
                        string = ((BaseObjectID)object4).getSchemaName();
                        string2 = ((BaseObjectID)object4).getName();
                        stringArray = object5.getChildObjectNames();
                    }
                } else {
                    object5 = null;
                    try {
                        object5 = dBObjectID.resolveID();
                    }
                    catch (DBException dBException) {
                        // empty catch block
                    }
                    if (object5 instanceof UniqueConstraint) {
                        object4 = (UniqueConstraint)object5;
                        object3 = (SchemaObject)object4.getParent();
                        string = object3.getSchema().getName();
                        string2 = object3.getName();
                        stringArray = new String[object4.getColumnIDs().length];
                        int n = 0;
                        for (DBObjectID dBObjectID2 : object4.getColumnIDs()) {
                            if (dBObjectID2 instanceof BaseObjectID) {
                                stringArray[n++] = ((BaseObjectID)dBObjectID2).getName();
                                continue;
                            }
                            try {
                                object2 = (Column)dBObjectID2.resolveID();
                                stringArray[n++] = object2.getName();
                            }
                            catch (DBException dBException) {
                                // empty catch block
                            }
                        }
                    }
                }
                object5 = this.findOrCreateNodeAfter(document, node7, "REFERENCES", "COL_LIST");
                object4 = this.findOrCreateNode(document, (Node)object5, "SCHEMA");
                object4.appendChild(document.createTextNode(string));
                object3 = this.findOrCreateNode(document, (Node)object5, "NAME");
                object3.appendChild(document.createTextNode(string2));
                Node node8 = this.findOrCreateNode(document, (Node)object5, "COL_LIST");
                for (DBObjectID dBObjectID3 : stringArray) {
                    object2 = this.createNode(document, node8, "COL_LIST_ITEM/NAME");
                    object2.appendChild(document.createTextNode((String)dBObjectID3));
                }
                FKConstraint.ReferentialAction referentialAction = fKConstraint.getOnDeleteAction();
                if (referentialAction != FKConstraint.ReferentialAction.CASCADE && referentialAction != FKConstraint.ReferentialAction.SET_NULL) continue;
                Node node9 = this.findOrCreateNode(document, (Node)object5, "ON_DELETE");
                String string3 = referentialAction.name();
                node9.appendChild(document.createTextNode(string3));
                continue;
            }
            if (constraintArray[i] instanceof CheckConstraint) {
                this.processConstraint(document, node, constraintArray[i], CKS, node3);
                continue;
            }
            if (!(constraintArray[i] instanceof UniqueConstraint)) continue;
            this.processConstraint(document, node, constraintArray[i], UKS, node5);
        }
        if (node4.getChildNodes().getLength() == 0) {
            node2.removeChild(node4);
        }
        if (node5.getChildNodes().getLength() == 0) {
            node2.removeChild(node5);
        }
        if (node3.getChildNodes().getLength() == 0) {
            node2.removeChild(node3);
        }
        if (node6.getChildNodes().getLength() == 0) {
            node2.removeChild(node6);
        }
    }

    private Node processConstraint(Document document, Node node, Constraint constraint, String string, Node node2) {
        Index index;
        Object object;
        Object object2;
        Node node3 = this.createNode(document, node2, string + "_ITEM");
        this.getParentGenerator().populateNode(node3, document, constraint);
        if (constraint.getDeferrableState() != null) {
            object2 = this.findOrCreateNodeAfter(document, node3, "DEFERRABLE", "COL_LIST");
            if (constraint.getDeferrableState() == Constraint.DeferrableState.DEFER_INIT_DEFERRED) {
                object = this.findOrCreateNodeAfter(document, node3, "INITIALLY_DEFERRED", "DEFERRABLE");
            }
        }
        if (constraint instanceof UniqueConstraint && (object2 = (UniqueConstraint)constraint).getIndexID() != null && (index = (Index)(object = (Table)constraint.getParent()).findOwnedObject(object2.getIndexID())) != null) {
            Node node4 = this.findOrCreateNodeAfter(document, node3, "USING_INDEX", "CUSTOMER_AREA");
            Node node5 = this.createNode(document, node4, "SCHEMA");
            node5.appendChild(document.createTextNode(object.getSchema().getName()));
            Node node6 = this.createNode(document, node4, "NAME");
            node6.appendChild(document.createTextNode(index.getName()));
        }
        return node3;
    }

    @Override
    protected void readNode(Node node, Object object) {
        SXMLReader sXMLReader = (SXMLReader)this.getParentGenerator();
        Table table = (Table)object;
        Object var5_5 = null;
        ArrayList<Constraint> arrayList = new ArrayList<Constraint>();
        this.addConstraints(sXMLReader, this.findNode(node, "RELATIONAL_TABLE/CHECK_CONSTRAINT_LIST"), arrayList, CheckConstraint.class, table);
        this.addConstraints(sXMLReader, this.findNode(node, "RELATIONAL_TABLE/PRIMARY_KEY_CONSTRAINT_LIST"), arrayList, PKConstraint.class, table);
        this.addConstraints(sXMLReader, this.findNode(node, "RELATIONAL_TABLE/UNIQUE_KEY_CONSTRAINT_LIST"), arrayList, UniqueConstraint.class, table);
        this.addConstraints(sXMLReader, this.findNode(node, "RELATIONAL_TABLE/FOREIGN_KEY_CONSTRAINT_LIST"), arrayList, FKConstraint.class, table);
        table.setConstraints(arrayList.toArray(new Constraint[arrayList.size()]));
    }

    private void addConstraints(SXMLReader sXMLReader, Node node, ArrayList<Constraint> arrayList, Class<? extends Constraint> clazz, Table table) {
        if (node != null) {
            SXMLFragmentGenerator.childXMLElementIterator childXMLElementIterator2 = new SXMLFragmentGenerator.childXMLElementIterator(node);
            while (childXMLElementIterator2.hasNext()) {
                Node node2;
                SXMLFragmentGenerator.childXMLElementIterator childXMLElementIterator3;
                Schema schema;
                String string;
                Node node3 = (Node)childXMLElementIterator2.next();
                Constraint constraint = null;
                try {
                    constraint = clazz.newInstance();
                    sXMLReader.fillInObject(constraint, node3, null);
                    arrayList.add(constraint);
                }
                catch (InstantiationException instantiationException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
                if (this.nodeExists(node3, "DEFERRABLE")) {
                    if (this.nodeExists(node3, "INITIALLY_DEFERRED")) {
                        constraint.setDeferrableState(Constraint.DeferrableState.DEFER_INIT_DEFERRED);
                    } else {
                        constraint.setDeferrableState(Constraint.DeferrableState.DEFER_INIT_IMMEDIATE);
                    }
                } else {
                    constraint.setDeferrableState(null);
                }
                if (constraint instanceof UniqueConstraint) {
                    if (!this.nodeExists(node3, "USING_INDEX")) continue;
                    string = new NameBasedID(table.getType(), table.getSchema().getName(), table.getName());
                    schema = new NameBasedID("INDEX", this.nodeText(node3, "USING_INDEX/NAME"), (DBObjectID)string);
                    ((UniqueConstraint)constraint).setIndexID((DBObjectID)schema);
                    continue;
                }
                if (!(constraint instanceof FKConstraint)) continue;
                string = this.nodeText(node3, "REFERENCES/SCHEMA");
                schema = new Schema(string);
                String string2 = this.nodeText(node3, "REFERENCES/NAME");
                ArrayList<String> arrayList2 = new ArrayList<String>();
                Node node4 = this.findNode(node3, "REFERENCES/COL_LIST");
                if (node4 != null) {
                    childXMLElementIterator3 = new SXMLFragmentGenerator.childXMLElementIterator(node4);
                    while (childXMLElementIterator3.hasNext()) {
                        node2 = (Node)childXMLElementIterator3.next();
                        arrayList2.add(this.nodeText(node2, "NAME"));
                    }
                }
                childXMLElementIterator3 = new NameBasedID("TABLE", string, string2);
                node2 = new ReferenceID("CONSTRAINT", (DBObjectID)childXMLElementIterator3, null, "FKConstraint", arrayList2.toArray(new String[arrayList2.size()]));
                ReferenceID referenceID = (ReferenceID)((FKConstraint)constraint).getReferenceID();
                if (referenceID != null) {
                    node2.setName(referenceID.getName());
                }
                ((FKConstraint)constraint).setReferenceID((DBObjectID)node2);
                String string3 = this.nodeText(node3, "REFERENCES/ON_DELETE");
                FKConstraint.ReferentialAction referentialAction = "SET_NULL".equals(string3) ? FKConstraint.ReferentialAction.SET_NULL : ("CASCADE".equals(string3) ? FKConstraint.ReferentialAction.CASCADE : FKConstraint.ReferentialAction.NO_ACTION);
                ((FKConstraint)constraint).setOnDeleteAction(referentialAction);
            }
        }
    }
}

