/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.validators;

import java.util.Collection;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.PKConstraint;
import oracle.javatools.db.Relation;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.Table;
import oracle.javatools.db.diff.Difference;
import oracle.javatools.db.ora.MaterializedView;
import oracle.javatools.db.ora.MaterializedViewLog;
import oracle.javatools.db.refactoring.CascadeAction;
import oracle.javatools.db.resource.APIBundle;
import oracle.javatools.db.validators.DBObjectValidator;
import oracle.javatools.db.validators.SchemaObjectValidator;
import oracle.javatools.db.validators.ValidationContext;
import oracle.javatools.db.validators.ValidationException;
import oracle.javatools.db.validators.ValidationLevel;
import oracle.javatools.util.ModelUtil;

public class MaterializedViewLogValidator
extends SchemaObjectValidator<MaterializedViewLog> {
    public MaterializedViewLogValidator(DBObjectProvider dBObjectProvider) {
        super(dBObjectProvider);
    }

    protected Collection<String> listAlwaysValidProperties() {
        Collection collection = super.listAlwaysValidProperties();
        collection.add("cache");
        collection.add("columnIDs");
        collection.add("newValues");
        collection.add("parallelDegree");
        collection.add("primaryKeyLogged");
        collection.add("rowidLogged");
        collection.add("sequenceLogged");
        return collection;
    }

    @DBObjectValidator.PropertyValidator(value={"masterTableID"})
    public void validateMasterTableID(ValidationContext<MaterializedViewLog> validationContext) throws ValidationException {
        MaterializedViewLog materializedViewLog = (MaterializedViewLog)validationContext.getOriginalObject();
        MaterializedViewLog materializedViewLog2 = (MaterializedViewLog)validationContext.getUpdatedObject();
        DBObjectID dBObjectID = materializedViewLog2.getMasterTableID();
        if (dBObjectID == null) {
            throw new ValidationException((DBObject)materializedViewLog2, APIBundle.get((String)"MVIEW_LOG_MISSING_MASTER"));
        }
        if (ModelUtil.areDifferent((Object)materializedViewLog2.getName(), (Object)DBUtil.getDBObjectName((DBObjectID)dBObjectID))) {
            throw new ValidationException((DBObject)materializedViewLog2, APIBundle.format((String)"MVIEW_LOG_NAME_MASTER_MISMATCH", (Object[])new Object[]{materializedViewLog2.getName(), DBUtil.getDBObjectName((DBObjectID)dBObjectID)}));
        }
        if (validationContext.getLevel() == ValidationLevel.FULL) {
            try {
                DBObject dBObject = dBObjectID.resolveID();
                if (dBObject instanceof Table) {
                    Table table = (Table)dBObject;
                    Table.TableType tableType = (Table.TableType)table.getProperty("TableType");
                    String string = materializedViewLog2.getName();
                    MaterializedViewLog materializedViewLog3 = (MaterializedViewLog)this.getProvider().getObject("MATERIALIZED VIEW LOG", table.getSchema(), string);
                    if (materializedViewLog3 != null && materializedViewLog3 != materializedViewLog && materializedViewLog3 != materializedViewLog2) {
                        throw new ValidationException((DBObject)materializedViewLog2, APIBundle.format((String)"MVIEW_LOG_MASTER_ALREADY_HAS_MVL", (Object[])new Object[]{string}));
                    }
                    if (tableType == Table.TableType.SESSION_TEMP || tableType == Table.TableType.TRANSACTION_TEMP) {
                        throw new ValidationException((DBObject)materializedViewLog2, APIBundle.format((String)"MVIEW_LOG_TEMP_MASTER_UNSUPPORTED", (Object[])new Object[]{string}));
                    }
                    if (table instanceof MaterializedView) {
                        MaterializedView materializedView = (MaterializedView)table;
                        if (materializedView.getKeyType() != MaterializedView.RefreshWith.PRIMARY_KEY) {
                            throw new ValidationException((DBObject)materializedViewLog2, APIBundle.format((String)"MVIEW_LOG_NO_PK_MASTER_MV_UNSUPPORTED", (Object[])new Object[]{string}));
                        }
                    } else {
                        PKConstraint pKConstraint = PKConstraint.getPrimaryKey((Relation)table);
                        if (pKConstraint == null) {
                            throw new ValidationException((DBObject)materializedViewLog2, APIBundle.format((String)"MVIEW_LOG_NO_PK_MASTER_UNSUPPORTED", (Object[])new Object[]{string}));
                        }
                    }
                }
            }
            catch (DBException dBException) {
                throw new ValidationException((DBObject)materializedViewLog2, dBException.getMessage());
            }
        }
    }

    public DBObjectValidator.NamespaceType getNamespaceType() {
        return DBObjectValidator.NamespaceType.TYPE;
    }

    protected CascadeAction cascadePropertyChange(Difference difference, String string, Object object, Object object2, MaterializedViewLog materializedViewLog) throws DBException {
        boolean bl = ModelUtil.areEqual((Object)materializedViewLog.getMasterTableID(), (Object)((DBObject)difference.getOriginalObject()).getID());
        CascadeAction cascadeAction = super.cascadePropertyChange(difference, string, object, object2, (SchemaObject)materializedViewLog);
        if (bl && cascadeAction == CascadeAction.UPDATE) {
            if ("name".equals(string)) {
                materializedViewLog.setName((String)object2);
            } else if ("schema".equals(string)) {
                materializedViewLog.setSchema((Schema)object2);
            }
        }
        return cascadeAction;
    }
}

