/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.validators;

import java.util.Arrays;
import java.util.Collection;
import oracle.javatools.db.Constraint;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.db.validators.ConstraintValidator;
import oracle.javatools.db.validators.DBObjectValidator;
import oracle.javatools.db.validators.ValidationException;

public class OracleConstraintValidator
extends ConstraintValidator {
    private static final Collection<String> INVALID_CONSTRAINT_DATATYPES = Arrays.asList("BFILE", "BLOB", "CLOB", "LONG", "LONG RAW", "NCLOB", "LOB", "VARRAY", "NESTED TABLE", "OBJECT", "REF");

    public OracleConstraintValidator(DBObjectProvider dBObjectProvider) {
        super(dBObjectProvider);
    }

    @Override
    protected boolean isValidConstraintDatatype(String string, DataTypeUsage dataTypeUsage) {
        String string2;
        boolean bl;
        boolean bl2 = bl = !INVALID_CONSTRAINT_DATATYPES.contains(string) && !"TYPE".equals(dataTypeUsage.getDataTypeID().getType());
        if (dataTypeUsage != null && string.equals("TIMESTAMP") && (string2 = (String)dataTypeUsage.getAttributeValue("time_zone")) != null && string2.equals("TIME ZONE")) {
            bl = false;
        }
        return bl;
    }

    @Override
    protected void handleMissingConstraintIndex(Constraint constraint, DBObjectID dBObjectID) throws ValidationException {
        if (!constraint.getName().startsWith("SYS_")) {
            super.handleMissingConstraintIndex(constraint, dBObjectID);
        }
    }

    @Override
    public DBObjectValidator.NamespaceType getNamespaceType() {
        return DBObjectValidator.NamespaceType.TYPE;
    }
}

