/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.validators;

import java.util.Arrays;
import java.util.Collection;
import java.util.logging.Level;
import oracle.javatools.db.BaseObjectID;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Index;
import oracle.javatools.db.ReferenceID;
import oracle.javatools.db.Relation;
import oracle.javatools.db.Table;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeHelper;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.db.datatypes.PredefinedDataType;
import oracle.javatools.db.ora.Indextype;
import oracle.javatools.db.ora.OracleIndexOrganizedTableProperties;
import oracle.javatools.db.plsql.Type;
import oracle.javatools.db.resource.APIBundle;
import oracle.javatools.db.sql.Function;
import oracle.javatools.db.sql.IndexObject;
import oracle.javatools.db.sql.Operation;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.db.sql.SQLFragmentExpressionBuilder;
import oracle.javatools.db.validators.DBObjectValidator;
import oracle.javatools.db.validators.IndexValidator;
import oracle.javatools.db.validators.ValidationContext;
import oracle.javatools.db.validators.ValidationException;
import oracle.javatools.db.validators.ValidationLevel;

public class OracleIndexValidator
extends IndexValidator {
    private static final Collection<String> INVALID_INDEX_DATATYPES = Arrays.asList("LONG", "LONG RAW", "LOB", "BLOB", "CLOB", "NCLOB", "BFILE", "REF");
    private static final Collection<String> VALID_TEXT_INDEX_DATATYPES = Arrays.asList("XMLTYPE", "URITYPE", "BLOB", "BFILE");

    public OracleIndexValidator(DBObjectProvider dBObjectProvider) {
        super(dBObjectProvider);
    }

    @Override
    protected Collection<String> listAlwaysValidProperties() {
        Collection<String> collection = super.listAlwaysValidProperties();
        collection.remove("domainIndextype");
        collection.remove("keyCompression");
        collection.remove("reverse");
        return collection;
    }

    @Override
    @DBObjectValidator.PropertyValidator(value={"columnExpressions"})
    @DBObjectValidator.PropertyDependency(value={"reverse"})
    public void validateExpressions(ValidationContext<Index> validationContext) throws ValidationException {
        super.validateExpressions(validationContext);
        if (validationContext.getLevel() == ValidationLevel.FULL) {
            Index index = (Index)validationContext.getUpdatedObject();
            Index.IndexType indexType = index.getIndexType();
            IndexObject[] indexObjectArray = index.getColumnExpressions();
            if (indexType == Index.IndexType.DOMAIN) {
                if (indexObjectArray.length != 1) {
                    throw new ValidationException((DBObject)index, APIBundle.get((String)"ORACLE_INDEX_ERROR_TOO_MANY_COLUMNS"));
                }
            } else if (indexType == Index.IndexType.BITMAP) {
                if (indexObjectArray.length > 30) {
                    throw new ValidationException((DBObject)index, APIBundle.get((String)"BIT_INDEX_ERROR_TOO_MANY_COLUMN_EXPR"));
                }
            } else if (indexObjectArray.length > 32) {
                throw new ValidationException((DBObject)index, APIBundle.get((String)"INDEX_ERROR_TOO_MANY_COLUMN_EXPR"));
            }
            this.checkInvalidFunctions(index);
        }
    }

    @DBObjectValidator.PropertyValidator(value={"keyCompression"}, level=ValidationLevel.FULL)
    @DBObjectValidator.PropertyDependency(value={"columnExpressions"})
    public void validateKeyCompression(Index index, Index index2) throws ValidationException {
        Integer n = index2.getKeyCompression();
        if (n != null) {
            if (n < 0) {
                throw new ValidationException((DBObject)index2, APIBundle.get((String)"INDEX_ERROR_KEY_COMPRESSION_TOO_SMALL"));
            }
            IndexObject[] indexObjectArray = index2.getColumnExpressions();
            if (index2.getIndexType() == Index.IndexType.DOMAIN) {
                throw new ValidationException((DBObject)index2, APIBundle.get((String)"INDEX_ERROR_KEY_COMPRESSION_NOT_FOR_DOMAIN_INDEX"));
            }
            if (index2.getIndexType() == Index.IndexType.UNIQUE && n > indexObjectArray.length - 1) {
                throw new ValidationException((DBObject)index2, APIBundle.get((String)"INDEX_ERROR_KEY_COMPRESSION_TOO_BIG_UNIQUE"));
            }
            if (index2.getIndexType() == Index.IndexType.NORMAL && n > indexObjectArray.length) {
                throw new ValidationException((DBObject)index2, APIBundle.get((String)"INDEX_ERROR_KEY_COMPRESSION_TOO_BIG_NON_UNIQUE"));
            }
        }
    }

    @Override
    @DBObjectValidator.PropertyValidator(value={"table"})
    public void validateTable(Index index, Index index2) throws ValidationException {
        super.validateTable(index, index2);
        Table table = index2.getTable();
        if (table != null && table.getProperty("TableType") == Table.TableType.EXTERNAL) {
            throw new ValidationException((DBObject)index2, APIBundle.get((String)"ORACLE_INDEX_ERROR_EXTERNAL_TABLE"));
        }
    }

    @Override
    protected void validateColumnType(Index index, Column column) throws ValidationException {
        super.validateColumnType(index, column);
        String string = null;
        DataType dataType = null;
        try {
            DataTypeUsage dataTypeUsage = column.getDataTypeUsage();
            if (dataTypeUsage != null) {
                dataType = DataTypeHelper.getDataType((DataTypeUsage)dataTypeUsage, (boolean)false);
                string = this.isValidDatatype(index, dataType);
            }
        }
        catch (DBException dBException) {
            string = "INDEX_ERROR_INVALID_COLUMN_TYPE";
        }
        if (string != null) {
            throw new ValidationException((DBObject)column, "dataTypeUsage", APIBundle.format((String)string, (Object[])new Object[]{index.getName(), column.getName(), dataType == null ? null : dataType.getName()}));
        }
    }

    private String isValidDatatype(Index index, DataType dataType) {
        String string = null;
        if (dataType == null) {
            string = "INDEX_ERROR_INVALID_COLUMN_TYPE";
        } else {
            String string2 = dataType.getName();
            if (index.getIndexType() == Index.IndexType.DOMAIN) {
                BaseObjectID baseObjectID;
                boolean bl = false;
                if (index.getDomainIndextype() instanceof BaseObjectID && "CTXSYS".equals((baseObjectID = (BaseObjectID)index.getDomainIndextype()).getSchemaName()) && "CONTEXT".equals(baseObjectID.getName())) {
                    bl = true;
                }
                if (bl && !PredefinedDataType.ValueType.CHAR.equals((Object)DataTypeHelper.getValueType((DataType)dataType)) && !VALID_TEXT_INDEX_DATATYPES.contains(string2)) {
                    string = "ORACLE_INDEX_ERROR_INVALID_TEXT_COLUMN_TYPE";
                }
            } else if (INVALID_INDEX_DATATYPES.contains(string2) || dataType instanceof Type) {
                string = "INDEX_ERROR_INVALID_COLUMN_TYPE";
            }
        }
        return string;
    }

    @Override
    protected boolean columnMustBeUnique(Table table, Index index, IndexObject indexObject) {
        String string = this.getProvider().getInternalName(indexObject.getExpressionSource());
        return table.getColumn(string) != null && !IndexObject.OrderType.DESC.equals((Object)indexObject.getOrderType());
    }

    @DBObjectValidator.PropertyValidator(value={"domainIndextype"})
    public void validateDomainIndextype(ValidationContext<Index> validationContext) throws ValidationException {
        Index index = (Index)validationContext.getUpdatedObject();
        if (index.getIndexType() == Index.IndexType.DOMAIN) {
            DBObjectID dBObjectID = index.getDomainIndextype();
            if (dBObjectID == null) {
                throw new ValidationException((DBObject)index, APIBundle.format((String)"ORACLE_INDEX_ERROR_MISSING_INDEXTYPE", (Object[])new Object[]{index.getName()}));
            }
            if (validationContext.getLevel() == ValidationLevel.FULL && !(dBObjectID instanceof ReferenceID)) {
                DBObject dBObject = null;
                if (dBObjectID != null) {
                    try {
                        dBObject = dBObjectID.resolveID();
                    }
                    catch (DBException dBException) {
                        this.logException(dBException, Level.WARNING);
                    }
                }
                if (!(dBObject instanceof Indextype)) {
                    throw new ValidationException((DBObject)index, APIBundle.format((String)"ORACLE_INDEX_ERROR_MISSING_INDEXTYPE", (Object[])new Object[]{index}));
                }
            }
        }
    }

    protected void checkInvalidFunctions(Index index) throws ValidationException {
        IndexObject[] indexObjectArray = index.getColumnExpressions();
        for (int i = 0; i < indexObjectArray.length; ++i) {
            SQLFragment sQLFragment = indexObjectArray[i].getExpression();
            if (sQLFragment == null) continue;
            String string = sQLFragment.getSQLText();
            Relation relation = (Relation)index.getParent();
            SQLFragment sQLFragment2 = SQLFragmentExpressionBuilder.getExpression((DBObjectProvider)this.getProvider(), (Relation)relation, (SQLFragmentExpressionBuilder.ExpressionType)SQLFragmentExpressionBuilder.ExpressionType.ITEM, (String)string);
            this.checkInvalidFunctionsInFragment(sQLFragment2, indexObjectArray[i]);
        }
    }

    private void checkInvalidFunctionsInFragment(SQLFragment sQLFragment, IndexObject indexObject) throws ValidationException {
        Object object;
        if (sQLFragment instanceof Function && ((Function)sQLFragment).isGrouping()) {
            throw new ValidationException((DBObject)indexObject, APIBundle.format((String)"ORACLE_INDEX_ERROR_INVALID_FUNCION", (Object[])new Object[]{indexObject.getSQLText()}));
        }
        if (sQLFragment instanceof Operation) {
            object = ((Operation)sQLFragment).getArguments();
            for (int i = 0; i < ((SQLFragment[])object).length; ++i) {
                if (object[i] == null) continue;
                this.checkInvalidFunctionsInFragment(object[i], indexObject);
            }
        }
        object = null;
        if (sQLFragment instanceof Function) {
            object = ((Function)sQLFragment).getFunction();
        } else if (sQLFragment != null) {
            object = sQLFragment.getSQLText();
        }
        if (object != null && "USER".equalsIgnoreCase((String)object) || "ROWNUM".equalsIgnoreCase((String)object) || "SYSDATE".equalsIgnoreCase((String)object) || "SYSTIMESTAMP".equalsIgnoreCase((String)object) || "CURRENT_DATE".equalsIgnoreCase((String)object) || "CURRENT_TIMESTAMP".equalsIgnoreCase((String)object)) {
            throw new ValidationException((DBObject)indexObject, APIBundle.format((String)"ORACLE_INDEX_ERROR_INVALID_FUNCION", (Object[])new Object[]{indexObject.getSQLText()}));
        }
    }

    @DBObjectValidator.PropertyValidator(value={"indexType"}, level=ValidationLevel.FULL)
    public void validateIndexType(Index index, Index index2) throws ValidationException {
        OracleIndexOrganizedTableProperties oracleIndexOrganizedTableProperties;
        Table table;
        if (!(Index.IndexType.BITMAP != index2.getIndexType() || Table.TableType.INDEX_ORGANIZED != (table = index2.getTable()).getProperty("TableType") || (oracleIndexOrganizedTableProperties = (OracleIndexOrganizedTableProperties)table.getProperty("OracleIndexOrganizedTableProperties")) != null && oracleIndexOrganizedTableProperties.isMapped())) {
            throw new ValidationException((DBObject)index2, APIBundle.format((String)"ORACLE_INDEX_ERROR_BITMAP_WITHOUT_MAPPING_TABLE", (Object[])new Object[]{table, index2}));
        }
    }

    @DBObjectValidator.PropertyValidator(value={"reverse"}, level=ValidationLevel.FULL)
    @DBObjectValidator.PropertyDependency(value={"columnExpressions"})
    public void validateReverse(Index index, Index index2) throws ValidationException {
        if (Boolean.TRUE.equals(index2.getReverse())) {
            for (IndexObject indexObject : index2.getColumnExpressions()) {
                if (indexObject.getOrderType() != IndexObject.OrderType.DESC) continue;
                throw new ValidationException((DBObject)index2, APIBundle.get((String)"INDEX_ERROR_DESC_REVERSE"));
            }
        }
    }
}

