/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.validators;

import java.util.ArrayList;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.InvalidNameException;
import oracle.javatools.db.Relation;
import oracle.javatools.db.ora.OracleTablePartitions;
import oracle.javatools.db.ora.TablePartition;
import oracle.javatools.db.resource.APIBundle;
import oracle.javatools.db.validators.AbstractChildDBObjectValidator;
import oracle.javatools.db.validators.DBObjectValidator;
import oracle.javatools.db.validators.ValidationException;
import oracle.javatools.db.validators.ValidationLevel;

public class TablePartitionValidator
extends AbstractChildDBObjectValidator<TablePartition> {
    public TablePartitionValidator(DBObjectProvider dBObjectProvider) {
        super(dBObjectProvider);
    }

    protected boolean canHaveEmptyName() {
        return true;
    }

    @Override
    public DBObjectValidator.NamespaceType getNamespaceType() {
        return DBObjectValidator.NamespaceType.TYPE_PARENT;
    }

    protected void validateName(TablePartition tablePartition) throws InvalidNameException {
        String string = tablePartition.getName();
        OracleTablePartitions.ObjectType objectType = tablePartition.getObjectType();
        if (string == null && objectType == OracleTablePartitions.ObjectType.SUBPARTITION_TEMPLATE) {
            throw new InvalidNameException((DBObject)tablePartition, APIBundle.get((String)"TABLE_SUBPARTITION_TEMPLATE_ERROR_MISSING_NAME"));
        }
        super.validateName((DBObject)tablePartition);
    }

    @DBObjectValidator.PropertyValidator(value={"values"}, level=ValidationLevel.FULL)
    public void validateValues(TablePartition tablePartition, TablePartition tablePartition2) throws ValidationException {
        OracleTablePartitions.PartitionType partitionType = tablePartition2.getPartitionType();
        if (partitionType == OracleTablePartitions.PartitionType.RANGE) {
            this.validateRangeValues(tablePartition2);
        } else if (partitionType == OracleTablePartitions.PartitionType.LIST) {
            this.validateListValues(tablePartition2);
        } else if (partitionType == OracleTablePartitions.PartitionType.HASH && tablePartition2.getValues().length > 0) {
            throw new ValidationException((DBObject)tablePartition2, APIBundle.get((String)"TABLE_HASH_PARTITION_INVALID_VALUES"));
        }
    }

    @DBObjectValidator.PropertyValidator(value={"partitionLevelSubpartitions"}, level=ValidationLevel.FULL)
    public void validatePartitionLevelSubpartitions(TablePartition tablePartition, TablePartition tablePartition2) throws ValidationException {
        OracleTablePartitions oracleTablePartitions = tablePartition2.getPartitionLevelSubpartitions();
        if (oracleTablePartitions != null) {
            if (!(tablePartition2.getPartitionType() == OracleTablePartitions.PartitionType.RANGE || this.allowSubPartitionedLists() && tablePartition2.getPartitionType() == OracleTablePartitions.PartitionType.LIST)) {
                throw new ValidationException((DBObject)tablePartition2, APIBundle.get((String)"TABLE_RANGE_PARTITION_ERROR_INVALID_PARTITION_LEVEL_SUBPARTITION"));
            }
            this.validateOwnedObjects(ValidationLevel.FULL, new DBObject[]{oracleTablePartitions});
        }
    }

    @DBObjectValidator.PropertyValidator(value={"partitionType"})
    public void validatePartitionType(TablePartition tablePartition, TablePartition tablePartition2) throws ValidationException {
        OracleTablePartitions.PartitionType partitionType = tablePartition2.getPartitionType();
        if (partitionType == null) {
            throw new ValidationException((DBObject)tablePartition2, APIBundle.get((String)"TABLE_PARTITION_ERROR_MISSING_PARTITION_TYPE"));
        }
    }

    @DBObjectValidator.PropertyValidator(value={"objectType"})
    public void validateObjectType(TablePartition tablePartition, TablePartition tablePartition2) throws ValidationException {
        OracleTablePartitions.ObjectType objectType = tablePartition2.getObjectType();
        if (objectType == null) {
            throw new ValidationException((DBObject)tablePartition2, APIBundle.get((String)"TABLE_PARTITION_ERROR_MISSING_OBJECT_TYPE"));
        }
    }

    private void validateRangeValues(TablePartition tablePartition) throws ValidationException {
        Object[] objectArray = tablePartition.getValues();
        boolean bl = false;
        OracleTablePartitions oracleTablePartitions = this.getOracleTablePartitions(tablePartition);
        if (oracleTablePartitions != null) {
            DBObjectID[] dBObjectIDArray = oracleTablePartitions.getPartitionColumns();
            ArrayList<Object> arrayList = new ArrayList<Object>();
            for (Object object : objectArray) {
                if (object instanceof String) {
                    arrayList.addAll(TablePartition.splitValues((String)((String)object)));
                    continue;
                }
                arrayList.add(object);
            }
            if (dBObjectIDArray.length != arrayList.size()) {
                throw new ValidationException((DBObject)tablePartition, APIBundle.get((String)"TABLE_RANGE_PARTITION_ERROR_MISSING_RANGE_VALUES"));
            }
            for (int i = 0; i < dBObjectIDArray.length; ++i) {
                Column column;
                Object e = arrayList.get(i);
                if (TablePartition.RangeValue.MAXVALUE == e || (column = this.createDummyColumn(tablePartition, dBObjectIDArray[i])) == null) continue;
                this.validationPartitionValue(tablePartition, column, arrayList.get(i));
            }
        }
    }

    private void validateListValues(TablePartition tablePartition) throws ValidationException {
        Column column;
        DBObjectID[] dBObjectIDArray;
        Object[] objectArray = tablePartition.getValues();
        if (objectArray.length < 1) {
            throw new ValidationException((DBObject)tablePartition, APIBundle.get((String)"TABLE_LIST_PARTITION_ERROR_MISSING_LIST_VALUES"));
        }
        OracleTablePartitions oracleTablePartitions = this.getOracleTablePartitions(tablePartition);
        if (oracleTablePartitions != null && (dBObjectIDArray = oracleTablePartitions.getPartitionColumns()) != null && dBObjectIDArray.length == 1 && (column = this.createDummyColumn(tablePartition, dBObjectIDArray[0])) != null) {
            for (int i = 0; i < objectArray.length; ++i) {
                Object object = objectArray[i];
                if (object != null && object == TablePartition.ListValue.DEFAULT && objectArray.length > 1) {
                    throw new ValidationException((DBObject)tablePartition, APIBundle.get((String)"TABLE_PARTITION_ERROR_INVALID_LIST_VALUES_LIST"));
                }
                if (object == null || object == TablePartition.ListValue.DEFAULT || object == TablePartition.ListValue.NULL) continue;
                this.validationPartitionValue(tablePartition, column, object);
            }
        }
    }

    private OracleTablePartitions getOracleTablePartitions(TablePartition tablePartition) {
        OracleTablePartitions oracleTablePartitions;
        DBObject dBObject;
        OracleTablePartitions.ObjectType objectType = tablePartition.getObjectType();
        DBObject dBObject2 = tablePartition.getParent();
        DBObject dBObject3 = dBObject2 != null ? dBObject2.getParent() : null;
        DBObject dBObject4 = dBObject = dBObject3 != null ? dBObject3.getParent() : null;
        if (objectType == OracleTablePartitions.ObjectType.PARTITION || objectType == OracleTablePartitions.ObjectType.SUBPARTITION_TEMPLATE) {
            oracleTablePartitions = (OracleTablePartitions)dBObject2;
        } else if (objectType == OracleTablePartitions.ObjectType.PARTITION_LEVEL_SUBPARTITION) {
            if (dBObject2 != null && dBObject3 != null && dBObject instanceof OracleTablePartitions) {
                oracleTablePartitions = ((OracleTablePartitions)dBObject).getSubpartitionModel();
            } else {
                oracleTablePartitions = null;
                this.getLogger().warning(APIBundle.get((String)"TABLE_PARTITION_ERROR_INVALID_MODEL"));
            }
        } else {
            oracleTablePartitions = null;
        }
        return oracleTablePartitions;
    }

    private Column createDummyColumn(TablePartition tablePartition, DBObjectID dBObjectID) {
        Relation relation = (Relation)DBUtil.findParentOfType((DBObject)tablePartition, Relation.class);
        Column column = null;
        if (relation != null) {
            column = (Column)relation.findOwnedObject(dBObjectID);
        }
        Column column2 = null;
        if (column != null) {
            column2 = new Column();
            column.copyTo((DBObject)column2, true);
        }
        return column2;
    }

    private void validationPartitionValue(TablePartition tablePartition, Column column, Object object) throws ValidationException {
        column.setDefault(object);
        try {
            this.getProvider().validateObjectProperty((DBObject)column, "default");
        }
        catch (ValidationException validationException) {
            throw new ValidationException((DBObject)tablePartition, "values", validationException.getMessage());
        }
    }

    private boolean allowSubPartitionedLists() {
        return this.is11g();
    }

    private boolean is11g() {
        return "Oracle Database".equals(this.getProvider().getDescriptor().getDatabaseType()) && this.getProvider().getDescriptor().getDatabaseVersion() >= 110;
    }
}

