/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.plsql.parser;

import java.util.Arrays;
import java.util.List;
import oracle.javatools.db.AbstractDBObjectBuilder;
import oracle.javatools.db.AbstractDBObjectProvider;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Schema;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeHelper;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.db.plsql.PlSqlReference;
import oracle.javatools.db.plsql.PlSqlSourceObject;
import oracle.javatools.db.plsql.PlSqlUtil;
import oracle.javatools.db.property.DerivedPropertyBuilder;

public class PlSqlReferenceBuilder
extends DerivedPropertyBuilder<PlSqlReference> {
    public PlSqlReferenceBuilder(AbstractDBObjectProvider abstractDBObjectProvider) {
        super(abstractDBObjectProvider, "PlSqlReference");
    }

    @AbstractDBObjectBuilder.PropertyBuilder(value={"references"})
    public void buildReferences(PlSqlReference plSqlReference) throws DBException {
        String[] stringArray = plSqlReference.getReferenceNames();
        DBObject dBObject = plSqlReference.getParent();
        if (dBObject != null && stringArray != null && stringArray.length > 0) {
            List<DBObjectID> list = PlSqlUtil.findReferences(Arrays.asList(stringArray), (DBObjectProvider)this.getProvider(), dBObject);
            plSqlReference.setReferences(list.toArray(new DBObjectID[list.size()]));
        }
    }

    @AbstractDBObjectBuilder.PropertyBuilder(value={"dataTypeUsage"})
    public void buildTypeUsage(PlSqlReference plSqlReference) {
        String string = plSqlReference.getDataTypeUsageSource();
        if (string != null) {
            DataType dataType;
            DataTypeUsage dataTypeUsage;
            AbstractDBObjectProvider abstractDBObjectProvider = this.getProvider();
            PlSqlSourceObject plSqlSourceObject = (PlSqlSourceObject)DBUtil.findParentOfType((DBObject)plSqlReference, PlSqlSourceObject.class);
            Schema schema = DBUtil.getSchema((DBObject)plSqlSourceObject);
            if (schema == null) {
                try {
                    schema = abstractDBObjectProvider.getDefaultSchema();
                }
                catch (DBException dBException) {
                    schema = null;
                }
            }
            if ((dataTypeUsage = DataTypeHelper.getDataTypeUsageForString((DBObjectProvider)abstractDBObjectProvider, (Schema)schema, (String)string)) == null && (dataType = abstractDBObjectProvider.getDataType(string)) != null) {
                dataTypeUsage = dataType.createDefaultUsage();
            }
            plSqlReference.setDataTypeUsage(dataTypeUsage);
        }
    }
}

