/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.sql;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Database;
import oracle.javatools.db.Relation;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.Synonym;
import oracle.javatools.db.plsql.PlSqlToken;
import oracle.javatools.db.plsql.PlSqlTokenPattern;
import oracle.javatools.db.plsql.PlSqlTokenizer;
import oracle.javatools.db.sql.SqlAliasExpander;
import oracle.javatools.db.token.Token;

public class BaseSqlAliasExpander
implements SqlAliasExpander {
    private final DBObjectProvider m_prov;
    private Schema m_defaultSchema;
    boolean m_anyCols = false;
    private final PlSqlTokenPattern m_relationAlias = new PlSqlTokenPattern("{from|,|insert into|update|delete [from]} <rel ?.> <alias [?]>");

    public BaseSqlAliasExpander() {
        this(null, null);
    }

    public BaseSqlAliasExpander(DBObjectProvider dBObjectProvider, Schema schema) {
        this.m_prov = dBObjectProvider;
        if (schema == null && dBObjectProvider != null) {
            try {
                this.m_defaultSchema = dBObjectProvider.getDefaultSchema();
            }
            catch (DBException dBException) {}
        } else {
            this.m_defaultSchema = schema;
        }
    }

    public Collection<SqlAliasExpander.Usage> getUsages(String string) {
        PlSqlToken plSqlToken;
        PlSqlToken plSqlToken2 = plSqlToken = PlSqlTokenizer.tokenize((String)string, (String[])new String[0]);
        while (plSqlToken2.getType() != Token.Type.END_MARKER) {
            plSqlToken2 = (PlSqlToken)plSqlToken2.getNextToken();
        }
        plSqlToken2 = (PlSqlToken)plSqlToken2.getPrevCodeToken();
        return this.getUsages(plSqlToken, plSqlToken2);
    }

    public Collection<SqlAliasExpander.Usage> getUsages(PlSqlToken plSqlToken, PlSqlToken plSqlToken2) {
        return this.parse(plSqlToken, plSqlToken2);
    }

    public void setDefaultSchema(Schema schema) {
        this.m_defaultSchema = schema;
    }

    private Collection<SqlAliasExpander.Usage> parse(PlSqlToken plSqlToken, PlSqlToken plSqlToken2) {
        SqlFragment.Type type;
        if (plSqlToken.matches("select") || plSqlToken.matches("with")) {
            type = SqlFragment.Type.QUERY;
        } else if (plSqlToken.matches("insert")) {
            type = SqlFragment.Type.INSERT;
        } else if (plSqlToken.matches("update")) {
            type = SqlFragment.Type.UPDATE;
        } else if (plSqlToken.matches("delete")) {
            type = SqlFragment.Type.DELETE;
        } else {
            throw new IllegalArgumentException("Not SQL");
        }
        SqlFragment sqlFragment = new SqlFragment(type, plSqlToken, null);
        try {
            this.buildTree(sqlFragment, plSqlToken, plSqlToken2);
        }
        catch (EndOfStatement endOfStatement) {
            // empty catch block
        }
        this.m_anyCols = false;
        if (!(this.m_prov instanceof Database) && this.m_prov != null) {
            this.findColumns(sqlFragment);
        }
        ArrayList<SqlAliasExpander.Usage> arrayList = new ArrayList<SqlAliasExpander.Usage>();
        this.expandAliases(sqlFragment, arrayList);
        return arrayList;
    }

    private PlSqlToken buildTree(SqlFragment sqlFragment, PlSqlToken plSqlToken, PlSqlToken plSqlToken2) throws EndOfStatement {
        PlSqlToken plSqlToken3 = plSqlToken;
        PlSqlToken plSqlToken4 = null;
        int n = 0;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        SqlFragment sqlFragment2 = null;
        SqlFragment sqlFragment3 = null;
        Boolean bl4 = null;
        while (plSqlToken4 != plSqlToken3) {
            SqlFragment sqlFragment4;
            plSqlToken4 = plSqlToken3;
            if (plSqlToken3 == null || plSqlToken3.matches(";") || plSqlToken3.getStart() > plSqlToken2.getStart() || plSqlToken3.getType() == Token.Type.END_MARKER) {
                throw new EndOfStatement();
            }
            if (plSqlToken3.matches("(")) {
                ++n;
            } else if (plSqlToken3.matches(")")) {
                --n;
                bl4 = Boolean.FALSE;
            }
            if (n < 0) break;
            if (bl && n == 0 && plSqlToken3.matches(",")) {
                this.checkSLIAlias(plSqlToken3, sqlFragment2);
            }
            if (plSqlToken3.matches("select")) {
                bl = true;
            } else if (bl && plSqlToken3.matches("into")) {
                this.checkSLIAlias(plSqlToken3, sqlFragment2);
                bl = false;
                bl3 = true;
            } else if (SqlFragment.Type.SELECT.equals((Object)sqlFragment.getType()) && plSqlToken3.matches("FROM")) {
                this.checkSLIAlias(plSqlToken3, sqlFragment2);
                bl = false;
                bl2 = true;
            } else if (this.endOfFrom(plSqlToken3)) {
                bl2 = false;
            } else if (SqlFragment.Type.DELETE.equals((Object)sqlFragment.getType()) && plSqlToken3.matches("delete")) {
                bl2 = true;
            } else if (SqlFragment.Type.UPDATE.equals((Object)sqlFragment.getType()) && plSqlToken3.matches("update")) {
                bl2 = true;
            } else if (SqlFragment.Type.INSERT.equals((Object)sqlFragment.getType()) && plSqlToken3.matches("insert")) {
                bl2 = true;
            }
            if (SqlFragment.Type.QUERY.equals((Object)sqlFragment.getType()) && plSqlToken3.matches("select")) {
                sqlFragment4 = new SqlFragment(SqlFragment.Type.SELECT, plSqlToken3, sqlFragment);
                plSqlToken3 = this.buildTree(sqlFragment4, plSqlToken3, plSqlToken2);
                continue;
            }
            if (plSqlToken3.matches("(") && ((PlSqlToken)plSqlToken3.getNextCodeToken()).matches("select")) {
                plSqlToken3 = (PlSqlToken)plSqlToken3.getNextCodeToken();
                sqlFragment4 = new SqlFragment(SqlFragment.Type.QUERY, plSqlToken3, sqlFragment);
                plSqlToken3 = this.buildTree(sqlFragment4, plSqlToken3, plSqlToken2);
                plSqlToken3 = (PlSqlToken)plSqlToken3.getNextCodeToken(2);
                continue;
            }
            if (SqlFragment.Type.SELECT.equals((Object)sqlFragment.getType()) && (plSqlToken3.matches("union") || plSqlToken3.matches("minus") || plSqlToken3.matches("intesect"))) {
                if (plSqlToken3.matches("union") && ((PlSqlToken)plSqlToken3.getNextCodeToken()).matches("all")) {
                    plSqlToken3 = (PlSqlToken)plSqlToken3.getNextCodeToken();
                }
                return (PlSqlToken)plSqlToken3.getNextCodeToken();
            }
            if (bl2) {
                String string;
                bl3 = false;
                if (((PlSqlToken)plSqlToken3.getNextCodeToken()).matches("(")) {
                    plSqlToken3 = (PlSqlToken)plSqlToken3.getNextCodeToken(2);
                    sqlFragment4 = new SqlFragment(SqlFragment.Type.QUERY, plSqlToken3, sqlFragment);
                    plSqlToken3 = this.buildTree(sqlFragment4, plSqlToken3, plSqlToken2);
                    if (this.endOfFrom(plSqlToken3 = (PlSqlToken)plSqlToken3.getNextCodeToken()) || plSqlToken3.getType() == Token.Type.PUNCTUATION) continue;
                    sqlFragment.addAlias(BaseSqlAliasExpander.getTokenSource(plSqlToken3), "0");
                    plSqlToken3 = (PlSqlToken)plSqlToken3.getNextCodeToken();
                    continue;
                }
                sqlFragment4 = this.m_relationAlias.getResult((Token)plSqlToken3);
                if (sqlFragment4 == null) continue;
                PlSqlToken plSqlToken5 = (PlSqlToken)sqlFragment4.getNamedMatchStartToken("alias");
                String string2 = sqlFragment4.getNamedMatch("rel", true);
                if (plSqlToken5 != null && !this.endOfFrom(plSqlToken5)) {
                    plSqlToken3 = (PlSqlToken)plSqlToken5.getNextCodeToken();
                    string = BaseSqlAliasExpander.getTokenSource(plSqlToken5);
                    sqlFragment.addAlias(string, string2);
                } else {
                    plSqlToken3 = (PlSqlToken)sqlFragment4.getNamedMatchEndToken("rel").getNextCodeToken();
                    sqlFragment.addNonAliasedRelation(string2);
                }
                string = (PlSqlToken)sqlFragment4.getNamedMatchStartToken("rel");
                SqlFragment sqlFragment5 = new SqlFragment(SqlFragment.Type.TOKEN, (PlSqlToken)string, sqlFragment);
                sqlFragment5.setName(BaseSqlAliasExpander.getTokenSource((PlSqlToken)string));
                while (((PlSqlToken)string.getNextCodeToken()).matches(".")) {
                    string = (PlSqlToken)string.getNextCodeToken(2);
                    sqlFragment2 = sqlFragment5;
                    sqlFragment5 = new SqlFragment(SqlFragment.Type.TOKEN, (PlSqlToken)string, sqlFragment);
                    sqlFragment5.setPrefix(sqlFragment2);
                }
                if (sqlFragment.getType() == SqlFragment.Type.INSERT && plSqlToken3.matches("(")) {
                    bl4 = Boolean.TRUE;
                    sqlFragment3 = sqlFragment5;
                }
                sqlFragment2 = null;
                continue;
            }
            if (plSqlToken3.matches(".") && ((PlSqlToken)plSqlToken3.getPrevToken()).isCode(true) && ((PlSqlToken)plSqlToken3.getNextToken()).isCode(true)) {
                plSqlToken3 = (PlSqlToken)plSqlToken3.getNextToken();
            } else {
                sqlFragment2 = plSqlToken3.isCode(true) && bl4 == Boolean.TRUE ? sqlFragment3 : null;
            }
            sqlFragment4 = new SqlFragment(SqlFragment.Type.TOKEN, plSqlToken3, sqlFragment);
            sqlFragment4.setIgnore(bl3);
            sqlFragment4.setPrefix(sqlFragment2);
            sqlFragment2 = sqlFragment4;
            plSqlToken3 = (PlSqlToken)plSqlToken3.getNextCodeToken();
        }
        return plSqlToken3;
    }

    private static String getTokenSource(PlSqlToken plSqlToken) {
        String string;
        if (plSqlToken.getType() == Token.Type.DOUBLE_QUOTED_STRING) {
            String string2 = plSqlToken.getSource(false);
            string = string2.substring(1, string2.length() - 1);
        } else {
            string = plSqlToken.getSource(true);
        }
        return string;
    }

    private void findColumns(SqlFragment sqlFragment) {
        for (Object object : sqlFragment.m_nonAliasedRels) {
            Relation relation = this.findRelation((String)object);
            if (relation == null) continue;
            this.m_anyCols = true;
            for (Column column : relation.getColumns()) {
                sqlFragment.m_colMap.put(column.getName(), relation);
            }
        }
        for (Object object : sqlFragment.getChildren()) {
            this.findColumns((SqlFragment)object);
        }
    }

    private Relation findRelation(String string) {
        String[] stringArray = string.split("\\.");
        try {
            String string2;
            Schema schema;
            if (stringArray.length > 1) {
                schema = this.m_prov.getSchema(this.m_prov.getInternalName(stringArray[0]));
                string2 = this.m_prov.getInternalName(stringArray[1]);
            } else {
                schema = this.m_defaultSchema;
                string2 = this.m_prov.getInternalName(stringArray[0]);
            }
            for (String string3 : this.m_prov.listObjectTypes()) {
                SchemaObject schemaObject = this.m_prov.getObject(string3, schema, string2);
                if (schemaObject instanceof Relation) {
                    return (Relation)schemaObject;
                }
                if (!(schemaObject instanceof Synonym)) continue;
                Synonym synonym = (Synonym)schemaObject;
            }
        }
        catch (DBException dBException) {
            // empty catch block
        }
        return null;
    }

    private void expandAliases(SqlFragment sqlFragment, Collection<SqlAliasExpander.Usage> collection) {
        List list = sqlFragment.getChildren();
        if (list.size() > 0) {
            for (SqlFragment sqlFragment2 : list) {
                this.expandAliases(sqlFragment2, collection);
            }
        } else {
            ArrayList<String> arrayList = new ArrayList<String>();
            if (sqlFragment.getType() == SqlFragment.Type.TOKEN) {
                Object object;
                PlSqlToken plSqlToken = sqlFragment.getToken();
                if (!((PlSqlToken)plSqlToken.getPrevToken()).isCode(true) && ((PlSqlToken)plSqlToken.getNextCodeToken()).matches(".")) {
                    object = this.findAlias(sqlFragment, plSqlToken);
                    if (object != null) {
                        sqlFragment.setName((String)object);
                        sqlFragment.setIgnore(true);
                    }
                } else if (!((PlSqlToken)plSqlToken.getPrevToken()).isCode(true) && !((PlSqlToken)plSqlToken.getNextCodeToken()).matches(".") && sqlFragment.m_prefix == null && (object = this.findRelation(sqlFragment, BaseSqlAliasExpander.getTokenSource(plSqlToken))) != null) {
                    arrayList.add(object.getSchema().getName());
                    arrayList.add(object.getName());
                }
                if (!sqlFragment.isIgnore()) {
                    object = new UsageImpl();
                    arrayList.addAll(sqlFragment.getNames());
                    ((UsageImpl)object).m_tokens = arrayList;
                    ((UsageImpl)object).m_start = sqlFragment.getToken().getStart();
                    ((UsageImpl)object).m_end = sqlFragment.getToken().getEnd();
                    collection.add((SqlAliasExpander.Usage)object);
                }
            }
        }
    }

    private String findAlias(SqlFragment sqlFragment, PlSqlToken plSqlToken) {
        String string = BaseSqlAliasExpander.getTokenSource(plSqlToken);
        String string2 = sqlFragment.getAliasFor(string);
        if (string2 != null) {
            return string2;
        }
        if (sqlFragment.getParent() != null) {
            return this.findAlias(sqlFragment.getParent(), plSqlToken);
        }
        return null;
    }

    private Relation findRelation(SqlFragment sqlFragment, String string) {
        if (this.m_anyCols) {
            Relation relation = (Relation)sqlFragment.m_colMap.get(string);
            if (relation != null) {
                return relation;
            }
            if (sqlFragment.getParent() != null) {
                return this.findRelation(sqlFragment.getParent(), string);
            }
        }
        return null;
    }

    private boolean endOfFrom(PlSqlToken plSqlToken) {
        if (plSqlToken.matches(",")) {
            return false;
        }
        return plSqlToken.matches("where") || plSqlToken.matches("group") && ((PlSqlToken)plSqlToken.getNextCodeToken()).matches("by") || plSqlToken.matches("order") && ((PlSqlToken)plSqlToken.getNextCodeToken()).matches("by") || plSqlToken.matches("connect") && ((PlSqlToken)plSqlToken.getNextCodeToken()).matches("by") || plSqlToken.matches("union") || plSqlToken.matches("minus") || plSqlToken.matches("intersect") || plSqlToken.matches("log") && ((PlSqlToken)plSqlToken.getNextCodeToken()).matches("errors") || plSqlToken.matches("return") || plSqlToken.matches("returning") || plSqlToken.matches("set") || plSqlToken.matches("values") || plSqlToken.matches("select") || plSqlToken.getType() == Token.Type.PUNCTUATION || plSqlToken.getType() == Token.Type.END_MARKER;
    }

    private void checkSLIAlias(PlSqlToken plSqlToken, SqlFragment sqlFragment) {
        PlSqlToken plSqlToken2 = (PlSqlToken)((PlSqlToken)plSqlToken.getPrevCodeToken()).getPrevCodeToken();
        if (plSqlToken2.matches(")")) {
            sqlFragment.setIgnore(true);
        } else if (!plSqlToken2.matches("select") && !plSqlToken2.matches("into") && plSqlToken2.getType() != Token.Type.PUNCTUATION) {
            sqlFragment.setIgnore(true);
        }
    }

    private static class SqlFragment {
        private final Type m_type;
        private final PlSqlToken m_token;
        private final SqlFragment m_parent;
        private final List<SqlFragment> m_children = new ArrayList<SqlFragment>();
        private final Map<String, String> m_aliasMap = new HashMap<String, String>();
        private final List<String> m_nonAliasedRels = new ArrayList<String>();
        private final Map<String, Relation> m_colMap = new HashMap<String, Relation>();
        private SqlFragment m_prefix;
        private List<String> m_names = new ArrayList<String>();
        private boolean m_ignore = false;

        private SqlFragment(Type type, PlSqlToken plSqlToken, SqlFragment sqlFragment) {
            this.m_type = type;
            this.m_token = plSqlToken;
            this.m_parent = sqlFragment;
            if (sqlFragment != null) {
                this.m_parent.m_children.add(this);
            }
        }

        private SqlFragment getParent() {
            return this.m_parent;
        }

        private void setPrefix(SqlFragment sqlFragment) {
            this.m_prefix = sqlFragment;
        }

        private Type getType() {
            return this.m_type;
        }

        private PlSqlToken getToken() {
            return this.m_token;
        }

        private List<SqlFragment> getChildren() {
            return this.m_children;
        }

        private void addAlias(String string, String string2) {
            this.m_aliasMap.put(string, string2);
        }

        private String getAliasFor(String string) {
            return this.m_aliasMap.get(string);
        }

        private void addNonAliasedRelation(String string) {
            this.m_nonAliasedRels.add(string);
        }

        private void setIgnore(boolean bl) {
            this.m_ignore = bl;
        }

        private boolean isIgnore() {
            if (this.m_ignore) {
                return true;
            }
            if ("0".equals(this.getNames().get(0))) {
                return true;
            }
            if (this.m_token != null) {
                if (this.m_token.getType() == Token.Type.PUNCTUATION) {
                    return true;
                }
                if (this.m_token.getType() == Token.Type.SINGLE_QUOTED_STRING) {
                    return true;
                }
                if (this.m_token.matches("select")) {
                    return true;
                }
                if (this.m_token.getType() == Token.Type.ALPHANUMERIC) {
                    try {
                        Float f = Float.valueOf(this.m_token.getSource(false));
                        return true;
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                return false;
            }
            return true;
        }

        private void setName(String string) {
            this.m_names.clear();
            for (String string2 : string.split("\\.")) {
                this.m_names.add(string2);
            }
        }

        private List<String> getNames() {
            if (this.m_names.size() == 0) {
                if (this.m_prefix != null) {
                    this.m_names.addAll(this.m_prefix.getNames());
                }
                this.m_names.add(BaseSqlAliasExpander.getTokenSource(this.m_token));
            }
            return this.m_names;
        }

        static enum Type {
            QUERY,
            SELECT,
            INSERT,
            UPDATE,
            DELETE,
            TOKEN;

        }
    }

    private static class EndOfStatement
    extends Throwable {
        private EndOfStatement() {
        }
    }

    private static class UsageImpl
    implements SqlAliasExpander.Usage {
        private List<String> m_tokens;
        private int m_start;
        private int m_end;

        private UsageImpl() {
        }

        public List<String> getTokens() {
            return this.m_tokens;
        }

        public int getStartOffset() {
            return this.m_start;
        }

        public int getEndOffset() {
            return this.m_end;
        }
    }
}

