/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.validators;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import oracle.javatools.db.Column;
import oracle.javatools.db.Constraint;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Database;
import oracle.javatools.db.DatabaseDescriptor;
import oracle.javatools.db.FKConstraint;
import oracle.javatools.db.GlobalSettings;
import oracle.javatools.db.PKConstraint;
import oracle.javatools.db.ReferenceID;
import oracle.javatools.db.Relation;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.UniqueConstraint;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeAttribute;
import oracle.javatools.db.datatypes.DataTypeHelper;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.db.datatypes.PredefinedDataType;
import oracle.javatools.db.resource.APIBundle;
import oracle.javatools.db.sql.BuiltInFunction;
import oracle.javatools.db.sql.ParserUtils;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.db.sql.SQLFragmentExpressionBuilder;
import oracle.javatools.db.sql.SQLQueryException;
import oracle.javatools.db.sql.SQLQueryOwner;
import oracle.javatools.db.validators.AbstractChildDBObjectValidator;
import oracle.javatools.db.validators.DBObjectValidator;
import oracle.javatools.db.validators.ValidationContext;
import oracle.javatools.db.validators.ValidationException;
import oracle.javatools.db.validators.ValidationLevel;
import oracle.javatools.util.ModelUtil;

public class ColumnValidator
extends AbstractChildDBObjectValidator<Column> {
    private static final String ORACLE_DATE_FORMAT = "DD-MON-RR";
    private static final String ORACLE_TZ_FORMAT = "DD-MON-RR HH.MI.SSXFF AM TZR";
    private static final String DATE_FORMAT = "ddMMMyy";
    private static final String[] SIMPLE_TZ_FORMATS = new String[]{"ddMMMyy", "ddMMMyyhhmm", "ddMMMyyhhmmaa", "ddMMMyyhhmmaazzz", "ddMMMyyhhmmss", "ddMMMyyhhmmssaa", "ddMMMyyhhmmssaazzz", "ddMMMyyhhmmssSSSaa", "ddMMMyyhhmmssSSSaazzz"};
    private static final int ORACLE_FIRST_YEAR = -4712;
    private static final int ORACLE_LAST_YEAR = 9999;
    private static Collection<String> s_validDateTimeFunctions;
    private boolean m_validateDefaults;

    public ColumnValidator(DBObjectProvider dBObjectProvider) {
        this(dBObjectProvider, false);
    }

    public ColumnValidator(DBObjectProvider dBObjectProvider, boolean bl) {
        super(dBObjectProvider);
        this.m_validateDefaults = bl;
    }

    protected boolean isViewColumn(Column column) {
        return column.getRelation() instanceof SQLQueryOwner;
    }

    @DBObjectValidator.PropertyValidator(value={"dataTypeUsage"}, level=ValidationLevel.FULL)
    public void validateDataTypeUsage(Column column, Column column2) throws ValidationException {
        if (!this.isViewColumn(column2)) {
            DBObjectID dBObjectID;
            DataTypeUsage dataTypeUsage;
            DBObjectProvider dBObjectProvider = this.getProvider();
            DataTypeUsage dataTypeUsage2 = column2.getDataTypeUsage();
            DataTypeUsage dataTypeUsage3 = dataTypeUsage = column == null ? null : column.getDataTypeUsage();
            if (dataTypeUsage != null && ModelUtil.areDifferent((Object)dataTypeUsage, (Object)dataTypeUsage2) && !this.canChangeColumnDatatype(dBObjectProvider, column2)) {
                throw new ValidationException((DBObject)column, APIBundle.format((String)"COLUMN_ERROR_CANNOT_CHANGE", (Object[])new Object[]{ColumnValidator.formatRelationColumn(column, null)}));
            }
            DataType dataType = null;
            DBObjectID dBObjectID2 = dBObjectID = dataTypeUsage2 == null ? null : dataTypeUsage2.getDataTypeID();
            if (!(dBObjectID instanceof ReferenceID && "DATATYPE".equals(dBObjectID.getType()) && this.getProvider() instanceof Database)) {
                try {
                    dataType = DataTypeHelper.getDataType((DataTypeUsage)dataTypeUsage2, (boolean)false);
                }
                catch (DBException dBException) {
                    this.logException(dBException, Level.FINE);
                }
                if (dataType == null) {
                    throw new ValidationException((DBObject)column2, APIBundle.format((String)"COLUMN_ERROR_MISSING_TYPE", (Object[])new Object[]{ColumnValidator.formatRelationColumn(column2, null)}));
                }
            }
            dBObjectProvider.validateObject((DBObject)dataTypeUsage, (DBObject)dataTypeUsage2);
            this.validateDataTypeUsage(column2, dataTypeUsage2, dBObjectID, dataType);
        }
    }

    protected void validateDataTypeUsage(Column column, DataTypeUsage dataTypeUsage, DBObjectID dBObjectID, DataType dataType) throws ValidationException {
    }

    @DBObjectValidator.PropertyValidator(value={"virtualExpression", "virtualExpressionSource"})
    public void validateVirtualExpression(ValidationContext<Column> validationContext) throws ValidationException {
        Column column = (Column)validationContext.getUpdatedObject();
        String string = column.getVirtualExpressionSource();
        if (string != null) {
            if (!ModelUtil.hasLength((String)string)) {
                throw new ValidationException((DBObject)column, "virtualExpressionSource", APIBundle.get((String)"VIRTUAL_COLUMN_EXPRESSION_MISSING"));
            }
            if (validationContext.getLevel() == ValidationLevel.FULL) {
                try {
                    this.getProvider().getObjectFactory().ensureDerivedPropertyBuilder((DBObject)column);
                    DBUtil.ensureObjectBuilt((DBObject)column, (String[])new String[]{"virtualExpression"});
                }
                catch (DBException dBException) {
                    throw new ValidationException((DBObject)column, "virtualExpressionSource", APIBundle.format((String)"VIRTUAL_COLUMN_EXPRESSION_INVALID", (Object[])new Object[]{dBException.getMessage()}));
                }
                SQLFragment sQLFragment = column.getVirtualExpression();
                if (sQLFragment != null) {
                    this.validateVirtualExpressionFragment(column, sQLFragment);
                }
            }
        }
    }

    protected void validateVirtualExpressionFragment(Column column, SQLFragment sQLFragment) throws ValidationException {
        if (DBUtil.findUsagesIn((DBObject)column, (DBObject)sQLFragment).size() > 0) {
            throw new ValidationException((DBObject)column, "virtualExpressionSource", APIBundle.format((String)"VIRTUAL_COLUMN_EXPRESSION_INVALID", (Object[])new Object[]{APIBundle.get((String)"VIRTUAL_COLUMN_EXPRESSION_SELF_REFERENCE")}));
        }
    }

    @DBObjectValidator.PropertyValidator(value={"notNull"}, level=ValidationLevel.FULL)
    public void validateNotNull(Column column, Column column2) throws ValidationException {
        if (!column2.isNotNull()) {
            PKConstraint pKConstraint;
            Relation relation = column2.getRelation();
            DBObjectID dBObjectID = column2.getID();
            if (relation != null && (pKConstraint = PKConstraint.getPrimaryKey((Relation)relation)) != null && pKConstraint.isEnabled()) {
                for (DBObjectID dBObjectID2 : pKConstraint.getColumnIDs()) {
                    if (!dBObjectID2.equals(dBObjectID)) continue;
                    throw new ValidationException((DBObject)column2, APIBundle.format((String)"COLUMN_ERROR_NOT_NULL_PK", (Object[])new Object[]{column2.getName()}));
                }
            }
        }
    }

    @DBObjectValidator.PropertyValidator(value={"default"}, level=ValidationLevel.FULL)
    public void validateDefaultValue(Column column, Column column2) throws ValidationException {
        if (!this.isViewColumn(column2) && column2.getDefault() != null) {
            DataTypeUsage dataTypeUsage = column2.getDataTypeUsage();
            DataType dataType = null;
            try {
                dataType = DataTypeHelper.getDataType((DataTypeUsage)dataTypeUsage, (boolean)false);
            }
            catch (DBException dBException) {
                this.logException(dBException, Level.FINE);
            }
            if (dataType != null) {
                this.validateDefaultValue(column2, dataType);
            }
        }
    }

    protected void validateDefaultValue(Column column, DataType dataType) throws ValidationException {
        String string;
        Object object = column.getDefault();
        if (this.useBaseDefaultValueValidation() && object != null && DataTypeHelper.isTypeOf((DataType)dataType, PredefinedDataType.class) && ModelUtil.hasLength((String)(string = object.toString().trim()))) {
            this.validateDefaultValue(string, column, column.getDataTypeUsage(), dataType);
        }
    }

    protected boolean useBaseDefaultValueValidation() {
        return this.m_validateDefaults;
    }

    protected void validateDefaultValue(String string, Column column, DataTypeUsage dataTypeUsage, DataType dataType) throws ValidationException {
        Object object;
        Relation relation;
        block16: {
            try {
                relation = column.getRelation();
                object = ParserUtils.getColumnNames((String)string, (SQLFragmentExpressionBuilder.ExpressionType)SQLFragmentExpressionBuilder.ExpressionType.ITEM, (DBObjectProvider)this.getProvider(), (Relation)relation);
                if (object.size() > 0) {
                    String string2 = null;
                    Iterator iterator = object.iterator();
                    while (iterator.hasNext()) {
                        String[] stringArray = (String[])iterator.next();
                        String string3 = null;
                        for (String string4 : stringArray) {
                            string3 = string3 == null ? string4 : string3 + '.' + string4;
                        }
                        if (string2 == null) {
                            string2 = string3;
                            continue;
                        }
                        string2 = string2 + ", " + string3;
                    }
                    throw new ValidationException((DBObject)column, APIBundle.format((String)"DEFAULT_VALUE_ERROR_COLUMN_REF", (Object[])new Object[]{string2}));
                }
            }
            catch (SQLQueryException sQLQueryException) {
                Character c;
                object = string.trim();
                if (!ModelUtil.hasLength((String)object) || !Character.isUnicodeIdentifierStart((c = Character.valueOf(((String)object).charAt(0))).charValue())) break block16;
                throw new ValidationException((DBObject)column, APIBundle.format((String)"DEFAULT_VALUE_ERROR_COLUMN_REF", (Object[])new Object[]{string}));
            }
        }
        relation = null;
        object = (PredefinedDataType)DataTypeHelper.unwrapDataType((DataType)dataType, PredefinedDataType.class);
        if (object != null) {
            relation = object.getValueType();
        }
        if (relation == PredefinedDataType.ValueType.CHAR) {
            this.validateCharacterDefaultValue(string, column, dataTypeUsage, dataType);
        } else if (PredefinedDataType.ValueType.isNumericType((PredefinedDataType.ValueType)relation)) {
            this.validateNumericDefaultValue(string, column, dataTypeUsage, dataType);
        } else if (relation == PredefinedDataType.ValueType.BINARY) {
            this.validateBinaryDefaultValue(string, column, dataTypeUsage, dataType);
        } else if (relation == PredefinedDataType.ValueType.TIMESTAMP) {
            this.validateTimestampDefaultValue(string, column, dataTypeUsage, dataType);
        } else if (relation == PredefinedDataType.ValueType.DATE) {
            this.validateDateDefaultValue(string, column, dataTypeUsage, dataType);
        }
    }

    protected void validateCharacterDefaultValue(String string, Column column, DataTypeUsage dataTypeUsage, DataType dataType) throws ValidationException {
        SQLFragment sQLFragment = this.parseDefaultValue(string, column);
        if (sQLFragment != null && ParserUtils.isConstant((SQLFragment)sQLFragment) && dataType.hasDataTypeAttribute("size")) {
            int n;
            DataTypeAttribute dataTypeAttribute = dataType.getDataTypeAttribute("size");
            Long l = dataTypeAttribute.isDeclarable() ? DataTypeHelper.getLongAttributeValue((DataTypeUsage)dataTypeUsage, (String)"size") : dataTypeAttribute.getMaxValue();
            if (l == null) {
                l = (Long)dataTypeAttribute.getDefaultValue();
            }
            if (l != null && (long)(n = (string = ParserUtils.getConstant((SQLFragment)sQLFragment)).length() - (string.charAt(0) == '\'' ? 2 : 0)) > l) {
                throw new ValidationException((DBObject)column, APIBundle.format((String)"DEFAULT_VALUE_ERROR_LENGTH_TOO_LARGE", (Object[])new Object[]{new Long(n), l}));
            }
        }
    }

    protected void validateBinaryDefaultValue(String string, Column column, DataTypeUsage dataTypeUsage, DataType dataType) throws ValidationException {
        if (this.isQuoted(string)) {
            this.validateCharacterDefaultValue(string, column, dataTypeUsage, dataType);
        }
    }

    protected void validateNumericDefaultValue(String string, Column column, DataTypeUsage dataTypeUsage, DataType dataType) throws ValidationException {
        SQLFragment sQLFragment = this.parseDefaultValue(string, column);
        if (ParserUtils.isConstant((SQLFragment)sQLFragment)) {
            Long l;
            String string2;
            BigDecimal bigDecimal = null;
            try {
                string2 = ParserUtils.getConstant((SQLFragment)sQLFragment);
                if (string2.length() > 0 && string2.startsWith("'")) {
                    string2 = string2.substring(1, string2.length() - 1);
                }
                if (string2.length() == 0) {
                    return;
                }
                if ((string2 = string2.trim()).length() == 0) {
                    throw new ValidationException((DBObject)column, APIBundle.get((String)"DEFAULT_VALUE_ERROR_NOT_A_NUMERIC"));
                }
                bigDecimal = new BigDecimal(string2);
            }
            catch (NumberFormatException numberFormatException) {
                throw new ValidationException((DBObject)column, APIBundle.get((String)"DEFAULT_VALUE_ERROR_NOT_A_NUMERIC"));
            }
            string2 = dataType.getDataTypeAttribute("precision");
            DataTypeAttribute dataTypeAttribute = dataType.getDataTypeAttribute("scale");
            Long l2 = DataTypeHelper.getLongAttributeValue((DataTypeUsage)dataTypeUsage, (String)"precision");
            if (l2 == null && string2 != null) {
                l2 = (Long)string2.getDefaultValue();
            }
            if ((l = DataTypeHelper.getLongAttributeValue((DataTypeUsage)dataTypeUsage, (String)"scale")) == null && dataTypeAttribute != null) {
                l = (Long)dataTypeAttribute.getDefaultValue();
            }
            if (l2 != null && l != null) {
                int n = bigDecimal.scale();
                BigInteger bigInteger = bigDecimal.abs().unscaledValue();
                String string3 = bigInteger.toString();
                int n2 = string3.length();
                for (int i = 0; n2 > 0 && i < n && string3.charAt(n2 - 1) == '0'; --n2, ++i) {
                }
                if (n == 0) {
                    n = n2 - string3.length();
                }
                if (l.intValue() >= 0) {
                    if (n > l.intValue()) {
                        throw new ValidationException((DBObject)column, APIBundle.format((String)"DEFAULT_VALUE_ERROR_SCALE_TOO_LARGE", (Object[])new Object[]{new Long(n), l}));
                    }
                } else if (n > 0) {
                    throw new ValidationException((DBObject)column, APIBundle.get((String)"DEFAULT_VALUE_ERROR_INVALID_FRACTION"));
                }
                if (n2 - n > l2.intValue() - l.intValue()) {
                    throw new ValidationException((DBObject)column, APIBundle.format((String)"DEFAULT_VALUE_ERROR_VALUE_TOO_LARGE", (Object[])new Object[]{string, l2, l}));
                }
            } else {
                boolean bl = false;
                boolean bl2 = dataTypeUsage.getAttributeValue("unsigned") != null;
                PredefinedDataType predefinedDataType = (PredefinedDataType)DataTypeHelper.unwrapDataType((DataType)dataType, PredefinedDataType.class);
                PredefinedDataType.ValueType valueType = predefinedDataType.getValueType();
                if (valueType == PredefinedDataType.ValueType.FLOAT) {
                    BigDecimal bigDecimal2 = predefinedDataType.getMinValue();
                    BigDecimal bigDecimal3 = predefinedDataType.getMaxValue();
                    BigDecimal bigDecimal4 = bigDecimal2.negate();
                    BigDecimal bigDecimal5 = bigDecimal3.negate();
                    if (bigDecimal.compareTo(BigDecimal.ZERO) == 0 || (bigDecimal2 == null || bigDecimal.compareTo(bigDecimal2) >= 0) && (bigDecimal3 == null || bigDecimal.compareTo(bigDecimal3) <= 0)) {
                        bl = true;
                    }
                    if (!(bl2 || bigDecimal4 != null && bigDecimal.compareTo(bigDecimal4) < 0 || bigDecimal5 != null && bigDecimal.compareTo(bigDecimal5) > 0)) {
                        bl = true;
                    }
                } else {
                    BigDecimal bigDecimal6 = null;
                    BigDecimal bigDecimal7 = predefinedDataType.getMinValue();
                    BigDecimal bigDecimal8 = predefinedDataType.getMaxValue();
                    if (valueType == PredefinedDataType.ValueType.SIGNED_INT && bigDecimal8 != null) {
                        bigDecimal6 = bigDecimal8.multiply(BigDecimal.valueOf(2L)).add(BigDecimal.ONE);
                    }
                    if (valueType == PredefinedDataType.ValueType.SIGNED_INT) {
                        BigDecimal bigDecimal9;
                        BigDecimal bigDecimal10 = bl2 ? BigDecimal.ZERO : bigDecimal7;
                        BigDecimal bigDecimal11 = bigDecimal9 = bl2 ? bigDecimal6 : bigDecimal8;
                        if (!(bigDecimal10 != null && bigDecimal.compareTo(bigDecimal10) < 0 || bigDecimal9 != null && bigDecimal.compareTo(bigDecimal9) > 0)) {
                            bl = true;
                        }
                    } else if (valueType == PredefinedDataType.ValueType.UNSIGNED_INT) {
                        if (!(bigDecimal7 != null && bigDecimal.compareTo(bigDecimal7) < 0 || bigDecimal8 != null && bigDecimal.compareTo(bigDecimal8) > 0)) {
                            bl = true;
                        }
                    } else {
                        this.getLogger().fine("Min Max range not defined for " + dataType.getName());
                        bl = true;
                    }
                }
                if (!bl) {
                    throw new ValidationException((DBObject)column, APIBundle.format((String)"DEFAULT_VALUE_ERROR_RANGE", (Object[])new Object[]{string}));
                }
            }
        }
    }

    protected void validateDateDefaultValue(String string, Column column, DataTypeUsage dataTypeUsage, DataType dataType) throws ValidationException {
        String string2 = this.validateDateTime(column, string, new SimpleDateFormat(DATE_FORMAT), ORACLE_DATE_FORMAT);
        if (string2 != null) {
            throw new ValidationException((DBObject)column, string2);
        }
    }

    protected void validateTimestampDefaultValue(String string, Column column, DataTypeUsage dataTypeUsage, DataType dataType) throws ValidationException {
        String string2;
        String string3 = null;
        String[] stringArray = SIMPLE_TZ_FORMATS;
        int n = stringArray.length;
        for (int i = 0; i < n && (string3 = this.validateDateTime(column, string, new SimpleDateFormat(string2 = stringArray[i]), ORACLE_TZ_FORMAT)) != null; ++i) {
        }
        if (string3 != null) {
            throw new ValidationException((DBObject)column, string3);
        }
    }

    protected String validateDateTime(Column column, String string, SimpleDateFormat simpleDateFormat, String string2) throws ValidationException {
        String string3 = null;
        GlobalSettings globalSettings = GlobalSettings.getInstance();
        if (globalSettings != null && globalSettings.isValidateDateTime() && !string.equalsIgnoreCase("null")) {
            string3 = this.isQuoted(string) ? this.validateUsingFormat(string, simpleDateFormat, string2) : this.validateDateExpr(column, string);
        }
        return string3;
    }

    private String validateDateExpr(Column column, String string) throws ValidationException {
        String string2 = null;
        String string3 = null;
        SQLFragment sQLFragment = null;
        try {
            sQLFragment = this.parseDefaultValue(string, column);
        }
        catch (ValidationException validationException) {
            string2 = APIBundle.format((String)"DEFAULT_VALUE_ERROR_INVALID_EXPRESSION", (Object[])new Object[]{validationException.getMessage()});
        }
        if (!ParserUtils.isAllowedExpression((SQLFragment)sQLFragment, this.getValidDateTimeFunctions())) {
            string2 = APIBundle.format((String)"DEFAULT_VALUE_ERROR_INVALID_EXPRESSION", (Object[])new Object[]{string});
        }
        if (string2 != null) {
            string3 = APIBundle.format((String)"DEFAULT_VALUE_ERROR_NOT_A_DATE_TIME_EXPR", (Object[])new Object[]{string2});
        }
        return string3;
    }

    private String validateUsingFormat(String string, SimpleDateFormat simpleDateFormat, String string2) {
        Object object;
        String string3 = null;
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
        String string4 = ColumnValidator.stripSpacesAndSeperators(string, hashMap);
        boolean bl = true;
        int n = 0;
        String string5 = "";
        ParsePosition parsePosition = new ParsePosition(0);
        Date date = simpleDateFormat.parse(string4, parsePosition);
        if (null == date || parsePosition.getIndex() != string4.length()) {
            bl = false;
            n = parsePosition.getErrorIndex();
            if (-1 == n) {
                n = parsePosition.getIndex();
            }
        } else {
            object = Calendar.getInstance();
            ((Calendar)object).setTime(date);
            int n2 = ((Calendar)object).get(1);
            if (n2 < -4712 || n2 > 9999) {
                bl = false;
                string5 = APIBundle.format((String)"DEFAULT_VALUE_ERROR_INVALID_YEAR", (Object[])new Object[]{Integer.toString(n2)});
            }
        }
        if (!bl) {
            object = "";
            Integer n3 = (Integer)hashMap.get(n);
            if (n3 != null) {
                object = APIBundle.format((String)"DEFAULT_VALUE_ERROR_FRAGMENT_NOT_RECOGNISED", (Object[])new Object[]{string.substring(n3)});
            }
            string3 = APIBundle.format((String)"DEFAULT_VALUE_ERROR_NOT_A_DATE_TIME", (Object[])new Object[]{object, string5, string2});
        }
        return string3;
    }

    protected boolean isQuoted(String string) {
        String string2 = string.trim();
        return string2.length() > 1 && string2.startsWith("'") && string2.endsWith("'");
    }

    protected SQLFragment parseDefaultValue(String string, Column column) throws ValidationException {
        SQLFragment sQLFragment = null;
        try {
            DBObjectProvider dBObjectProvider = this.getProvider();
            Relation relation = column.getRelation();
            SQLFragmentExpressionBuilder.ExpressionType expressionType = SQLFragmentExpressionBuilder.ExpressionType.ITEM;
            sQLFragment = SQLFragmentExpressionBuilder.getExpressionOrFail((DBObjectProvider)dBObjectProvider, (Relation)relation, (SQLFragmentExpressionBuilder.ExpressionType)expressionType, (String)string);
        }
        catch (SQLQueryException sQLQueryException) {
            throw new ValidationException((DBObject)column, APIBundle.format((String)"DEFAULT_VALUE_ERROR_INVALID_EXPRESSION", (Object[])new Object[]{sQLQueryException.getMessage()}));
        }
        return sQLFragment;
    }

    private static String stripSpacesAndSeperators(String string, Map<Integer, Integer> map) {
        StringBuilder stringBuilder = new StringBuilder();
        char[] cArray = string.toCharArray();
        int n = 0;
        int n2 = 0;
        while (n < cArray.length) {
            while (n < cArray.length && Character.isWhitespace(cArray[n])) {
                ++n;
            }
            if (cArray.length == n) break;
            if (!Character.isLetterOrDigit(cArray[n])) {
                ++n;
            }
            while (n < cArray.length && Character.isWhitespace(cArray[n])) {
                ++n;
            }
            if (cArray.length == n) break;
            stringBuilder.append(cArray[n]);
            map.put(new Integer(n2++), new Integer(n++));
        }
        String string2 = stringBuilder.toString();
        return string2;
    }

    private boolean isDateTimeType(DBObjectID dBObjectID) throws ValidationException {
        boolean bl = false;
        try {
            DBObject dBObject;
            if (dBObjectID != null && (dBObject = dBObjectID.resolveID()) instanceof PredefinedDataType) {
                PredefinedDataType.ValueType valueType = ((PredefinedDataType)dBObject).getValueType();
                bl = valueType == PredefinedDataType.ValueType.DATE || valueType == PredefinedDataType.ValueType.TIMESTAMP;
            }
        }
        catch (DBException dBException) {
            this.logException(dBException, Level.FINE);
        }
        return bl;
    }

    private boolean isDateTimeFunction(BuiltInFunction builtInFunction) throws ValidationException {
        boolean bl = false;
        DBObjectID dBObjectID = builtInFunction.getReturnTypeID();
        if (dBObjectID != null) {
            bl = this.isDateTimeType(dBObjectID);
        }
        return bl;
    }

    private Collection<String> getValidDateTimeFunctions() throws ValidationException {
        if (s_validDateTimeFunctions == null) {
            s_validDateTimeFunctions = new ArrayList<String>();
            DatabaseDescriptor databaseDescriptor = this.getProvider().getDescriptor();
            List list = databaseDescriptor.listBuiltInFunctions();
            for (BuiltInFunction builtInFunction : list) {
                if (!this.isDateTimeFunction(builtInFunction)) continue;
                s_validDateTimeFunctions.add(builtInFunction.getName());
            }
        }
        s_validDateTimeFunctions.add("ROUND");
        s_validDateTimeFunctions.add("LEAST");
        s_validDateTimeFunctions.add("GREATEST");
        s_validDateTimeFunctions.add("+");
        s_validDateTimeFunctions.add("-");
        return s_validDateTimeFunctions;
    }

    private boolean canChangeColumnDatatype(DBObjectProvider dBObjectProvider, Column column) throws ValidationException {
        try {
            Relation relation = column.getRelation();
            DBObject dBObject = TemporaryObjectID.getOriginalObject((DBObject)relation);
            DBObjectID dBObjectID = dBObject == null ? null : dBObject.getID();
            for (Constraint constraint : relation.getConstraints()) {
                for (DBObject dBObject2 : DBUtil.findUsagesIn((DBObject)column, (DBObject)constraint)) {
                    DBObject dBObject3;
                    int n;
                    if (dBObject2 instanceof FKConstraint) {
                        return false;
                    }
                    if (!(dBObject2 instanceof PKConstraint) && !(dBObject2 instanceof UniqueConstraint)) continue;
                    Constraint[] constraintArray = relation.getConstraints();
                    int n2 = constraintArray.length;
                    for (n = 0; n < n2; ++n) {
                        Constraint constraint2 = constraintArray[n];
                        if (!(constraint2 instanceof FKConstraint) || (dBObject3 = ((FKConstraint)constraint2).getReferenceID().resolveID()) != dBObject2) continue;
                        return false;
                    }
                    if (dBObject2.getID() instanceof TemporaryObjectID) {
                        dBObject2 = ((TemporaryObjectID)dBObject2.getID()).getOriginalObject();
                    }
                    if (null == (constraintArray = DBUtil.getReferences((Constraint)((Constraint)dBObject2), (DBObjectProvider)dBObjectProvider))) continue;
                    Constraint[] constraintArray2 = constraintArray;
                    n = constraintArray2.length;
                    for (int i = 0; i < n; ++i) {
                        dBObject3 = constraintArray2[i];
                        if (dBObject3.getParent().getID().equals(dBObjectID)) continue;
                        return false;
                    }
                }
            }
        }
        catch (DBException dBException) {
            this.logException(dBException, Level.WARNING);
        }
        return true;
    }

    public static String formatRelationColumn(Column column, Relation relation) {
        StringBuilder stringBuilder = new StringBuilder();
        if (column != null) {
            String string;
            Relation relation2 = column.getRelation();
            Relation relation3 = relation2 = relation2 == null ? relation : relation2;
            if (relation2 != null && ModelUtil.hasLength((String)(string = relation2.getName()))) {
                stringBuilder.append(string);
                stringBuilder.append(".");
            }
            stringBuilder.append(column.getName());
        }
        return stringBuilder.toString();
    }
}

