/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.validators;

import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Level;
import oracle.javatools.db.BaseObjectID;
import oracle.javatools.db.CheckConstraint;
import oracle.javatools.db.Column;
import oracle.javatools.db.ColumnConstraint;
import oracle.javatools.db.Constraint;
import oracle.javatools.db.ConstraintIndexHelper;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.FKConstraint;
import oracle.javatools.db.Index;
import oracle.javatools.db.NameBasedID;
import oracle.javatools.db.PKConstraint;
import oracle.javatools.db.ReferenceID;
import oracle.javatools.db.Relation;
import oracle.javatools.db.Table;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.UniqueConstraint;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeHelper;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.db.property.DisplayNames;
import oracle.javatools.db.resource.APIBundle;
import oracle.javatools.db.sql.ParserUtils;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.db.sql.SQLQueryException;
import oracle.javatools.db.sql.SQLQueryOwner;
import oracle.javatools.db.validators.AbstractChildDBObjectValidator;
import oracle.javatools.db.validators.DBObjectValidator;
import oracle.javatools.db.validators.ValidationContext;
import oracle.javatools.db.validators.ValidationException;
import oracle.javatools.db.validators.ValidationLevel;
import oracle.javatools.util.ModelUtil;

public class ConstraintValidator<T extends Constraint>
extends AbstractChildDBObjectValidator<T> {
    public ConstraintValidator(DBObjectProvider dBObjectProvider) {
        super(dBObjectProvider);
    }

    protected Collection<String> listAlwaysValidProperties() {
        Collection collection = super.listAlwaysValidProperties();
        collection.add("deferrableState");
        collection.add("onDeleteAction");
        return collection;
    }

    @DBObjectValidator.PropertyValidator(value={"enabled"}, level=ValidationLevel.FULL)
    public void validateEnabled(Constraint constraint, Constraint constraint2) throws ValidationException {
        Relation relation;
        Table.TableType tableType;
        if (constraint2 instanceof PKConstraint && (tableType = (Table.TableType)(relation = constraint2.getRelation()).getProperty("TableType")) == Table.TableType.INDEX_ORGANIZED && !constraint2.isEnabled()) {
            throw new ValidationException((DBObject)constraint2, APIBundle.get((String)"IOT_PROPERTY_ERROR_DISABLED_PRIMARY_KEY"));
        }
    }

    @DBObjectValidator.PropertyValidator(value={"indexID"}, level=ValidationLevel.FULL)
    public void validateIndexID(Constraint constraint, Constraint constraint2) throws ValidationException {
        if (constraint2 instanceof UniqueConstraint) {
            DBObjectID dBObjectID = ((UniqueConstraint)constraint2).getIndexID();
            Relation relation = constraint2.getRelation();
            if (relation != null && dBObjectID != null) {
                Index index = (Index)relation.findOwnedObject(dBObjectID);
                if (index == null) {
                    throw new ValidationException((DBObject)constraint2, APIBundle.format((String)"CONIDX_MISSING_INDEX_ERR", (Object[])new Object[]{DBUtil.getDBObjectName((DBObjectID)dBObjectID), constraint2.getName()}));
                }
                ConstraintIndexHelper.validateIndexForConstraint(index, (UniqueConstraint)constraint2, this.getProvider(), true);
            }
        }
    }

    protected void handleMissingConstraintIndex(Constraint constraint, DBObjectID dBObjectID) throws ValidationException {
        throw new ValidationException((DBObject)constraint, APIBundle.format((String)"CONIDX_MISSING_INDEX_ERR", (Object[])new Object[]{DBUtil.getDBObjectName((DBObjectID)dBObjectID), constraint.getName()}));
    }

    @DBObjectValidator.PropertyValidator(value={"checkConditionFragment", "checkCondition"})
    public void validateCheckCondition(ValidationContext<Constraint> validationContext) throws ValidationException {
        Constraint constraint = (Constraint)validationContext.getUpdatedObject();
        if (constraint instanceof CheckConstraint) {
            Relation relation = (Relation)constraint.getParent();
            String string = ((CheckConstraint)constraint).getCheckCondition();
            if (!ModelUtil.hasLength((String)string)) {
                throw new ValidationException((DBObject)constraint, APIBundle.format((String)"CC_ERROR_NO_CONDITION", (Object[])new Object[]{constraint.getName()}));
            }
            if (validationContext.getLevel() == ValidationLevel.FULL) {
                try {
                    this.getProvider().getObjectFactory().ensureDerivedPropertyBuilder((DBObject)constraint);
                    DBUtil.ensureObjectBuilt((DBObject)constraint, (String[])new String[]{"checkConditionFragment"});
                    SQLFragment sQLFragment = ((CheckConstraint)constraint).getCheckConditionFragment();
                    for (String[] stringArray : ParserUtils.getColumnNames((SQLFragment)sQLFragment)) {
                        String string2 = this.getProvider().getInternalName(stringArray[0]);
                        Column column = (Column)DBUtil.findChildByName((DBObject)relation, (String)"columns", (String)string2, (DBObjectProvider)this.getProvider());
                        if (column != null) continue;
                        throw new SQLQueryException(APIBundle.format((String)"CC_ERROR_INVALID_COLUMN", (Object[])new Object[]{this.getProvider().getExternalName(string2)}));
                    }
                }
                catch (DBException dBException) {
                    throw new ValidationException((DBObject)constraint, "checkCondition", APIBundle.format((String)"CC_ERROR_PARSING_CONDITION", (Object[])new Object[]{constraint.getName(), dBException.getMessage()}));
                }
            }
        }
    }

    @DBObjectValidator.PropertyValidator(value={"columnIDs"})
    public void validateColumns(ValidationContext<Constraint> validationContext) throws ValidationException {
        Constraint constraint = (Constraint)validationContext.getUpdatedObject();
        if (constraint instanceof ColumnConstraint) {
            DBObjectID[] dBObjectIDArray = ((ColumnConstraint)constraint).getColumnIDs();
            if (dBObjectIDArray == null || dBObjectIDArray.length == 0) {
                throw new ValidationException((DBObject)constraint, APIBundle.get((String)(constraint instanceof FKConstraint ? "FK_ERROR_NO_COLUMNS" : "PK_ERROR_NO_COLUMNS")));
            }
            if (validationContext.getLevel() == ValidationLevel.FULL) {
                DBObjectID dBObjectID;
                Column[] columnArray = this.getConstraintColumns((ColumnConstraint)constraint);
                this.validateConstraintColumns((ColumnConstraint)constraint, columnArray);
                if (constraint instanceof UniqueConstraint) {
                    this.checkIsUniqueDefinition(constraint);
                } else if (constraint instanceof FKConstraint && (dBObjectID = ((FKConstraint)constraint).getReferenceID()) != null && !(dBObjectID instanceof ReferenceID)) {
                    this.checkColumnsMatch((FKConstraint)constraint);
                }
            }
        }
    }

    @DBObjectValidator.PropertyValidator(value={"referenceID"})
    public void validateReference(ValidationContext<Constraint> validationContext) throws ValidationException {
        Constraint constraint = (Constraint)validationContext.getUpdatedObject();
        if (constraint instanceof FKConstraint) {
            FKConstraint fKConstraint = (FKConstraint)constraint;
            DBObjectID dBObjectID = fKConstraint.getReferenceID();
            if (dBObjectID == null) {
                throw new ValidationException((DBObject)constraint, APIBundle.get((String)"FK_ERROR_NO_REF_CON"));
            }
            if (validationContext.getLevel() == ValidationLevel.FULL && dBObjectID instanceof ReferenceID) {
                ReferenceID referenceID = (ReferenceID)dBObjectID;
                this.getProvider().validateName("CONSTRAINT", referenceID.getName());
                BaseObjectID baseObjectID = (BaseObjectID)referenceID.getParent();
                if (baseObjectID == null) {
                    throw new ValidationException((DBObject)constraint, APIBundle.get((String)"FK_ERROR_NO_REF_CON"));
                }
                this.getProvider().validateName("SCHEMA", baseObjectID.getSchemaName());
                this.getProvider().validateName("TABLE", baseObjectID.getName());
                String[] stringArray = referenceID.getChildObjectNames();
                DBObjectID[] dBObjectIDArray = fKConstraint.getColumnIDs();
                if (stringArray.length > 0 && stringArray.length != dBObjectIDArray.length) {
                    throw new ValidationException((DBObject)fKConstraint, APIBundle.format((String)"FK_ERROR_MISMATCHED_COLUMN_COUNT", (Object[])new Object[]{dBObjectIDArray.length, stringArray.length}));
                }
                for (String string : stringArray) {
                    this.getProvider().validateName("COLUMN", string);
                }
            }
        }
    }

    protected void validateConstraintColumns(ColumnConstraint columnConstraint, Column[] columnArray) throws ValidationException {
        if (columnArray.length == 0) {
            throw new ValidationException((DBObject)columnConstraint, APIBundle.get((String)(columnConstraint instanceof FKConstraint ? "FK_ERROR_NO_COLUMNS" : "PK_ERROR_NO_COLUMNS")));
        }
        if (this.areDuplicateColumns(columnArray)) {
            throw new ValidationException((DBObject)columnConstraint, APIBundle.get((String)"CONSTRAINT_ERROR_DUPLICATE_COLUMN"));
        }
        if (columnConstraint instanceof PKConstraint) {
            this.checkColumnDataType((Constraint)columnConstraint, columnArray, "PK_ERROR_INVALID_COLUMN_TYPE");
        } else if (columnConstraint instanceof UniqueConstraint) {
            this.checkColumnDataType((Constraint)columnConstraint, columnArray, "UK_ERROR_INVALID_COLUMN_TYPE");
        } else if (columnConstraint instanceof FKConstraint) {
            this.checkColumnDataType((Constraint)columnConstraint, columnArray, "FK_ERROR_INVALID_COLUMN_TYPE");
        }
    }

    public boolean isCompatibleDataTypes(DataType dataType, DataType dataType2) {
        return this.getProvider().getDescriptor().isValidFKDataType(dataType, dataType2);
    }

    protected boolean isValidConstraintDatatype(String string, DataTypeUsage dataTypeUsage) {
        return true;
    }

    private void checkColumnsMatch(FKConstraint fKConstraint) throws ValidationException {
        DBObjectID[] dBObjectIDArray = fKConstraint.getColumnIDs();
        DBObjectID dBObjectID = fKConstraint.getReferenceID();
        UniqueConstraint uniqueConstraint = null;
        try {
            uniqueConstraint = (UniqueConstraint)dBObjectID.resolveID();
        }
        catch (DBException dBException) {
            this.logException(dBException, Level.FINE);
        }
        if (uniqueConstraint != null && dBObjectIDArray != null) {
            Column[] columnArray;
            try {
                columnArray = this.getConstraintColumns((ColumnConstraint)uniqueConstraint);
            }
            catch (ValidationException validationException) {
                ValidationException validationException2 = new ValidationException((DBObject)fKConstraint, APIBundle.format((String)"FK_ERROR_INVALID_REF_CON", (Object[])new Object[]{uniqueConstraint.getName()}));
                validationException2.setRelatedObjects(new DBObject[]{uniqueConstraint});
                throw validationException2;
            }
            if (dBObjectIDArray.length == columnArray.length) {
                ValidationException validationException = null;
                for (int i = 0; i < dBObjectIDArray.length; ++i) {
                    Column column = columnArray[i];
                    Column column2 = (Column)fKConstraint.getRelation().findOwnedObject(dBObjectIDArray[i]);
                    if (column == null || column2 == null) continue;
                    String string = column.getName();
                    DataType dataType = null;
                    DataType dataType2 = null;
                    try {
                        dataType = DataTypeHelper.getDataType((DataTypeUsage)column2.getDataTypeUsage());
                        dataType2 = DataTypeHelper.getDataType((DataTypeUsage)column.getDataTypeUsage());
                    }
                    catch (DBException dBException) {
                        this.logException(dBException, Level.FINE);
                    }
                    if (this.isCompatibleDataTypes(dataType, dataType2)) continue;
                    ValidationException validationException3 = new ValidationException((DBObject)fKConstraint, APIBundle.format((String)"FK_ERROR_MISMATCHED_COLUMN_TYPES", (Object[])new Object[]{column2.getName(), dataType == null ? null : dataType.getName(), string, dataType2 == null ? null : dataType2.getName()}));
                    validationException3.setRelatedObjects(new DBObject[]{uniqueConstraint});
                    validationException = (ValidationException)((Object)DBException.append(validationException, (DBException)((Object)validationException3)));
                }
                if (validationException != null) {
                    throw validationException;
                }
            } else {
                throw new ValidationException((DBObject)fKConstraint, APIBundle.format((String)"FK_ERROR_MISMATCHED_COLUMN_COUNT", (Object[])new Object[]{dBObjectIDArray.length, columnArray.length}));
            }
        }
    }

    private void checkColumnDataType(Constraint constraint, Column[] columnArray, String string) throws ValidationException {
        for (int i = 0; i < columnArray.length; ++i) {
            Column column = columnArray[i];
            if (column == null || column.getParent() instanceof SQLQueryOwner) continue;
            DataType dataType = null;
            try {
                dataType = DataTypeHelper.getDataType((DataTypeUsage)column.getDataTypeUsage());
            }
            catch (DBException dBException) {
                this.logException(dBException, Level.FINE);
            }
            if (dataType == null) {
                throw new ValidationException((DBObject)constraint, APIBundle.format((String)"COLUMN_ERROR_MISSING_TYPE", (Object[])new Object[]{column.getName()}));
            }
            if (this.isValidConstraintDatatype(dataType.getName(), column.getDataTypeUsage())) continue;
            throw new ValidationException((DBObject)constraint, APIBundle.format((String)string, (Object[])new Object[]{column.getName()}));
        }
    }

    protected void checkIsUniqueDefinition(Constraint constraint) throws ValidationException {
        Relation relation = constraint.getRelation();
        DBObjectID[] dBObjectIDArray = ((UniqueConstraint)constraint).getColumnIDs();
        for (Constraint constraint2 : relation.getConstraints()) {
            if (!(constraint2 instanceof UniqueConstraint) || DBUtil.areNamesAndTypesEqual((DBObject)constraint2, (DBObject)constraint) || !this.areIdenticalColumnLists(relation, dBObjectIDArray, ((UniqueConstraint)constraint2).getColumnIDs())) continue;
            throw new ValidationException((DBObject)constraint, APIBundle.format((String)"UK_ERROR_DUPLICATE_DEFINITION", (Object[])new Object[]{this.getConstraintTypeDisplayName(constraint), constraint.getName(), this.getConstraintTypeDisplayName(constraint2), constraint2.getName()}));
        }
    }

    private boolean areIdenticalColumnLists(Relation relation, DBObjectID[] dBObjectIDArray, DBObjectID[] dBObjectIDArray2) {
        boolean bl = false;
        if (dBObjectIDArray.length == dBObjectIDArray2.length) {
            bl = true;
            for (int i = 0; i < dBObjectIDArray.length; ++i) {
                String string;
                String string2 = this.getColumnName(dBObjectIDArray[i], relation);
                if (!ModelUtil.areDifferent((Object)string2, (Object)(string = this.getColumnName(dBObjectIDArray2[i], relation)))) continue;
                bl = false;
                break;
            }
        }
        return bl;
    }

    private String getColumnName(DBObjectID dBObjectID, Relation relation) {
        String string = null;
        if (dBObjectID instanceof TemporaryObjectID) {
            string = ((TemporaryObjectID)dBObjectID).getDBObject().getName();
        } else if (dBObjectID instanceof NameBasedID) {
            string = ((NameBasedID)dBObjectID).getName();
        }
        if (!ModelUtil.hasLength((String)string)) {
            for (Column column : relation.getColumns()) {
                if (!column.getID().equals(dBObjectID, true)) continue;
                string = column.getName();
                break;
            }
        }
        return string;
    }

    protected String getConstraintTypeDisplayName(Constraint constraint) {
        return DisplayNames.getTypeDisplayName((String)constraint.getConstraintType());
    }

    private boolean areDuplicateColumns(Column[] columnArray) {
        boolean bl = false;
        block0: for (int i = 0; i < columnArray.length - 1 && !bl; ++i) {
            if (null == columnArray[i]) continue;
            for (int j = i + 1; j < columnArray.length; ++j) {
                if (!columnArray[i].equals((Object)columnArray[j])) continue;
                bl = true;
                continue block0;
            }
        }
        return bl;
    }

    public static void validateOnePK(Constraint[] constraintArray) throws ValidationException {
        boolean bl = false;
        for (int i = 0; i < constraintArray.length; ++i) {
            String string = constraintArray[i].getConstraintType();
            if (!"PKConstraint".equals(string)) continue;
            if (bl) {
                throw new ValidationException((DBObject)constraintArray[i], APIBundle.get((String)"CONSTRAINTS_INFO_ERROR_DUP_PK"));
            }
            bl = true;
        }
    }

    private Column[] getConstraintColumns(ColumnConstraint columnConstraint) throws ValidationException {
        ArrayList<Column> arrayList = new ArrayList<Column>();
        Relation relation = columnConstraint.getRelation();
        if (relation == null) {
            throw new ValidationException((DBObject)columnConstraint, APIBundle.format((String)"CONSTRAINT_ERROR_ORPHANED_CONSTRAINT", (Object[])new Object[0]));
        }
        ValidationException validationException = null;
        DBObjectID[] dBObjectIDArray = columnConstraint.getColumnIDs();
        for (int i = 0; i < dBObjectIDArray.length; ++i) {
            if (dBObjectIDArray[i] == null) {
                validationException = (ValidationException)((Object)DBException.append(validationException, (DBException)((Object)new ValidationException((DBObject)columnConstraint, APIBundle.format((String)"CONSTRAINT_ERROR_MISSING_COLUMN_INDEX", (Object[])new Object[]{i})))));
                continue;
            }
            Column column = (Column)relation.findOwnedObject(dBObjectIDArray[i]);
            if (column == null) {
                validationException = (ValidationException)((Object)DBException.append((DBException)((Object)validationException), (DBException)((Object)new ValidationException((DBObject)columnConstraint, APIBundle.format((String)"CONSTRAINT_ERROR_MISSING_COLUMN", (Object[])new Object[]{DBUtil.getDBObjectName((DBObjectID)dBObjectIDArray[i])})))));
            }
            arrayList.add(column);
        }
        if (validationException != null) {
            throw validationException;
        }
        return arrayList.toArray(new Column[arrayList.size()]);
    }

    public boolean initializeWithDefaultName() {
        return false;
    }
}

