/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.validators;

import java.util.logging.Level;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Database;
import oracle.javatools.db.ReferenceID;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeAttribute;
import oracle.javatools.db.datatypes.DataTypeHelper;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.db.datatypes.PredefinedDataType;
import oracle.javatools.db.property.Property;
import oracle.javatools.db.resource.APIBundle;
import oracle.javatools.db.validators.AbstractChildDBObjectValidator;
import oracle.javatools.db.validators.DBObjectValidator;
import oracle.javatools.db.validators.ValidationException;
import oracle.javatools.db.validators.ValidationLevel;

public class DataTypeUsageValidator
extends AbstractChildDBObjectValidator<DataTypeUsage> {
    public DataTypeUsageValidator(DBObjectProvider dBObjectProvider) {
        super(dBObjectProvider);
    }

    protected boolean canHaveEmptyName() {
        return true;
    }

    protected void validateMissingPath(DataTypeUsage dataTypeUsage, DataTypeUsage dataTypeUsage2, String string) throws ValidationException {
        DataTypeAttribute dataTypeAttribute;
        DataType dataType;
        String[] stringArray = Property.getProperties((String)string);
        if (stringArray.length == 2 && stringArray[0].equals("attributeValues") && (dataType = this.getDataType(dataTypeUsage2, false)) != null && (dataTypeAttribute = dataType.getDataTypeAttribute(stringArray[1])) != null) {
            Object object = dataTypeUsage2.getAttributeValue(stringArray[1]);
            this.validateAttributeUsage(dataTypeAttribute, object, dataType, dataTypeUsage2);
        }
    }

    @DBObjectValidator.PropertyValidator(value={"dataTypeID"}, level=ValidationLevel.FULL)
    public void validateDataTypeID(DataTypeUsage dataTypeUsage, DataTypeUsage dataTypeUsage2) throws ValidationException {
        this.getDataType(dataTypeUsage2, true);
    }

    private DataType getDataType(DataTypeUsage dataTypeUsage, boolean bl) throws ValidationException {
        DataType dataType = null;
        DBObjectID dBObjectID = dataTypeUsage.getDataTypeID();
        if (!(dBObjectID instanceof ReferenceID && "DATATYPE".equals(dBObjectID.getType()) && this.getProvider() instanceof Database)) {
            try {
                dataType = DataTypeHelper.getDataType((DataTypeUsage)dataTypeUsage, (boolean)false);
            }
            catch (DBException dBException) {
                this.logException(dBException, Level.FINE);
            }
            if (bl && dataType == null) {
                throw new ValidationException((DBObject)dataTypeUsage, "dataTypeID", APIBundle.format((String)"COLUMN_ERROR_MISSING_TYPE", (Object[])new Object[]{DBUtil.getFullyQualifiedName((DBObject)dataTypeUsage.getParent())}));
            }
        }
        return dataType;
    }

    @DBObjectValidator.PropertyValidator(value={"dataTypeAttributes"}, level=ValidationLevel.FULL)
    public void validateAttributes(DataTypeUsage dataTypeUsage, DataTypeUsage dataTypeUsage2) throws ValidationException {
        DataType dataType = this.getDataType(dataTypeUsage2, false);
        if (dataType != null) {
            this.validateAttributes(dataTypeUsage2, dataType);
        }
    }

    protected void validateAttributes(DataTypeUsage dataTypeUsage, DataType dataType) throws ValidationException {
        if (DataTypeHelper.isTypeOf((DataType)dataType, PredefinedDataType.class)) {
            for (DataTypeAttribute dataTypeAttribute : dataType.getDataTypeAttributes()) {
                Object object = dataTypeUsage.getAttributeValue(dataTypeAttribute.getName());
                this.validateAttributeUsage(dataTypeAttribute, object, dataType, dataTypeUsage);
            }
            DataTypeAttribute dataTypeAttribute = dataType.getDataTypeAttribute("precision");
            DataTypeAttribute dataTypeAttribute2 = dataType.getDataTypeAttribute("scale");
            this.validatePrecisionAndScale(dataTypeUsage, dataTypeAttribute, dataTypeAttribute2);
        }
    }

    protected void validatePrecisionAndScale(DataTypeUsage dataTypeUsage, DataTypeAttribute dataTypeAttribute, DataTypeAttribute dataTypeAttribute2) throws ValidationException {
        if (dataTypeAttribute != null && dataTypeAttribute2 != null && dataTypeAttribute2.isDeclarable() && dataTypeUsage.hasAttributeValue("scale")) {
            Long l = DataTypeHelper.getLongAttributeValue((DataTypeUsage)dataTypeUsage, (String)"precision");
            if (l == null) {
                l = (Long)dataTypeAttribute.getDefaultValue();
            }
            if (dataTypeAttribute2.getMaxValue() == null) {
                Long l2;
                if (l == null) {
                    this.throwAttributeValueInvalid(dataTypeUsage, dataTypeAttribute, APIBundle.format((String)"DATATYPE_ERROR_INVALID_SCALE1", (Object[])new Object[]{dataTypeAttribute2.getMinValue()}));
                }
                if ((l2 = DataTypeHelper.getLongAttributeValue((DataTypeUsage)dataTypeUsage, (String)"scale")) != null && l2.compareTo(l) > 0) {
                    this.throwAttributeValueInvalid(dataTypeUsage, dataTypeAttribute2, APIBundle.format((String)"DATATYPE_ERROR_INVALID_SCALE2", (Object[])new Object[]{l}));
                }
            }
        }
    }

    protected void validateAttributeUsage(DataTypeAttribute dataTypeAttribute, Object object, DataType dataType, DataTypeUsage dataTypeUsage) throws ValidationException {
        if (dataTypeAttribute.isMandatory() && (object == null || "".equals(object))) {
            this.throwAttributeValueInvalid(dataTypeUsage, dataTypeAttribute, APIBundle.format((String)"DATATYPE_ERROR_MISSING_MANDATORY", (Object[])new Object[]{dataTypeAttribute.getNLSLabel()}));
        }
        if (dataTypeAttribute.isDeclarable()) {
            int n = dataTypeAttribute.getValueType();
            if (n == 0) {
                String string = DataTypeHelper.toString((Object)object);
                String[] stringArray = dataTypeAttribute.getValues();
                if (string != null && stringArray != null && !dataTypeAttribute.isExtensible()) {
                    boolean bl = false;
                    for (int i = 0; i < stringArray.length; ++i) {
                        if (stringArray[i].compareToIgnoreCase(string) != 0) continue;
                        bl = true;
                        break;
                    }
                    if (!bl) {
                        this.throwAttributeValueInvalid(dataTypeUsage, dataTypeAttribute, APIBundle.format((String)"DATATYPE_ERROR_INVALID_STRING_VALUE", (Object[])new Object[]{string, dataTypeAttribute.getNLSLabel()}));
                    }
                }
            } else if (n == 1) {
                this.validateLongDataTypeAttribute(dataTypeAttribute, object, dataTypeUsage);
            } else if (n == 2) {
                String string = DataTypeHelper.toString((Object)object);
                String[] stringArray = dataTypeAttribute.getValues();
                if (stringArray != null && stringArray.length > 0) {
                    boolean bl = false;
                    for (String string2 : stringArray) {
                        if (!string2.equalsIgnoreCase(string)) continue;
                        bl = true;
                        break;
                    }
                    if (!bl) {
                        this.validateLongDataTypeAttribute(dataTypeAttribute, object, dataTypeUsage);
                    }
                }
            } else if (n != 3) {
                this.getLogger().severe("Unrecognized value type " + n + " for attribute value " + dataTypeAttribute.getName());
            }
        }
    }

    private void validateLongDataTypeAttribute(DataTypeAttribute dataTypeAttribute, Object object, DataTypeUsage dataTypeUsage) throws ValidationException {
        Long l = DataTypeHelper.toLong((Object)object);
        Long l2 = dataTypeAttribute.getMinValue();
        Long l3 = dataTypeAttribute.getMaxValue();
        if (l != null) {
            if (l2 != null && l.compareTo(l2) < 0) {
                this.throwAttributeValueInvalid(dataTypeUsage, dataTypeAttribute, APIBundle.format((String)"DATATYPE_ERROR_INVALID_NUMERIC_VALUE1", (Object[])new Object[]{dataTypeAttribute.getNLSLabel(), l2}));
            }
            if (l3 != null && l.compareTo(l3) > 0) {
                this.throwAttributeValueInvalid(dataTypeUsage, dataTypeAttribute, APIBundle.format((String)"DATATYPE_ERROR_INVALID_NUMERIC_VALUE2", (Object[])new Object[]{dataTypeAttribute.getNLSLabel(), l3}));
            }
        }
    }

    protected void throwAttributeValueInvalid(DataTypeUsage dataTypeUsage, DataTypeAttribute dataTypeAttribute, String string) throws ValidationException {
        this.throwAttributeValueInvalid(dataTypeUsage, dataTypeAttribute.getName(), string);
    }

    protected void throwAttributeValueInvalid(DataTypeUsage dataTypeUsage, String string, String string2) throws ValidationException {
        throw new ValidationException((DBObject)dataTypeUsage, Property.createPath((String[])new String[]{"attributeValues", string}), string2);
    }
}

