/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.addin.help;

import java.util.HashMap;
import oracle.bali.xml.addin.XMLSourceNode;
import oracle.bali.xml.addin.help.DefaultLanguageHelpProvider;
import oracle.bali.xml.addin.help.LanguageHelpProvider;
import oracle.bali.xml.dom.DomModel;
import oracle.bali.xml.dom.position.DomPosition;
import oracle.bali.xml.gui.jdev.JDevXmlContext;
import oracle.bali.xml.model.XmlModel;
import oracle.bali.xml.model.XmlUsage;
import oracle.ide.Context;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.help.HelpInfo;
import oracle.ide.help.Helpable;
import oracle.ide.help.HelpableProvider;
import oracle.ide.model.Node;

public class XMLHelpSupport
implements HelpableProvider {
    private static HashMap _registeredHelpProviders = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HelpInfo getHelpInfo(Helpable helpable) {
        String helpTopic = null;
        if (helpable instanceof CodeEditor) {
            JDevXmlContext xmlContext;
            CodeEditor codeEditor = (CodeEditor)helpable;
            Context editorContext = codeEditor.getContext();
            Node node = editorContext.getNode();
            int caretPosition = codeEditor.getCaretPosition();
            if (node instanceof XMLSourceNode && caretPosition >= 0 && (xmlContext = JDevXmlContext.getXmlContext(editorContext)) != null) {
                XmlModel xmlModel = xmlContext.getModel();
                DomModel domModel = xmlModel.getDomModel();
                xmlModel.acquireReadLock();
                try {
                    org.w3c.dom.Node nodeAtCaretPosition;
                    DomPosition domPos = domModel.getDomPosition(caretPosition);
                    if (domPos != null && (nodeAtCaretPosition = domPos.getContainerNode()) != null) {
                        helpTopic = xmlContext.getGui(XmlUsage.XML_CODE_EDITOR).getHelpTopic(nodeAtCaretPosition, xmlModel.getNodeXmlKey(nodeAtCaretPosition));
                    }
                }
                finally {
                    xmlModel.releaseReadLock();
                }
            }
        }
        HelpInfo helpInfo = null;
        if (helpTopic != null) {
            helpInfo = new HelpInfo(helpTopic);
        }
        return helpInfo;
    }

    public static void registerLanguageHelpProvider(String namespace, String prefix, boolean supportLocalElements) {
        DefaultLanguageHelpProvider defaultHelpProvider = new DefaultLanguageHelpProvider(namespace, prefix, supportLocalElements);
        XMLHelpSupport.registerLanguageHelpProvider(namespace, defaultHelpProvider);
    }

    public static void registerLanguageHelpProvider(String namespace, LanguageHelpProvider provider) {
        if (_registeredHelpProviders == null) {
            _registeredHelpProviders = new HashMap(7);
        }
        _registeredHelpProviders.put(namespace, provider);
    }

    public static LanguageHelpProvider getLanguageHelpProvider(String namespace) {
        LanguageHelpProvider provider = null;
        if (_registeredHelpProviders != null) {
            provider = (LanguageHelpProvider)_registeredHelpProviders.get(namespace);
        }
        return provider;
    }
}

