/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.jdev.dependency.url;

import java.net.MalformedURLException;
import java.net.URL;
import oracle.bali.xml.grammar.GrammarProvider;
import oracle.bali.xml.grammar.instance.XmlInstanceGrammarProvider;
import oracle.bali.xml.grammar.remote.GrammarLoadingPolicy;
import oracle.bali.xml.gui.jdev.audit.XmlefAuditBundle;
import oracle.bali.xml.gui.jdev.dependency.ExternalIdDeclaration;
import oracle.bali.xml.gui.jdev.dependency.url.UrlReference;
import oracle.bali.xml.model.XmlContext;
import oracle.bali.xml.model.dependency.Declaration;
import oracle.bali.xml.model.dependency.DependencyContext;
import oracle.bali.xml.model.dependency.ValidationResult;
import oracle.ide.Context;
import oracle.ide.dependency.URLDeclarationProvider;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.status.Issue;
import oracle.javatools.status.Severity;
import org.w3c.dom.Node;

public class SchemaLocReference
extends UrlReference {
    public SchemaLocReference(XmlContext xmlContext, Node node, int start, int end, URL url) {
        super(xmlContext, node, start, end, url);
    }

    @Override
    public Declaration findDeclaration(DependencyContext context) {
        if (this._url == null) {
            return null;
        }
        GrammarProvider gp = this.getXmlContext(context).getGrammarProvider();
        if (gp instanceof XmlInstanceGrammarProvider) {
            XmlInstanceGrammarProvider instanceGrammarProvider = (XmlInstanceGrammarProvider)gp;
            URL urlToCheck = this._swapWithAliasIfNeeded(instanceGrammarProvider, this._url);
            GrammarLoadingPolicy grammarLoadingPolicy = instanceGrammarProvider.getGrammarLoadingPolicy();
            GrammarLoadingPolicy.Policy policy = grammarLoadingPolicy.getPolicy(urlToCheck, GrammarLoadingPolicy.Type.XML_SCHEMA);
            switch (policy) {
                case LOAD: {
                    return this._createDeclaration(urlToCheck, false);
                }
                case IGNORE: {
                    return null;
                }
                case ERROR_UNREACHABLE: {
                    return null;
                }
            }
            throw new IllegalStateException("Unknown GrammarLoadingPolicy.Policy value");
        }
        if (this.isLocalURL(this.getURL(), this._url)) {
            return this._createDeclaration(this._url, true);
        }
        return null;
    }

    @Override
    public ValidationResult validateDeclaration(DependencyContext context, Declaration declaration) {
        if (declaration == null) {
            if (this._url == null || this.isLocalURL(this.getURL(), this._url)) {
                return this._notFound(context, false);
            }
            GrammarProvider gp = this.getXmlContext(context).getGrammarProvider();
            if (gp instanceof XmlInstanceGrammarProvider) {
                XmlInstanceGrammarProvider instanceGrammarProvider = (XmlInstanceGrammarProvider)gp;
                GrammarLoadingPolicy grammarLoadingPolicy = instanceGrammarProvider.getGrammarLoadingPolicy();
                GrammarLoadingPolicy.Policy policy = grammarLoadingPolicy.getPolicy(this._url, GrammarLoadingPolicy.Type.XML_SCHEMA);
                switch (policy) {
                    case LOAD: {
                        return ValidationResult.OK;
                    }
                    case IGNORE: {
                        return this._notLoaded(context);
                    }
                    case ERROR_UNREACHABLE: {
                        return this._notFound(context, true);
                    }
                }
                throw new IllegalStateException("Unknown GrammarLoadingPolicy.Policy value");
            }
            return ValidationResult.OK;
        }
        return ValidationResult.OK;
    }

    private Declaration _createDeclaration(URL url, boolean doExistsCheck) {
        if (doExistsCheck && !URLFileSystem.exists((URL)url)) {
            return null;
        }
        String declId = URLDeclarationProvider.getDeclarationId((URL)url);
        if (declId == null) {
            return null;
        }
        return ExternalIdDeclaration.getDeclaration(new Context(this.getWorkspace(), this.getProject()), declId);
    }

    private URL _swapWithAliasIfNeeded(XmlInstanceGrammarProvider provider, URL url) {
        URL result = url;
        String alias = provider.getSchemaLocationAlias(url);
        if (!alias.equals(url.toExternalForm())) {
            try {
                result = new URL(alias);
            }
            catch (MalformedURLException e) {
                result = url;
            }
        }
        return result;
    }

    private ValidationResult _notFound(DependencyContext context, boolean remote) {
        StringBuffer message = new StringBuffer();
        if (remote) {
            message.append(XmlefAuditBundle.get("REMOTE_LOCATION_NOT_FOUND"));
        } else {
            message.append(XmlefAuditBundle.get("LOCAL_LOCATION_NOT_FOUND"));
        }
        String value = this.getValue(context);
        if (value != null && value.length() > 0) {
            message.append(" (");
            message.append(value);
            message.append(")");
        }
        if (remote) {
            return new ValidationResult((Issue)new UrlReference.RemoteURLIssue(Severity.WARNING, message.toString()));
        }
        return new ValidationResult(Severity.WARNING, message.toString());
    }

    private ValidationResult _notLoaded(DependencyContext context) {
        StringBuffer message = new StringBuffer();
        message.append(XmlefAuditBundle.get("REMOTE_LOCATION_NOT_LOADED"));
        String value = this.getValue(context);
        if (value != null && value.length() > 0) {
            message.append(" (");
            message.append(value);
            message.append(")");
        }
        return new ValidationResult((Issue)new UrlReference.RemoteURLIssue(Severity.ADVISORY, message.toString()));
    }
}

