/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.ceditor.text.parser;

import java.awt.Color;
import java.awt.font.TextAttribute;
import java.io.Serializable;
import java.text.AttributedString;
import java.util.HashMap;
import java.util.Map;
import oracle.ide.ceditor.text.parser.Producer;

public class TextAttributeProducer
extends Producer {
    private static final HashMap ATTRIBUTES = new HashMap();
    private AttributedString _attributedString;

    private static Map createAttributes(Color color, boolean bold) {
        HashMap<TextAttribute, Serializable> map = new HashMap<TextAttribute, Serializable>();
        map.put(TextAttribute.FOREGROUND, color);
        if (bold) {
            map.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
        }
        return map;
    }

    public TextAttributeProducer(String code) {
        this._attributedString = new AttributedString(code);
    }

    @Override
    public void addAttributes(Object attributes, int from, int to) {
        Map textAttributes;
        if (from < to && (textAttributes = (Map)ATTRIBUTES.get(attributes)) != null) {
            this._attributedString.addAttributes(textAttributes, from, to);
        }
    }

    public AttributedString getAttributedString() {
        return this._attributedString;
    }

    static {
        ATTRIBUTES.put(ATTRIBUTES_NORMAL, null);
        ATTRIBUTES.put(ATTRIBUTES_STRING, TextAttributeProducer.createAttributes(new Color(0, 48, 206), false));
        ATTRIBUTES.put(ATTRIBUTES_RESERVED_WORD, TextAttributeProducer.createAttributes(new Color(49, 101, 156), true));
        ATTRIBUTES.put(ATTRIBUTES_CONSTANT, TextAttributeProducer.createAttributes(new Color(156, 101, 0), false));
        ATTRIBUTES.put(ATTRIBUTES_SINGLE_LINE_COMMENT, TextAttributeProducer.createAttributes(new Color(132, 130, 132), false));
        ATTRIBUTES.put(ATTRIBUTES_COMMENT, ATTRIBUTES.get(ATTRIBUTES_SINGLE_LINE_COMMENT));
        ATTRIBUTES.put(ATTRIBUTES_JAVADOC, ATTRIBUTES.get(ATTRIBUTES_STRING));
        ATTRIBUTES.put(ATTRIBUTES_CHAR, ATTRIBUTES.get(ATTRIBUTES_STRING));
        ATTRIBUTES.put(ATTRIBUTES_BRACE, ATTRIBUTES.get(ATTRIBUTES_NORMAL));
        ATTRIBUTES.put(ATTRIBUTES_IDENTIFIER, ATTRIBUTES.get(ATTRIBUTES_NORMAL));
        ATTRIBUTES.put(ATTRIBUTES_OPERATOR, ATTRIBUTES.get(ATTRIBUTES_NORMAL));
        ATTRIBUTES.put(ATTRIBUTES_TAGNAME, TextAttributeProducer.createAttributes(Color.RED, true));
    }
}

