/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.compare;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.ide.extension.ElementContext;
import javax.ide.extension.ElementName;
import javax.ide.extension.ElementStartContext;
import javax.ide.extension.ElementVisitor;
import javax.ide.extension.ExtensionHook;
import javax.ide.extension.MetaClassVisitor;
import javax.ide.util.MetaClass;
import oracle.ide.javaxide.Util;
import oracle.javatools.buffer.TextBuffer;
import oracle.jdevimpl.compare.StreamTextProcessor;

public final class CompareTextProcessorHook
extends ExtensionHook {
    public static final String COMPARE_TEXT_PROCESSOR_HOOK = "compare-text-processor-hook";
    private static final String NS = "http://xmlns.oracle.com/ide/extension";
    private final Collection<StreamTextProcessor> _textProcessors = new ArrayList<StreamTextProcessor>();
    private static final ElementName PROCESSOR_CLASS = new ElementName("http://xmlns.oracle.com/ide/extension", "processor-class");
    private final ElementVisitor _processorClassHandler = new ProcessorClassHandler();

    public void start(ElementStartContext context) {
        context.registerChildVisitor(PROCESSOR_CLASS, this._processorClassHandler);
    }

    public Collection<StreamTextProcessor> getTextProcessors() {
        return Collections.unmodifiableCollection(this._textProcessors);
    }

    private final class MetaClassStreamTextProcessor
    extends StreamTextProcessor {
        private final MetaClass _metaClass;
        private StreamTextProcessor _delegate;

        MetaClassStreamTextProcessor(MetaClass metaClass) {
            this._metaClass = metaClass;
        }

        @Override
        public final void process(String type, TextBuffer textBuffer, URL referenceUrl) {
            if (this._delegate == null) {
                this._delegate = (StreamTextProcessor)Util.createInstance((MetaClass)this._metaClass, StreamTextProcessor.class);
                if (this._delegate == null) {
                    this._delegate = new StreamTextProcessor(){

                        @Override
                        public final void process(String type, TextBuffer textBuffer, URL referenceUrl) {
                        }
                    };
                }
            }
            this._delegate.process(type, textBuffer, referenceUrl);
        }
    }

    private final class ProcessorClassHandler
    extends MetaClassVisitor {
        private ProcessorClassHandler() {
        }

        protected void metaClass(ElementContext context, MetaClass mc) {
            CompareTextProcessorHook.this._textProcessors.add(new MetaClassStreamTextProcessor(mc));
        }
    }
}

