/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.calendar;

import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.KeyStroke;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.PopupButton;
import oracle.javatools.ui.calendar.CalendarPanel;

public final class CalendarPopupButton
extends PopupButton {
    private static final Insets INSETS = new Insets(1, 1, 0, 1);
    private CalendarPanel calendarPanel;
    public static final String PROPERTY_CALENDAR_POPUP_VISIBLE = "PROPERTY_CALENDAR_POPUP_VISIBLE";

    public CalendarPopupButton() {
        this(Locale.getDefault());
    }

    public CalendarPopupButton(Locale locale) {
        this.init(locale);
    }

    public CalendarPanel getCalendarPanel() {
        return this.calendarPanel;
    }

    public Date[] getSelectedDates() {
        return this.calendarPanel.getSelectedDates();
    }

    private void init(Locale locale) {
        this.setIcon(OracleIcons.getIcon((String)"chooseDate.png"));
        this.setMargin(INSETS);
        this.calendarPanel = new CalendarPanel(locale);
        String hideKey = "hide-popup";
        this.calendarPanel.getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), "hide-popup");
        this.calendarPanel.getInputMap(2).put(KeyStroke.getKeyStroke(10, 0), "hide-popup");
        this.calendarPanel.getActionMap().put("hide-popup", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                CalendarPopupButton.this.hidePopup();
            }
        });
        this.calendarPanel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getActionCommand() == "DOUBLE_CLICK_COMMAND") {
                    CalendarPopupButton.this.hidePopup();
                }
            }
        });
        this.setPopupContent(this.calendarPanel);
    }

    @Override
    public void showPopup() {
        if (this.isEnabled()) {
            this.setSelected(true);
            super.showPopup();
            this.calendarPanel.focusOnDay();
            this.firePropertyChange(PROPERTY_CALENDAR_POPUP_VISIBLE, false, true);
        }
    }

    @Override
    public void hidePopup() {
        this.setSelected(false);
        super.hidePopup();
        if (this.isEnabled()) {
            this.firePropertyChange(PROPERTY_CALENDAR_POPUP_VISIBLE, true, false);
        }
    }
}

