/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.ghost;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicArrowButton;
import javax.swing.plaf.basic.BasicScrollBarUI;
import oracle.javatools.ui.ghost.UIConstants;

final class GhostScrollBarUI
extends BasicScrollBarUI {
    private static final int ROUNDEDNESS = 4;

    GhostScrollBarUI() {
    }

    public static ComponentUI createUI(JComponent c) {
        return new GhostScrollBarUI();
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this.minimumThumbSize = UIConstants.getDimension("ghost.scrollbar.thumb.min", UIConstants.Look.DARK);
    }

    @Override
    protected void configureScrollBarColors() {
        UIConstants.Look look = null;
        if (this.scrollbar.getParent() instanceof JScrollPane) {
            look = (UIConstants.Look)((Object)((JScrollPane)this.scrollbar.getParent()).getClientProperty(UIConstants.GHOST_LOOK));
        }
        look = look == null ? UIConstants.Look.DARK : look;
        this.thumbHighlightColor = UIConstants.getColor("ghost.scrollbar.track.highlight", look);
        this.thumbLightShadowColor = UIConstants.getColor("ghost.scrollbar.thumb.shadow", look);
        this.thumbColor = UIConstants.getColor("ghost.scrollbar.thumb", look);
        this.trackColor = UIConstants.getColor("ghost.scrollbar.track", look);
    }

    @Override
    protected JButton createDecreaseButton(int orientation) {
        UIConstants.Look look = (UIConstants.Look)((Object)this.scrollbar.getClientProperty(UIConstants.GHOST_LOOK));
        look = look == null ? UIConstants.Look.DARK : look;
        CustomArrowButton button = new CustomArrowButton(orientation, this.thumbColor, this.thumbHighlightColor, UIConstants.getColor("ghost.scrollbar.button", look), this.thumbColor);
        button.setOpaque(false);
        button.setBorderPainted(false);
        button.setBackground(UIConstants.getColor("ghost.transparent", look));
        return button;
    }

    @Override
    protected JButton createIncreaseButton(int orientation) {
        UIConstants.Look look = (UIConstants.Look)((Object)this.scrollbar.getClientProperty(UIConstants.GHOST_LOOK));
        look = look == null ? UIConstants.Look.DARK : look;
        CustomArrowButton button = new CustomArrowButton(orientation, this.thumbColor, this.thumbHighlightColor, UIConstants.getColor("ghost.scrollbar.button", look), this.thumbColor);
        button.setOpaque(false);
        button.setBorderPainted(false);
        button.setBackground(UIConstants.getColor("ghost.transparent", look));
        return button;
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        return this.scrollbar.getOrientation() == 1 ? new Dimension(12, 48) : new Dimension(48, 12);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        this.paintTrack(g, c, this.getTrackBounds());
        Rectangle thumbBounds = this.getThumbBounds();
        if (thumbBounds.intersects(g.getClipBounds())) {
            this.paintThumb(g, c, thumbBounds);
        }
    }

    @Override
    protected void paintTrack(Graphics g, JComponent c, Rectangle trackBounds) {
        g.setColor(this.trackColor);
        Graphics2D g2 = (Graphics2D)g.create();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setStroke(new BasicStroke(1.0f));
        if (c.getWidth() > c.getHeight()) {
            g2.fillRect(1, 1, c.getWidth(), c.getHeight() - 3);
        } else {
            g2.fillRect(1, 1, c.getWidth() - 3, c.getHeight());
        }
        g2.dispose();
    }

    @Override
    protected void paintThumb(Graphics g, JComponent c, Rectangle thumbBounds) {
        if (thumbBounds.isEmpty() || !this.scrollbar.isEnabled()) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g.create();
        int w = thumbBounds.width - 5;
        int h = thumbBounds.height - 5;
        g2.translate(thumbBounds.x, thumbBounds.y);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setStroke(new BasicStroke(1.0f));
        g2.setColor(this.thumbColor);
        if (thumbBounds.width > thumbBounds.height) {
            g2.setPaint(new GradientPaint(1.0f, 2 + h / 3, this.thumbColor, 1.0f, 2 + h / 3 * 2, this.trackColor));
        } else {
            g2.setPaint(new GradientPaint(2 + w / 3, 1.0f, this.thumbColor, 2 + w / 3 * 2, 1.0f, this.trackColor));
        }
        g2.fillRoundRect(2, 2, w, h, 4, 4);
        g2.setColor(this.thumbHighlightColor);
        g2.drawRoundRect(2, 2, w, h, 4, 4);
        g2.translate(-thumbBounds.x, -thumbBounds.y);
        g2.dispose();
    }

    private class CustomArrowButton
    extends BasicArrowButton {
        private Color highlight;
        private Stroke stroke;

        public CustomArrowButton(int direction, Color background, Color shadow, Color darkShadow, Color highlight) {
            super(direction, background, shadow, darkShadow, highlight);
            this.stroke = new BasicStroke(2.0f, 2, 1);
            this.highlight = highlight;
        }

        @Override
        public Border getBorder() {
            return BorderFactory.createEmptyBorder();
        }

        @Override
        public void paintTriangle(Graphics g, int x, int y, int size, int direction, boolean isEnabled) {
            Graphics2D g2 = (Graphics2D)g;
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setStroke(this.stroke);
            g.setColor(this.highlight);
            g2.translate(2, 2);
            int b = 6;
            int m = b / 2;
            int d = 3;
            GeneralPath path = new GeneralPath();
            switch (direction) {
                case 5: {
                    path.moveTo(0.0f, 0.0f);
                    path.lineTo(m, d);
                    path.lineTo(b, 0.0f);
                    break;
                }
                case 1: {
                    path.moveTo(0.0f, d);
                    path.lineTo(m, 0.0f);
                    path.lineTo(b, d);
                    break;
                }
                case 3: {
                    path.moveTo(0.0f, 0.0f);
                    path.lineTo(d, m);
                    path.lineTo(0.0f, b);
                    break;
                }
                case 7: {
                    path.moveTo(d, 0.0f);
                    path.lineTo(0.0f, m);
                    path.lineTo(d, b);
                }
            }
            g2.draw(path);
            g2.translate(-2, -2);
        }

        @Override
        public Dimension getPreferredSize() {
            switch (this.direction) {
                case 1: 
                case 5: {
                    return new Dimension(9, 7);
                }
            }
            return new Dimension(7, 9);
        }
    }
}

