/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.themes;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import oracle.javatools.ui.themes.Painter;
import oracle.javatools.ui.themes.SystemBoolean;

final class BufferedImageCachingPainter
implements Painter {
    private final Painter _delegate;
    private BufferedImage _cachedImage;
    private static final SystemBoolean useCompatibleImage = new SystemBoolean("ide.themes.useCompatibleImage", true);

    BufferedImageCachingPainter(Painter delegate) {
        this._delegate = delegate;
    }

    @Override
    public void paint(Graphics g, int x, int y, int w, int h) {
        if (w <= 0 || h <= 0) {
            return;
        }
        if (this._cachedImage == null || this._cachedImage.getWidth() != w || this._cachedImage.getHeight() != h) {
            this._cachedImage = this.createBufferedImage(g, w, h);
            Graphics2D gCache = this._cachedImage.createGraphics();
            this._delegate.paint(gCache, 0, 0, w, h);
            gCache.dispose();
        }
        g.drawImage(this._cachedImage, x, y, w, h, null);
    }

    private BufferedImage createBufferedImage(Graphics g, int width, int height) {
        if (this.shouldUseCompatibleImage()) {
            return ((Graphics2D)g).getDeviceConfiguration().createCompatibleImage(width, height, 3);
        }
        return new BufferedImage(width, height, 2);
    }

    private boolean shouldUseCompatibleImage() {
        return useCompatibleImage.booleanValue();
    }
}

