/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.worksheet.commands.autotrace;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.security.MessageDigest;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextField;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.RaptorExtensionConstants;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.controls.ITabCloseListner;
import oracle.dbtools.raptor.newscriptrunner.commands.HiddenParameters;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.worksheet.Messages;
import oracle.dbtools.worksheet.WorksheetContext;
import oracle.dbtools.worksheet.commands.autotrace.AnalyzeAction;
import oracle.dbtools.worksheet.commands.autotrace.AutotracePanel;
import oracle.dbtools.worksheet.commands.autotrace.SerializedData;
import oracle.dbtools.worksheet.editor.WorksheetTabbedPane;
import oracle.ide.Ide;
import oracle.javatools.dialogs.MessageDialog;

public class ExplainPlanAction
extends AnalyzeAction {
    int childNo = -1;
    private Logger logger = Logger.getLogger(AutotracePanel.class.getName());

    public ExplainPlanAction(String string, WorksheetContext worksheetContext) {
        super(Messages.getString("WorksheetTaskUI.9"), string, worksheetContext);
        if (string.startsWith("Worksheet.VSQL_Child")) {
            this.childNo = Integer.parseInt(string.substring("Worksheet.VSQL_Child".length()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Void doWork() throws TaskException {
        if (this.init()) {
            try {
                String string = this.extractSql(null);
                if (0 <= this.childNo && this.childNo < 3) {
                    try {
                        String string2 = ExplainPlanAction.stmt2sqlid(string);
                        this.autoTracePanel.setTabLabel("V$SQL_PLAN.SQL_ID=" + string2);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                this.showResultPanel();
                this.explainPlan(string, this.conn);
                this.autoTracePanel.tbl.revalidate();
                SerializedData.initColumnWidths(this.autoTracePanel.tbl);
            }
            catch (Exception exception) {
                this.logger.log(Level.SEVERE, Messages.getString("ExplainPlanAction.2") + " " + exception.getMessage());
            }
            finally {
                this.resetCursor();
            }
        }
        return null;
    }

    private final String explainPlan(String string, Connection connection) {
        boolean bl = DBConfig.getInstance().getBoolean("COMMIT_PRIOR_TRANSACTION");
        if (bl && !Connections.getInstance().isTimesTen(connection) && RaptorExtensionConstants.isStandAlone() && DBUtil.hasTransaction((Connection)connection)) {
            if (!MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)Messages.getString("Confirm_Commit"), (String)Messages.getString("Uncommitted_transaction"), null)) {
                return null;
            }
            try {
                connection.commit();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        String string2 = "" + System.currentTimeMillis();
        if (0 <= this.childNo && this.childNo < 3) {
            string2 = "" + this.childNo;
        }
        this.autoTracePanel.explainPlan(string, string2, connection);
        this.autoTracePanel.fetchPlan(string, string2, connection);
        if (bl && !Connections.getInstance().isTimesTen(connection)) {
            try {
                connection.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return string2;
    }

    public static void main(String[] stringArray) throws Exception {
        JFrame jFrame = new JFrame("Result set Panels");
        jFrame.setDefaultCloseOperation(3);
        WorksheetContext worksheetContext = new WorksheetContext();
        ExplainPlanAction explainPlanAction = new ExplainPlanAction("1", worksheetContext);
        explainPlanAction.setConnection(DriverManager.getConnection("jdbc:oracle:thin:@adc2180670:1521:x112", "scott", "tiger"));
        explainPlanAction.setAutoTracePanel(new AutotracePanel("1", true, "oracle.jdbc.OracleDriver"));
        explainPlanAction.getAutoTracePanel().setTabLabel("Explain plan 1");
        explainPlanAction.getAutoTracePanel().setContext(worksheetContext);
        explainPlanAction.explainPlan("select --+leading(e) use_nl(d) \n* from emp e, dept d where e.deptno = d.deptno ", explainPlanAction.conn);
        ExplainPlanAction explainPlanAction2 = new ExplainPlanAction("2", worksheetContext);
        explainPlanAction2.setConnection(DriverManager.getConnection("jdbc:oracle:thin:@adc2180670:1521:x112", "scott", "tiger"));
        explainPlanAction2.setAutoTracePanel(new AutotracePanel("2", true, "oracle.jdbc.OracleDriver"));
        explainPlanAction2.getAutoTracePanel().setTabLabel("Explain plan 2");
        explainPlanAction2.getAutoTracePanel().setContext(worksheetContext);
        explainPlanAction2.explainPlan("select * from emp e, dept d where e.deptno = d.deptno", explainPlanAction2.conn);
        WorksheetTabbedPane worksheetTabbedPane = new WorksheetTabbedPane();
        ITabCloseListner iTabCloseListner = new ITabCloseListner(){

            public void tabClosed() {
            }
        };
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBackground(Color.BLUE);
        jPanel.add((Component)new JTextField("tab1"), "Center");
        worksheetTabbedPane.addTab(null, "Tab 1", jPanel, Collections.singletonList(iTabCloseListner));
        worksheetTabbedPane.addTab(null, "Explain plan 1", explainPlanAction.getAutoTracePanel(), Collections.singletonList(iTabCloseListner));
        worksheetTabbedPane.addTab(null, "Explain plan 2", explainPlanAction2.getAutoTracePanel(), Collections.singletonList(iTabCloseListner));
        jFrame.add((Component)((Object)worksheetTabbedPane));
        jFrame.pack();
        jFrame.setVisible(true);
    }

    static String stmt2sqlid(String string) throws Exception {
        int n;
        if ("true".equals(HiddenParameters.parameters.get("PrintStmt2sqlid"))) {
            System.out.println(string + ".");
        }
        for (int i = 0; i < string.length(); ++i) {
            if ('\u07d0' >= string.charAt(i)) continue;
            return null;
        }
        byte[] byArray = (string + '\u0000').getBytes("utf8");
        MessageDigest messageDigest = MessageDigest.getInstance("MD5");
        byte[] byArray2 = messageDigest.digest(byArray);
        long l = 0L;
        long l2 = 0L;
        l = l * 256L + (long)(byArray2[11] & 0xFF);
        l = l * 256L + (long)(byArray2[10] & 0xFF);
        l = l * 256L + (long)(byArray2[9] & 0xFF);
        l2 = l2 * 256L + (long)(byArray2[8] & 0xFF);
        l2 = l2 * 256L + (long)(byArray2[15] & 0xFF);
        l2 = l2 * 256L + (long)(byArray2[14] & 0xFF);
        l2 = l2 * 256L + (long)(byArray2[13] & 0xFF);
        l2 = l2 * 256L + (long)(byArray2[12] & 0xFF);
        String string2 = "0123456789abcdfghjkmnpqrstuvwxyz";
        String string3 = "";
        for (n = 1; n <= 8; ++n) {
            string3 = string2.substring((int)(l2 % 32L), (int)(l2 % 32L) + 1) + string3;
            l2 /= 32L;
        }
        for (n = 9; n <= 13; ++n) {
            string3 = string2.substring((int)(l % 32L), (int)(l % 32L) + 1) + string3;
            l /= 32L;
        }
        return string3;
    }
}

