/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.worksheet.commands.autotrace;

import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.HashMap;
import java.util.TreeMap;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import oracle.dbtools.util.Service;
import oracle.ide.ExtensionRegistry;
import oracle.ide.net.URLFactory;
import oracle.javatools.ui.treetable.JTreeTable;

public class SerializedData
implements Serializable {
    TreeMap<Object, Integer> columnProperties = new TreeMap();
    public TreeMap<String, String> columnNames = new TreeMap();
    public boolean collapsePredNodes = false;
    int dividerLocation = 600;
    private static SerializedData instance = null;
    private static final String fname = "stuff.serial";
    private static MouseListener columnTrigger = new MouseListener(){
        TableColumn current = null;
        int startCol = 0;
        int startWidth = 100;

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            JTableHeader jTableHeader = (JTableHeader)mouseEvent.getSource();
            JTable jTable = jTableHeader.getTable();
            Point point = mouseEvent.getPoint();
            point.translate(-2, 0);
            this.startCol = jTable.columnAtPoint(point);
            this.current = jTable.getColumnModel().getColumn(this.startCol);
            this.startWidth = this.current.getWidth();
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (this.current == null) {
                System.out.println("current==null");
                return;
            }
            Object object = this.current.getHeaderValue();
            int n = this.current.getWidth();
            Point point = mouseEvent.getPoint();
            JTableHeader jTableHeader = (JTableHeader)mouseEvent.getSource();
            JTable jTable = jTableHeader.getTable();
            int n2 = jTable.columnAtPoint(point);
            SerializedData serializedData = SerializedData.getInstance();
            if (this.startWidth != n) {
                serializedData.columnProperties.put(object, Service.pair((int)this.startCol, (int)n));
            } else if (this.startCol != n2) {
                for (int i = 0; i < jTable.getColumnModel().getColumnCount(); ++i) {
                    TableColumn tableColumn = jTable.getColumnModel().getColumn(i);
                    serializedData.columnProperties.put(tableColumn.getHeaderValue(), Service.pair((int)i, (int)tableColumn.getWidth()));
                }
            }
            SerializedData.write();
            this.current = null;
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }
    };

    public static SerializedData getInstance() {
        if (instance == null) {
            try {
                instance = SerializedData.read();
            }
            catch (Exception exception) {
                instance = new SerializedData();
            }
        }
        return instance;
    }

    public static void write() {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(SerializedData.getURL().getFile());
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
            objectOutputStream.writeObject(SerializedData.getInstance());
            objectOutputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static SerializedData read() throws IOException, ClassNotFoundException {
        InputStream inputStream = SerializedData.getURL().openStream();
        ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
        SerializedData serializedData = (SerializedData)objectInputStream.readObject();
        objectInputStream.close();
        return serializedData;
    }

    private static URL getURL() {
        ExtensionRegistry extensionRegistry = ExtensionRegistry.getExtensionRegistry();
        URL uRL = extensionRegistry.getSystemDirectory("oracle.sqldeveloper.worksheet");
        return URLFactory.newURL((URL)uRL, (String)fname);
    }

    public static void initColumnWidths(final JTreeTable jTreeTable) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MouseListener[] mouseListenerArray2;
                SerializedData serializedData = SerializedData.getInstance();
                HashMap<Object, Integer> hashMap = new HashMap<Object, Integer>();
                for (int i = 0; i < jTreeTable.getColumnModel().getColumnCount(); ++i) {
                    mouseListenerArray2 = jTreeTable.getColumnModel().getColumn(i);
                    Object object = mouseListenerArray2.getHeaderValue();
                    Integer n = serializedData.columnProperties.get(object);
                    if (object != null && n != null) {
                        int n2 = Service.X((int)n);
                        int n3 = Service.Y((int)n);
                        mouseListenerArray2.setPreferredWidth(n3);
                        if (0 > n2 || n2 >= jTreeTable.getColumnModel().getColumnCount()) continue;
                        hashMap.put(mouseListenerArray2.getIdentifier(), n2);
                        continue;
                    }
                    mouseListenerArray2.setPreferredWidth(i == 0 ? 300 : 200);
                }
                for (MouseListener[] mouseListenerArray2 : hashMap.keySet()) {
                    int n = jTreeTable.getColumnModel().getColumnIndex(mouseListenerArray2);
                    jTreeTable.getColumnModel().moveColumn(n, (Integer)hashMap.get(mouseListenerArray2));
                }
                boolean bl = false;
                for (MouseListener mouseListener : mouseListenerArray2 = jTreeTable.getTableHeader().getMouseListeners()) {
                    if (mouseListener != columnTrigger) continue;
                    bl = true;
                }
                if (!bl) {
                    jTreeTable.getTableHeader().addMouseListener(columnTrigger);
                }
            }
        });
    }

    public void setColumnWidths(TreeMap<Object, Integer> treeMap) {
        this.columnProperties = treeMap;
    }

    public TreeMap<Object, Integer> getColumnWidths() {
        return this.columnProperties;
    }

    public void setDividerLocation(int n) {
        this.dividerLocation = n;
    }

    public int getDividerLocation() {
        return this.dividerLocation;
    }
}

