/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.worksheet.editor;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import oracle.dbtools.raptor.controls.CustomTabbedPane;
import oracle.dbtools.raptor.controls.ITabCloseListner;
import oracle.dbtools.worksheet.WorksheetResultPanel;
import oracle.dbtools.worksheet.WorksheetState;
import oracle.ide.controls.customtab.DefaultCustomTabPage;

public class WorksheetTabbedPane
extends CustomTabbedPane {
    protected JSplitPane splitter = null;

    public void setSplitter(JSplitPane jSplitPane) {
        this.splitter = jSplitPane;
        if (this.splitter != null) {
            this._customTab.addMouseListener((MouseListener)new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    if (SwingUtilities.isLeftMouseButton(mouseEvent) && mouseEvent.getClickCount() == 2) {
                        int n = WorksheetTabbedPane.this.splitter.getDividerLocation();
                        int n2 = WorksheetTabbedPane.this.splitter.getMinimumDividerLocation();
                        int n3 = WorksheetTabbedPane.this.splitter.getMaximumDividerLocation();
                        if (mouseEvent.isShiftDown()) {
                            WorksheetTabbedPane.this.splitter.resetToPreferredSizes();
                            return;
                        }
                        if (n == n2) {
                            WorksheetTabbedPane.this.splitter.setDividerLocation(n3);
                        } else {
                            WorksheetTabbedPane.this.splitter.setDividerLocation(n2);
                        }
                        WorksheetTabbedPane.this.splitter.setLastDividerLocation(n);
                    }
                }
            });
        }
    }

    public void addTab(WorksheetResultPanel worksheetResultPanel, List<ITabCloseListner> list) {
        int n;
        JComponent jComponent = worksheetResultPanel.getGUI();
        String string = worksheetResultPanel.getID();
        for (n = 0; n < this._model.getSize(); ++n) {
            DefaultCustomTabPage defaultCustomTabPage = (DefaultCustomTabPage)this._model.get(n);
            WorksheetResultPanel worksheetResultPanel2 = (WorksheetResultPanel)defaultCustomTabPage.getUserObject();
            if (!defaultCustomTabPage.isCloseable() || !worksheetResultPanel2.getID().equals(string) || worksheetResultPanel2.isPinned()) continue;
            this.replaceTab(defaultCustomTabPage, worksheetResultPanel, list);
            return;
        }
        n = this.getPanelIndex(jComponent);
        if (n >= 0) {
            this.setSelectedIndex(n);
        } else if (!worksheetResultPanel.isCloseable()) {
            this.addTab(0, worksheetResultPanel, list);
        } else {
            this.addTab(this._content.getComponentCount(), worksheetResultPanel, list);
        }
    }

    public void replaceTab(DefaultCustomTabPage defaultCustomTabPage, WorksheetResultPanel worksheetResultPanel, List<ITabCloseListner> list) {
        WorksheetResultPanel worksheetResultPanel2 = (WorksheetResultPanel)defaultCustomTabPage.getUserObject();
        int n = this.getPanelIndex(worksheetResultPanel2.getGUI());
        if (n >= 0) {
            this.removeTab(defaultCustomTabPage);
            this.addTab(worksheetResultPanel, list);
        }
    }

    public void addTab(int n, final WorksheetResultPanel worksheetResultPanel, List<ITabCloseListner> list) {
        String string = this.getUniqueName(n, worksheetResultPanel, false);
        worksheetResultPanel.setTabLabel(string);
        DefaultCustomTabPage defaultCustomTabPage = new DefaultCustomTabPage(worksheetResultPanel.getTabIcon(), string, worksheetResultPanel.getGUI()){

            public Icon getIcon() {
                return worksheetResultPanel.getTabIcon();
            }
        };
        if (worksheetResultPanel.isCloseable()) {
            defaultCustomTabPage.setCloseable(true);
        } else {
            defaultCustomTabPage.setCloseable(false);
        }
        defaultCustomTabPage.setTooltip(worksheetResultPanel.getTabToolTip());
        this._model.add(n, defaultCustomTabPage);
        worksheetResultPanel.getGUI().setName(string);
        this._content.add(worksheetResultPanel.getGUI(), string, n);
        list.add(worksheetResultPanel);
        this._closeListenters.put(defaultCustomTabPage, list);
        worksheetResultPanel.setState(WorksheetState.OPENED);
        this.setSelectedIndex(n);
    }

    public WorksheetResultPanel getSelectedResultPanel() {
        return (WorksheetResultPanel)((Object)this.getActivePanel());
    }

    protected String getUniqueName(int n, WorksheetResultPanel worksheetResultPanel, boolean bl) {
        String string;
        String string2 = string = worksheetResultPanel.getTabLabel();
        if (n > 0) {
            int n2;
            ArrayList<String> arrayList = new ArrayList<String>();
            for (n2 = 0; n2 < this._model.getSize(); ++n2) {
                DefaultCustomTabPage defaultCustomTabPage = (DefaultCustomTabPage)this._model.get(n2);
                WorksheetResultPanel object = (WorksheetResultPanel)defaultCustomTabPage.getUserObject();
                if (!object.getTabLabel().startsWith(string) || !worksheetResultPanel.getClass().getName().equals(object.getClass().getName())) continue;
                arrayList.add(object.getTabLabel());
            }
            if (arrayList.size() == 0) {
                string2 = string;
            } else {
                n2 = 0;
                for (String string3 : arrayList) {
                    int n3 = this.getIndexFromTabLabel(string3);
                    n2 = Math.max(n2, n3);
                }
                string2 = string + " " + (n2 + 1);
            }
        }
        return string2;
    }

    private int getIndexFromTabLabel(String string) {
        String string2 = string;
        int n = 0;
        for (int i = string.length() - 1; i >= 0; --i) {
            if (Character.isDigit(string.charAt(i))) continue;
            if (i + 1 >= string.length()) break;
            string2 = string.substring(i + 1);
            break;
        }
        try {
            n = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
        return n;
    }

    protected JMenuItem[] getDynamicMenuItems(Object object) {
        if (object instanceof WorksheetResultPanel) {
            WorksheetResultPanel worksheetResultPanel = (WorksheetResultPanel)object;
            LinkedList<WorksheetResultPanel> linkedList = new LinkedList<WorksheetResultPanel>();
            for (int i = 0; i < this._model.getSize(); ++i) {
                WorksheetResultPanel worksheetResultPanel2;
                DefaultCustomTabPage defaultCustomTabPage = (DefaultCustomTabPage)this._model.get(i);
                if (!(defaultCustomTabPage.getUserObject() instanceof WorksheetResultPanel) || (worksheetResultPanel2 = (WorksheetResultPanel)defaultCustomTabPage.getUserObject()) == worksheetResultPanel) continue;
                linkedList.add(worksheetResultPanel2);
            }
            return worksheetResultPanel.getTabDynamicCtxMenu(linkedList.toArray(new WorksheetResultPanel[0]));
        }
        return null;
    }
}

