/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.worksheet.sqlcodeadvisor;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.net.URL;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.Timer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.connections.ConnectionEvent;
import oracle.dbtools.raptor.connections.ConnectionListener;
import oracle.dbtools.raptor.editors.RaptorEditorPlugin;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.SQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptParser;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.util.Debug;
import oracle.dbtools.worksheet.WorksheetResources;
import oracle.dbtools.worksheet.sqlcodeadvisor.AdviceInfo;
import oracle.dbtools.worksheet.sqlcodeadvisor.CAMessages;
import oracle.dbtools.worksheet.sqlcodeadvisor.CodeAdvisorCache;
import oracle.dbtools.worksheet.sqlcodeadvisor.CodeAdvisorLogPage;
import oracle.dbtools.worksheet.sqlcodeadvisor.CodeAdvisorPane;
import oracle.dbtools.worksheet.sqlcodeadvisor.CodeAdvisorStatusDisplay;
import oracle.ide.model.UpdateMessage;
import oracle.javatools.buffer.ExpiredTextBufferException;
import oracle.javatools.db.DBException;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.EditorProperties;
import oracle.javatools.editor.gutter.GutterColumn;
import oracle.javatools.editor.gutter.GutterColumnListener;
import oracle.javatools.editor.gutter.GutterMark;
import oracle.javatools.editor.gutter.LineGutterPlugin;
import oracle.javatools.editor.highlight.HighlightStyle;
import oracle.javatools.util.ModelUtil;

public class CodeAdvisor
implements RaptorEditorPlugin {
    static CodeAdvisorStatusDisplay display = null;
    private CodeAdvisorCache m_cache = null;
    private String m_connName = null;
    private URL m_codeURL = null;
    boolean isWorksheet = true;
    private LineGutterPlugin m_gutter;
    private BasicEditorPane m_editPane;
    private Integer m_docChanges = 0;
    private long m_docChanged = 0L;
    static List<CodeAdvisor> instances = new LinkedList<CodeAdvisor>();
    private WorksheetGutterColumnListener m_worksheetAdviceListener = new WorksheetGutterColumnListener();
    private Timer m_worksheetAdviceTimer = null;
    private DocumentListener m_dl = new DocumentListener(){

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            CodeAdvisor.this.trackDocChanges();
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            CodeAdvisor.this.trackDocChanges();
        }
    };

    static boolean isCodeAdvisorEnabled() {
        return DBConfig.getInstance().getBoolean("CODEADVISOR_ENABLE");
    }

    static int getRefreshDelay() {
        return Integer.valueOf(DBConfig.getInstance().getString("CODEADVISOR_REFRESHDELAY"));
    }

    static int getInactivityDelay() {
        return Integer.valueOf(DBConfig.getInstance().getString("CODEADVISOR_INACTIVITYDELAY"));
    }

    private Timer getWorksheetAdviceTimer() {
        Timer timer = null;
        if (this.m_worksheetAdviceTimer == null) {
            ActionListener actionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (CodeAdvisor.this.resetDocChanges()) {
                        CodeAdvisor.this.m_worksheetAdviceListener.actionPerformed(null);
                    }
                }
            };
            timer = new Timer(CodeAdvisor.getRefreshDelay(), actionListener);
            timer.start();
        }
        return timer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean resetDocChanges() {
        Integer n = this.m_docChanges;
        synchronized (n) {
            boolean bl = CodeAdvisorPane.getInstance().isAdviceAvailable();
            if (bl && this.m_docChanges == 0) {
                return false;
            }
            if (bl && this.m_docChanged + (long)CodeAdvisor.getInactivityDelay() > System.currentTimeMillis()) {
                return false;
            }
            this.m_docChanges = 0;
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void trackDocChanges() {
        Integer n = this.m_docChanges;
        synchronized (n) {
            Integer n2 = this.m_docChanges;
            Integer n3 = this.m_docChanges = Integer.valueOf(this.m_docChanges + 1);
            this.m_docChanged = System.currentTimeMillis();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cleanupCache(List<AdviceInfo> list) {
        Integer n = this.m_docChanges;
        synchronized (n) {
            this.m_cache.cleanupCache(list);
        }
    }

    private void registerAndAnalyze(final List<AdviceInfo> list) {
        if (CodeAdvisor.isCodeAdvisorEnabled()) {
            if (this.m_cache == null) {
                this.m_cache = CodeAdvisorCache.initialize(this.m_codeURL);
            }
            new Thread(){

                @Override
                public void run() {
                    String string;
                    int n = 1;
                    for (AdviceInfo adviceInfo : list) {
                        string = adviceInfo.getSql();
                        AdviceInfo adviceInfo2 = CodeAdvisor.this.m_cache.register(adviceInfo, CodeAdvisor.this.m_connName);
                        if (adviceInfo2 == adviceInfo) {
                            CodeAdvisor.displayWarning(n, 0, 0, "Completed registration of sql_id: " + adviceInfo.getSqlId() + " for: " + string + "\n");
                        } else if (adviceInfo2 == null) {
                            CodeAdvisor.displayWarning(n, 0, 0, "Could not acquire connection lock to register sql: " + string + "\n");
                        }
                        ++n;
                    }
                    n = 1;
                    for (AdviceInfo adviceInfo : list) {
                        string = adviceInfo.getSql();
                        boolean bl = CodeAdvisor.this.m_cache.analyze(adviceInfo, CodeAdvisor.this.m_connName);
                        if (bl) {
                            CodeAdvisor.displayWarning(n, 0, 0, "Completed analysis of sqlid: " + adviceInfo.getSqlId() + " with force_matching_signature: " + adviceInfo.getForceMatchingSignature() + "\n");
                        }
                        ++n;
                    }
                    try {
                        CodeAdvisor.this.cleanupCache(list);
                    }
                    catch (ConcurrentModificationException concurrentModificationException) {
                        CodeAdvisor.displayWarning(0, 0, 0, "ConcurrentModificationException upon cleanupCache in CodeAdvisor.registerAndAnalyze\n");
                    }
                    CodeAdvisor.this.m_cache.notifyObservers((Object)CodeAdvisor.this.m_cache, new UpdateMessage(UpdateMessage.CONTENT_MODIFIED, (Object)this));
                    CodeAdvisorPane.getInstance().setAdviceAvailable(true);
                }
            }.start();
        }
    }

    void displayAdvice() {
        if (display != null && CodeAdvisor.isCodeAdvisorEnabled()) {
            if (Debug.isDebugBuild()) {
                display.registerAsynchronousLogPage(null);
            }
            CodeAdvisorPane codeAdvisorPane = CodeAdvisorPane.getInstance();
            codeAdvisorPane.activateWindow(this.m_codeURL);
        }
    }

    static void displayWarning(int n, int n2, int n3, String string) {
        if (CodeAdvisor.isCodeAdvisorEnabled() && Debug.isDebugBuild()) {
            display.warning(n, n2, n3, string);
        }
    }

    public void deinstall(BasicEditorPane basicEditorPane) {
        this.m_worksheetAdviceTimer.stop();
        this.m_editPane.getDocument().removeDocumentListener(this.m_dl);
        this.m_editPane = null;
        CodeAdvisorCache.s_sqlAtURL.remove(this.m_codeURL);
        this.m_codeURL = null;
        this.m_connName = null;
        CodeAdvisorPane.getInstance().activateWindow(null);
        if (display != null && !CodeAdvisor.isCodeAdvisorEnabled()) {
            display.unRegisterAsynchronousLogPage();
        }
        instances.remove(this);
        if (instances.size() == 0 && display != null) {
            display.unRegisterAsynchronousLogPage();
            CodeAdvisorLogPage.getAdviceLog().clearAll();
        }
    }

    public void install(BasicEditorPane basicEditorPane) {
        instances.add(this);
        this.m_editPane = basicEditorPane;
        this.m_editPane.getDocument().addDocumentListener(this.m_dl);
        this.m_worksheetAdviceTimer = this.getWorksheetAdviceTimer();
        this.displayAdvice();
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
    }

    public void setConnection(String string) {
        if (ModelUtil.areDifferent((Object)this.m_connName, (Object)string)) {
            this.m_connName = string;
            if (this.m_cache != null) {
                this.m_cache.setFlushable(false);
            }
            this.trackDocChanges();
            Connections.getInstance().addConnectionListener(new ConnectionListener(){

                public void connectionAdded(ConnectionEvent connectionEvent) {
                }

                public void connectionRemoved(ConnectionEvent connectionEvent) {
                }

                public void connectionRenamed(ConnectionEvent connectionEvent) {
                }

                public void connectionModified(ConnectionEvent connectionEvent) {
                }

                public void connectionOpened(ConnectionEvent connectionEvent) {
                }

                public void connectionClosed(ConnectionEvent connectionEvent) {
                    if (connectionEvent.getConnectionName().equals(CodeAdvisor.this.m_connName)) {
                        CodeAdvisor.this.trackDocChanges();
                        CodeAdvisor.this.m_connName = null;
                        if (CodeAdvisor.this.m_cache != null) {
                            CodeAdvisor.this.m_cache.setFlushable(true);
                        }
                    }
                }
            });
        }
    }

    public void setLineGutter(LineGutterPlugin lineGutterPlugin) {
        this.m_gutter = lineGutterPlugin;
    }

    public void setNodeURL(URL uRL) {
        this.m_codeURL = uRL;
        if (CodeAdvisor.isCodeAdvisorEnabled()) {
            this.m_cache = CodeAdvisorCache.initialize(this.m_codeURL);
        }
    }

    public class WorksheetGutterColumnListener
    implements ActionListener,
    GutterColumnListener {
        private int m_lineNo;
        private List<GutterMark> m_marks;
        private Icon m_adviceIcon;
        private Connection m_conn;

        private boolean isConnected() {
            try {
                return CodeAdvisor.this.m_connName != null && Connections.getInstance().getConnection(CodeAdvisor.this.m_connName, false) != null;
            }
            catch (DBException dBException) {
                return false;
            }
        }

        private String getSqlStatement() {
            try {
                String string = CodeAdvisor.this.m_editPane.getSelectedText();
                if (string == null) {
                    string = CodeAdvisor.this.m_editPane.getText();
                }
                return string;
            }
            catch (ExpiredTextBufferException expiredTextBufferException) {
                return null;
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            GutterMark gutterMark2;
            String string;
            String string2 = WorksheetResources.getString("WORKSHEET_CODEADVICE_COLUMN");
            GutterColumn gutterColumn = CodeAdvisor.this.m_gutter.lookupGutterColumn(string2);
            if (gutterColumn == null) {
                gutterColumn = CodeAdvisor.this.m_gutter.createGutterColumn(string2, (GutterColumnListener)this);
            }
            if (this.m_marks == null) {
                this.m_marks = new ArrayList<GutterMark>();
                this.m_adviceIcon = CAMessages.getIcon("GUTTER_ICON");
            }
            if ((string = this.getSqlStatement()) == null) {
                return;
            }
            boolean bl = this.isConnected();
            for (GutterMark gutterMark2 : this.m_marks) {
                if (gutterMark2 == null) continue;
                try {
                    gutterMark2.getGutterColumn().removeGutterMark(gutterMark2);
                }
                catch (ExpiredTextBufferException expiredTextBufferException) {}
            }
            EditorProperties editorProperties = EditorProperties.getProperties();
            gutterMark2 = editorProperties.getHighlightRegistry();
            String string3 = WorksheetResources.getString("WORKSHEET_BOOKMARK_STYLE");
            HighlightStyle highlightStyle = gutterMark2.createStyle(string3, string3, 20, Color.black, new Color(153, 255, 255));
            if (CodeAdvisor.isCodeAdvisorEnabled() && bl) {
                ArrayList<AdviceInfo> arrayList = new ArrayList<AdviceInfo>();
                ScriptParser scriptParser = new ScriptParser(string, this.m_conn);
                scriptParser.parse();
                ISQLCommand iSQLCommand = null;
                gutterColumn.beginBlockAdd();
                ISQLCommand[] iSQLCommandArray = scriptParser.getSqlStatements();
                int n = iSQLCommandArray.length;
                for (int i = 0; i < n; ++i) {
                    ISQLCommand iSQLCommand2;
                    iSQLCommand = iSQLCommand2 = iSQLCommandArray[i];
                    string = iSQLCommand.getSql();
                    String string4 = iSQLCommand.getSQLOrig();
                    if (string == null || string.trim().length() < 1 || iSQLCommand.getStmtId() == SQLCommand.StmtSubType.G_S_COMMENT_PLUS || string4.trim().toUpperCase().startsWith("DESC") || string4.trim().toUpperCase().startsWith("@") || string4.trim().toUpperCase().startsWith("START ") || iSQLCommand.getStmtId() == SQLCommand.StmtSubType.G_S_DEFINE || iSQLCommand.getStmtId() == SQLCommand.StmtSubType.G_S_UNDEFINE || iSQLCommand.isSqlPlusSetCmd() || iSQLCommand.getStmtId() == SQLCommand.StmtSubType.G_S_COMMENT_SQL) {
                        string = null;
                    } else if (string.endsWith(";") && !string.toUpperCase().endsWith("END;")) {
                        string = string.substring(0, string.length() - 1);
                    }
                    if (iSQLCommand == null || string == null) continue;
                    this.m_lineNo = iSQLCommand.getStartLine() + 1;
                    this.m_marks.add(gutterColumn.addGutterMark(this.m_lineNo, this.m_adviceIcon, highlightStyle, 2, 1));
                    GutterMark[] gutterMarkArray = gutterColumn.lookupGutterMarks(this.m_lineNo);
                    if (gutterMarkArray.length <= 0) continue;
                    AdviceInfo adviceInfo = new AdviceInfo(string, this.m_lineNo, iSQLCommand.getStartLine(), iSQLCommand.getEndLine(), iSQLCommand.getLines());
                    gutterMarkArray[0].setUserData((Object)adviceInfo);
                    arrayList.add(adviceInfo);
                }
                gutterColumn.endBlockAdd();
                if (CodeAdvisor.this.m_cache != null && CodeAdvisor.this.m_cache.isFlushable()) {
                    CodeAdvisorPane.getInstance().activateWindow(CodeAdvisor.this.m_codeURL);
                } else {
                    CodeAdvisor.this.registerAndAnalyze(arrayList);
                }
            }
        }

        public String getMarkToolTip(GutterMark gutterMark, MouseEvent mouseEvent) {
            return "Code Advice for sql = " + gutterMark.getUserData().toString();
        }

        public void markClicked(GutterMark gutterMark, int n, MouseEvent mouseEvent) {
            AdviceInfo adviceInfo = (AdviceInfo)gutterMark.getUserData();
            adviceInfo.setRefreshRequested(true);
            AdviceInfo adviceInfo2 = CodeAdvisor.this.m_cache.getAdviceInfo(adviceInfo.getSql(), false);
            if (adviceInfo2 != null && adviceInfo != adviceInfo2) {
                adviceInfo2.setRefreshRequested(true);
            }
            CodeAdvisor.this.trackDocChanges();
            CodeAdvisor.displayWarning(n, 0, 0, gutterMark.getUserData().toString() + "\n");
        }

        public void markMoved(GutterMark gutterMark, int n, int n2) {
        }

        public void markRemoved(GutterMark gutterMark, int n) {
            int n2 = this.m_marks.indexOf(gutterMark);
            if (n2 != -1) {
                this.m_marks.remove(n2);
            }
        }
    }
}

