/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.graphlayout.uniformlengthedges;

import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.graphlayout.IlvGraphLayoutException;
import ilog.views.graphlayout.IlvGraphModel;
import ilog.views.graphlayout.hierarchical.IlvHierarchicalLayout;
import ilog.views.graphlayout.internalutil.IlvGraphLayoutData;
import ilog.views.graphlayout.internalutil.LayoutUtil;
import ilog.views.graphlayout.internalutil.LogResUtil;
import ilog.views.graphlayout.internalutil.LogResUtil2;
import ilog.views.graphlayout.internalutil.PositionData;
import ilog.views.graphlayout.internalutil.ReshapeLinkUtil;
import ilog.views.graphlayout.internalutil.TopologicalData;
import ilog.views.graphlayout.tree.IlvTreeLayout;
import ilog.views.graphlayout.uniformlengthedges.IlvFMMAlgorithm;
import ilog.views.graphlayout.uniformlengthedges.IlvUniformLengthEdgesLayout;
import ilog.views.graphlayout.uniformlengthedges.IlvUniformLengthEdgesLayoutReport;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Random;

class IlvULEAlgorithm
implements Serializable {
    private static final int a = 20;
    private static final int b = 60;
    private static final int c = 8;
    private static final float d = 0.9f;
    private static final float e = 0.1f;
    private static final float f = 0.2f;
    private static final float g = 0.7f;
    private static final float h = 0.1f;
    private transient IlvGraphModel i;
    private IlvUniformLengthEdgesLayoutReport j;
    protected IlvGraphLayoutData _layoutData;
    protected TopologicalData _topologicalData;
    protected PositionData _positionData;
    protected float[] _vectNodesDx;
    protected float[] _vectNodesDy;
    private int[] k;
    private int[] l;
    private float[] m;
    protected float[] _vectHalfNodeDiag;
    private boolean n = false;
    private boolean o = false;
    private float p = 0.0f;
    private float[] q = new float[2];
    private long r;
    private boolean s = false;
    private int t = 11;
    protected IlvUniformLengthEdgesLayout _ule;
    private IlvTreeLayout u;
    private IlvHierarchicalLayout v;
    private IlvFMMAlgorithm w;

    public IlvULEAlgorithm(IlvUniformLengthEdgesLayout ilvUniformLengthEdgesLayout) {
        this._ule = ilvUniformLengthEdgesLayout;
    }

    protected IlvUniformLengthEdgesLayout getOriginalUle() {
        return this._ule;
    }

    IlvFMMAlgorithm a() {
        return this.w;
    }

    public void detach() {
        if (this.s) {
            return;
        }
        this._vectNodesDx = null;
        this._vectNodesDy = null;
        this.k = null;
        this.l = null;
        this.m = null;
        this._vectHalfNodeDiag = null;
        this._layoutData = null;
        this._topologicalData = null;
        this._positionData = null;
        if (this.u != null) {
            this.u.detach();
        }
        if (this.v != null) {
            this.v.detach();
        }
        if (this.w != null) {
            this.w.detach();
        }
    }

    public void layout(IlvFMMAlgorithm ilvFMMAlgorithm, boolean bl) throws IlvGraphLayoutException {
        this.s = true;
        this.init();
        try {
            this.w = ilvFMMAlgorithm;
            if (ilvFMMAlgorithm != null) {
                ilvFMMAlgorithm.doLayout(this.i, bl);
            } else {
                this.doLayout(bl);
            }
        }
        finally {
            this._layoutData = null;
            this._topologicalData = null;
            this._positionData = null;
            this.s = false;
            this.clean();
        }
    }

    protected void init() throws IlvGraphLayoutException {
        block11: {
            block10: {
                block9: {
                    block8: {
                        this.i = this._ule.getGraphModel();
                        this.j = (IlvUniformLengthEdgesLayoutReport)this._ule.getLayoutReport();
                        this._ule.checkAppropriateLinks();
                        this._layoutData = new IlvGraphLayoutData(this._ule);
                        this._layoutData.beforeLayout(false, false, false, false);
                        this._topologicalData = this._layoutData.getTopologicalData();
                        this._positionData = this._layoutData.getPositionData();
                        this.initializeDataStructures();
                        if (this._topologicalData == null) break block8;
                        if (this._positionData != null) break block9;
                    }
                    LogResUtil2.logAndThrowGraphLayoutExc(IlvUniformLengthEdgesLayout.class, "graphlayout.expert.message.6766E");
                }
                if (this._topologicalData.isNoMoveableNode()) {
                    this.j.setCode(5);
                    return;
                }
                if (this._topologicalData.getNumberOfLinks() < 1) {
                    this.j.setCode(5);
                    return;
                }
                if (this._topologicalData == null) break block10;
                if (this._positionData != null) break block11;
            }
            LogResUtil2.logAndThrowGraphLayoutExc(IlvUniformLengthEdgesLayout.class, "graphlayout.expert.message.6766E");
        }
    }

    protected void clean() {
    }

    protected void doLayout(boolean bl) throws IlvGraphLayoutException {
        float f;
        float f2;
        float f3;
        float f4;
        long l;
        int n;
        if (this._topologicalData.getNumberOfNodes() < 2 || this._topologicalData.getNumberOfLinks() < 1) {
            this.a(1, true, bl);
            return;
        }
        IlvRect ilvRect = null;
        boolean bl2 = this._ule.isForceFitToLayoutRegion();
        if (bl2) {
            ilvRect = this._topologicalData.getModifiedLayoutRegion(this._ule.getCalcLayoutRegion());
        }
        if (this._ule.getLinkStyle() == 1) {
            ReshapeLinkUtil.deleteIntermediatePointsOnLinks(this.i, this._ule, false);
        }
        this.c();
        IlvPoint ilvPoint = this.a(ilvRect);
        boolean bl3 = this._ule.getLayoutMode() == 10;
        Random random = new Random(0L);
        float f5 = this._ule.getAdditionalNodeRepulsionWeight();
        int n2 = this._ule.getAllowedNumberOfIterations();
        long l2 = this._ule.getAllowedTime();
        float f6 = this._ule.getNodeDistanceThreshold();
        float f7 = this._ule.getMaxAllowedMovePerIteration();
        boolean bl4 = this._ule.isRespectNodeSizes();
        float f8 = this._ule.getPreferredLinksLength();
        boolean bl5 = false;
        int n3 = 0;
        this.b();
        if (!bl3) {
            int n4 = this.getPreprocessingMode();
            switch (n4) {
                case 11: {
                    this.a(this.i, this._ule.getRemainingAllowedTime());
                    break;
                }
                case 12: {
                    this.b(this.i, this._ule.getRemainingAllowedTime());
                }
            }
            if (n4 != 10) {
                this._positionData.updateNodePositions();
            }
            n = (int)((float)n2 * 0.2f);
            l = (long)((float)l2 * 0.2f);
            bl5 = false;
            f4 = f6;
            f3 = f8;
            f2 = this.a(this.i, f7);
            f = 0.0f;
            this.a(f3, bl5);
            n3 += this.a(n, l, f2, ilvRect, ilvPoint, bl2, f4, f, f3, bl5, random, bl);
        }
        float f9 = 0.0f;
        f9 = bl3 ? (f5 > 0.0f ? 0.9f : 1.0f) : (f5 > 0.0f ? 0.7f : 0.8f);
        n = (int)((float)n2 * f9);
        l = (long)((float)l2 * f9);
        f3 = f8;
        f2 = f7;
        f = 0.0f;
        bl5 = bl4;
        f4 = f6;
        this.a(f3, bl5);
        n3 += this.a(n, l, f2, ilvRect, ilvPoint, bl2, f4, f, f8, bl5, random, bl);
        if (f5 > 0.0f) {
            float f10 = bl3 ? 0.1f : 0.1f;
            n = (int)((float)n2 * f10);
            l = (long)((float)l2 * f10);
            f3 = f8;
            f2 = f7;
            f = f5;
            bl5 = bl4;
            f4 = f6;
            this.a(f3, bl5);
            n3 += this.a(n, l, f2, ilvRect, ilvPoint, bl2, f4, f, f8, bl5, random, bl);
        }
        if (!this.o && !this._positionData.placeNodesAtPosition(bl, ilvPoint)) {
            LogResUtil2.logAndThrowGraphLayoutExc(IlvUniformLengthEdgesLayout.class, "graphlayout.expert.message.6767E");
        }
        this.a(n3, this.n, bl);
    }

    final void a(int n) {
        this.t = n;
    }

    protected int getPreprocessingMode() {
        return this.t;
    }

    private IlvPoint a(IlvRect ilvRect) {
        IlvPoint ilvPoint = null;
        if (this._positionData.getNumberOfFixedNodes() == 0) {
            ilvPoint = ilvRect != null ? new IlvPoint(ilvRect.x + ilvRect.width * 0.5f, ilvRect.y + ilvRect.height * 0.5f) : this._positionData.getNodesBarycenter();
        }
        return ilvPoint;
    }

    private void a(int n, boolean bl, boolean bl2) throws IlvGraphLayoutException {
        if (bl) {
            this.j.setCode(5);
        } else {
            this.j.setCode(6);
        }
        this.j.b(n);
    }

    private float a(IlvGraphModel ilvGraphModel, float f) {
        IlvRect ilvRect = this._positionData.getNodesBoundingBox();
        float f2 = (float)Math.sqrt(ilvRect.width * ilvRect.width + ilvRect.height + ilvRect.height);
        ilvRect = LayoutUtil.GetEstimatedLayoutRegion(ilvGraphModel);
        float f3 = (float)Math.sqrt(ilvRect.width * ilvRect.width + ilvRect.height + ilvRect.height);
        float f4 = 0.5f * Math.max(f2, f3);
        if (f4 < f) {
            f4 = f;
        }
        if (f4 > 6.0f * f) {
            f4 = 6.0f * f;
        }
        return f4;
    }

    private void b() {
        this.p = 0.0f;
        this.o = false;
        this.n = false;
    }

    private int a(int n, long l, float f, IlvRect ilvRect, IlvPoint ilvPoint, boolean bl, float f2, float f3, float f4, boolean bl2, Random random, boolean bl3) throws IlvGraphLayoutException {
        this.r = System.currentTimeMillis();
        boolean bl4 = this._ule.isAnimate();
        float f5 = this._ule.getConvergenceThreshold();
        float f6 = 2.0f * f5;
        float f7 = this._ule.getLinkLengthWeight();
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (this.a(n4, n, l)) {
            this._positionData.resetMaxMovementCounter();
            this.a(ilvRect, f2, bl, f, f7, f3, f5, bl2, random);
            this.o = false;
            this.p = this._positionData.getMaxMovement();
            if (bl4 && this.p > f5 && n4 % 8 == 0) {
                if (!this._positionData.placeNodesAtPositionInAnimation(bl3, ilvPoint)) {
                    LogResUtil2.logAndThrowGraphLayoutExc(IlvUniformLengthEdgesLayout.class, "graphlayout.expert.message.6767E");
                }
                this.o = true;
            }
            this.j.b(n4 + 1);
            this.j.a(this.p);
            this._ule.callLayoutStepPerformedIfNeeded();
            ++n4;
            if (this.p <= f5) {
                if (n2 > 20) {
                    this.n = true;
                    break;
                }
                ++n2;
            } else {
                n2 = 0;
            }
            if (this.p <= f6) {
                if (n3 > 60) {
                    this.n = true;
                    break;
                }
                ++n3;
                continue;
            }
            n3 = 0;
        }
        return n4;
    }

    private void a(IlvRect ilvRect, float f, boolean bl, float f2, float f3, float f4, float f5, boolean bl2, Random random) {
        this.a(f3, f5, random);
        this.computeNodeForces(f, f4, f5, bl2, random);
        this.a(ilvRect, bl, f2, f5, random);
    }

    protected void initializeDataStructures() throws IlvGraphLayoutException {
        if (this._positionData == null) {
            LogResUtil2.logAndThrowGraphLayoutExc(IlvUniformLengthEdgesLayout.class, "graphlayout.expert.message.6768E");
        }
        if (!this._positionData.identifyFixedAndMoveableNodes(false, true)) {
            LogResUtil2.logAndThrowGraphLayoutExc(IlvUniformLengthEdgesLayout.class, "graphlayout.expert.message.6768E");
        }
        int n = this._topologicalData.getNumberOfNodes();
        int n2 = this._topologicalData.getNumberOfLinks();
        if (this._vectNodesDx == null || n != this._vectNodesDx.length) {
            this._vectNodesDx = new float[n];
            this._vectNodesDy = new float[n];
        } else {
            for (int i = 0; i < n; ++i) {
                this._vectNodesDx[i] = 0.0f;
                this._vectNodesDy[i] = 0.0f;
            }
        }
        if (this.k == null || n2 != this.k.length) {
            this.k = new int[n2];
            this.l = new int[n2];
        }
        if (this.m == null || n2 != this.m.length) {
            this.m = new float[n2];
        }
        if (this._ule.isRespectNodeSizes() && (this._vectHalfNodeDiag == null || n != this._vectHalfNodeDiag.length)) {
            this._vectHalfNodeDiag = new float[n];
        }
    }

    private final void a(float f, float f2, Random random) {
        if (f == 0.0f) {
            return;
        }
        f /= 3.0f;
        int n = this._topologicalData.getNumberOfLinks();
        float f3 = 0.0f;
        float f4 = 0.0f;
        double d = 0.0;
        float f5 = f2 * 2.0f;
        float[] fArray = this._positionData.getVectNodesPositionX();
        float[] fArray2 = this._positionData.getVectNodesPositionY();
        for (int i = 0; i < n; ++i) {
            int n2 = this.l[i];
            int n3 = this.k[i];
            if (n2 == n3) continue;
            f3 = fArray[n2] - fArray[n3];
            f4 = fArray2[n2] - fArray2[n3];
            float f6 = f3;
            float f7 = f4;
            if (f6 < 0.0f) {
                f6 = -f6;
            }
            if (f7 < 0.0f) {
                f7 = -f7;
            }
            if (f6 < 1.0E-20f) {
                if (f7 < 1.0E-20f) {
                    f3 = this.getRandomValue(f5, random);
                    f4 = this.getRandomValue(f5, random);
                }
            }
            d = (d = Math.sqrt(f3 * f3 + f4 * f4)) == 0.0 ? 1.0E-4 : d;
            float f8 = (float)((double)f * ((double)this.m[i] - d) / d);
            float f9 = f8 * f3;
            float f10 = f8 * f4;
            int n4 = n2;
            this._vectNodesDx[n4] = this._vectNodesDx[n4] + f9;
            int n5 = n2;
            this._vectNodesDy[n5] = this._vectNodesDy[n5] + f10;
            int n6 = n3;
            this._vectNodesDx[n6] = this._vectNodesDx[n6] - f9;
            int n7 = n3;
            this._vectNodesDy[n7] = this._vectNodesDy[n7] - f10;
        }
    }

    private final float a(float f, boolean bl) {
        int n;
        block5: {
            block7: {
                block6: {
                    if (!bl) break block5;
                    n = this._topologicalData.getNumberOfNodes();
                    if (this._vectHalfNodeDiag == null) break block6;
                    if (this._vectHalfNodeDiag.length == n) break block7;
                }
                LogResUtil.logAndThrowRuntimeExc(IlvUniformLengthEdgesLayout.class, "graphlayout.expert.message.6769E");
            }
            this.a(this._vectHalfNodeDiag, n);
        }
        n = this._topologicalData.getNumberOfLinks();
        float f2 = 0.0f;
        for (int i = 0; i < n; ++i) {
            Object object = this._topologicalData.getLink(i);
            int n2 = this.k[i];
            int n3 = this.l[i];
            if (n2 == n3) continue;
            float f3 = this._ule.getPreferredLength(object);
            float f4 = this.m[i] = f3 >= 0.0f ? f3 : f;
            if (bl) {
                int n4 = i;
                this.m[n4] = this.m[n4] + (this._vectHalfNodeDiag[n2] + this._vectHalfNodeDiag[n3]);
            }
            if (!(this.m[i] > f2)) continue;
            f2 = this.m[i];
        }
        this._ule.callLayoutStepPerformedIfNeeded();
        return f2;
    }

    private void c() {
        int n = this._topologicalData.getNumberOfLinks();
        for (int i = 0; i < n; ++i) {
            Object object = this._topologicalData.getLink(i);
            this.k[i] = this._layoutData.getIntIdentifier(this.i.getFrom(object));
            this.l[i] = this._layoutData.getIntIdentifier(this.i.getTo(object));
        }
        this._ule.callLayoutStepPerformedIfNeeded();
    }

    private void a(float[] fArray, int n) {
        float f = -1.0f;
        for (int i = 0; i < n; ++i) {
            float f2 = 0.5f * LayoutUtil.getDiagonal(this._topologicalData.getNode(i), this.i);
            if (f2 > f) {
                f = f2;
            }
            fArray[i] = f2;
        }
    }

    protected void computeNodeForces(float f, float f2, float f3, boolean bl, Random random) {
        float f4 = 0.0f;
        float f5 = 0.0f;
        float f6 = 0.0f;
        float f7 = 0.0f;
        float f8 = 0.0f;
        float f9 = 0.0f;
        float f10 = f2 / 3.0f;
        float f11 = f;
        float f12 = f3 * 2.0f;
        int n = this._topologicalData.getNumberOfNodes();
        float[] fArray = this._positionData.getVectNodesPositionX();
        float[] fArray2 = this._positionData.getVectNodesPositionY();
        for (int i = 0; i < n; ++i) {
            f6 = 0.0f;
            f7 = 0.0f;
            for (int j = 0; j < n; ++j) {
                if (i == j) continue;
                f4 = fArray[i] - fArray[j];
                f5 = fArray2[i] - fArray2[j];
                double d = f4 * f4 + f5 * f5;
                if (f10 > 0.0f) {
                    double d2 = Math.sqrt(d);
                    double d3 = d2 = d2 == 0.0 ? 1.0E-4 : d2;
                    if (bl) {
                        f11 = f + this._vectHalfNodeDiag[i] + this._vectHalfNodeDiag[j];
                    }
                    if (d2 < (double)f11) {
                        float f13 = (float)((double)f10 * (((double)f11 - d2) / d2));
                        f8 = f13 * f4;
                        f9 = f13 * f5;
                        int n2 = i;
                        this._vectNodesDx[n2] = this._vectNodesDx[n2] + f8;
                        int n3 = i;
                        this._vectNodesDy[n3] = this._vectNodesDy[n3] + f9;
                        int n4 = j;
                        this._vectNodesDx[n4] = this._vectNodesDx[n4] - f8;
                        int n5 = j;
                        this._vectNodesDy[n5] = this._vectNodesDy[n5] - f9;
                    }
                }
                if (d <= (double)1.0E-20f) {
                    f6 += this.getRandomValue(f12, random);
                    f7 += this.getRandomValue(f12, random);
                    f6 += f4 / 3.0f;
                    f7 += f5 / 3.0f;
                    continue;
                }
                f6 = (float)((double)f6 + (double)f4 / d);
                f7 = (float)((double)f7 + (double)f5 / d);
            }
            double d = f6 * f6 + f7 * f7;
            if (d <= (double)1.0E-20f) {
                if (this._vectNodesDx == null) {
                    LogResUtil.logAndThrowRuntimeExc(IlvUniformLengthEdgesLayout.class, "graphlayout.expert.message.6770E");
                }
                int n6 = i;
                this._vectNodesDx[n6] = this._vectNodesDx[n6] + this.getRandomValue(f12, random);
                int n7 = i;
                this._vectNodesDy[n7] = this._vectNodesDy[n7] + this.getRandomValue(f12, random);
                continue;
            }
            if (!((d = Math.sqrt(d) / 2.0) > (double)1.0E-20f)) continue;
            int n8 = i;
            this._vectNodesDx[n8] = (float)((double)this._vectNodesDx[n8] + (double)f6 / d);
            int n9 = i;
            this._vectNodesDy[n9] = (float)((double)this._vectNodesDy[n9] + (double)f7 / d);
        }
        this._ule.callLayoutStepPerformedIfNeeded();
    }

    private static void a(float[] fArray, float f) {
        float f2 = fArray[0];
        float f3 = fArray[1];
        float f4 = f2 < 0.0f ? -f2 : f2;
        float f5 = f3 < 0.0f ? -f3 : f3;
        float f6 = f4 > f5 ? f4 : f5;
        if (f6 < 1.0E-20f) {
            return;
        }
        if (f6 > f) {
            if (f4 >= f5) {
                f3 = f3 * f / f4;
                f2 = f2 >= 0.0f ? f : -f;
            } else {
                f2 = f2 * f / f5;
                f3 = f3 >= 0.0f ? f : -f;
            }
        }
        fArray[0] = f2;
        fArray[1] = f3;
    }

    private void a(IlvRect ilvRect, boolean bl, float f, float f2, Random random) {
        int n = this._topologicalData.getNumberOfNodes();
        boolean bl2 = this._ule.isPreserveFixedNodes();
        boolean bl3 = this.d();
        float f3 = f2 * 2.0f;
        int n2 = 0;
        while (n2 < n) {
            if (!bl2 || !this._positionData.hasBeenIdentifiedAsFixed(n2)) {
                this.q[0] = this._vectNodesDx[n2];
                this.q[1] = this._vectNodesDy[n2];
                if (bl3) {
                    this.q[0] = this.q[0] + this.getRandomValue(f3, random);
                    this.q[1] = this.q[1] + this.getRandomValue(f3, random);
                }
                IlvULEAlgorithm.a(this.q, f);
                float f4 = this.q[0];
                float f5 = this.q[1];
                float f6 = this._positionData.getXofNode(n2) + f4;
                float f7 = this._positionData.getYofNode(n2) + f5;
                if (bl) {
                    if (f6 < ilvRect.x) {
                        f6 = ilvRect.x;
                    } else if (f6 > ilvRect.x + ilvRect.width) {
                        f6 = ilvRect.x + ilvRect.width;
                    }
                    if (f7 < ilvRect.y) {
                        f7 = ilvRect.y;
                    } else if (f7 > ilvRect.y + ilvRect.height) {
                        f7 = ilvRect.y + ilvRect.height;
                    }
                    this._positionData.recordMove(f6 - this._positionData.getXofNode(n2), f7 - this._positionData.getYofNode(n2));
                } else {
                    this._positionData.recordMove(f4, f5);
                }
                this._positionData.setNodePosition(n2, f6, f7);
            }
            int n3 = n2;
            this._vectNodesDx[n3] = this._vectNodesDx[n3] / 2.0f;
            int n4 = n2++;
            this._vectNodesDy[n4] = this._vectNodesDy[n4] / 2.0f;
        }
        this._ule.callLayoutStepPerformedIfNeeded();
    }

    private boolean d() {
        int n = this._topologicalData.getNumberOfNodes();
        if (n <= 2) {
            return false;
        }
        double d = 0.0;
        boolean bl = false;
        boolean bl2 = false;
        for (int i = 0; i < n; ++i) {
            float f = this._vectNodesDx[i];
            float f2 = this._vectNodesDy[i];
            if (i == 0) {
                if (Math.abs(f) < 1.0E-20f) {
                    bl = true;
                    continue;
                }
                if (Math.abs(f2) < 1.0E-20f) {
                    bl2 = true;
                    continue;
                }
                d = Math.abs(f / f2);
                continue;
            }
            if (bl) {
                if (!(Math.abs(f) >= 1.0E-20f)) continue;
                return false;
            }
            if (bl2) {
                if (!(Math.abs(f2) >= 1.0E-20f)) continue;
                return false;
            }
            if (!(Math.abs(d - (double)Math.abs(f / f2)) >= (double)1.0E-20f)) continue;
            return false;
        }
        return true;
    }

    protected float getRandomValue(float f, Random random) {
        float f2 = random.nextFloat() * f - f * 0.5f;
        return Math.abs(f2) < 1.0E-20f ? this.getRandomValue(f, random) : f2;
    }

    private boolean a(int n, int n2, long l) {
        return n < n2 && !this.a(l) && !this._ule.isStoppedImmediately();
    }

    private boolean a(long l) {
        return System.currentTimeMillis() - this.r > l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void a(IlvGraphModel ilvGraphModel, long l) throws IlvGraphLayoutException {
        if (this.u == null) {
            this.e();
        }
        if (this.u.getGraphModel() != ilvGraphModel) {
            boolean bl = ilvGraphModel.isInternalGraphModelChecking();
            ilvGraphModel.setInternalGraphModelChecking(false);
            this.u.attach(ilvGraphModel);
            ilvGraphModel.setInternalGraphModelChecking(bl);
        }
        this.u.setAllowedTime(l);
        float f = this._ule.getPreferredLinksLength();
        this.u.setParentChildOffset(f);
        Object object = this.a(ilvGraphModel);
        this.u.setRoot(object);
        try {
            this.u.performLayout(true, false);
        }
        finally {
            this.u.setRootPreference(object, -1);
        }
        this.u.setPreserveFixedNodes(this._ule.isPreserveFixedNodes());
    }

    private void e() {
        final IlvUniformLengthEdgesLayout ilvUniformLengthEdgesLayout = this._ule;
        this.u = new IlvTreeLayout(){

            @Override
            public boolean isFixed(Object object) {
                return ilvUniformLengthEdgesLayout.isFixed(object);
            }
        };
        this.u.setGlobalLinkStyle(0);
        this.u.setLayoutOfConnectedComponentsEnabled(false);
        this.u.setLayoutMode(3);
        this.u.setIncrementalMode(false);
        this.u.setFirstCircleEvenlySpacing(false);
    }

    Object a(IlvGraphModel ilvGraphModel) {
        Object var2_2 = null;
        int n = -1;
        Enumeration enumeration = ilvGraphModel.getNodes();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            int n2 = ilvGraphModel.getNodeDegree(e);
            if (n2 <= n) continue;
            n = n2;
            var2_2 = e;
        }
        return var2_2;
    }

    final void b(IlvGraphModel ilvGraphModel, long l) throws IlvGraphLayoutException {
        if (this.v == null) {
            this.f();
        }
        if (this.v.getGraphModel() != ilvGraphModel) {
            boolean bl = ilvGraphModel.isInternalGraphModelChecking();
            ilvGraphModel.setInternalGraphModelChecking(false);
            this.v.attach(ilvGraphModel);
            ilvGraphModel.setInternalGraphModelChecking(bl);
        }
        this.v.setAllowedTime(l);
        this.v.performLayout(true, false);
        this.v.setPreserveFixedNodes(this._ule.isPreserveFixedNodes());
    }

    private void f() {
        final IlvUniformLengthEdgesLayout ilvUniformLengthEdgesLayout = this._ule;
        this.v = new IlvHierarchicalLayout(){

            @Override
            public boolean isFixed(Object object) {
                return ilvUniformLengthEdgesLayout.isFixed(object);
            }
        };
        this.v.setGlobalLinkStyle(0);
        this.v.setLayoutOfConnectedComponentsEnabled(false);
        this.v.setHorizontalLinkOffset(30.0f);
        this.v.setHorizontalNodeLinkOffset(40.0f);
        this.v.setHorizontalNodeOffset(80.0f);
        this.v.setVerticalLinkOffset(30.0f);
        this.v.setVerticalNodeLinkOffset(40.0f);
        this.v.setVerticalNodeOffset(80.0f);
    }
}

