/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.sdm.debugger.gui;

import ilog.views.sdm.debugger.IlvDebuggerContext;
import ilog.views.util.IlvLocaleUtil;
import ilog.views.util.IlvResourceUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class MessageDialog
extends JPanel {
    private DefaultTreeModel a;
    private DefaultMutableTreeNode b;
    private TreePath c;
    private String d;
    private String e;
    private HashMap<Object, LogEntry> f = new HashMap();
    private boolean g = true;
    private JTree h;
    private IlvDebuggerContext i;
    private static Icon j;
    private static Icon k;
    private static final boolean l = true;
    private static ResourceBundle m;

    private MessageDialog(Object[] objectArray, IlvDebuggerContext ilvDebuggerContext, String string) {
        super(new BorderLayout());
        if (j == null) {
            j = new ImageIcon(this.getClass().getResource("ADD_Notation.gif"));
            k = new ImageIcon(this.getClass().getResource("error_obj.gif"));
        }
        this.i = ilvDebuggerContext;
        this.c();
        LogRecord logRecord = new LogRecord(Level.INFO, string);
        logRecord.setParameters(objectArray);
        logRecord.setResourceBundle(IlvResourceUtil.getBundle((String)"ilog.views.util.css.css", (Locale)IlvLocaleUtil.getCurrentLocale(), (ClassLoader)MessageDialog.class.getClassLoader()));
        new CSSLogPublisher().publish(logRecord, this);
        this.setSize(300, 200);
        this.revalidate();
    }

    public static void showDialog(final Object[] objectArray, final IlvDebuggerContext ilvDebuggerContext, final String string) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MessageDialog messageDialog = new MessageDialog(objectArray, ilvDebuggerContext, string);
                JFrame jFrame = new JFrame(messageDialog.b("Builder.MessageView.Title"));
                jFrame.getContentPane().add(messageDialog);
                jFrame.setDefaultCloseOperation(2);
                Rectangle rectangle = SwingUtilities.getRoot(ilvDebuggerContext.getDiagramPanel()).getBounds();
                int n = 300;
                int n2 = 200;
                jFrame.setBounds(rectangle.x + rectangle.width / 2 + n / 2, rectangle.y + rectangle.height - n2, n, n2);
                jFrame.setVisible(true);
            }
        });
    }

    private JTree c() {
        if (this.h != null) {
            return this.h;
        }
        JTree jTree = new JTree();
        jTree.setCellRenderer(this.createTreeCellRenderer(jTree));
        this.setTree(jTree);
        return jTree;
    }

    public void setTree(JTree jTree) {
        if (this.h != null) {
            this.remove(this.h);
        }
        this.h = jTree;
        if (jTree != null) {
            this.initializeTree(jTree);
            this.a(jTree);
        }
    }

    protected void initializeTreeSuper(JTree jTree) {
        jTree.setRootVisible(false);
        jTree.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2 && mouseEvent.getModifiers() == 16) {
                    JTree jTree = (JTree)mouseEvent.getSource();
                    TreePath[] treePathArray = jTree.getSelectionPaths();
                    for (int i = 0; treePathArray != null && i < treePathArray.length; ++i) {
                        TreePath treePath = treePathArray[i];
                        TreeNode treeNode = (TreeNode)treePath.getLastPathComponent();
                        if (!treeNode.isLeaf()) continue;
                        MessageDialog.this.nodeDoubleClicked(mouseEvent, treeNode, treeNode instanceof DefaultMutableTreeNode ? ((DefaultMutableTreeNode)treeNode).getUserObject() : null);
                    }
                } else if (mouseEvent.getClickCount() == 1) {
                    JTree jTree = (JTree)mouseEvent.getSource();
                    TreePath treePath = jTree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
                    if (treePath == null) {
                        jTree.setSelectionPath(null);
                    }
                    if (mouseEvent.getModifiers() == 4) {
                        TreeNode treeNode;
                        if (treePath == null) {
                            return;
                        }
                        if (jTree.getSelectionCount() != 1 || treePath != jTree.getSelectionPath()) {
                            jTree.getSelectionModel().setSelectionPath(treePath);
                        }
                        MessageDialog.this.nodeRightClicked(mouseEvent, treeNode, (treeNode = (TreeNode)treePath.getLastPathComponent()) instanceof DefaultMutableTreeNode ? ((DefaultMutableTreeNode)treeNode).getUserObject() : null);
                    }
                }
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
            }
        });
    }

    private void a(JTree jTree) {
        JScrollPane jScrollPane = new JScrollPane(jTree);
        this.add((Component)jScrollPane, "Center");
    }

    protected void nodeRightClicked(MouseEvent mouseEvent, TreeNode treeNode, Object object) {
    }

    public JTree getTree() {
        return this.c();
    }

    protected void initializeTree(JTree jTree) {
        this.initializeTreeSuper(jTree);
        this.b = new DefaultMutableTreeNode(null);
        this.a = new DefaultTreeModel(this.b);
        jTree.setModel(this.a);
        ToolTipManager.sharedInstance().registerComponent(jTree);
        this.d = this.b("Builder.MessageView.ClickableFormat");
        this.e = this.b("Builder.MessageView.ClickableToolTip");
    }

    protected TreeCellRenderer createTreeCellRenderer(JTree jTree) {
        return new LogEntryRenderer();
    }

    protected void nodeDoubleClicked(MouseEvent mouseEvent, TreeNode treeNode, Object object) {
        if (object instanceof LogDetail && ((LogDetail)object).isClickable()) {
            ((LogDetail)object).click();
        }
    }

    public void clear() {
        this.b.removeAllChildren();
        this.a.nodeStructureChanged(this.b);
    }

    private void a(StringBuffer stringBuffer, DefaultMutableTreeNode defaultMutableTreeNode, int n) {
        int n2;
        Component component = this.getTree().getCellRenderer().getTreeCellRendererComponent(this.getTree(), defaultMutableTreeNode, false, false, false, this.getTree().getRowForPath(new TreePath(defaultMutableTreeNode.getPath())), false);
        for (n2 = 0; n2 < n; ++n2) {
            stringBuffer.append(" ");
        }
        stringBuffer.append("- ");
        if (defaultMutableTreeNode == this.b) {
            stringBuffer.append(this.b("title"));
        } else {
            if (defaultMutableTreeNode.getUserObject() instanceof LogEntry) {
                stringBuffer.append(((LogEntry)defaultMutableTreeNode.getUserObject()).getRecord().getLevel().getName());
                stringBuffer.append(": ");
            }
            stringBuffer.append(this.a(((JLabel)component).getText()));
        }
        stringBuffer.append("\n");
        for (n2 = 0; n2 < defaultMutableTreeNode.getChildCount(); ++n2) {
            this.a(stringBuffer, (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(n2), n + 2);
        }
    }

    private String a(String string) {
        if (string.startsWith("<html>")) {
            string = string.substring("<html>".length());
            if (string.endsWith("</html>")) {
                string = string.substring(0, string.length() - "</html>".length());
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string, "<>", true);
            StringBuffer stringBuffer = new StringBuffer();
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                if (string2.equals("<") && stringTokenizer.hasMoreTokens()) {
                    stringTokenizer.nextToken();
                    continue;
                }
                if (string2.equals(">")) continue;
                stringBuffer.append(string2);
            }
            string = stringBuffer.toString();
        }
        return string;
    }

    private boolean a(LogRecord logRecord, LogPublisher logPublisher) {
        LogEntry logEntry = this.f.get(logPublisher.getHashKey(logRecord));
        if (logEntry == null) {
            Throwable throwable;
            logEntry = new LogEntry(logRecord, logPublisher.getLabel(logRecord));
            this.f.put(logPublisher.getHashKey(logRecord), logEntry);
            DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(logEntry);
            this.a.insertNodeInto(defaultMutableTreeNode, this.b, this.b.getChildCount());
            this.getTree().expandPath(this.c);
            DefaultMutableTreeNode defaultMutableTreeNode2 = defaultMutableTreeNode;
            LogDetail[] logDetailArray = logPublisher.getDetails(logRecord, this);
            if (logDetailArray != null) {
                for (int i = 0; i < logDetailArray.length; ++i) {
                    LogDetail logDetail = logDetailArray[i];
                    DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode(logDetail);
                    this.a.insertNodeInto(defaultMutableTreeNode3, defaultMutableTreeNode, defaultMutableTreeNode.getChildCount());
                    defaultMutableTreeNode2 = defaultMutableTreeNode3;
                }
            }
            if ((throwable = logPublisher.getThrown(logRecord)) != null) {
                defaultMutableTreeNode2 = this.a(throwable, defaultMutableTreeNode);
            }
            this.getTree().expandPath(new TreePath(defaultMutableTreeNode));
            this.getTree().scrollPathToVisible(new TreePath(defaultMutableTreeNode2.getPath()));
            return true;
        }
        return false;
    }

    private String b(String string) {
        if (m == null) {
            m = IlvResourceUtil.getBundle((String)"ilog.views.builder.resources.builder", (Locale)IlvLocaleUtil.getCurrentLocale(), (ClassLoader)MessageDialog.class.getClassLoader());
        }
        return m.getString(string);
    }

    private DefaultMutableTreeNode a(Throwable throwable, DefaultMutableTreeNode defaultMutableTreeNode) {
        Object object;
        String string = this.b("Builder.MessageView.ExceptionFormat");
        String string2 = MessageFormat.format(string, throwable);
        Object object2 = new DefaultMutableTreeNode(string2);
        this.a.insertNodeInto((MutableTreeNode)object2, defaultMutableTreeNode, defaultMutableTreeNode.getChildCount());
        Throwable throwable2 = null;
        while (throwable != null) {
            throwable2 = throwable;
            if ((throwable = throwable.getCause()) == null) continue;
            string = this.b("Builder.MessageView.CausedByFormat");
            string2 = MessageFormat.format(string, throwable);
            object = new DefaultMutableTreeNode(string2);
            this.a.insertNodeInto((MutableTreeNode)object, (MutableTreeNode)object2, object2.getChildCount());
            object2 = object;
        }
        if (throwable2 != null) {
            object = throwable2.getStackTrace();
            for (int i = 0; i < ((StackTraceElement[])object).length; ++i) {
                DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(object[i]);
                this.a.insertNodeInto(defaultMutableTreeNode2, (MutableTreeNode)object2, object2.getChildCount());
            }
        }
        return object2;
    }

    protected void setCheckButton(boolean bl) {
        this.g = bl;
    }

    protected boolean isCheckButton() {
        return this.g;
    }

    private class LogEntryRenderer
    extends DefaultTreeCellRenderer {
        private LogEntryRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            JLabel jLabel = (JLabel)super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            Object object2 = ((DefaultMutableTreeNode)object).getUserObject();
            String string = null;
            if (object2 instanceof LogEntry) {
                LogEntry logEntry = (LogEntry)object2;
                this.setText(logEntry.getLabel());
                this.setIcon(k);
            } else {
                if (object2 instanceof LogDetail && ((LogDetail)object2).isClickable()) {
                    this.setText(MessageFormat.format(MessageDialog.this.d, this.getText()));
                    string = MessageDialog.this.e;
                }
                this.setIcon(j);
            }
            this.setToolTipText(string);
            return jLabel;
        }
    }

    public static class CSSLogPublisher
    extends LogPublisher {
        @Override
        public boolean isIgnored(LogRecord logRecord, MessageDialog messageDialog) {
            return false;
        }

        @Override
        public Object getHashKey(LogRecord logRecord) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(logRecord.getMessage());
            stringBuffer.append("");
            Object[] objectArray = logRecord.getParameters();
            for (int i = 0; i < objectArray.length; ++i) {
                if (this.a(logRecord, i)) continue;
                stringBuffer.append(objectArray[i]);
                stringBuffer.append("");
            }
            return stringBuffer.toString();
        }

        @Override
        public LogDetail[] getDetails(LogRecord logRecord, MessageDialog messageDialog) {
            Object[] objectArray = logRecord.getParameters();
            ArrayList<LogDetail> arrayList = new ArrayList<LogDetail>();
            for (int i = 0; i < objectArray.length; i += 2) {
                String string = (String)objectArray[i];
                if (this.a(logRecord, i)) continue;
                String string2 = objectArray[i + 1] != null ? objectArray[i + 1].toString() : null;
                String string3 = logRecord.getResourceBundle().getString(string);
                arrayList.add(new LogDetail(MessageFormat.format(string3, string2)));
            }
            return arrayList.toArray(new LogDetail[0]);
        }

        @Override
        public Throwable getThrown(LogRecord logRecord) {
            Object object = this.a(logRecord, "CSS.Beans.Exception");
            if (object instanceof Throwable) {
                return (Throwable)object;
            }
            return super.getThrown(logRecord);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private boolean a(LogRecord logRecord, int n) {
            Object[] objectArray = logRecord.getParameters();
            if (objectArray == null) return false;
            n = n / 2 * 2;
            Object object = objectArray[n];
            if ("CSS.Beans.Object".equals(object)) return true;
            if ("CSS.Beans.Bean".equals(object)) return true;
            if ("CSS.Beans.Rule".equals(object)) return true;
            if ("CSS.Beans.RuleSelector".equals(object)) return true;
            if ("CSS.Beans.Exception".equals(object)) return true;
            if (!"CSS.Beans.CSSEngine".equals(object)) return false;
            return true;
        }

        private Object a(LogRecord logRecord, String string) {
            Object[] objectArray = logRecord.getParameters();
            if (objectArray != null) {
                for (int i = 0; i < objectArray.length; i += 2) {
                    if (!string.equals(objectArray[i]) || i >= objectArray.length - 1) continue;
                    return objectArray[i + 1];
                }
            }
            return null;
        }
    }

    public static class LogPublisher {
        public boolean isIgnored(LogRecord logRecord, MessageDialog messageDialog) {
            return false;
        }

        public Object getHashKey(LogRecord logRecord) {
            return logRecord;
        }

        public boolean publish(LogRecord logRecord, MessageDialog messageDialog) {
            return messageDialog.a(logRecord, this);
        }

        public String getLabel(LogRecord logRecord) {
            String string = logRecord.getMessage();
            if (string == null) {
                return "<html><i>(null)</i></html>";
            }
            if (logRecord.getResourceBundle() != null) {
                try {
                    string = logRecord.getResourceBundle().getString(string);
                }
                catch (MissingResourceException missingResourceException) {
                }
            }
            String string2 = "<html>";
            StringTokenizer stringTokenizer = new StringTokenizer(string, "{}", true);
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                if (string3.equals("{")) {
                    string2 = string2 + "<strong>{";
                    continue;
                }
                if (string3.equals("}")) {
                    string2 = string2 + "}</strong>";
                    continue;
                }
                string2 = string2 + string3;
            }
            string2 = string2 + "</html>";
            return MessageFormat.format(string2, logRecord.getParameters());
        }

        public LogDetail[] getDetails(LogRecord logRecord, MessageDialog messageDialog) {
            Object[] objectArray = logRecord.getParameters();
            if (objectArray != null) {
                ArrayList<LogDetail> arrayList = new ArrayList<LogDetail>();
                for (int i = 0; i < objectArray.length; ++i) {
                    if (objectArray[i] == null) continue;
                    LogDetail logDetail = new LogDetail(objectArray[i].toString());
                    arrayList.add(logDetail);
                }
                return arrayList.toArray(new LogDetail[0]);
            }
            return null;
        }

        public Throwable getThrown(LogRecord logRecord) {
            return logRecord.getThrown();
        }

        public void pusblished(LogRecord logRecord) {
        }
    }

    public static class LogDetail {
        private Object a;

        public LogDetail(Object object) {
            this.a = object;
        }

        public String toString() {
            return this.a.toString();
        }

        public boolean isClickable() {
            return false;
        }

        public void click() {
        }
    }

    private class LogEntry {
        private LogRecord a;
        private String b;

        public LogEntry(LogRecord logRecord, String string) {
            this.a = logRecord;
            this.b = string;
        }

        public LogRecord getRecord() {
            return this.a;
        }

        public Icon getIcon() {
            return j;
        }

        public String getLabel() {
            return this.b;
        }
    }
}

