/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.sdm.renderer;

import ilog.views.IlvApplyObject;
import ilog.views.IlvGrapher;
import ilog.views.IlvGraphic;
import ilog.views.IlvLinkConnector;
import ilog.views.IlvLinkImage;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.IlvTransformer;
import ilog.views.io.IlvInputStream;
import ilog.views.io.IlvOutputStream;
import ilog.views.io.IlvReadFileException;
import ilog.views.linkconnector.IlvGrapherPin;
import ilog.views.linkconnector.IlvPinLinkConnector;
import ilog.views.sdm.IlvSDMEngine;
import ilog.views.sdm.renderer.IlvCachedLinkConnectionRectIndex;
import ilog.views.sdm.renderer.IlvFilterSDMRenderer;
import ilog.views.sdm.renderer.IlvRendererUtil;
import java.io.IOException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;

public class IlvGrapherPinRenderer
extends IlvFilterSDMRenderer {
    private static final String a = "_GrapherPinLinkObject";
    private static final String b = "_GrapherPinConnectorProperty";
    private static final String c = "_GrapherPinConnectedFrom";
    private static final String d = "_GrapherPinConnectedTo";

    @Override
    public void nodeGraphicAdded(IlvSDMEngine ilvSDMEngine, Object object, IlvGraphic ilvGraphic, boolean bl) {
        IlvPoint ilvPoint;
        super.nodeGraphicAdded(ilvSDMEngine, object, ilvGraphic, bl);
        SDMPinLinkConnector sDMPinLinkConnector = null;
        int n = 0;
        while ((ilvPoint = this.a(ilvSDMEngine, object, n)) != null) {
            if (sDMPinLinkConnector == null) {
                sDMPinLinkConnector = new SDMPinLinkConnector(ilvSDMEngine, ilvGraphic);
                ilvGraphic.setProperty(b, (Object)sDMPinLinkConnector);
            }
            new SDMGrapherPin(sDMPinLinkConnector, ilvSDMEngine, ilvPoint.x, ilvPoint.y);
            ++n;
        }
    }

    @Override
    public void linkGraphicAdded(IlvSDMEngine ilvSDMEngine, Object object, IlvGraphic ilvGraphic, boolean bl) {
        super.linkGraphicAdded(ilvSDMEngine, object, ilvGraphic, bl);
        IlvLinkImage ilvLinkImage = (IlvLinkImage)ilvGraphic;
        this.a(ilvSDMEngine, object, ilvLinkImage, true, bl);
        this.a(ilvSDMEngine, object, ilvLinkImage, false, bl);
        ilvLinkImage.setProperty(a, object);
    }

    private void a(IlvSDMEngine ilvSDMEngine, Object object, IlvLinkImage ilvLinkImage, final boolean bl, boolean bl2) {
        int n = IlvRendererUtil.getGraphicPropertyAsInt(ilvSDMEngine, object, bl ? "FromPin" : "ToPin", null, -1);
        if (n >= 0) {
            IlvGraphic ilvGraphic = bl ? ilvLinkImage.getFrom() : ilvLinkImage.getTo();
            IlvPoint ilvPoint = this.a(ilvSDMEngine, ilvSDMEngine.getObject(ilvGraphic), n);
            final SDMPinLinkConnector sDMPinLinkConnector = new SDMPinLinkConnector(ilvSDMEngine, ilvLinkImage, bl);
            SDMGrapherPin sDMGrapherPin = null;
            if (ilvPoint != null) {
                sDMGrapherPin = new SDMGrapherPin(sDMPinLinkConnector, ilvSDMEngine, ilvPoint.x, ilvPoint.y);
            }
            if (sDMGrapherPin != null) {
                if (ilvLinkImage.getGraphicBag() != null) {
                    ilvLinkImage.getGraphicBag().applyToObject((IlvGraphic)ilvLinkImage, new IlvApplyObject(){

                        public void apply(IlvGraphic ilvGraphic, Object object) {
                            sDMPinLinkConnector.connectLink((IlvLinkImage)ilvGraphic, (IlvGrapherPin)object, bl);
                        }
                    }, (Object)sDMGrapherPin, bl2);
                } else {
                    sDMPinLinkConnector.connectLink(ilvLinkImage, sDMGrapherPin, bl);
                }
                ilvLinkImage.setProperty(bl ? c : d, (Object)sDMGrapherPin);
            }
        }
    }

    @Override
    public void propertiesChanged(IlvSDMEngine ilvSDMEngine, Object object, Collection<String> collection, IlvGraphic ilvGraphic) {
        block5: {
            block9: {
                block8: {
                    block7: {
                        block6: {
                            block4: {
                                super.propertiesChanged(ilvSDMEngine, object, collection, ilvGraphic);
                                if (collection == null) break block4;
                                if (collection.contains("FromPin")) break block4;
                                if (!collection.contains("ToPin")) break block5;
                            }
                            if (!ilvSDMEngine.getModel().isLink(object) || !(ilvGraphic instanceof IlvLinkImage)) break block5;
                            if (collection == null) break block6;
                            if (!collection.contains("FromPin")) break block7;
                        }
                        this.a(ilvSDMEngine, object, (IlvLinkImage)ilvGraphic, true, true);
                    }
                    if (collection == null) break block8;
                    if (!collection.contains("ToPin")) break block9;
                }
                this.a(ilvSDMEngine, object, (IlvLinkImage)ilvGraphic, false, true);
            }
            ilvSDMEngine.performLinkLayout();
        }
    }

    @Override
    public void renderingDone(IlvSDMEngine ilvSDMEngine) {
        ilvSDMEngine.getGrapher().map(new IlvApplyObject(){

            public void apply(IlvGraphic ilvGraphic, Object object) {
                IlvLinkConnector ilvLinkConnector = (IlvLinkConnector)ilvGraphic.getProperty(IlvGrapherPinRenderer.b);
                if (ilvLinkConnector != null) {
                    ilvLinkConnector.attach(ilvGraphic, false);
                }
            }
        }, null, true);
        super.renderingDone(ilvSDMEngine);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private IlvPoint a(IlvSDMEngine ilvSDMEngine, Object object, int n) {
        float f;
        float f2;
        String string = IlvRendererUtil.getGraphicPropertyAsString(ilvSDMEngine, object, "GrapherPin[" + n + "]", null, null);
        if (string == null || string.length() == 0) {
            return null;
        }
        char c = string.charAt(0);
        if (Character.isLetter(c) && Character.isUpperCase(c)) {
            if (string.equalsIgnoreCase("Top")) {
                f2 = 0.0f;
                f = -1.0f;
                return new IlvPoint(f2, f);
            }
            if (string.equalsIgnoreCase("Bottom")) {
                f2 = 0.0f;
                f = 1.0f;
                return new IlvPoint(f2, f);
            }
            if (string.equalsIgnoreCase("Left")) {
                f2 = -1.0f;
                f = 0.0f;
                return new IlvPoint(f2, f);
            }
            if (string.equalsIgnoreCase("Right")) {
                f2 = 1.0f;
                f = 0.0f;
                return new IlvPoint(f2, f);
            }
            if (string.equalsIgnoreCase("TopLeft")) {
                f2 = -1.0f;
                f = -1.0f;
                return new IlvPoint(f2, f);
            }
            if (string.equalsIgnoreCase("TopRight")) {
                f2 = 1.0f;
                f = -1.0f;
                return new IlvPoint(f2, f);
            }
            if (string.equalsIgnoreCase("BottomLeft")) {
                f2 = -1.0f;
                f = 1.0f;
                return new IlvPoint(f2, f);
            }
            if (string.equalsIgnoreCase("BottomRight")) {
                f2 = 1.0f;
                f = 1.0f;
                return new IlvPoint(f2, f);
            }
            if (string.equalsIgnoreCase("Center")) {
                f2 = 0.0f;
                f = 0.0f;
                return new IlvPoint(f2, f);
            }
            Logger.getLogger("ilog.views.sdm", "ilog.views.sdm.messages").log(Level.WARNING, "GrapherPinRenderer.InvalidPinPosition", string);
            return null;
        }
        int n2 = string.indexOf(44);
        if (n2 <= 0) {
            Logger.getLogger("ilog.views.sdm", "ilog.views.sdm.messages").log(Level.WARNING, "GrapherPinRenderer.InvalidPinPosition", string);
            return null;
        }
        try {
            f2 = Float.parseFloat(string.substring(0, n2));
            f = Float.parseFloat(string.substring(n2 + 1));
            return new IlvPoint(f2, f);
        }
        catch (NumberFormatException numberFormatException) {
            Logger.getLogger("ilog.views.sdm", "ilog.views.sdm.messages").log(Level.WARNING, "GrapherPinRenderer.InvalidPinPosition", string);
            return null;
        }
    }

    public static class SDMGrapherPin
    extends IlvGrapherPin {
        private IlvSDMEngine a;
        private float b;
        private float c;

        public SDMGrapherPin(IlvPinLinkConnector ilvPinLinkConnector, IlvSDMEngine ilvSDMEngine, float f, float f2) {
            super(ilvPinLinkConnector);
            this.a = ilvSDMEngine;
            this.b = f;
            this.c = f2;
        }

        public SDMGrapherPin(IlvInputStream ilvInputStream) throws IlvReadFileException, IOException {
            super(ilvInputStream);
            this.a = IlvSDMEngine.getSDMEngine((IlvGrapher)ilvInputStream.getGraphicBag());
            this.b = ilvInputStream.readFloat("xOffset");
            this.c = ilvInputStream.readFloat("yOffset");
        }

        public void write(IlvOutputStream ilvOutputStream) throws IOException {
            super.write(ilvOutputStream);
            ilvOutputStream.write("xOffset", this.b);
            ilvOutputStream.write("yOffset", this.c);
        }

        public IlvPoint getPosition(IlvTransformer ilvTransformer) {
            IlvRect ilvRect = this.a != null ? this.a.getRenderer().getLinkConnectionRectangle(this.a, this.getNode(), ilvTransformer, (IlvLinkConnector)this.getPinLinkConnector()) : this.getNode().boundingBox(ilvTransformer);
            return new IlvPoint(ilvRect.x + ilvRect.width * ((this.b + 1.0f) * 0.5f), ilvRect.y + ilvRect.height * ((this.c + 1.0f) * 0.5f));
        }
    }

    public static class SDMPinLinkConnector
    extends IlvPinLinkConnector
    implements IlvCachedLinkConnectionRectIndex {
        IlvSDMEngine a;
        private int b;

        public SDMPinLinkConnector(IlvSDMEngine ilvSDMEngine, IlvGraphic ilvGraphic) {
            super(ilvGraphic);
            this.a = ilvSDMEngine;
        }

        public SDMPinLinkConnector(IlvSDMEngine ilvSDMEngine, IlvLinkImage ilvLinkImage, boolean bl) {
            super(ilvLinkImage, bl);
            this.a = ilvSDMEngine;
        }

        public SDMPinLinkConnector(IlvInputStream ilvInputStream) throws IlvReadFileException, IOException {
            super(ilvInputStream);
            this.a = IlvSDMEngine.getSDMEngine((IlvGrapher)ilvInputStream.getGraphicBag());
        }

        protected boolean useCache() {
            return true;
        }

        private boolean a() {
            return this.a.isLayoutRunning();
        }

        public void connectLink(IlvLinkImage ilvLinkImage, IlvPoint ilvPoint, boolean bl, IlvTransformer ilvTransformer) {
            if (this.a != null && this.a()) {
                return;
            }
            super.connectLink(ilvLinkImage, ilvPoint, bl, ilvTransformer);
            if (this.a != null) {
                IlvGrapherPin ilvGrapherPin = this.getPin(ilvLinkImage, bl);
                Object object = this.a.getObject((IlvGraphic)ilvLinkImage);
                if (object == null) {
                    object = ilvLinkImage.getProperty(IlvGrapherPinRenderer.a);
                }
                if (object != null) {
                    if (ilvGrapherPin != null) {
                        Enumeration enumeration = this.getPins();
                        int n = -1;
                        while (enumeration.hasMoreElements()) {
                            ++n;
                            if (enumeration.nextElement() != ilvGrapherPin) continue;
                        }
                        if (n < 0) {
                            Logger.getLogger("ilog.views.sdm", "ilog.views.sdm.messages").log(Level.WARNING, "GrapherPinRenderer.PinNotFound", ilvGrapherPin);
                        } else {
                            this.a.getRenderer().updateObjectProperties(this.a, object, bl ? "FromPin" : "ToPin", new Integer(n), null);
                        }
                    } else {
                        this.a.getRenderer().updateObjectProperties(this.a, object, bl ? "FromPin" : "ToPin", null, null);
                    }
                }
            }
        }

        @Override
        public void setCachedLinkConnectionRectIndex(int n) {
            this.b = n;
        }

        @Override
        public int getCachedLinkConnectionRectIndex() {
            return this.b;
        }
    }
}

