/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.symbol.compiler;

import ilog.views.symbol.compiler.IlvSymbolCompilerApplication;
import ilog.views.symbol.compiler.IlvSymbolCompilerException;
import ilog.views.symbol.compiler.ScParameter;
import ilog.views.symbol.compiler.ScRule;
import ilog.views.symbol.compiler.ScSymbol;
import ilog.views.symbol.compiler.util.TextViewer;
import ilog.views.symbology.palettes.IlvPaletteSymbol;
import ilog.views.symbology.palettes.IlvPaletteSymbolParameter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Toolkit;
import java.io.StringWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.event.EventListenerList;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.BadLocationException;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

class SymbolJavaView
extends JPanel {
    private IlvSymbolCompilerApplication a;
    private IlvPaletteSymbol b;
    private ScSymbol c;
    private TextViewer d;
    private JSplitPane e;
    private JTree f;
    private SymbolTreeModel g;
    private String h;
    private Icon i;
    private Icon j;
    private Icon k;
    private Icon l;
    private Icon m;
    private Icon n;
    private Icon o;
    private Icon p;
    private Icon q;
    private Icon r;
    private Enumeration<Object> s = new Enumeration<Object>(){

        @Override
        public boolean hasMoreElements() {
            return false;
        }

        @Override
        public Object nextElement() {
            throw new IllegalArgumentException();
        }
    };

    SymbolJavaView(IlvSymbolCompilerApplication ilvSymbolCompilerApplication) {
        this.a = ilvSymbolCompilerApplication;
        ilvSymbolCompilerApplication.a(this);
        this.d();
        this.e();
    }

    private void d() {
        this.i = this.a("images/symbol.gif");
        this.j = this.a("images/text.gif");
        this.k = this.a("images/parameters.gif");
        this.l = this.a("images/parameter.gif");
        this.m = this.a("images/conditions.gif");
        this.n = this.a("images/condition.gif");
        this.o = this.a("images/imagelist.gif");
        this.p = this.a("images/image.gif");
        this.q = this.a("images/miscs.gif");
        this.r = this.a("images/misc.gif");
    }

    private Icon a(String string) {
        URL uRL = SymbolJavaView.class.getResource(string);
        if (uRL == null) {
            return null;
        }
        return new ImageIcon(Toolkit.getDefaultToolkit().getImage(uRL));
    }

    private void e() {
        this.setLayout(new BorderLayout());
        this.e = new JSplitPane(1);
        this.e.setResizeWeight(0.27);
        this.add("Center", this.e);
        this.f = new JTree((TreeModel)null);
        this.f.getSelectionModel().setSelectionMode(1);
        this.f.addTreeSelectionListener(new TreeSelectionL());
        this.f.setCellRenderer(new SymbolTreeCellRenderer());
        JScrollPane jScrollPane = new JScrollPane(this.f);
        this.d = new TextViewer();
        this.e.setLeftComponent(jScrollPane);
        this.e.setRightComponent(this.d);
    }

    void a(IlvPaletteSymbol ilvPaletteSymbol) {
        if (ilvPaletteSymbol == null) {
            this.a();
            return;
        }
        this.b = ilvPaletteSymbol;
        try {
            this.c = new ScSymbol(this.a.a(), ilvPaletteSymbol);
        }
        catch (IlvSymbolCompilerException ilvSymbolCompilerException) {
            // empty catch block
        }
        this.h = this.c();
        if (this.h == null) {
            this.a.a(this.a.a("Compiler.AddingSymbol"), this.a.a("Compiler.CoulNotTranslateToJava"));
            return;
        }
        this.d.setText(this.h);
        this.g = new SymbolTreeModel();
        this.f.setModel(this.g);
    }

    void a() {
        this.f.setModel(null);
        this.d.setText("");
    }

    IlvPaletteSymbol b() {
        return this.b;
    }

    String c() {
        if (this.c == null) {
            return null;
        }
        try {
            StringWriter stringWriter = new StringWriter();
            this.c.writeClass(stringWriter);
            stringWriter.flush();
            return stringWriter.toString();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public JComponent getComponent() {
        return this;
    }

    public String getTitle() {
        return this.b.getID();
    }

    public String getDescription() {
        return this.b.getID() + " - " + this.b.getPalette().getPackageName();
    }

    private String b(String string) {
        return this.a.a(string);
    }

    static class SymbolTreeCellRenderer
    extends DefaultTreeCellRenderer {
        SymbolTreeCellRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            Icon icon;
            JLabel jLabel = (JLabel)super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            if (object instanceof SymbolTreeNode && (icon = ((SymbolTreeNode)object).getIcon()) != null) {
                jLabel.setIcon(icon);
            }
            return jLabel;
        }
    }

    class TreeSelectionL
    implements TreeSelectionListener {
        TreeSelectionL() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            Object object = treeSelectionEvent.getPath().getLastPathComponent();
            if (object instanceof TextPosition) {
                JTextArea jTextArea = SymbolJavaView.this.d.getTextComponent();
                int n = ((TextPosition)object).getTextPosition();
                if (n != -1) {
                    try {
                        int n2 = jTextArea.getLineOfOffset(n);
                        jTextArea.requestFocus();
                        SymbolJavaView.this.d.selectLine(n2);
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    private class SymbolTreeModel
    implements TreeModel {
        private RootTreeNode a;
        private EventListenerList b;
        TreeNode c = new HeaderNode();
        TreeNode d = new ConstructorNode();
        TreeNode e = new ParametersNode();
        TreeNode f = new StatesNode();
        TreeNode g = new SubObjectsNode();
        TreeNode h = new MiscsNode();
        private TreeNode[] i = new TreeNode[]{this.c, this.d, this.e, this.f, this.g, this.h};

        SymbolTreeModel() {
            this.b = new EventListenerList();
            this.a = new RootTreeNode();
        }

        @Override
        public void addTreeModelListener(TreeModelListener treeModelListener) {
            this.b.add(TreeModelListener.class, treeModelListener);
        }

        @Override
        public Object getChild(Object object, int n) {
            return ((TreeNode)object).getChildAt(n);
        }

        @Override
        public int getChildCount(Object object) {
            return ((TreeNode)object).getChildCount();
        }

        @Override
        public int getIndexOfChild(Object object, Object object2) {
            if (object == null || object2 == null) {
                return -1;
            }
            return ((TreeNode)object).getIndex((TreeNode)object2);
        }

        @Override
        public Object getRoot() {
            return this.a;
        }

        @Override
        public boolean isLeaf(Object object) {
            return ((TreeNode)object).isLeaf();
        }

        @Override
        public void removeTreeModelListener(TreeModelListener treeModelListener) {
            this.b.remove(TreeModelListener.class, treeModelListener);
        }

        @Override
        public void valueForPathChanged(TreePath treePath, Object object) {
        }

        private class MiscsNode
        extends CategoryNode {
            MiscsNode() {
                this.children.add(new MiscNode("public void refresh()", "refresh"));
                this.children.add(new MiscNode("public void doRefresh()", "doRefresh"));
                ArrayList<ScRule> arrayList = SymbolJavaView.this.c.j();
                for (ScRule scRule : arrayList) {
                    if (!scRule.k()) continue;
                    this.children.add(new MiscNode("public void selectionStateChanged()", "selection"));
                }
            }

            public String toString() {
                return SymbolJavaView.this.b("SymbolTree.Misc");
            }

            @Override
            public Icon getIcon() {
                return SymbolJavaView.this.q;
            }
        }

        private class MiscNode
        extends SimpleNode {
            MiscNode(String string, String string2) {
                this.offset = SymbolJavaView.this.h.indexOf(string);
                this.label = string2;
            }

            @Override
            public TreeNode getParent() {
                return SymbolTreeModel.this.h;
            }

            @Override
            public Icon getIcon() {
                return SymbolJavaView.this.r;
            }
        }

        private class SubObjectsNode
        extends CategoryNode {
            SubObjectsNode() {
                ArrayList<ScRule> arrayList = SymbolJavaView.this.c.j();
                for (ScRule scRule : arrayList) {
                    try {
                        if (scRule.f() != 200) continue;
                        this.children.add(new SubObjectNode(scRule));
                    }
                    catch (IlvSymbolCompilerException ilvSymbolCompilerException) {}
                }
            }

            public String toString() {
                return SymbolJavaView.this.b("SymbolTree.SubObjects");
            }

            @Override
            public Icon getIcon() {
                return SymbolJavaView.this.o;
            }
        }

        private class SubObjectNode
        extends SimpleNode {
            SubObjectNode(ScRule scRule) {
                String string = scRule.m();
                this.offset = SymbolJavaView.this.h.indexOf(string);
                this.label = scRule.i();
            }

            @Override
            public TreeNode getParent() {
                return SymbolTreeModel.this.g;
            }

            @Override
            public Icon getIcon() {
                return SymbolJavaView.this.p;
            }
        }

        private class StatesNode
        extends CategoryNode {
            StatesNode() {
                ArrayList<ScRule> arrayList = SymbolJavaView.this.c.j();
                for (ScRule scRule : arrayList) {
                    try {
                        if (scRule.f() != 300) continue;
                        this.children.add(new StateNode(scRule));
                    }
                    catch (IlvSymbolCompilerException ilvSymbolCompilerException) {}
                }
            }

            public String toString() {
                return SymbolJavaView.this.b("SymbolTree.States");
            }

            @Override
            public Icon getIcon() {
                return SymbolJavaView.this.m;
            }
        }

        private class StateNode
        extends SimpleNode {
            static final String a = "setState_";

            StateNode(ScRule scRule) {
                try {
                    String string = scRule.n();
                    this.offset = SymbolJavaView.this.h.indexOf("public void " + string + "()");
                    this.label = string.startsWith(a) ? string.substring(a.length()) : string;
                }
                catch (IlvSymbolCompilerException ilvSymbolCompilerException) {
                    this.label = scRule.b().getSelectorStringForDebug();
                }
            }

            @Override
            public TreeNode getParent() {
                return SymbolTreeModel.this.f;
            }

            @Override
            public Icon getIcon() {
                return SymbolJavaView.this.n;
            }
        }

        private abstract class SimpleNode
        extends Node {
            protected String label;
            protected int offset;

            SimpleNode() {
                this("<not initialized>", -1);
            }

            SimpleNode(String string, int n) {
                this.label = string;
                this.offset = n;
            }

            public String toString() {
                return this.label;
            }

            @Override
            public int getTextPosition() {
                return this.offset;
            }
        }

        private class ParametersNode
        extends CategoryNode {
            ParametersNode() {
                int n = SymbolJavaView.this.b.getParameterCount();
                for (int i = 0; i < n; ++i) {
                    IlvPaletteSymbolParameter ilvPaletteSymbolParameter = SymbolJavaView.this.b.getParameter(i);
                    ScParameter scParameter = SymbolJavaView.this.c.a(ilvPaletteSymbolParameter.getID());
                    if (scParameter == null) continue;
                    this.children.add(new ParameterGetterNode(scParameter));
                    this.children.add(new ParameterSetterNode(scParameter));
                }
                this.children.trimToSize();
            }

            public String toString() {
                return SymbolJavaView.this.b("SymbolTree.Parameters");
            }

            @Override
            public Icon getIcon() {
                return SymbolJavaView.this.k;
            }
        }

        private class ParameterSetterNode
        extends ParameterNode {
            ParameterSetterNode(ScParameter scParameter) {
                super(scParameter);
            }

            @Override
            public int getTextPosition() {
                try {
                    return SymbolJavaView.this.h.indexOf("public void " + this.scp.g() + "(");
                }
                catch (IlvSymbolCompilerException ilvSymbolCompilerException) {
                    return -1;
                }
            }

            public String toString() {
                return this.scp.b().getID() + " setter";
            }
        }

        private class ParameterGetterNode
        extends ParameterNode {
            ParameterGetterNode(ScParameter scParameter) {
                super(scParameter);
            }

            @Override
            public int getTextPosition() {
                try {
                    return SymbolJavaView.this.h.indexOf("public " + SymbolJavaView.this.c.getShortClassName(this.scp.c()) + " " + this.scp.f() + "()");
                }
                catch (IlvSymbolCompilerException ilvSymbolCompilerException) {
                    return -1;
                }
            }

            public String toString() {
                return this.scp.b().getID() + " getter";
            }
        }

        private abstract class ParameterNode
        extends Node {
            protected ScParameter scp;

            ParameterNode(ScParameter scParameter) {
                this.scp = scParameter;
            }

            @Override
            public TreeNode getParent() {
                return SymbolTreeModel.this.e;
            }

            @Override
            public Icon getIcon() {
                return SymbolJavaView.this.l;
            }
        }

        abstract class CategoryNode
        implements SymbolTreeNode {
            protected Vector<TreeNode> children = new Vector(10);

            protected CategoryNode() {
            }

            @Override
            public boolean isLeaf() {
                return false;
            }

            @Override
            public boolean getAllowsChildren() {
                return true;
            }

            public Enumeration<?> children() {
                return this.children.elements();
            }

            @Override
            public TreeNode getChildAt(int n) {
                return this.children.get(n);
            }

            @Override
            public int getChildCount() {
                return this.children.size();
            }

            @Override
            public int getIndex(TreeNode treeNode) {
                return this.children.indexOf(treeNode);
            }

            @Override
            public TreeNode getParent() {
                return SymbolTreeModel.this.a;
            }
        }

        abstract class Node
        implements SymbolTreeNode,
        TextPosition {
            Node() {
            }

            public Enumeration<Object> children() {
                return SymbolJavaView.this.s;
            }

            @Override
            public boolean getAllowsChildren() {
                return false;
            }

            @Override
            public TreeNode getChildAt(int n) {
                return null;
            }

            @Override
            public int getChildCount() {
                return 0;
            }

            @Override
            public int getIndex(TreeNode treeNode) {
                return -1;
            }

            @Override
            public boolean isLeaf() {
                return true;
            }
        }

        class ConstructorNode
        extends SingleLevelNode
        implements TextPosition {
            ConstructorNode() {
            }

            public String toString() {
                return SymbolJavaView.this.b("SymbolTree.Constructor");
            }

            @Override
            public int getTextPosition() {
                return SymbolJavaView.this.h.indexOf("public " + SymbolJavaView.this.b.getID() + "()");
            }

            @Override
            public Icon getIcon() {
                return SymbolJavaView.this.i;
            }
        }

        class HeaderNode
        extends SingleLevelNode
        implements TextPosition {
            HeaderNode() {
            }

            public String toString() {
                return SymbolJavaView.this.b("SymbolTree.Header");
            }

            @Override
            public int getTextPosition() {
                return 0;
            }

            @Override
            public Icon getIcon() {
                return SymbolJavaView.this.j;
            }
        }

        abstract class SingleLevelNode
        implements SymbolTreeNode {
            SingleLevelNode() {
            }

            public Enumeration<Object> children() {
                return SymbolJavaView.this.s;
            }

            @Override
            public boolean getAllowsChildren() {
                return false;
            }

            @Override
            public TreeNode getChildAt(int n) {
                return null;
            }

            @Override
            public int getChildCount() {
                return 0;
            }

            @Override
            public int getIndex(TreeNode treeNode) {
                return -1;
            }

            @Override
            public TreeNode getParent() {
                return SymbolTreeModel.this.a;
            }

            @Override
            public boolean isLeaf() {
                return true;
            }
        }

        private class RootTreeNode
        implements SymbolTreeNode,
        TextPosition {
            private RootTreeNode() {
            }

            public String toString() {
                return SymbolJavaView.this.b != null ? SymbolJavaView.this.b.getID() : "";
            }

            public Enumeration<TreeNode> children() {
                return new ArrayEnumeration(SymbolTreeModel.this.i);
            }

            @Override
            public boolean getAllowsChildren() {
                return true;
            }

            @Override
            public TreeNode getChildAt(int n) {
                return SymbolTreeModel.this.i[n];
            }

            @Override
            public int getChildCount() {
                return SymbolTreeModel.this.i.length;
            }

            @Override
            public int getIndex(TreeNode treeNode) {
                for (int i = 0; i < SymbolTreeModel.this.i.length; ++i) {
                    if (SymbolTreeModel.this.i[i] != treeNode) continue;
                    return i;
                }
                return -1;
            }

            @Override
            public TreeNode getParent() {
                return null;
            }

            @Override
            public boolean isLeaf() {
                return false;
            }

            @Override
            public int getTextPosition() {
                return SymbolJavaView.this.h.indexOf("public class " + SymbolJavaView.this.b.getID());
            }

            @Override
            public Icon getIcon() {
                return null;
            }
        }
    }

    static interface TextPosition {
        public int getTextPosition();
    }

    private class ArrayEnumeration
    implements Enumeration<TreeNode> {
        private int a;
        private TreeNode[] b;

        ArrayEnumeration(TreeNode[] treeNodeArray) {
            this.b = treeNodeArray;
            this.a = 0;
        }

        @Override
        public boolean hasMoreElements() {
            return this.a < this.b.length;
        }

        @Override
        public TreeNode nextElement() {
            return this.b[this.a++];
        }
    }

    static interface SymbolTreeNode
    extends TreeNode {
        public Icon getIcon();
    }
}

