/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.inspector;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import oracle.ide.adapters.AdapterManager;
import oracle.ide.inspector.Orientation;
import oracle.javatools.ui.Borders;

class FocusPainter
implements FocusListener {
    private static final Map<Orientation, FocusPainter> PAINTERS_BY_ORIENTATION = new HashMap<Orientation, FocusPainter>();
    static final Color FOCUS_BORDER = new Color(102, 153, 255);
    private final Orientation orientation;

    private FocusPainter(Orientation orientation) {
        this.orientation = orientation;
    }

    @Override
    public void focusGained(FocusEvent e) {
        Component comp = e.getComponent();
        if (!(comp instanceof JComponent)) {
            return;
        }
        JComponent c = (JComponent)comp;
        if (c.getClientProperty("hasIssues") == null) {
            Color color = (Color)AdapterManager.Factory.getAdapterManager().adapt((Object)this.orientation, Color.class);
            Borders.attachBorder((JComponent)c, (Color)FOCUS_BORDER, (Color)color);
        }
    }

    @Override
    public void focusLost(FocusEvent e) {
        Component comp = e.getComponent();
        if (!(comp instanceof JComponent)) {
            return;
        }
        JComponent c = (JComponent)comp;
        if (c.getClientProperty("hasIssues") == null) {
            Borders.restoreBorder((JComponent)c);
        }
    }

    static FocusListener painterFor(Orientation orientation) {
        FocusPainter painter = PAINTERS_BY_ORIENTATION.get((Object)orientation);
        if (null == painter) {
            painter = new FocusPainter(orientation);
            PAINTERS_BY_ORIENTATION.put(orientation, painter);
        }
        return painter;
    }
}

