/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.jdi;

import oracle.ide.model.Node;
import oracle.javatools.util.Log;
import oracle.jdevimpl.debugger.jdi.DebugJDI;
import oracle.jdevimpl.debugger.jdi.DebugJDIBreakpointStreamBCOp;
import oracle.jdevimpl.debugger.jdi.StreamDebuggingManager;
import oracle.jdevimpl.debugger.plugin.StreamDebugger;
import oracle.jdevimpl.debugger.support.CodeExecutionBreakpoint;
import oracle.jdevimpl.debugger.support.DebugBreakpointTerminalStreamOperation;
import oracle.jdevimpl.debugger.support.DebugStackFrameInfo;
import oracle.jdevimpl.debugger.support.DebugThreadInfo;
import oracle.jdevimpl.runner.debug.streams.StreamOperationExpressionInfo;

public class DebugJDIBreakpointStreamTerminalBCOp
extends DebugJDIBreakpointStreamBCOp
implements DebugBreakpointTerminalStreamOperation,
CodeExecutionBreakpoint {
    private StreamOperationExpressionInfo info;
    private int firstLine = -1;
    private int lastLine = -1;
    private Log streamsLogger = StreamDebugger.getLogger();
    private boolean accumulateArguments = true;

    public DebugJDIBreakpointStreamTerminalBCOp(DebugJDI dj, String method, int bytecodeOffset) {
        super(dj, method, bytecodeOffset);
    }

    public void setExpressionInfo(StreamOperationExpressionInfo info) {
        this.info = info;
    }

    public void setFirstLine(int line) {
        this.firstLine = line;
    }

    public void setLastLine(int line) {
        this.lastLine = line;
    }

    public void executeAfterStop() {
        this.streamsLogger.trace("DebugJDIBreakpointStreamTerminalBCOp executeAfterStop() invoked");
        this.streamsLogger.trace("    operation is " + this.info.getText() + " range is " + this.firstLine + "-" + this.lastLine);
        DebugThreadInfo thread = this.dj.getCurrentThread();
        Node node = this.context.getNode();
        if (this.firstLine == -1 || this.lastLine == -1) {
            throw new IllegalArgumentException("Lines not configured");
        }
        DebugStackFrameInfo frame = this.dj.getCurrentThread().getStackFrame(0);
        if (frame != null) {
            StreamDebuggingManager.dumpResults(node, thread.getThreadId(), this.firstLine, this.lastLine);
            StreamDebuggingManager.getInstance().markExitedStream(thread);
        }
    }
}

