/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.jdi;

import com.sun.jdi.ArrayType;
import com.sun.jdi.BooleanType;
import com.sun.jdi.ByteType;
import com.sun.jdi.CharType;
import com.sun.jdi.ClassLoaderReference;
import com.sun.jdi.ClassObjectReference;
import com.sun.jdi.ClassType;
import com.sun.jdi.DoubleType;
import com.sun.jdi.Field;
import com.sun.jdi.FloatType;
import com.sun.jdi.IntegerType;
import com.sun.jdi.InterfaceType;
import com.sun.jdi.Location;
import com.sun.jdi.LongType;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.PrimitiveType;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.ShortType;
import com.sun.jdi.Type;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.Value;
import com.sun.jdi.VoidType;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import oracle.jdevimpl.debugger.jdi.DebugJDI;
import oracle.jdevimpl.debugger.jdi.DebugJDIAnnotationInfo;
import oracle.jdevimpl.debugger.jdi.DebugJDIClassLoaderInfo;
import oracle.jdevimpl.debugger.jdi.DebugJDIFieldInfo;
import oracle.jdevimpl.debugger.jdi.DebugJDIMethodInfo;
import oracle.jdevimpl.debugger.jdi.DebugJDIPlsqlTableElement;
import oracle.jdevimpl.debugger.shared.DebugShared;
import oracle.jdevimpl.debugger.support.DataExpiredException;
import oracle.jdevimpl.debugger.support.DebugAnnotationInfo;
import oracle.jdevimpl.debugger.support.DebugArrayElementInfo;
import oracle.jdevimpl.debugger.support.DebugClassInfo;
import oracle.jdevimpl.debugger.support.DebugClassLoaderInfo;
import oracle.jdevimpl.debugger.support.DebugDataArrayInfo;
import oracle.jdevimpl.debugger.support.DebugDataInfo;
import oracle.jdevimpl.debugger.support.DebugDataObjectInfo;
import oracle.jdevimpl.debugger.support.DebugFieldInfo;
import oracle.jdevimpl.debugger.support.DebugHasAnnotations;
import oracle.jdevimpl.debugger.support.DebugMethodInfo;
import oracle.jdevimpl.debugger.support.JDIInformationProvider;
import oracle.jdevimpl.debugger.support.XSLTDebugHelper;

public final class DebugJDIClassInfo
extends JDIInformationProvider
implements DebugClassInfo,
DebugHasAnnotations {
    private static final String SYNTHETIC_ENUM_MARKER1 = "$v";
    private static final String SYNTHETIC_ENUM_MARKER2 = "$VALUES";
    DebugJDI dj;
    Type type;
    private boolean classLoaderReferenceKnown;
    private ClassLoaderReference classLoaderReference;
    boolean rtCollected;
    String name;
    List methods;
    boolean debuggable;
    String justPackage;
    String nameWithoutPackage;
    int annotationCount = -1;
    private int hashCode;

    DebugJDIClassInfo(DebugJDI dj, Type type) {
        this.dj = dj;
        this.type = type;
        this.name = type.name();
        this.checkDebuggable();
    }

    DebugJDIClassInfo(String name) {
        this.name = name;
    }

    void checkDebuggable() {
        this.debuggable = this.type instanceof PrimitiveType || this.type instanceof VoidType ? true : this.dj != null && this.dj.isClassDebuggable(this.name);
    }

    ReferenceType getReferenceType() {
        if (this.type instanceof ReferenceType) {
            return (ReferenceType)this.type;
        }
        return null;
    }

    public boolean hasExpired() {
        return this.rtCollected;
    }

    private void throwIfExpired() {
        if (this.hasExpired()) {
            throw new DataExpiredException();
        }
    }

    public String getName() {
        return this.name;
    }

    public String getPackage() {
        if (this.justPackage == null) {
            this.justPackage = DebugShared.getPackage((String)this.name);
        }
        return this.justPackage;
    }

    public String getPackagePath() {
        return this.getPackage().replace('.', File.separatorChar);
    }

    public String getNameWithoutPackage() {
        if (this.nameWithoutPackage == null) {
            this.nameWithoutPackage = DebugShared.getNameWithoutPackage((String)this.name);
        }
        return this.nameWithoutPackage;
    }

    public String getGenericSignature() {
        if (this.type instanceof ReferenceType) {
            try {
                return ((ReferenceType)this.type).genericSignature();
            }
            catch (VMDisconnectedException e) {
                return null;
            }
        }
        return null;
    }

    public int getAccess() {
        this.throwIfExpired();
        if (this.type instanceof ReferenceType) {
            ReferenceType rt = (ReferenceType)this.type;
            try {
                return rt.modifiers();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return 0;
    }

    public boolean isInterface() {
        this.throwIfExpired();
        return this.type instanceof InterfaceType;
    }

    public boolean isPrimitive() {
        this.throwIfExpired();
        return this.type instanceof PrimitiveType || this.type instanceof VoidType;
    }

    public boolean isObject() {
        this.throwIfExpired();
        return this.type instanceof ClassType;
    }

    public boolean isNotYetLoadedType() {
        return this.type == null;
    }

    public boolean isArray() {
        this.throwIfExpired();
        return this.type instanceof ArrayType;
    }

    public int getSizeOfObject() {
        this.throwIfExpired();
        if (this.type instanceof PrimitiveType || this.type instanceof VoidType) {
            if (this.type instanceof BooleanType) {
                return 1;
            }
            if (this.type instanceof ByteType) {
                return 1;
            }
            if (this.type instanceof CharType) {
                return 2;
            }
            if (this.type instanceof DoubleType) {
                return 8;
            }
            if (this.type instanceof FloatType) {
                return 4;
            }
            if (this.type instanceof IntegerType) {
                return 4;
            }
            if (this.type instanceof LongType) {
                return 8;
            }
            if (this.type instanceof ShortType) {
                return 2;
            }
            if (this.type instanceof VoidType) {
                return 0;
            }
        } else if (this.type instanceof ReferenceType) {
            ReferenceType rt = (ReferenceType)this.type;
            try {
                List<Field> allFields = rt.allFields();
                int size = 0;
                block13: for (int i = 0; i < allFields.size(); ++i) {
                    Field field = allFields.get(i);
                    if (field.isStatic()) continue;
                    String sig = field.signature();
                    char c = sig.charAt(0);
                    switch (c) {
                        case 'B': {
                            ++size;
                            continue block13;
                        }
                        case 'C': {
                            size += 2;
                            continue block13;
                        }
                        case 'D': {
                            size += 8;
                            continue block13;
                        }
                        case 'F': {
                            size += 4;
                            continue block13;
                        }
                        case 'I': {
                            size += 4;
                            continue block13;
                        }
                        case 'J': {
                            size += 8;
                            continue block13;
                        }
                        case 'S': {
                            size += 2;
                            continue block13;
                        }
                        case 'Z': {
                            ++size;
                            continue block13;
                        }
                        case 'L': 
                        case '[': {
                            size += 4;
                        }
                    }
                }
                return size;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return 0;
    }

    public long countObjectsOfClass() {
        if (this.dj != null && this.dj.canCountObjectsOfClass() && this.type instanceof ReferenceType) {
            ArrayList<ReferenceType> classes = new ArrayList<ReferenceType>();
            classes.add((ReferenceType)this.type);
            long[] array = this.dj.vm.instanceCounts(classes);
            if (array != null && array.length == 1) {
                return array[0];
            }
        }
        return 0L;
    }

    public int countMemoryOfClass() {
        return 0;
    }

    public DebugDataObjectInfo getClassObject() {
        this.throwIfExpired();
        ClassObjectReference cor = this.getClassObjectReference();
        if (cor != null) {
            return (DebugDataObjectInfo)this.dj.makeData(cor, null);
        }
        return null;
    }

    public ClassObjectReference getClassObjectReference() {
        this.throwIfExpired();
        if (this.type instanceof PrimitiveType || this.type instanceof VoidType) {
            try {
                Value typeFieldValue;
                Field typeField;
                ReferenceType rt;
                DebugJDIClassInfo wrapperClassInfo = null;
                if (this.type instanceof BooleanType) {
                    wrapperClassInfo = this.dj.findClassByName("java.lang.Boolean", false);
                } else if (this.type instanceof ByteType) {
                    wrapperClassInfo = this.dj.findClassByName("java.lang.Byte", false);
                } else if (this.type instanceof CharType) {
                    wrapperClassInfo = this.dj.findClassByName("java.lang.Char", false);
                } else if (this.type instanceof DoubleType) {
                    wrapperClassInfo = this.dj.findClassByName("java.lang.Double", false);
                } else if (this.type instanceof FloatType) {
                    wrapperClassInfo = this.dj.findClassByName("java.lang.Float", false);
                } else if (this.type instanceof IntegerType) {
                    wrapperClassInfo = this.dj.findClassByName("java.lang.Integer", false);
                } else if (this.type instanceof LongType) {
                    wrapperClassInfo = this.dj.findClassByName("java.lang.Long", false);
                } else if (this.type instanceof ShortType) {
                    wrapperClassInfo = this.dj.findClassByName("java.lang.Short", false);
                } else if (this.type instanceof VoidType) {
                    wrapperClassInfo = this.dj.findClassByName("java.lang.Void", false);
                }
                if (wrapperClassInfo != null && (rt = wrapperClassInfo.getReferenceType()) != null && (typeField = rt.fieldByName("TYPE")) != null && typeField.isStatic() && (typeFieldValue = rt.getValue(typeField)) instanceof ClassObjectReference) {
                    return (ClassObjectReference)typeFieldValue;
                }
            }
            catch (Exception wrapperClassInfo) {}
        } else if (this.type instanceof ReferenceType) {
            ReferenceType rt = (ReferenceType)this.type;
            try {
                return rt.classObject();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    ClassLoaderReference getClassLoaderReference() {
        if (!this.classLoaderReferenceKnown) {
            try {
                if (this.type instanceof ReferenceType) {
                    ReferenceType rt = (ReferenceType)this.type;
                    this.classLoaderReference = this.dj.getClassLoader(rt);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.classLoaderReferenceKnown = true;
        }
        return this.classLoaderReference;
    }

    void setClassLoaderReference(ClassLoaderReference clr) {
        if (!this.classLoaderReferenceKnown) {
            this.classLoaderReference = clr;
            this.classLoaderReferenceKnown = true;
        }
    }

    public DebugDataObjectInfo getClassLoaderObject() {
        ClassLoaderReference clr;
        this.throwIfExpired();
        if (this.type instanceof ReferenceType && (clr = this.getClassLoaderReference()) != null) {
            return (DebugDataObjectInfo)this.dj.makeData(clr, null);
        }
        return null;
    }

    public DebugClassLoaderInfo getClassLoader() {
        this.throwIfExpired();
        if (this.type instanceof ReferenceType) {
            return DebugJDIClassLoaderInfo.makeClassLoaderInfo(this.dj, this.getClassLoaderReference());
        }
        return null;
    }

    public String getPrimarySourceFilename() {
        this.throwIfExpired();
        if (this.type instanceof ReferenceType && !(this.type instanceof ArrayType)) {
            ReferenceType rt = (ReferenceType)this.type;
            try {
                List<String> list = rt.sourceNames(rt.defaultStratum());
                if (list != null && list.size() > 0) {
                    return list.get(0);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.getSourceFilename();
    }

    public String getSourceFilename() {
        this.throwIfExpired();
        if (this.type instanceof ReferenceType && !(this.type instanceof ArrayType)) {
            ReferenceType rt = (ReferenceType)this.type;
            try {
                return rt.sourceName();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return "";
    }

    public DebugClassInfo getSuperClass(int level) {
        this.throwIfExpired();
        if (this.type instanceof ClassType) {
            ClassType ct = (ClassType)this.type;
            for (int i = 0; ct != null && i < level; ct = ct.superclass(), ++i) {
            }
            if (ct != null) {
                return this.dj.findClass(ct);
            }
        }
        return null;
    }

    void redefiningClass() {
        this.methods = null;
    }

    private void getRTMethods() {
        if (this.methods == null) {
            ReferenceType rt = (ReferenceType)this.type;
            try {
                this.methods = rt.methods();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public int getMethodCount() {
        this.throwIfExpired();
        if (this.type instanceof ReferenceType) {
            this.getRTMethods();
            if (this.methods != null) {
                return this.methods.size();
            }
        }
        return 0;
    }

    public DebugMethodInfo[] getMethods() {
        this.throwIfExpired();
        if (this.type instanceof ReferenceType) {
            this.getRTMethods();
            if (this.methods != null) {
                DebugMethodInfo[] a = new DebugMethodInfo[this.methods.size()];
                for (int i = 0; i < this.methods.size(); ++i) {
                    a[i] = new DebugJDIMethodInfo(this.dj, this, (Method)this.methods.get(i));
                }
                return a;
            }
        }
        return new DebugMethodInfo[0];
    }

    public int getStaticFieldCount() {
        return this.getStaticFieldCount(0, false);
    }

    public DebugFieldInfo[] getStaticFields() {
        return this.getStaticFields(0, false);
    }

    public DebugFieldInfo getStaticField(int index) {
        return this.getStaticField(0, false, index);
    }

    public int getStaticFieldCount(int classLevel) {
        return this.getStaticFieldCount(classLevel, false);
    }

    public DebugFieldInfo[] getStaticFields(int classLevel) {
        return this.getStaticFields(classLevel, false);
    }

    public DebugFieldInfo getStaticField(int classLevel, int index) {
        return this.getStaticField(classLevel, false, index);
    }

    public int getStaticFieldCount(int classLevel, boolean noFinal) {
        this.throwIfExpired();
        List fields = this.collectFields(classLevel, null, noFinal, Boolean.TRUE, false);
        return fields.size();
    }

    public DebugFieldInfo[] getStaticFields(int classLevel, boolean noFinal) {
        this.throwIfExpired();
        List fields = this.collectFields(classLevel, null, noFinal, Boolean.TRUE, false);
        int size = fields.size();
        DebugFieldInfo[] array = new DebugFieldInfo[size];
        for (int i = 0; i < size; ++i) {
            array[i] = new DebugJDIFieldInfo(this.dj, (Field)fields.get(i), this, null);
        }
        return array;
    }

    public DebugFieldInfo getStaticField(int classLevel, boolean noFinal, int index) {
        this.throwIfExpired();
        List fields = this.collectFields(classLevel, null, noFinal, Boolean.TRUE, false);
        int size = fields.size();
        if (index < size) {
            return new DebugJDIFieldInfo(this.dj, (Field)fields.get(index), this, null);
        }
        return null;
    }

    public DebugFieldInfo getStaticField(String fname) {
        block3: {
            try {
                ArrayList keys;
                String tableName;
                if (this.dj != null && this.getLanguage() == 2 && (tableName = DebugJDIPlsqlTableElement.parseTableElement(fname, keys = new ArrayList())) != null) {
                    return DebugJDIPlsqlTableElement.getTableElementField(this.getStaticFields(), tableName, keys, this.dj, fname, this, true);
                }
            }
            catch (Throwable e) {
                if (!(e instanceof ThreadDeath)) break block3;
                throw (ThreadDeath)e;
            }
        }
        return null;
    }

    public int getFieldCount(int classLevel) {
        return this.getFieldCount(classLevel, false, false);
    }

    public DebugFieldInfo[] getFields(int classLevel) {
        return this.getFields(classLevel, false, false);
    }

    public DebugFieldInfo getField(int classLevel, int index) {
        return this.getField(classLevel, false, false, index);
    }

    public int getFieldCount(int classLevel, boolean noFinal) {
        return this.getFieldCount(classLevel, noFinal, false);
    }

    public DebugFieldInfo[] getFields(int classLevel, boolean noFinal) {
        return this.getFields(classLevel, noFinal, false);
    }

    public DebugFieldInfo getField(int classLevel, boolean noFinal, int index) {
        return this.getField(classLevel, noFinal, false, index);
    }

    public int getFieldCount(int classLevel, boolean noFinal, boolean noStatic) {
        this.throwIfExpired();
        Boolean staticFields = noStatic ? Boolean.FALSE : null;
        List fields = this.collectFields(classLevel, null, noFinal, staticFields, false);
        return fields.size();
    }

    public DebugFieldInfo[] getFields(int classLevel, boolean noFinal, boolean noStatic) {
        this.throwIfExpired();
        Boolean staticFields = noStatic ? Boolean.FALSE : null;
        List fields = this.collectFields(classLevel, null, noFinal, staticFields, false);
        int size = fields.size();
        DebugFieldInfo[] array = new DebugFieldInfo[size];
        for (int i = 0; i < size; ++i) {
            array[i] = new DebugJDIFieldInfo(this.dj, (Field)fields.get(i), this, null);
        }
        return array;
    }

    public DebugFieldInfo getField(int classLevel, boolean noFinal, boolean noStatic, int index) {
        this.throwIfExpired();
        Boolean staticFields = noStatic ? Boolean.FALSE : null;
        List fields = this.collectFields(classLevel, null, noFinal, staticFields, false);
        int size = fields.size();
        if (index < size) {
            return new DebugJDIFieldInfo(this.dj, (Field)fields.get(index), this, null);
        }
        return null;
    }

    List collectFields(int classLevel, ObjectReference or, boolean skipFinal, Boolean staticFields, boolean skipNulls) {
        ArrayList list = new ArrayList();
        try {
            if (this.type instanceof ClassType) {
                ClassType ct = (ClassType)this.type;
                int level = 0;
                while (ct != null) {
                    if (classLevel < 0 || level == classLevel) {
                        DebugJDIClassInfo.addFields(list, ct.fields(), or, skipFinal, staticFields, skipNulls);
                        if (classLevel < 0) {
                            DebugJDIClassInfo.addInterfaceFields(list, ct, or, skipFinal, staticFields, skipNulls);
                        }
                    }
                    ct = ct.superclass();
                    ++level;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    private static void addFields(List list, List fields, ObjectReference or, boolean skipFinal, Boolean staticFields, boolean skipNulls) {
        int fieldsSize = fields.size();
        for (int f = 0; f < fieldsSize; ++f) {
            Field field = (Field)fields.get(f);
            if (DebugJDIClassInfo.skipField(field, or, skipFinal, staticFields, skipNulls)) continue;
            list.add(field);
        }
    }

    private static boolean skipField(Field field, ObjectReference or, boolean skipFinal, Boolean staticFields, boolean skipNulls) {
        if (skipFinal && field.isFinal()) {
            return true;
        }
        if (staticFields != null && staticFields.booleanValue() != field.isStatic()) {
            return true;
        }
        return skipNulls && or != null && or.getValue(field) == null;
    }

    private static void addInterfaceFields(List list, ReferenceType rt, ObjectReference or, boolean skipFinal, Boolean staticFields, boolean skipNulls) {
        List<InterfaceType> interfaces = null;
        if (rt instanceof ClassType) {
            interfaces = ((ClassType)rt).interfaces();
        } else if (rt instanceof InterfaceType) {
            interfaces = ((InterfaceType)rt).superinterfaces();
        }
        if (interfaces != null) {
            int interfacesSize = interfaces.size();
            for (int i = 0; i < interfacesSize; ++i) {
                InterfaceType it = interfaces.get(i);
                DebugJDIClassInfo.addFields(list, it.fields(), or, skipFinal, staticFields, skipNulls);
                DebugJDIClassInfo.addInterfaceFields(list, it, or, skipFinal, staticFields, skipNulls);
            }
        }
    }

    Field fieldByName(String fname) {
        try {
            if (this.type instanceof ClassType) {
                ClassType ct = (ClassType)this.type;
                return ct.fieldByName(fname);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public boolean isDebuggable() {
        return this.debuggable;
    }

    public void setDebuggable(boolean debuggable) {
        this.debuggable = debuggable;
    }

    public boolean isObfuscated() {
        this.throwIfExpired();
        if (this.type instanceof ClassType) {
            ClassType ct = (ClassType)this.type;
            try {
                if (this.getMethodCount() > 0) {
                    String sourceName = ct.sourceName();
                    if (sourceName == null || sourceName.length() == 0) {
                        return true;
                    }
                    List<Location> allLines = ct.allLineLocations();
                    if (allLines == null || allLines.size() == 0) {
                        return true;
                    }
                }
            }
            catch (Exception e) {
                return true;
            }
        }
        return false;
    }

    public boolean isCodeCoverage() {
        return false;
    }

    public void setCodeCoverage(boolean codeCoverage) {
    }

    public void discardCodeCoverage() {
    }

    public double getCodeCoverageRatio() {
        return 0.0;
    }

    private void addAllInterfaces(Set v, InterfaceType iface) {
        DebugJDIClassInfo ci = this.dj.findClass(iface);
        if (ci != null) {
            v.add(ci);
        }
        List<InterfaceType> superinterfaces = iface.superinterfaces();
        for (int i = 0; i < superinterfaces.size(); ++i) {
            InterfaceType it = superinterfaces.get(i);
            this.addAllInterfaces(v, it);
        }
    }

    public DebugClassInfo[] getInterfaces() {
        return this.getInterfaces(0);
    }

    public DebugClassInfo[] getInterfaces(int classLevel) {
        this.throwIfExpired();
        HashSet<DebugJDIClassInfo> v = new HashSet<DebugJDIClassInfo>();
        try {
            if (this.type instanceof ClassType) {
                int countClassLevel = 0;
                for (ClassType ct = (ClassType)this.type; ct != null; ct = ct.superclass()) {
                    if (classLevel == -1 || classLevel == countClassLevel) {
                        List<InterfaceType> ifaces = ct.interfaces();
                        for (int i = 0; i < ifaces.size(); ++i) {
                            InterfaceType iface = ifaces.get(i);
                            this.addAllInterfaces(v, iface);
                        }
                    }
                    ++countClassLevel;
                }
            } else if (this.type instanceof InterfaceType) {
                if (classLevel == -1) {
                    this.addAllInterfaces(v, (InterfaceType)this.type);
                } else if (classLevel == 0) {
                    List<InterfaceType> superinterfaces = ((InterfaceType)this.type).superinterfaces();
                    for (int i = 0; i < superinterfaces.size(); ++i) {
                        InterfaceType it = superinterfaces.get(i);
                        DebugJDIClassInfo ci = this.dj.findClass(it);
                        if (ci == null) continue;
                        v.add(ci);
                    }
                }
            }
        }
        catch (Exception superinterfaces) {
            // empty catch block
        }
        DebugClassInfo[] array = new DebugClassInfo[v.size()];
        return v.toArray(array);
    }

    public int getLanguage() {
        if (this.name.startsWith(XSLTDebugHelper.getXSLTPackage())) {
            return 4;
        }
        if (this.name.startsWith("$Oracle.")) {
            return 2;
        }
        return 1;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = this.type != null ? this.type.hashCode() : this.name.hashCode();
        }
        return this.hashCode;
    }

    public boolean equals(Object o) {
        if (o instanceof DebugJDIClassInfo) {
            DebugJDIClassInfo other = (DebugJDIClassInfo)((Object)o);
            return (this.type == null ? other.type == null : this.type.equals(other.type)) && this.name.equals(this.name);
        }
        return false;
    }

    public int countAnnotations() {
        this.throwIfExpired();
        if (this.dj == null || this.dj.isRIM()) {
            return 0;
        }
        if (this.annotationCount < 0) {
            this.getAnnotations();
        }
        return this.annotationCount < 0 ? 0 : this.annotationCount;
    }

    public DebugAnnotationInfo[] getAnnotations() {
        this.throwIfExpired();
        try {
            ClassObjectReference orClass;
            if (this.dj != null && this.dj.isSafeToGetAnnotations() && (orClass = this.getClassObjectReference()) != null) {
                DebugAnnotationInfo[] result = this.dj.getAnnotations(orClass);
                this.annotationCount = result.length;
                return result;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new DebugJDIAnnotationInfo[0];
    }

    public Type getJDIType() {
        return this.type;
    }

    public Value getJDIValue() {
        try {
            if (this.type instanceof ReferenceType) {
                return ((ReferenceType)this.type).classObject();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public boolean isEnum() {
        ClassType classType;
        return this.type != null && this.type instanceof ClassType && ((classType = (ClassType)this.type).isEnum() || DebugJDIClassInfo.isAnonymousEnum(classType));
    }

    public DebugFieldInfo[] getEnumConstants() {
        int i;
        if (!this.isEnum()) {
            return new DebugFieldInfo[0];
        }
        DebugFieldInfo[] fields = DebugJDIClassInfo.isAnonymousEnum((ClassType)this.type) ? this.getFields(1) : this.getFields(0);
        ArrayList<DebugFieldInfo> enumConstants = new ArrayList<DebugFieldInfo>();
        HashMap enumHashCode2ValuesMap = new HashMap();
        for (i = 0; i < fields.length; ++i) {
            String fieldName = fields[i].getName();
            if (!fieldName.equals(SYNTHETIC_ENUM_MARKER2) && !fieldName.equals(SYNTHETIC_ENUM_MARKER1)) continue;
            DebugClassInfo classInfo = fields[i].getClassInfo();
            if (!classInfo.isArray()) break;
            DebugDataArrayInfo ddi = (DebugDataArrayInfo)fields[i].getDataInfo();
            DebugArrayElementInfo[] elems = ddi.getArrayElements();
            for (int i1 = 0; i1 < elems.length; ++i1) {
                DebugDataInfo dataInfo = elems[i1].getDataInfo();
                enumHashCode2ValuesMap.put(new Integer(dataInfo.hashCode()), null);
            }
            break;
        }
        for (i = 0; i < fields.length; ++i) {
            DebugDataInfo ddi1 = fields[i].getDataInfo();
            if (ddi1 == null || !enumHashCode2ValuesMap.containsKey(new Integer(ddi1.hashCode()))) continue;
            enumConstants.add(0, fields[i]);
        }
        return enumConstants.toArray(new DebugFieldInfo[enumConstants.size()]);
    }

    private static boolean isAnonymousEnum(ClassType classType) {
        int index;
        String name;
        if (classType.isEnum()) {
            return false;
        }
        ClassType superClass = classType.superclass();
        if (superClass != null && superClass.isEnum() && (name = classType.name()) != null && (index = name.lastIndexOf(36)) > 0) {
            String number = name.substring(index + 1);
            try {
                Integer.getInteger(number);
            }
            catch (Exception ex) {
                return false;
            }
            return true;
        }
        return false;
    }

    public int getConstantPoolCount() {
        try {
            if (this.dj != null && this.dj.canGetConstantPool() && this.type instanceof ReferenceType) {
                return ((ReferenceType)this.type).constantPoolCount();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 0;
    }

    public byte[] getConstantPool() {
        try {
            if (this.dj != null && this.dj.canGetConstantPool() && this.type instanceof ReferenceType) {
                return ((ReferenceType)this.type).constantPool();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new byte[0];
    }
}

