/*
 * Decompiled with CFR 0.152.
 */
package oracle.jrf;

import java.io.File;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import oracle.jrf.JRFServerScopedServiceMBean;
import oracle.jrf.JrfUtils;
import oracle.jrf.PortabilityLayerException;
import oracle.jrf.ServerPlatformSupportFactory;
import oracle.jrf.i18n.JRFMessageBundleHelper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class JRFServerScopedService
implements JRFServerScopedServiceMBean {
    @Override
    public String getCommonComponentsHomeGUID() throws PortabilityLayerException {
        try {
            String guid = "";
            String mwhome = JrfUtils.getCommonComponentsHome();
            File oracleHomePropFile = new File(mwhome + "/inventory/ContentsXML/oraclehomeproperties.xml");
            if (oracleHomePropFile.exists()) {
                Element elem;
                NodeList childNodes;
                DocumentBuilder db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                Document doc = db.parse(oracleHomePropFile);
                NodeList elems = doc.getElementsByTagName("GUID");
                if (elems != null && elems.getLength() >= 1 && (childNodes = (elem = (Element)elems.item(0)).getChildNodes()) != null && childNodes.getLength() >= 1) {
                    guid = childNodes.item(0).getNodeValue();
                }
            } else {
                throw new PortabilityLayerException(JRFMessageBundleHelper.msg.getString("JRF-20010", new String[]{oracleHomePropFile.getAbsolutePath()}));
            }
            if (guid == null || guid.trim().equals("")) {
                throw new PortabilityLayerException(JRFMessageBundleHelper.msg.getString("JRF-20011", new String[]{oracleHomePropFile.getAbsolutePath()}));
            }
            return guid;
        }
        catch (Exception e) {
            throw new PortabilityLayerException(e);
        }
    }

    @Override
    public String getDomainConfigDirectory() throws PortabilityLayerException {
        return ServerPlatformSupportFactory.getInstance().getDomainConfigDirectory();
    }

    @Override
    public String getServerConfigDirectory() throws PortabilityLayerException {
        return ServerPlatformSupportFactory.getInstance().getServerConfigDirectory();
    }

    @Override
    public boolean isJRFEnabled() {
        return true;
    }

    @Override
    public boolean isRestricted() throws PortabilityLayerException {
        return ServerPlatformSupportFactory.getInstance().isRestricted();
    }
}

