/*
 * Decompiled with CFR 0.152.
 */
package oracle.jrf.wls;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jrf.JrfUtils;
import weblogic.application.ApplicationException;
import weblogic.application.ApplicationLifecycleEvent;
import weblogic.application.ApplicationLifecycleListener;
import weblogic.application.internal.ApplicationContextImpl;
import weblogic.utils.classloaders.FilteringClassLoader;

public class JRFAppLifecycleListener
extends ApplicationLifecycleListener {
    public void preStart(ApplicationLifecycleEvent paramApplicationLifecycleEvent) throws ApplicationException {
        try {
            ApplicationContextImpl appCtxImpl = (ApplicationContextImpl)paramApplicationLifecycleEvent.getApplicationContext();
            FilteringClassLoader filterClassLoader = (FilteringClassLoader)appCtxImpl.getAppClassLoader().getParent();
            Field classPatternsField = filterClassLoader.getClass().getDeclaredField("classPatterns");
            classPatternsField.setAccessible(true);
            List classPatterns = (List)classPatternsField.get(filterClassLoader);
            ArrayList<String> filterList = new ArrayList<String>();
            filterList.add("org.apache.commons.*");
            if (classPatterns.isEmpty()) {
                Method setFilterListMth = filterClassLoader.getClass().getMethod("setFilterList", List.class);
                setFilterListMth.invoke((Object)filterClassLoader, filterList);
            } else {
                Method makePatternsMth = filterClassLoader.getClass().getDeclaredMethod("makePatterns", List.class);
                makePatternsMth.setAccessible(true);
                List newClassPatterns = (List)makePatternsMth.invoke(null, filterList);
                newClassPatterns.addAll(classPatterns);
                classPatternsField.set(filterClassLoader, newClassPatterns);
            }
            Logger.getLogger(JrfUtils.JRF_LOGGER).log(Level.INFO, "internally added applicaton classloader filter org.apache.commons.*");
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
    }
}

