/*
 * Decompiled with CFR 0.152.
 */
package oracle.express.olapi.data;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import oracle.express.olapi.data.CompoundCursorStructure;
import oracle.express.olapi.data.CursorFactory;
import oracle.express.olapi.data.CursorStructure;
import oracle.express.olapi.data.CursorTreeManager;
import oracle.express.olapi.data.CursorValidationContext;
import oracle.express.olapi.data.DescendantRequestedCursorPositionState;
import oracle.express.olapi.data.ExpressCursor;
import oracle.express.olapi.data.ExpressValueCursor;
import oracle.olapi.data.cursor.CompoundCursor;
import oracle.olapi.data.cursor.ValueCursor;

class ExpressCompoundCursor
extends ExpressCursor
implements CompoundCursor {
    private ExpressValueCursor _valueCursor;
    private List _outputs;

    public ExpressCompoundCursor(CompoundCursorStructure compoundCursorStructure, ExpressCompoundCursor expressCompoundCursor, CursorTreeManager cursorTreeManager) {
        super(compoundCursorStructure, expressCompoundCursor, cursorTreeManager);
        List list = compoundCursorStructure._getOutputs();
        this._outputs = new ArrayList(list.size());
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            this._outputs.add(CursorFactory._createExpressCursor((CursorStructure)iterator.next(), this, cursorTreeManager));
        }
        this._outputs = Collections.unmodifiableList(this._outputs);
        this._valueCursor = new ExpressValueCursor(compoundCursorStructure._getValueCursorStructure(), this, cursorTreeManager);
    }

    @Override
    public final ValueCursor getValueCursor() {
        return this._valueCursor;
    }

    @Override
    public final List getOutputs() {
        return this._outputs;
    }

    public final void descendantRequested() {
        this.setPositionToInvalid(DescendantRequestedCursorPositionState.INSTANCE);
        this.broadcastPositionRequestToAncestors();
    }

    @Override
    protected final void broadcastPositionRequestToDescendants() {
        Iterator iterator = this.getOutputs().iterator();
        while (iterator.hasNext()) {
            ((ExpressCursor)iterator.next()).ancestorRequested();
        }
        ((ExpressValueCursor)this.getValueCursor()).ancestorRequested();
    }

    @Override
    protected final void aggregatePositionFromInteriorDependencies(CursorValidationContext cursorValidationContext) {
        CompoundCursorStructure compoundCursorStructure = (CompoundCursorStructure)this.getCursorStructure();
        compoundCursorStructure.aggregatePositionFromInteriorDependencies(cursorValidationContext);
    }

    @Override
    protected final void allocatePositionToInteriorDependencies(CursorValidationContext cursorValidationContext) {
        CompoundCursorStructure compoundCursorStructure = (CompoundCursorStructure)this.getCursorStructure();
        compoundCursorStructure.allocatePositionToInteriorDependencies(cursorValidationContext);
    }

    @Override
    public final void setDescendantPositionsToOne() {
        this.setPositionToValid(1L, -1, -1);
        Iterator iterator = this._outputs.iterator();
        while (iterator.hasNext()) {
            ((ExpressCursor)iterator.next()).setDescendantPositionsToOne();
        }
        this._valueCursor.setDescendantPositionsToOne();
    }

    @Override
    public void validateAncestorRequestedLeaves() {
        Iterator iterator = this._outputs.iterator();
        while (iterator.hasNext()) {
            ((ExpressCursor)iterator.next()).validateAncestorRequestedLeaves();
        }
        this._valueCursor.validateAncestorRequestedLeaves();
    }
}

