/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.metadata;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import oracle.olapi.data.source.Source;
import oracle.olapi.metadata.BaseMetadataObject;
import oracle.olapi.metadata.BaseMetadataProvider;
import oracle.olapi.metadata.BaseMetadataXMLTags;
import oracle.olapi.metadata.MetadataListModificationStep;
import oracle.olapi.metadata.MetadataObjectHolder;
import oracle.olapi.metadata.MetadataProperty;
import oracle.olapi.metadata.MetadataToXMLConverter;
import oracle.olapi.metadata.XMLTag;
import oracle.olapi.syntax.SQLDataType;
import oracle.olapi.syntax.SyntaxObject;

final class MetadataListProperty
extends MetadataProperty {
    private List m_Objects = new ArrayList();
    private List m_Modifications = null;

    MetadataListProperty(XMLTag xMLTag) {
        super(xMLTag);
    }

    private MetadataListProperty(MetadataListProperty metadataListProperty, boolean bl) {
        super(metadataListProperty);
        this.getObjects().addAll(metadataListProperty.getObjects());
        if (bl && metadataListProperty.hasModifications()) {
            this.getModifications().addAll(metadataListProperty.getModifications());
        }
    }

    @Override
    boolean addChildrenToXMLWriter(MetadataToXMLConverter metadataToXMLConverter, List list) {
        boolean bl = false;
        if (!this.isMetadataObjectList()) {
            return bl;
        }
        for (MetadataObjectHolder metadataObjectHolder : this.getObjects()) {
            bl = metadataToXMLConverter.addMetadataObject(metadataObjectHolder, list) || bl;
        }
        return bl;
    }

    @Override
    void gatherMetadataObjects(List<MetadataObjectHolder> list) {
        if (!this.isMetadataObjectList()) {
            return;
        }
        for (MetadataObjectHolder metadataObjectHolder : this.getObjects()) {
            list.add(metadataObjectHolder);
        }
    }

    @Override
    void gatherReferencedSources(List list) {
        if (!this.isSourceObjectList()) {
            return;
        }
        Iterator iterator = this.getObjects().iterator();
        while (iterator.hasNext()) {
            list.add(iterator.next());
        }
    }

    void addObject(Object object, BaseMetadataObject baseMetadataObject) {
        this.addObject(object, -1, baseMetadataObject);
    }

    void addObject(Object object, int n, BaseMetadataObject baseMetadataObject) {
        if (!this.containsObject(object)) {
            MetadataListModificationStep metadataListModificationStep = MetadataListModificationStep.newAddAction(object, n);
            metadataListModificationStep.applyModification(this);
            this.getModifications().add(metadataListModificationStep);
        }
    }

    boolean containsObject(Object object) {
        for (Object e : this.getObjects()) {
            if (object != e) continue;
            return true;
        }
        return false;
    }

    void removeObject(Object object, BaseMetadataObject baseMetadataObject) {
        MetadataListModificationStep metadataListModificationStep = MetadataListModificationStep.newRemoveAction(object);
        metadataListModificationStep.applyModification(this);
        this.getModifications().add(metadataListModificationStep);
    }

    void clearObjects(BaseMetadataObject baseMetadataObject) {
        MetadataListModificationStep metadataListModificationStep = MetadataListModificationStep.newClearAction();
        metadataListModificationStep.applyModification(this);
        this.getModifications().add(metadataListModificationStep);
    }

    @Override
    void appendXMLString(MetadataToXMLConverter metadataToXMLConverter, BaseMetadataObject baseMetadataObject) {
        for (Object e : this.getObjects()) {
            if (this.isMetadataObjectList()) {
                MetadataObjectHolder metadataObjectHolder = (MetadataObjectHolder)e;
                if (this.getPropertyTag().isXMLContainedObject() && !this.isXMLWriteableContainedObject(metadataToXMLConverter, baseMetadataObject, metadataObjectHolder.getMetadataObject())) continue;
            }
            this.appendObjectXMLString(metadataToXMLConverter, baseMetadataObject, e, false);
        }
    }

    private void appendObjectXMLString(MetadataToXMLConverter metadataToXMLConverter, BaseMetadataObject baseMetadataObject, Object object, boolean bl) {
        if (this.isMetadataObjectList()) {
            MetadataObjectHolder metadataObjectHolder = (MetadataObjectHolder)object;
            if (metadataToXMLConverter.getXMLFormat().is10gMode() || this.getPropertyTag().isXMLObjectReference() || bl) {
                metadataToXMLConverter.appendIDRefElement(this.getPropertyTag(), metadataObjectHolder, baseMetadataObject);
            } else if (7 == this.getXMLFormatType()) {
                metadataToXMLConverter.appendChoiceElement(this.getPropertyTag(), metadataObjectHolder);
            } else if (6 == this.getXMLFormatType()) {
                metadataToXMLConverter.appendElement(this.getPropertyTag(), metadataObjectHolder);
            }
        } else if (this.isSourceObjectList()) {
            Source source = (Source)object;
            metadataToXMLConverter.appendIDRefElement(this.getPropertyTag(), source, baseMetadataObject);
        } else if (this.isSyntaxObjectList()) {
            SyntaxObject syntaxObject = (SyntaxObject)object;
            metadataToXMLConverter.appendSyntaxElement(this.getPropertyTag(), BaseMetadataXMLTags.LIST_VALUE, syntaxObject, baseMetadataObject);
        } else if (this.isSQLDataTypeList()) {
            SQLDataType sQLDataType = (SQLDataType)object;
            metadataToXMLConverter.beginElement(this.getPropertyTag());
            metadataToXMLConverter.appendSQLDataType(BaseMetadataXMLTags.LIST_VALUE, sQLDataType, baseMetadataObject);
            metadataToXMLConverter.endElement();
        } else {
            String string = (String)object;
            metadataToXMLConverter.beginElement(this.getPropertyTag());
            metadataToXMLConverter.appendAttribute(BaseMetadataXMLTags.LIST_VALUE, string, baseMetadataObject);
            metadataToXMLConverter.endElement();
        }
    }

    @Override
    void appendIncrementalXMLString(MetadataToXMLConverter metadataToXMLConverter, BaseMetadataObject baseMetadataObject) {
        boolean bl;
        boolean bl2 = false;
        if (this.isMetadataObjectList() && this.getPropertyTag().isXMLContainedObject()) {
            bl2 = true;
        }
        if (!(bl = this.isModification(metadataToXMLConverter, baseMetadataObject)) && !bl2) {
            return;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        if (bl) {
            Iterator iterator = this.getModifications().iterator();
            int n = 0;
            while (iterator.hasNext()) {
                MetadataListModificationStep metadataListModificationStep = (MetadataListModificationStep)iterator.next();
                metadataToXMLConverter.appendAttributeToNextElement(BaseMetadataXMLTags.ACTION, metadataListModificationStep.getActionString());
                if (-1 != metadataListModificationStep.getPosition()) {
                    metadataToXMLConverter.appendAttributeToNextElement(BaseMetadataXMLTags.LIST_POSITION, "" + metadataListModificationStep.getPosition());
                }
                boolean bl3 = false;
                if (bl2) {
                    if (0 == metadataListModificationStep.getAction()) {
                        MetadataObjectHolder metadataObjectHolder = (MetadataObjectHolder)metadataListModificationStep.getObject();
                        if (arrayList.contains(metadataListModificationStep.getObject())) {
                            bl3 = true;
                        } else if (arrayList2.contains(metadataListModificationStep.getObject()) && !this.isXMLWriteableContainedObject(metadataToXMLConverter, baseMetadataObject, metadataObjectHolder.getMetadataObject())) {
                            bl3 = true;
                        }
                        arrayList.add(metadataListModificationStep.getObject());
                    } else if (1 == metadataListModificationStep.getAction()) {
                        bl3 = true;
                        arrayList2.add(metadataListModificationStep.getObject());
                    } else {
                        arrayList2.addAll(metadataListModificationStep.getClearedObjects());
                    }
                }
                if (null == metadataListModificationStep.getObject()) {
                    metadataToXMLConverter.beginElement(this.getPropertyTag());
                    metadataToXMLConverter.endElement();
                } else {
                    this.appendObjectXMLString(metadataToXMLConverter, baseMetadataObject, metadataListModificationStep.getObject(), bl3);
                }
                ++n;
            }
        }
        if (bl2) {
            for (MetadataObjectHolder metadataObjectHolder : this.getObjects()) {
                if (arrayList.contains(metadataObjectHolder) || !this.isXMLWriteableContainedObject(metadataToXMLConverter, baseMetadataObject, metadataObjectHolder.getMetadataObject())) continue;
                this.appendObjectXMLString(metadataToXMLConverter, baseMetadataObject, metadataObjectHolder, false);
            }
        }
    }

    void getObjects(ArrayList arrayList, BaseMetadataProvider baseMetadataProvider) {
        if (this.isMetadataObjectList()) {
            baseMetadataProvider.fetchMetadataObjects(this.getObjects(), arrayList);
        } else {
            arrayList.addAll(this.getObjects());
        }
    }

    List getObjects() {
        return this.m_Objects;
    }

    private List getModifications() {
        if (null == this.m_Modifications) {
            this.m_Modifications = new ArrayList();
        }
        return this.m_Modifications;
    }

    private boolean hasModifications() {
        return null != this.m_Modifications;
    }

    @Override
    boolean isAttribute(MetadataToXMLConverter metadataToXMLConverter, BaseMetadataObject baseMetadataObject) {
        return false;
    }

    private void setObjects(List list) {
        this.m_Objects = list;
    }

    @Override
    void updateFromChild(MetadataProperty metadataProperty) {
        MetadataListProperty metadataListProperty = (MetadataListProperty)metadataProperty;
        this.setObjects(metadataListProperty.getObjects());
        if (metadataListProperty.hasModifications()) {
            this.getModifications().addAll(metadataListProperty.getModifications());
        }
    }

    @Override
    void updateFromParent(MetadataProperty metadataProperty) {
        MetadataListProperty metadataListProperty = (MetadataListProperty)metadataProperty;
        this.getObjects().clear();
        this.getObjects().addAll(metadataListProperty.getObjects());
        if (!this.hasModifications()) {
            return;
        }
        for (MetadataListModificationStep metadataListModificationStep : this.getModifications()) {
            metadataListModificationStep.applyModification(this);
        }
    }

    @Override
    MetadataProperty cloneProperty(boolean bl) {
        return new MetadataListProperty(this, bl);
    }

    boolean isMetadataObjectList() {
        return this.getDataType() == 0;
    }

    boolean isSourceObjectList() {
        return this.getDataType() == 1;
    }

    boolean isSyntaxObjectList() {
        return this.getPropertyTag().isSyntaxDataType();
    }

    boolean isSQLDataTypeList() {
        return this.getDataType() == 7;
    }

    private int getDataType() {
        return this.getPropertyTag().getDataType();
    }

    @Override
    boolean isModification(MetadataToXMLConverter metadataToXMLConverter, BaseMetadataObject baseMetadataObject) {
        return this.hasModifications() && super.isModification(metadataToXMLConverter, baseMetadataObject);
    }

    @Override
    final boolean isServerSendable(MetadataProperty metadataProperty) {
        boolean bl = true;
        if (!this.hasModifications()) {
            bl = false;
        }
        return bl;
    }

    @Override
    void getRemovedElements(Set set) {
        if (!this.hasModifications() || this.getModifications().size() == 0) {
            return;
        }
        for (MetadataListModificationStep metadataListModificationStep : this.getModifications()) {
            List list = metadataListModificationStep.getObjects();
            for (Object object : list) {
                if (object instanceof MetadataObjectHolder) {
                    object = ((MetadataObjectHolder)object).getMetadataObject();
                }
                if (!(object instanceof BaseMetadataObject)) continue;
                switch (metadataListModificationStep.getAction()) {
                    case 0: {
                        set.remove(object);
                        break;
                    }
                    case 1: 
                    case 2: {
                        set.add(object);
                    }
                }
            }
        }
    }

    @Override
    void getAssociatedObjects(List list) {
        list.addAll(this.getObjects());
    }

    @Override
    void updatePersistentState(short s) {
        for (MetadataObjectHolder metadataObjectHolder : this.getObjects()) {
            if (null == metadataObjectHolder || !(metadataObjectHolder.getMetadataObject() instanceof BaseMetadataObject)) continue;
            ((BaseMetadataObject)metadataObjectHolder.getMetadataObject()).updatePersistentState(s);
        }
    }

    @Override
    void revertPersistentState() {
        for (MetadataObjectHolder metadataObjectHolder : this.getObjects()) {
            if (null == metadataObjectHolder || !(metadataObjectHolder.getMetadataObject() instanceof BaseMetadataObject)) continue;
            ((BaseMetadataObject)metadataObjectHolder.getMetadataObject()).revertPersistentState();
        }
    }

    @Override
    boolean isLocal() {
        return this.hasModifications();
    }
}

