/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.metadata.conversion;

import java.util.List;
import oracle.olapi.metadata.BaseMetadataProvider;
import oracle.olapi.metadata.XMLTag;
import oracle.olapi.metadata.conversion.LegacyXMLAWObject;
import oracle.olapi.metadata.conversion.LegacyXMLAttribute;
import oracle.olapi.metadata.conversion.LegacyXMLBaseObject;
import oracle.olapi.metadata.conversion.LegacyXMLConverter;
import oracle.olapi.metadata.conversion.LegacyXMLDimension;
import oracle.olapi.metadata.conversion.LegacyXMLHierarchyLevelAssociation;
import oracle.olapi.metadata.conversion.LegacyXMLLevel;
import oracle.olapi.metadata.conversion.LegacyXMLTags;
import oracle.olapi.metadata.mdm.MdmHierarchy;
import oracle.olapi.metadata.mdm.MdmPrimaryDimension;

final class LegacyXMLHierarchy
extends LegacyXMLAWObject {
    private static final XMLTag[] LOCAL_TAGS = new XMLTag[]{LegacyXMLTags.IS_DEFAULT, LegacyXMLTags.HIERARCHY_TYPE, LegacyXMLTags.DEFAULT_ORDER_REF, LegacyXMLTags.HIERARCHY_LEVEL_ASSOCIATIONS};

    protected LegacyXMLHierarchy(BaseMetadataProvider baseMetadataProvider) {
        super(baseMetadataProvider);
    }

    boolean getIsDefault() {
        return this.getPropertyBooleanValue(LegacyXMLTags.IS_DEFAULT);
    }

    String getType() {
        return this.getPropertyStringValue(LegacyXMLTags.HIERARCHY_TYPE);
    }

    LegacyXMLAttribute getDefaultOrder() {
        return (LegacyXMLAttribute)this.getPropertyObjectValue(LegacyXMLTags.DEFAULT_ORDER_REF);
    }

    List<LegacyXMLHierarchyLevelAssociation> getHierarchyLevelAssociations() {
        return this.getPropertyListValues(LegacyXMLTags.HIERARCHY_LEVEL_ASSOCIATIONS);
    }

    LegacyXMLDimension getDimension() {
        return (LegacyXMLDimension)this.getContainedByObject();
    }

    LegacyXMLHierarchyLevelAssociation getParentLevel(LegacyXMLHierarchyLevelAssociation legacyXMLHierarchyLevelAssociation) {
        LegacyXMLHierarchyLevelAssociation legacyXMLHierarchyLevelAssociation2 = null;
        for (LegacyXMLHierarchyLevelAssociation legacyXMLHierarchyLevelAssociation3 : this.getHierarchyLevelAssociations()) {
            if (legacyXMLHierarchyLevelAssociation3 == legacyXMLHierarchyLevelAssociation) {
                return legacyXMLHierarchyLevelAssociation2;
            }
            legacyXMLHierarchyLevelAssociation2 = legacyXMLHierarchyLevelAssociation3;
        }
        return null;
    }

    LegacyXMLHierarchyLevelAssociation getChildLevel(LegacyXMLHierarchyLevelAssociation legacyXMLHierarchyLevelAssociation) {
        boolean bl = false;
        for (LegacyXMLHierarchyLevelAssociation legacyXMLHierarchyLevelAssociation2 : this.getHierarchyLevelAssociations()) {
            if (bl) {
                return legacyXMLHierarchyLevelAssociation2;
            }
            if (legacyXMLHierarchyLevelAssociation2 != legacyXMLHierarchyLevelAssociation) continue;
            bl = true;
        }
        if (bl) {
            return null;
        }
        return null;
    }

    LegacyXMLHierarchyLevelAssociation getHierarchyLevelAssociation(LegacyXMLLevel legacyXMLLevel) {
        for (LegacyXMLHierarchyLevelAssociation legacyXMLHierarchyLevelAssociation : this.getHierarchyLevelAssociations()) {
            if (legacyXMLHierarchyLevelAssociation.getLevel() != legacyXMLLevel) continue;
            return legacyXMLHierarchyLevelAssociation;
        }
        return null;
    }

    boolean isValueHierarchy() {
        return "VALUE" == this.getType();
    }

    boolean isLevelHierarchy() {
        return "LEVEL" == this.getType();
    }

    MdmHierarchy getMdmHierarchy() {
        return (MdmHierarchy)this.getConvertToObject();
    }

    @Override
    protected XMLTag getPropertyXMLTag(String string, String string2) {
        XMLTag xMLTag = this.findXMLTag(string, string2, LOCAL_TAGS);
        if (null == xMLTag) {
            return super.getPropertyXMLTag(string, string2);
        }
        return xMLTag;
    }

    @Override
    protected XMLTag getXMLTag() {
        return LegacyXMLTags.HIERARCHY_TAG;
    }

    @Override
    protected boolean validateState(LegacyXMLConverter legacyXMLConverter) {
        if (null != this.getDefaultOrder()) {
            legacyXMLConverter.reportIgnoredProperty(LegacyXMLTags.DEFAULT_ORDER_REF, this.getDefaultOrder().getID(), this);
        }
        return true;
    }

    @Override
    protected void convertToMdm(LegacyXMLConverter legacyXMLConverter) {
        MdmPrimaryDimension mdmPrimaryDimension = this.getDimension().getMdmPrimaryDimension();
        MdmHierarchy mdmHierarchy = null;
        String string = this.getName();
        mdmHierarchy = this.isValueHierarchy() ? mdmPrimaryDimension.findOrCreateValueHierarchy(string) : mdmPrimaryDimension.findOrCreateLevelHierarchy(string);
        if (this.getIsDefault()) {
            mdmPrimaryDimension.setDefaultHierarchy(mdmHierarchy);
        }
        this.setMdmHierarchy(mdmHierarchy);
        super.convertToMdm(legacyXMLConverter);
    }

    @Override
    void validateSubDimRefs(LegacyXMLConverter legacyXMLConverter, LegacyXMLHierarchy legacyXMLHierarchy, LegacyXMLLevel legacyXMLLevel, LegacyXMLBaseObject legacyXMLBaseObject) {
        if (this != legacyXMLHierarchy) {
            legacyXMLConverter.reportIgnoredProperty(LegacyXMLTags.HIERARCHY_REF, legacyXMLHierarchy, legacyXMLBaseObject);
        }
        if (null != legacyXMLLevel) {
            legacyXMLConverter.reportIgnoredProperty(LegacyXMLTags.LEVEL_REF, legacyXMLLevel, legacyXMLBaseObject);
        }
    }

    private void setMdmHierarchy(MdmHierarchy mdmHierarchy) {
        this.setConvertToObject(mdmHierarchy);
    }
}

