/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.metadata.mdm;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import oracle.express.ObjectClosedException;
import oracle.express.idl.util.XMLWriter;
import oracle.olapi.data.source.DataProvider;
import oracle.olapi.data.source.Source;
import oracle.olapi.metadata.BaseMetadataObject;
import oracle.olapi.metadata.BaseMetadataProvider;
import oracle.olapi.metadata.ClientXMLMetadataFetcher;
import oracle.olapi.metadata.MetadataObject;
import oracle.olapi.metadata.MetadataProvider;
import oracle.olapi.metadata.MetadataToFileXMLConverter;
import oracle.olapi.metadata.MetadataXMLReader;
import oracle.olapi.metadata.XMLParserCallback;
import oracle.olapi.metadata.XMLWriterCallback;
import oracle.olapi.metadata.deployment.AW;
import oracle.olapi.metadata.mdm.Mdm102IDToObjectConverter;
import oracle.olapi.metadata.mdm.Mdm9iNamingConvention;
import oracle.olapi.metadata.mdm.MdmCustomObjectFactory;
import oracle.olapi.metadata.mdm.MdmDatabaseSchema;
import oracle.olapi.metadata.mdm.MdmDefaultValueConverter;
import oracle.olapi.metadata.mdm.MdmNamingConvention;
import oracle.olapi.metadata.mdm.MdmODBOValueConverter;
import oracle.olapi.metadata.mdm.MdmObject;
import oracle.olapi.metadata.mdm.MdmObjectFactory;
import oracle.olapi.metadata.mdm.MdmRootSchema;
import oracle.olapi.metadata.mdm.MdmSchema;
import oracle.olapi.metadata.mdm.MdmSource;
import oracle.olapi.metadata.mdm.MdmValueConverter;
import oracle.olapi.metadata.mtm.MtmCustomObjectFactory;
import oracle.olapi.metadata.mtm.MtmDataTypeConverter;
import oracle.olapi.metadata.mtm.MtmObjectFactory;
import oracle.olapi.metadata.mtm.MtmPartitionedCube;
import oracle.olapi.syntax.parser.Identifier;
import oracle.olapi.transaction.BaseTransaction;
import oracle.olapi.transaction.Transaction;
import oracle.olapi.version.Version;
import oracle.olapi.xml.XMLException;
import org.xml.sax.SAXException;

public class MdmMetadataProvider
extends BaseMetadataProvider
implements MetadataProvider {
    private static final String DEFAULT_TRANSIENT_OWNER_NAME = "TRANSIENT";
    public static final String NAMESPACE_DELIMITER = "..";
    public static final String DEFAULT_NAMESPACE = "";
    public static final String AWXML_CUBE_NAMESPACE = "AWXML_CUBE";
    public static final String AWXML_DIMENSION_NAMESPACE = "AWXML_DIMENSION";
    public static final String AWXML_FOLDER_NAMESPACE = "AWXML_FOLDER";
    public static final String CWM_CUBE_NAMESPACE = "CWM_CUBE";
    public static final String CWM_DIMENSION_NAMESPACE = "CWM_DIMENSION";
    public static final String CWM_FOLDER_NAMESPACE = "CWM_FOLDER";
    private MdmObjectFactory m_MdmObjectFactory = null;
    private MtmObjectFactory m_MtmObjectFactory = null;
    private MdmCustomObjectFactory m_MdmCustomObjectFactory = null;
    private MtmCustomObjectFactory m_MtmCustomObjectFactory = null;
    private List m_MtmPartitionedCubes = new ArrayList();
    private MdmValueConverter m_valueConverter = null;
    private MdmNamingConvention m_MdmNamingConvention = null;
    private MtmDataTypeConverter m_MtmDataTypeConverter = null;
    private Mdm102IDToObjectConverter m_Mdm102IDToObjectConverter = null;
    private int m_exprCounter = 0;

    public MdmMetadataProvider(DataProvider dataProvider) throws ObjectClosedException {
        this(dataProvider, null);
    }

    public MdmMetadataProvider(DataProvider dataProvider, ClientXMLMetadataFetcher clientXMLMetadataFetcher) throws ObjectClosedException {
        super(dataProvider, clientXMLMetadataFetcher);
        dataProvider.registerMetadataProvider(this);
        this.m_MdmObjectFactory = new MdmObjectFactory(this);
        this.m_MtmObjectFactory = new MtmObjectFactory(this);
        this.m_MdmCustomObjectFactory = new MdmCustomObjectFactory(this);
        this.m_MtmCustomObjectFactory = new MtmCustomObjectFactory(this);
        this.setMdmNamingConvention(null);
    }

    public final MdmObject getMetadataObject(String string) throws ObjectClosedException {
        return (MdmObject)this.fetchMetadataObject(string);
    }

    public final List getMetadataObjects(String[] stringArray) throws ObjectClosedException {
        return this.fetchMetadataObjects(stringArray);
    }

    public MdmSchema getRootSchema() {
        return (MdmSchema)this.getMetadataObject("RootSchema");
    }

    @Override
    public final Source getSource(String string) throws ObjectClosedException {
        MetadataObject metadataObject = this.fetchMetadataObject(string);
        if (metadataObject instanceof MdmSource) {
            return ((MdmSource)metadataObject).getSource();
        }
        return null;
    }

    public MdmObject getMdmObject(Identifier identifier) {
        if (this.getDataProvider().read11gMetadata()) {
            String string;
            MdmRootSchema mdmRootSchema = (MdmRootSchema)this.getRootSchema();
            MdmDatabaseSchema mdmDatabaseSchema = null;
            String string2 = null;
            if (identifier.hasNamespace()) {
                string2 = identifier.getNamespace();
            }
            if (null == (mdmDatabaseSchema = mdmRootSchema.getDatabaseSchema(string = identifier.getComponent(identifier.getOwnerIndex())))) {
                return null;
            }
            if (identifier.getNumComponents() == identifier.getOwnerIndex() + 1) {
                return mdmDatabaseSchema;
            }
            String string3 = identifier.getComponent(identifier.getOwnerIndex() + 1);
            BaseMetadataObject baseMetadataObject = mdmDatabaseSchema.getTopLevelObject(string2, string3);
            if (null == baseMetadataObject) {
                return null;
            }
            if (identifier.getNumComponents() == identifier.getOwnerIndex() + 2) {
                return (MdmObject)baseMetadataObject;
            }
            MetadataObject metadataObject = this.fetchMetadataObject(identifier.toString());
            if (metadataObject instanceof MdmObject) {
                return (MdmObject)metadataObject;
            }
            return null;
        }
        MetadataObject metadataObject = this.fetchMetadataObject(identifier.toString());
        if (metadataObject instanceof MdmObject) {
            return (MdmObject)metadataObject;
        }
        return null;
    }

    private String generateID(String string, String string2, List<String> list, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        if (null != string && string.length() > 0) {
            stringBuffer.append('.');
            stringBuffer.append(string);
            stringBuffer.append('.');
        }
        if (null != string2) {
            stringBuffer.append(string2);
            stringBuffer.append('.');
        }
        for (int i = 0; i < n; ++i) {
            if (0 != i) {
                stringBuffer.append('.');
            }
            stringBuffer.append(list.get(i));
        }
        return stringBuffer.toString();
    }

    public List getPartitionedCubes() {
        return this.m_MtmPartitionedCubes;
    }

    public void registerCube(MtmPartitionedCube mtmPartitionedCube) {
        this.m_MtmPartitionedCubes.add(mtmPartitionedCube);
    }

    public void unregisterCube(MtmPartitionedCube mtmPartitionedCube) {
        this.m_MtmPartitionedCubes.remove(mtmPartitionedCube);
    }

    public final MdmCustomObjectFactory getMdmCustomObjectFactory() {
        return this.m_MdmCustomObjectFactory;
    }

    public final MtmCustomObjectFactory getMtmCustomObjectFactory() {
        return this.m_MtmCustomObjectFactory;
    }

    public final MdmObjectFactory getMdmObjectFactory() {
        return this.m_MdmObjectFactory;
    }

    public final MtmObjectFactory getMtmObjectFactory() {
        return this.m_MtmObjectFactory;
    }

    private boolean isPropertyEqual(String string, String string2) {
        return string2.equals(this.getDataProvider().getProperty(string));
    }

    MdmValueConverter getValueConverter() {
        if (this.m_valueConverter == null) {
            this.m_valueConverter = this.isPropertyEqual("ODBOMode", "YES") ? new MdmODBOValueConverter() : new MdmDefaultValueConverter();
        }
        return this.m_valueConverter;
    }

    boolean usingUniqueValues() {
        return this.isPropertyEqual("HierarchyValueType", "unique") || this.isPropertyEqual("ODBOMode", "YES");
    }

    public String[] getValidNamespaces() {
        return new String[]{DEFAULT_NAMESPACE, AWXML_CUBE_NAMESPACE, AWXML_DIMENSION_NAMESPACE, AWXML_FOLDER_NAMESPACE, CWM_CUBE_NAMESPACE, CWM_DIMENSION_NAMESPACE, CWM_FOLDER_NAMESPACE};
    }

    MdmNamingConvention getMdmNamingConvention() {
        return this.m_MdmNamingConvention;
    }

    public void setMdmNamingConvention(MdmNamingConvention mdmNamingConvention) {
        this.m_MdmNamingConvention = null == mdmNamingConvention ? new Mdm9iNamingConvention(DEFAULT_TRANSIENT_OWNER_NAME, this) : mdmNamingConvention;
    }

    public MtmDataTypeConverter getMtmDataTypeConverter() {
        if (null == this.m_MtmDataTypeConverter) {
            this.m_MtmDataTypeConverter = new MtmDataTypeConverter(this.getDataProvider());
        }
        return this.m_MtmDataTypeConverter;
    }

    public void setMtmDataTypeConverter(MtmDataTypeConverter mtmDataTypeConverter) {
        this.m_MtmDataTypeConverter = mtmDataTypeConverter;
    }

    public String getUniqueNumberString() {
        ++this.m_exprCounter;
        Integer n = new Integer(this.m_exprCounter);
        return n.toString();
    }

    public boolean supportsBulkSend() {
        return this.getDataProvider().supportsBulkSend();
    }

    public void bulkSend() {
        if (this.supportsBulkSend()) {
            this.getDataProvider().bulkSendMetadata();
        }
    }

    public final void exportFullXML(Writer writer, List list, Map map, boolean bl, Map map2, XMLWriterCallback xMLWriterCallback, String string) throws IOException {
        this.exportObjectListXML(writer, list, null, map, map2, bl, xMLWriterCallback, 1, string);
    }

    public final void exportFullXML(Writer writer, List list, Map map, boolean bl, Map map2, XMLWriterCallback xMLWriterCallback) throws IOException {
        this.exportFullXML(writer, list, map, bl, map2, xMLWriterCallback, null);
    }

    public final void exportFullXML(Writer writer, List list, Map map, boolean bl, Map map2) throws IOException {
        this.exportFullXML(writer, list, map, bl, map2, null);
    }

    public final void exportFullXML(Writer writer, List list, Map map, boolean bl) throws IOException {
        this.exportFullXML(writer, list, map, bl, null);
    }

    public final void exportFullXML(Writer writer, List list, Map map) throws IOException {
        this.exportFullXML(writer, list, map, false);
    }

    public final String exportFullXML(List list, Map map, boolean bl, Map map2, XMLWriterCallback xMLWriterCallback, String string) throws IOException {
        StringWriter stringWriter = new StringWriter();
        this.exportFullXML((Writer)stringWriter, list, map, bl, map2, xMLWriterCallback, string);
        return stringWriter.getBuffer().toString();
    }

    public final String exportFullXML(List list, Map map, boolean bl, Map map2, XMLWriterCallback xMLWriterCallback) throws IOException {
        return this.exportFullXML(list, map, bl, map2, xMLWriterCallback, null);
    }

    public final String exportFullXML(List list, Map map, boolean bl, Map map2) throws IOException {
        return this.exportFullXML(list, map, bl, map2, null);
    }

    public final String exportFullXML(List list, Map map, boolean bl) throws IOException {
        return this.exportFullXML(list, map, bl, null);
    }

    public final void exportFullXML(Writer writer, Transaction transaction, Map map, boolean bl, Map map2, XMLWriterCallback xMLWriterCallback, String string) throws IOException {
        this.exportModifiedObjectsXML(writer, transaction, map, map2, bl, xMLWriterCallback, 1, string);
    }

    public final void exportFullXML(Writer writer, Transaction transaction, Map map, boolean bl, Map map2, XMLWriterCallback xMLWriterCallback) throws IOException {
        this.exportFullXML(writer, transaction, map, bl, map2, xMLWriterCallback, null);
    }

    public final void exportFullXML(Writer writer, Transaction transaction, Map map, boolean bl, Map map2) throws IOException {
        this.exportFullXML(writer, transaction, map, bl, map2, null);
    }

    public final void exportFullXML(Writer writer, Transaction transaction, Map map, boolean bl) throws IOException {
        this.exportFullXML(writer, transaction, map, bl, null);
    }

    public final void exportFullXML(Writer writer, Transaction transaction, Map map) throws IOException {
        this.exportFullXML(writer, transaction, map, false);
    }

    public final String exportFullXML(Transaction transaction, Map map, boolean bl, Map map2, XMLWriterCallback xMLWriterCallback, String string) throws IOException {
        StringWriter stringWriter = new StringWriter();
        this.exportFullXML((Writer)stringWriter, transaction, map, bl, map2, xMLWriterCallback, string);
        return stringWriter.getBuffer().toString();
    }

    public final String exportFullXML(Transaction transaction, Map map, boolean bl, Map map2, XMLWriterCallback xMLWriterCallback) throws IOException {
        return this.exportFullXML(transaction, map, bl, map2, xMLWriterCallback, null);
    }

    public final String exportFullXML(Transaction transaction, Map map, boolean bl, Map map2) throws IOException {
        return this.exportFullXML(transaction, map, bl, map2, null);
    }

    public final String exportFullXML(Transaction transaction, Map map, boolean bl) throws IOException {
        return this.exportFullXML(transaction, map, bl, null);
    }

    public final void exportIncrementalXML(Writer writer, List list, Transaction transaction, Map map, boolean bl, Map map2, XMLWriterCallback xMLWriterCallback, String string) throws IOException {
        this.exportObjectListXML(writer, list, transaction, map, map2, bl, xMLWriterCallback, 2, string);
    }

    public final void exportIncrementalXML(Writer writer, List list, Transaction transaction, Map map, boolean bl, Map map2, XMLWriterCallback xMLWriterCallback) throws IOException {
        this.exportIncrementalXML(writer, list, transaction, map, bl, map2, xMLWriterCallback, null);
    }

    public final void exportIncrementalXML(Writer writer, List list, Transaction transaction, Map map, boolean bl, Map map2) throws IOException {
        this.exportIncrementalXML(writer, list, transaction, map, bl, map2, null);
    }

    public final void exportIncrementalXML(Writer writer, List list, Transaction transaction, Map map, boolean bl) throws IOException {
        this.exportIncrementalXML(writer, list, transaction, map, bl, null);
    }

    public final void exportIncrementalXML(Writer writer, List list, Transaction transaction, Map map) throws IOException {
        this.exportIncrementalXML(writer, list, transaction, map, false);
    }

    public final String exportIncrementalXML(List list, Transaction transaction, Map map, boolean bl, Map map2, XMLWriterCallback xMLWriterCallback, String string) throws IOException {
        StringWriter stringWriter = new StringWriter();
        this.exportIncrementalXML(stringWriter, list, transaction, map, bl, map2, xMLWriterCallback, string);
        return stringWriter.getBuffer().toString();
    }

    public final String exportIncrementalXML(List list, Transaction transaction, Map map, boolean bl, Map map2, XMLWriterCallback xMLWriterCallback) throws IOException {
        return this.exportIncrementalXML(list, transaction, map, bl, map2, xMLWriterCallback, null);
    }

    public final String exportIncrementalXML(List list, Transaction transaction, Map map, boolean bl, Map map2) throws IOException {
        return this.exportIncrementalXML(list, transaction, map, bl, map2, null);
    }

    public final String exportIncrementalXML(List list, Transaction transaction, Map map, boolean bl) throws IOException {
        return this.exportIncrementalXML(list, transaction, map, bl, null);
    }

    public final void exportIncrementalXML(Writer writer, Transaction transaction, Map map, boolean bl, Map map2, XMLWriterCallback xMLWriterCallback, String string) throws IOException {
        this.exportModifiedObjectsXML(writer, transaction, map, map2, bl, xMLWriterCallback, 2, string);
    }

    public final void exportIncrementalXML(Writer writer, Transaction transaction, Map map, boolean bl, Map map2, XMLWriterCallback xMLWriterCallback) throws IOException {
        this.exportIncrementalXML(writer, transaction, map, bl, map2, xMLWriterCallback, null);
    }

    public final void exportIncrementalXML(Writer writer, Transaction transaction, Map map, boolean bl, Map map2) throws IOException {
        this.exportIncrementalXML(writer, transaction, map, bl, map2, null);
    }

    public final void exportIncrementalXML(Writer writer, Transaction transaction, Map map, boolean bl) throws IOException {
        this.exportIncrementalXML(writer, transaction, map, bl, null);
    }

    public final void exportIncrementalXML(Writer writer, Transaction transaction, Map map) throws IOException {
        this.exportIncrementalXML(writer, transaction, map, false);
    }

    public final String exportIncrementalXML(Transaction transaction, Map map, boolean bl, Map map2, XMLWriterCallback xMLWriterCallback, String string) throws IOException {
        StringWriter stringWriter = new StringWriter();
        this.exportIncrementalXML((Writer)stringWriter, transaction, map, bl, map2, xMLWriterCallback, string);
        return stringWriter.getBuffer().toString();
    }

    public final String exportIncrementalXML(Transaction transaction, Map map, boolean bl, Map map2, XMLWriterCallback xMLWriterCallback) throws IOException {
        return this.exportIncrementalXML(transaction, map, bl, map2, xMLWriterCallback, null);
    }

    public final String exportIncrementalXML(Transaction transaction, Map map, boolean bl, Map map2) throws IOException {
        return this.exportIncrementalXML(transaction, map, bl, map2, null);
    }

    public final String exportIncrementalXML(Transaction transaction, Map map, boolean bl) throws IOException {
        return this.exportIncrementalXML(transaction, map, bl, null);
    }

    private void exportObjectListXML(Writer writer, List list, Transaction transaction, Map map, Map map2, boolean bl, XMLWriterCallback xMLWriterCallback, int n, String string) throws IOException {
        ArrayList<BaseMetadataObject> arrayList = new ArrayList<BaseMetadataObject>();
        for (BaseMetadataObject baseMetadataObject : list) {
            BaseMetadataObject baseMetadataObject2;
            if (baseMetadataObject instanceof MdmDatabaseSchema) {
                baseMetadataObject2 = (MdmDatabaseSchema)baseMetadataObject;
                arrayList.addAll(((MdmDatabaseSchema)baseMetadataObject2).getSchemaObjects());
                continue;
            }
            if (baseMetadataObject instanceof AW) {
                baseMetadataObject2 = (AW)baseMetadataObject;
                arrayList.addAll(((AW)baseMetadataObject2).getDimensions());
                arrayList.addAll(((AW)baseMetadataObject2).getCubes());
                arrayList.addAll(((AW)baseMetadataObject2).getOrganizationalSchemas());
                arrayList.add(baseMetadataObject2);
                continue;
            }
            if (baseMetadataObject instanceof MdmRootSchema) continue;
            arrayList.add(baseMetadataObject);
        }
        this.exportXML(writer, arrayList, transaction, map, map2, bl, xMLWriterCallback, n, string);
    }

    private void exportModifiedObjectsXML(Writer writer, Transaction transaction, Map map, Map map2, boolean bl, XMLWriterCallback xMLWriterCallback, int n, String string) throws IOException {
        BaseTransaction baseTransaction = this.getDataProvider().getBaseTransactionProvider().getCurrentSystemTransaction();
        ArrayList arrayList = new ArrayList();
        baseTransaction.getModifiedMetadataObjectsSince(transaction, arrayList);
        this.exportXML(writer, arrayList, transaction, map, map2, bl, xMLWriterCallback, n, string);
    }

    private void exportXML(Writer writer, List list, Transaction transaction, Map map, Map map2, boolean bl, XMLWriterCallback xMLWriterCallback, int n, String string) throws IOException {
        Version version = null;
        if (null == string) {
            version = this.getDataProvider().getServerVersion();
        } else {
            version = new Version(string);
            if ("0.1" == version.getMetadataXMLVersion()) {
                throw new XMLException("XMLWriteVersionBelowMin");
            }
        }
        MetadataToFileXMLConverter metadataToFileXMLConverter = new MetadataToFileXMLConverter(this.getDataProvider(), version);
        metadataToFileXMLConverter.setTransaction(this.getDataProvider().getBaseTransactionProvider().getCurrentSystemTransaction());
        metadataToFileXMLConverter.setRenameMap(map);
        metadataToFileXMLConverter.setBindVariables(map2);
        metadataToFileXMLConverter.getXMLFormat().setMode(n);
        metadataToFileXMLConverter.setSinceTransaction(transaction);
        metadataToFileXMLConverter.setUserCallback(xMLWriterCallback);
        for (BaseMetadataObject baseMetadataObject : list) {
            if (baseMetadataObject instanceof MdmRootSchema || baseMetadataObject instanceof MdmDatabaseSchema && !metadataToFileXMLConverter.getXMLFormat().is11gPartialXMLMode()) continue;
            metadataToFileXMLConverter.addMetadataObject(baseMetadataObject);
            if (bl || !(baseMetadataObject.getOwner() instanceof MdmDatabaseSchema)) continue;
            metadataToFileXMLConverter.addContextSchema((MdmDatabaseSchema)baseMetadataObject.getOwner());
        }
        XMLWriter xMLWriter = new XMLWriter();
        metadataToFileXMLConverter.generateXML(xMLWriter);
        xMLWriter.writeXML(writer);
    }

    public final List importXML(Reader reader, MdmDatabaseSchema mdmDatabaseSchema, boolean bl, Map<String, String> map, XMLParserCallback xMLParserCallback) throws IOException, SAXException {
        MetadataXMLReader metadataXMLReader = new MetadataXMLReader(0, this);
        metadataXMLReader.setContextSchema(mdmDatabaseSchema);
        metadataXMLReader.setCreateOnly(!bl);
        metadataXMLReader.setBindValues(map);
        metadataXMLReader.setUserCallback(xMLParserCallback);
        metadataXMLReader.parse(reader);
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(metadataXMLReader.getParsedObjects());
        return arrayList;
    }

    public final List importXML(Reader reader, MdmDatabaseSchema mdmDatabaseSchema, boolean bl, Map<String, String> map) throws IOException, SAXException {
        return this.importXML(reader, mdmDatabaseSchema, bl, map, null);
    }

    public final List importXML(Reader reader, MdmDatabaseSchema mdmDatabaseSchema, boolean bl) throws IOException, SAXException {
        return this.importXML(reader, mdmDatabaseSchema, bl, null);
    }

    public final List importXML(String string, MdmDatabaseSchema mdmDatabaseSchema, boolean bl, Map<String, String> map, XMLParserCallback xMLParserCallback) throws IOException, SAXException {
        StringReader stringReader = new StringReader(string);
        return this.importXML(stringReader, mdmDatabaseSchema, bl, map, xMLParserCallback);
    }

    public final List importXML(String string, MdmDatabaseSchema mdmDatabaseSchema, boolean bl, Map<String, String> map) throws IOException, SAXException {
        return this.importXML(string, mdmDatabaseSchema, bl, map, null);
    }

    public final List importXML(String string, MdmDatabaseSchema mdmDatabaseSchema, boolean bl) throws IOException, SAXException {
        return this.importXML(string, mdmDatabaseSchema, bl, null);
    }

    public final MdmObject getObjectFrom102ID(String string) {
        List<MdmObject> list = this.getObjectsFrom102IDs(new String[]{string});
        return list.get(0);
    }

    public final List<MdmObject> getObjectsFrom102IDs(String[] stringArray) {
        if (!this.getDataProvider().isServerVersionLaterThan(new int[]{11, 0, 0, 0})) {
            return this.getMetadataObjects(stringArray);
        }
        return this.get102IDToObjectConverter().convertIDs(stringArray);
    }

    private Mdm102IDToObjectConverter get102IDToObjectConverter() {
        if (null == this.m_Mdm102IDToObjectConverter) {
            this.m_Mdm102IDToObjectConverter = new Mdm102IDToObjectConverter(this);
        }
        return this.m_Mdm102IDToObjectConverter;
    }
}

