/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.syntax;

import oracle.olapi.syntax.Condition;
import oracle.olapi.syntax.SyntaxObject;
import oracle.olapi.syntax.TypedExpression;
import oracle.olapi.syntax.ValidationContext;

public abstract class ComparisonCondition
extends Condition {
    public static final String LT = "<";
    public static final String LE = "<=";
    public static final String GT = ">";
    public static final String GE = ">=";
    public static final String EQ = "=";
    public static final String NE = "!=";
    public static final String NE2 = "<>";
    public static final String NE3 = "^=";
    static final String[] ALL_OPERATORS = new String[]{"<", "<=", ">", ">=", "=", "!=", "<>", "^="};
    static final String[] DEFAULT_ALL_OPERATORS = new String[]{"<", "<=", ">", ">=", "=", "!=", "!=", "!="};
    private String m_Operator;
    private TypedExpression m_LhsArgument;

    @Override
    public SyntaxObject validate(ValidationContext validationContext) {
        this.m_LhsArgument = (TypedExpression)validationContext.validate(this.m_LhsArgument);
        return this;
    }

    @Override
    protected boolean checkIfDefinitionIsComplete() {
        return this.getLhsArgument().isDefinitionComplete();
    }

    public ComparisonCondition(TypedExpression typedExpression, String string) {
        this.m_Operator = ComparisonCondition.validateEnum(string, ALL_OPERATORS, DEFAULT_ALL_OPERATORS);
        ComparisonCondition.validateValue(typedExpression);
        this.m_LhsArgument = typedExpression;
    }

    @Override
    public String getOperator() {
        return this.m_Operator;
    }

    public TypedExpression getLhsArgument() {
        return this.m_LhsArgument;
    }
}

