/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.xml;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import oracle.olapi.xml.TagHandler;
import oracle.xml.parser.v2.SAXParser;
import org.xml.sax.InputSource;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.ParserAdapter;

public abstract class XMLProcessor
extends TagHandler {
    public final void parse(InputSource inputSource) throws IOException, SAXException {
        if (this.needsReset()) {
            this.resetState();
        }
        XMLReader xMLReader = this.createXMLReader();
        this.setNeedsReset(true);
        this.setState(this.getInitialState());
        xMLReader.parse(inputSource);
        if (this.hasErrors()) {
            this.reportAllErrors();
        }
        this.finishObjectCreation();
        this.validateParsedObjects();
        if (this.hasErrors()) {
            this.reportAllErrors();
        }
    }

    public final void parse(Reader reader) throws IOException, SAXException {
        this.parse(new InputSource(reader));
    }

    public final void parse(String string) throws IOException, SAXException {
        this.parse(new StringReader(string));
    }

    protected XMLProcessor() {
    }

    protected void validateParsedObjects() {
    }

    protected void finishObjectCreation() {
        this.setState(null);
        this.setDocumentLocator(null);
    }

    private XMLReader createXMLReader() throws IOException, SAXException {
        SAXParser sAXParser = new SAXParser();
        sAXParser.setProperty("oracle.xdkjava.security.resolveEntityDefault", (Object)Boolean.FALSE);
        ParserAdapter parserAdapter = new ParserAdapter((Parser)sAXParser);
        parserAdapter.setContentHandler(this);
        parserAdapter.setEntityResolver(this);
        parserAdapter.setErrorHandler(this);
        return parserAdapter;
    }

    private void reportAllErrors() {
        if (null != this.getRootException()) {
            throw this.getRootException();
        }
    }
}

