/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.ceditor.tint;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import oracle.ide.ceditor.tint.BlockType;
import oracle.ideimpl.ceditor.tint.Bundle;

final class TintOptionsModel
implements TableModel {
    private Map<String, List<BlockType>> providerToBlockListMap;
    private Map<String, Comparator<BlockType>> providerToBlockComparatorMap;
    private List<TableModelListener> listeners = new ArrayList<TableModelListener>();
    private String currentProvider = null;

    TintOptionsModel() {
    }

    void populate(Map<String, List<BlockType>> providerToBlockListMap, Map<String, Comparator<BlockType>> providerToBlockComparatorMap) {
        this.providerToBlockComparatorMap = providerToBlockComparatorMap;
        this.providerToBlockListMap = providerToBlockListMap;
        for (String id : providerToBlockListMap.keySet()) {
            if (this.currentProvider == null) {
                this.currentProvider = id;
            }
            this.sortBlockList(id);
        }
    }

    private void sortBlockList(String id) {
        Comparator<BlockType> comparator = this.providerToBlockComparatorMap.get(id);
        Collections.sort(this.providerToBlockListMap.get(id), comparator);
    }

    public List<BlockType> getBlocks(String language) {
        return this.providerToBlockListMap.get(language);
    }

    public void setProvider(String id) {
        this.currentProvider = id;
        this.fireTableChanged();
    }

    public void add(BlockType block) {
        this.providerToBlockListMap.get(this.currentProvider).add(block);
        this.sortBlockList(this.currentProvider);
        this.fireTableChanged();
    }

    public void replaceProvidersBlocks(String providerID, List<BlockType> blocks) {
        List<BlockType> list = this.providerToBlockListMap.get(providerID);
        if (list != null) {
            list.clear();
            list.addAll(blocks);
            this.sortBlockList(providerID);
            this.fireTableChanged();
        }
    }

    public void remove(int row) {
        this.providerToBlockListMap.get(this.currentProvider).remove(row);
        this.fireTableChanged();
    }

    @Override
    public int getRowCount() {
        if (this.currentProvider == null) {
            return 0;
        }
        return this.providerToBlockListMap == null ? 0 : this.providerToBlockListMap.get(this.currentProvider).size();
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public String getColumnName(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return Bundle.get("OPTIONS_TABLE_TYPE");
            }
            case 1: {
                return Bundle.get("OPTIONS_TABLE_PREVIEW");
            }
        }
        return "";
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return String.class;
            }
            case 1: {
                return BlockType.class;
            }
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex != 0;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        BlockType block = this.providerToBlockListMap.get(this.currentProvider).get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return block.getIdentifier();
            }
            case 1: {
                return block;
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
    }

    private void fireTableChanged() {
        TableModelEvent event = new TableModelEvent(this);
        for (TableModelListener l : this.listeners) {
            l.tableChanged(event);
        }
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
        if (!this.listeners.contains(l)) {
            this.listeners.add(l);
        }
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
        this.listeners.remove(l);
    }
}

